/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model.applier;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementMatcher;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelBase;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbEditorModelListener;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbStructureModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureNodeState;
import com.intellij.database.schemaEditor.ui.DbEditorUtilsKt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbStructureModelApplier<E extends BasicElement>
extends DbEditorModelBase.ApplierBase<E, DbStructureModelState> {
    private final RootsChecker myRootsChecker;

    public DbStructureModelApplier(@NotNull RootsChecker rootsChecker) {
        if (rootsChecker == null) {
            DbStructureModelApplier.$$$reportNull$$$0(0);
        }
        super(DbStructureModelState.ID);
        this.myRootsChecker = rootsChecker;
    }

    @NotNull
    public RootsChecker getRootsChecker() {
        RootsChecker rootsChecker = this.myRootsChecker;
        if (rootsChecker == null) {
            DbStructureModelApplier.$$$reportNull$$$0(1);
        }
        return rootsChecker;
    }

    @Override
    @Nullable
    protected DbEditorModelListener createListener(final @NotNull DbEditorModel<E, DbStructureModelState> model2) {
        if (model2 == null) {
            DbStructureModelApplier.$$$reportNull$$$0(2);
        }
        return new DbEditorModelListener(){

            @Override
            public void modified(@NotNull DbEditorModel<?, ?> changedModel) {
                boolean added;
                DbModelRef<?, ? extends DbStructureNodeState<?, ?>> node2;
                if (changedModel == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((node2 = DbStructureModelApplier.this.myRootsChecker.getAffectedNodeByChange(changedModel)) == null) {
                    return;
                }
                DbStructureModelState state = (DbStructureModelState)model2.getState();
                DbEditorModelController controller = model2.getController();
                String group2 = DbStructureModelApplier.this.myRootsChecker.getRootGroup(controller, model2.getIdentity(), node2);
                if (group2 != null == (added = state.isUnderRoots(controller, node2))) {
                    return;
                }
                if (added) {
                    state.removeRoot(node2);
                } else {
                    state.addRoot(node2, group2.isEmpty() ? null : group2);
                }
            }

            @Override
            public void created(@NotNull DbEditorModel<?, ?> addedModel) {
                DbStructureNodeState sm;
                if (addedModel == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((sm = (DbStructureNodeState)ObjectUtils.tryCast(addedModel.getState(), DbStructureNodeState.class)) == null) {
                    return;
                }
                ElementIdentity rootId2 = model2.getIdentity();
                ElementMatcher matcher = model2.getController().getMatcher();
                if (!DbEditorUtilsKt.isAncestor(matcher, rootId2, addedModel.getIdentity(), false)) {
                    return;
                }
                DbStructureModelState state = (DbStructureModelState)model2.getState();
                DbModelRef<?, DbStructureNodeState> ref2 = DbModelRef.create(addedModel.castState(sm));
                if (state.isUnderRoots(model2.getController(), ref2)) {
                    return;
                }
                String group2 = DbStructureModelApplier.this.myRootsChecker.getRootGroup(model2.getController(), rootId2, ref2);
                if (group2 == null) {
                    return;
                }
                state.addRoot(ref2, StringUtil.nullize((String)group2));
            }

            @Override
            public void removed(@NotNull DbEditorModel<?, ?> removedModel) {
                if (removedModel == null) {
                    1.$$$reportNull$$$0(2);
                }
                DbStructureModelState state = (DbStructureModelState)model2.getState();
                DbStructureNodeState sm = (DbStructureNodeState)ObjectUtils.tryCast(removedModel.getState(), DbStructureNodeState.class);
                if (sm == null) {
                    return;
                }
                DbModelRef<?, DbStructureNodeState> ref2 = DbModelRef.create(removedModel.castState(sm));
                if (!state.isInRoots(ref2)) {
                    return;
                }
                state.removeRoot(ref2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "changedModel";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "addedModel";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "removedModel";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/schemaEditor/model/applier/DbStructureModelApplier$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "created";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "removed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    public void copyState(@NotNull DbEditorModel<E, DbStructureModelState> from, @NotNull DbEditorModel<E, DbStructureModelState> to) {
        if (from == null) {
            DbStructureModelApplier.$$$reportNull$$$0(3);
        }
        if (to == null) {
            DbStructureModelApplier.$$$reportNull$$$0(4);
        }
        super.copyState(from, to);
    }

    @Override
    protected void applyImpl(@NotNull DbEditorModel<E, DbStructureModelState> model2, @NotNull ElementOwner owner, @NotNull E e2) {
        if (model2 == null) {
            DbStructureModelApplier.$$$reportNull$$$0(5);
        }
        if (owner == null) {
            DbStructureModelApplier.$$$reportNull$$$0(6);
        }
        if (e2 == null) {
            DbStructureModelApplier.$$$reportNull$$$0(7);
        }
    }

    @Override
    protected void resetImpl(@NotNull DbEditorModel<E, DbStructureModelState> model2, @NotNull ElementOwner owner, @NotNull E e2) {
        if (model2 == null) {
            DbStructureModelApplier.$$$reportNull$$$0(8);
        }
        if (owner == null) {
            DbStructureModelApplier.$$$reportNull$$$0(9);
        }
        if (e2 == null) {
            DbStructureModelApplier.$$$reportNull$$$0(10);
        }
    }

    @Override
    public boolean isEnabled(@NotNull DbEditorModel<E, DbStructureModelState> model2, @NotNull ElementOwner owner, @Nullable E e2) {
        if (model2 == null) {
            DbStructureModelApplier.$$$reportNull$$$0(11);
        }
        if (owner == null) {
            DbStructureModelApplier.$$$reportNull$$$0(12);
        }
        return DbStructureModelApplier.isEnabledImpl(model2);
    }

    @Override
    protected boolean differsFromImpl(@NotNull DbEditorModel<E, DbStructureModelState> model2, @NotNull ElementOwner owner, @NotNull E e2) {
        if (model2 == null) {
            DbStructureModelApplier.$$$reportNull$$$0(13);
        }
        if (owner == null) {
            DbStructureModelApplier.$$$reportNull$$$0(14);
        }
        if (e2 == null) {
            DbStructureModelApplier.$$$reportNull$$$0(15);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsChecker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/applier/DbStructureModelApplier";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 7: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/applier/DbStructureModelApplier";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createListener";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyState";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyImpl";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resetImpl";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "differsFromImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static interface RootsChecker {
        @Nullable
        public String getRootGroup(@NotNull DbEditorModelController var1, @NotNull ElementIdentity<?> var2, @NotNull DbModelRef<?, ? extends DbStructureNodeState<?, ?>> var3);

        @Nullable
        public DbModelRef<?, ? extends DbStructureNodeState<?, ?>> getAffectedNodeByChange(@NotNull DbEditorModel<?, ?> var1);
    }
}

