/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model.applier;

import com.intellij.database.model.ModelUtil;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.applier.DbObjectCollectionModelApplier;
import com.intellij.database.schemaEditor.model.state.DbStructureFamilyModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureObjectModelState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbStructureFamilyModelApplier<E extends BasicElement, C extends BasicElement>
extends DbObjectCollectionModelApplier<E, C, DbStructureObjectModelState<C>, DbStructureFamilyModelState<C>> {
    private final BasicMetaObject<C> myMeta;
    private final int myWeight;

    public DbStructureFamilyModelApplier(@NotNull BasicMetaObject<C> meta) {
        if (meta == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(0);
        }
        super(BasicMetaId.create("FAMILY_" + meta.kind.name() + "_ID"));
        this.myMeta = meta;
        this.myWeight = DbPresentationCore.getWeight(this.myMeta.kind, 0);
    }

    public int getWeight() {
        return this.myWeight;
    }

    @Override
    protected void removeChildrenSyncPending(@NotNull ElementOwner owner, @NotNull E e2) {
        ModFamily<BasicModElement> family;
        if (owner == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(1);
        }
        if (e2 == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(2);
        }
        if ((family = this.getModFamily(e2)) == null) {
            return;
        }
        ArrayList elements2 = ContainerUtil.newArrayList(family);
        for (BasicModElement c2 : elements2) {
            if (!c2.isSyncPending()) continue;
            ElementIdentity<BasicModElement> identity = owner.findIdentity(c2);
            if (identity != null) {
                owner.drop(identity);
                continue;
            }
            c2.drop();
        }
        family.sort();
    }

    @Override
    protected void applyChild(@NotNull ElementOwner owner, @NotNull E e2, @NotNull DbModelRef<C, DbStructureObjectModelState<C>> desc) {
        C object;
        if (owner == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(3);
        }
        if (e2 == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(4);
        }
        if (desc == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(5);
        }
        if ((object = owner.findOrCreate(desc.getIdentity())) == null) {
            return;
        }
        ((BasicModElement)object).resetSyncPending();
    }

    @Override
    public boolean differsFromImpl(@NotNull DbEditorModel<E, DbStructureFamilyModelState<C>> model2, @NotNull ElementOwner owner, @NotNull E e2) {
        if (model2 == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(6);
        }
        if (owner == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(7);
        }
        if (e2 == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(8);
        }
        return false;
    }

    @Nullable
    private ModFamily<BasicModElement> getModFamily(@NotNull E e2) {
        BasicMetaObject<BasicModElement> modMeta;
        if (e2 == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(9);
        }
        return (modMeta = this.getMetaObject().tryCast(BasicModElement.class)) == null ? null : (ModFamily)BasicMetaUtils.getFamily(e2, modMeta);
    }

    @Override
    protected void markChildrenSyncPending(@NotNull ElementOwner owner, @NotNull E e2) {
        ModFamily<BasicModElement> family;
        if (owner == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(10);
        }
        if (e2 == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(11);
        }
        if ((family = this.getModFamily(e2)) != null) {
            family.markChildrenAsSyncPending();
        }
    }

    @Override
    @NotNull
    protected Iterable<C> extractObjects(@NotNull DbEditorModel<E, DbStructureFamilyModelState<C>> model2, @NotNull ElementOwner owner, @NotNull E e2) {
        if (model2 == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(12);
        }
        if (owner == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(13);
        }
        if (e2 == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(14);
        }
        JBIterable jBIterable = owner.getChildren(model2.getIdentity(), this.getMetaObject()).filterMap(cId -> owner.findOrCreate(cId)).sort(ModelUtil.DISPLAY_ORDER_COMPARATOR);
        if (jBIterable == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(15);
        }
        return jBIterable;
    }

    @Override
    public BasicMetaObject<C> getMetaObject() {
        return this.myMeta;
    }

    @Override
    @NotNull
    public DbModelRef<C, DbStructureObjectModelState<C>> createModel(@NotNull DbEditorModel<E, DbStructureFamilyModelState<C>> model2, @Nullable ElementIdentity<C> id) {
        if (model2 == null) {
            DbStructureFamilyModelApplier.$$$reportNull$$$0(16);
        }
        if (id == null) {
            id = this.createObject(model2);
        }
        DbEditorModel<C, DbStructureObjectModelState<C>> res2 = model2.getController().createStructureNodeModel(id);
        res2.register();
        return new DbModelRef<C, DbStructureObjectModelState<C>>(res2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 6: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/applier/DbStructureFamilyModelApplier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/applier/DbStructureFamilyModelApplier";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "extractObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeChildrenSyncPending";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyChild";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "differsFromImpl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getModFamily";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "markChildrenSyncPending";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "extractObjects";
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15 -> new IllegalStateException(string);
        };
    }
}

