/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model.applier;

import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.applier.DbKeyColumnsModelApplier;
import com.intellij.database.schemaEditor.model.state.DbCollectionModelState;
import com.intellij.database.schemaEditor.model.state.DbReferenceModelState;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbForeignKeyColumnsModelApplier<E extends BasicModForeignKey, C extends FkColumn>
extends DbKeyColumnsModelApplier<E, C> {
    @Override
    public C createItem(@Nullable C src2) {
        return (C)new FkColumn((FkColumn)src2);
    }

    @Override
    protected void applyItems(@NotNull ElementOwner owner, @NotNull E e2, @NotNull List<C> items2) {
        if (owner == null) {
            DbForeignKeyColumnsModelApplier.$$$reportNull$$$0(0);
        }
        if (e2 == null) {
            DbForeignKeyColumnsModelApplier.$$$reportNull$$$0(1);
        }
        if (items2 == null) {
            DbForeignKeyColumnsModelApplier.$$$reportNull$$$0(2);
        }
        super.applyItems(owner, e2, items2);
        e2.setRefColNames(ContainerUtil.map(items2, c2 -> DbKeyColumnsModelApplier.ColumnApplyHelper.getReferenceValue(c2.refName, owner)));
    }

    @Override
    @NotNull
    protected List<C> extractColumns(@NotNull DbEditorModel<E, DbCollectionModelState<C>> model2, @NotNull ElementOwner owner, @NotNull E e2) {
        if (model2 == null) {
            DbForeignKeyColumnsModelApplier.$$$reportNull$$$0(3);
        }
        if (owner == null) {
            DbForeignKeyColumnsModelApplier.$$$reportNull$$$0(4);
        }
        if (e2 == null) {
            DbForeignKeyColumnsModelApplier.$$$reportNull$$$0(5);
        }
        List<C> res2 = super.extractColumns(model2, owner, e2);
        List<String> refColNames = e2.getRefColNames();
        ElementIdentity<?> refTableId = this.getRefTableId(model2);
        int s2 = Math.min(refColNames.size(), res2.size());
        for (int i2 = 0; i2 < s2; ++i2) {
            DbKeyColumnsModelApplier.ColumnApplyHelper.identifyAndSetTargetId(owner, refTableId, refColNames.get(i2), false, ((FkColumn)res2.get((int)i2)).refName, model2);
        }
        List<C> list = res2;
        if (list == null) {
            DbForeignKeyColumnsModelApplier.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    private ElementIdentity<?> getRefTableId(@NotNull DbEditorModel<E, DbCollectionModelState<C>> model2) {
        if (model2 == null) {
            DbForeignKeyColumnsModelApplier.$$$reportNull$$$0(7);
        }
        return DbReferenceModelState.resolveReference(model2.getController(), model2.getIdentity(), BasicModForeignKey.REF_TABLE_REF);
    }

    @Override
    protected void resolveItems(@NotNull DbEditorModel<E, DbCollectionModelState<C>> model2, @NotNull ElementOwner owner, @NotNull E e2, List<C> items2) {
        if (model2 == null) {
            DbForeignKeyColumnsModelApplier.$$$reportNull$$$0(8);
        }
        if (owner == null) {
            DbForeignKeyColumnsModelApplier.$$$reportNull$$$0(9);
        }
        if (e2 == null) {
            DbForeignKeyColumnsModelApplier.$$$reportNull$$$0(10);
        }
        super.resolveItems(model2, owner, e2, items2);
        ElementIdentity<?> refTableId = this.getRefTableId(model2);
        for (FkColumn item : items2) {
            DbKeyColumnsModelApplier.ColumnApplyHelper.resolve(owner, refTableId, DbKeyColumnsModelApplier.ColumnApplyHelper.getReferenceValue(item.refName, owner), item.refName, model2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/applier/DbForeignKeyColumnsModelApplier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/applier/DbForeignKeyColumnsModelApplier";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "extractColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyItems";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractColumns";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRefTableId";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveItems";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    public static class FkColumn
    extends DbKeyColumnsModelApplier.KeyColumn {
        @NlsSafe
        @NotNull
        public DbKeyColumnsModelApplier.ColumnNameState refName;

        public FkColumn(@Nullable FkColumn src2) {
            super(src2);
            this.refName = new DbKeyColumnsModelApplier.ColumnNameState(src2 == null ? null : src2.refName);
        }

        @Override
        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof FkColumn)) {
                return false;
            }
            return super.equals(o2) && this.refName.equals(((FkColumn)o2).refName);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.refName);
        }
    }
}

