/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeConstraint;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeGrant;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeKeysSet;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ArrayListSet;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeTable
extends DeObject {
    public static final DeTable STUB = new DeTable("STUB", null, DeModel.STUB);
    public boolean temporary;
    @Nullable
    public DeObject parent;
    public final List<DeColumn> columns;
    public final ArrayListSet<DeIndex> indices;
    public final ArrayListSet<DeForeignKey> foreignKeys;
    public final ArrayListSet<DeConstraint> constraints;
    public final DeKeysSet keys;
    public final List<DeGrant> grants;

    public DeTable(@NotNull DeModel model2) {
        if (model2 == null) {
            DeTable.$$$reportNull$$$0(0);
        }
        super(model2);
        this.columns = new ArrayList<DeColumn>();
        this.indices = new ArrayListSet();
        this.foreignKeys = new ArrayListSet();
        this.constraints = new ArrayListSet();
        this.keys = new DeKeysSet();
        this.grants = new ArrayList<DeGrant>();
    }

    public DeTable(@NotNull String name2, @Nullable DeObject parent2, @NotNull DeModel model2) {
        if (name2 == null) {
            DeTable.$$$reportNull$$$0(1);
        }
        if (model2 == null) {
            DeTable.$$$reportNull$$$0(2);
        }
        super(name2, model2);
        this.columns = new ArrayList<DeColumn>();
        this.indices = new ArrayListSet();
        this.foreignKeys = new ArrayListSet();
        this.constraints = new ArrayListSet();
        this.keys = new DeKeysSet();
        this.grants = new ArrayList<DeGrant>();
        this.parent = parent2;
    }

    @Override
    @Nullable
    public DeTable getEditedDeObject() {
        return (DeTable)super.getEditedDeObject();
    }

    @Override
    @NotNull
    public DeObject copyFrom(@NotNull DeObject obj2, boolean withChildren, @NotNull DeObject.DeCopier copier) {
        if (obj2 == null) {
            DeTable.$$$reportNull$$$0(3);
        }
        if (copier == null) {
            DeTable.$$$reportNull$$$0(4);
        }
        super.copyFrom(obj2, withChildren, copier);
        DeTable tab2 = (DeTable)obj2;
        this.parent = copier.copy(tab2.parent, false);
        this.temporary = tab2.temporary;
        this.grants.clear();
        this.grants.addAll(tab2.grants);
        DeTable deTable = this;
        if (deTable == null) {
            DeTable.$$$reportNull$$$0(5);
        }
        return deTable;
    }

    @Override
    @NotNull
    public DeObject emptyClone(@NotNull DeModel model2) {
        if (model2 == null) {
            DeTable.$$$reportNull$$$0(6);
        }
        return new DeTable(model2);
    }

    @Override
    public void copyChildrenFrom(@NotNull DeObject obj2, @NotNull DeObject.DeCopier copier) {
        if (obj2 == null) {
            DeTable.$$$reportNull$$$0(7);
        }
        if (copier == null) {
            DeTable.$$$reportNull$$$0(8);
        }
        super.copyChildrenFrom(obj2, copier);
        DeTable tab2 = (DeTable)obj2;
        this.columns.clear();
        for (DeColumn column2 : tab2.columns) {
            this.columns.add(copier.copy(column2, true));
        }
        this.indices.clear();
        for (DeIndex index2 : tab2.indices) {
            this.indices.add((Object)copier.copy(index2, true));
        }
        this.foreignKeys.clear();
        for (DeForeignKey foreignKey : tab2.foreignKeys) {
            this.foreignKeys.add((Object)copier.copy(foreignKey, true));
        }
        this.constraints.clear();
        for (DeConstraint constraint : tab2.constraints) {
            this.constraints.add((Object)copier.copy(constraint, true));
        }
        SmartList newKeys = new SmartList();
        Iterator iterator = tab2.keys.iterator();
        while (iterator.hasNext()) {
            DeTableKey key2 = (DeTableKey)iterator.next();
            newKeys.add(copier.copy(key2, true));
        }
        this.keys.setKeys((Collection<DeTableKey>)newKeys);
        this.keys.setPrimaryKey(copier.copy(tab2.keys.getPrimaryKey(), true));
    }

    @Override
    @NotNull
    public JBIterable<DeObject> getChildren() {
        JBIterable jBIterable = JBIterable.from(this.columns).append(this.indices).append(this.foreignKeys).append(this.constraints).append((Iterable)((Object)this.keys));
        if (jBIterable == null) {
            DeTable.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @Override
    @Nullable
    public DeObject getParent() {
        return this.parent;
    }

    @Override
    public boolean isAlteredIgnoringChild(@NotNull DeObject other, @NotNull Collection<? extends DeObject> children2, @NotNull Collection<? extends DeObject> otherChildren) {
        Collection<? extends DeObject> editedIgnore;
        if (other == null) {
            DeTable.$$$reportNull$$$0(10);
        }
        if (children2 == null) {
            DeTable.$$$reportNull$$$0(11);
        }
        if (otherChildren == null) {
            DeTable.$$$reportNull$$$0(12);
        }
        DeTable table = (DeTable)other;
        if (children2.isEmpty()) {
            editedIgnore = otherChildren;
        } else {
            editedIgnore = new HashSet<DeObject>();
            for (DeObject deObject : children2) {
                if (deObject.getEditedObject() == null) continue;
                editedIgnore.add((DeObject)deObject.getEditedObject());
            }
            editedIgnore.addAll(otherChildren);
        }
        return this.temporary != table.temporary || !this.grants.equals(table.grants) || super.isAlteredIgnoringChild(other, children2, otherChildren) || DeTable.isAltered(this.columns, table.columns, children2, editedIgnore) || DeTable.isAltered(this.indices, table.indices, children2, editedIgnore) || DeTable.isAltered(this.foreignKeys, table.foreignKeys, children2, editedIgnore) || DeTable.isAltered(this.constraints, table.constraints, children2, editedIgnore) || DeTable.isAltered((Collection<? extends DeObject>)((Object)this.keys), (Collection<? extends DeObject>)((Object)table.keys), children2, editedIgnore);
    }

    private static boolean isAltered(@NotNull Collection<? extends DeObject> a, @NotNull Collection<? extends DeObject> b2, @NotNull Collection<? extends DeObject> ignore, @NotNull Collection<?> editedIgnore) {
        if (a == null) {
            DeTable.$$$reportNull$$$0(13);
        }
        if (b2 == null) {
            DeTable.$$$reportNull$$$0(14);
        }
        if (ignore == null) {
            DeTable.$$$reportNull$$$0(15);
        }
        if (editedIgnore == null) {
            DeTable.$$$reportNull$$$0(16);
        }
        HashSet<DeObject> edited = new HashSet<DeObject>();
        for (DeObject deObject : a) {
            if (ignore.contains(deObject)) continue;
            DeObject editedObject = (DeObject)deObject.getEditedObject();
            if (!b2.contains(editedObject)) {
                return true;
            }
            edited.add(editedObject);
        }
        for (DeObject deObject : b2) {
            if (editedIgnore.contains(deObject) || edited.contains(deObject)) continue;
            return true;
        }
        for (DeObject deObject : a) {
            if (ignore.contains(deObject) || !deObject.isAltered((DeObject)Objects.requireNonNull(deObject.getEditedObject()))) continue;
            return true;
        }
        return false;
    }

    private static boolean isAltered(@Nullable DeObject a, @Nullable DeObject b2) {
        if (a == null || b2 == null) {
            return a != b2;
        }
        return a.getEditedObject() != b2 || a.isAltered((DeObject)a.getEditedObject());
    }

    private static boolean isAltered(@NotNull List<? extends DeObject> a, @NotNull List<? extends DeObject> b2, @NotNull Collection<? extends DeObject> ignore, @NotNull Collection<?> editedIgnore) {
        if (a == null) {
            DeTable.$$$reportNull$$$0(17);
        }
        if (b2 == null) {
            DeTable.$$$reportNull$$$0(18);
        }
        if (ignore == null) {
            DeTable.$$$reportNull$$$0(19);
        }
        if (editedIgnore == null) {
            DeTable.$$$reportNull$$$0(20);
        }
        int i2 = 0;
        int j = 0;
        while (i2 < a.size() && j < b2.size()) {
            boolean skip = false;
            if (ignore.contains(a.get(i2))) {
                ++i2;
                skip = true;
            }
            if (editedIgnore.contains(b2.get(j))) {
                ++j;
                skip = true;
            }
            if (skip) continue;
            if (DeTable.isAltered(a.get(i2), b2.get(j))) {
                return true;
            }
            ++i2;
            ++j;
        }
        return i2 != a.size() || j != b2.size();
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.TABLE;
        if (objectKind == null) {
            DeTable.$$$reportNull$$$0(21);
        }
        return objectKind;
    }

    public void removeChild(@NotNull DeObject child) {
        if (child == null) {
            DeTable.$$$reportNull$$$0(22);
        }
        if (child instanceof DeColumn) {
            this.columns.remove(child);
        }
        if (child instanceof DeIndex) {
            this.indices.remove((Object)child);
        }
        if (child instanceof DeForeignKey) {
            this.foreignKeys.remove((Object)child);
        }
        if (child instanceof DeConstraint) {
            this.constraints.remove((Object)child);
        }
        if (child instanceof DeTableKey) {
            this.keys.remove(child);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 9, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copier";
                break;
            }
            case 5: 
            case 9: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/DeTable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherChildren";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignore";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editedIgnore";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/DeTable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFrom";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 5: 
            case 9: 
            case 21: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "emptyClone";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyChildrenFrom";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAlteredIgnoringChild";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isAltered";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 9, 21 -> new IllegalStateException(string);
        };
    }
}

