/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.Dbms;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbModelIdentity;
import com.intellij.database.schemaEditor.model.applier.DbModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbModelMultiApplier;
import com.intellij.database.schemaEditor.model.state.DbModelState;
import com.intellij.openapi.util.NlsContexts;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DbEditorModel<E extends BasicElement, S extends DbModelState> {
    @NotNull
    public DbEditorModelController getController();

    @NotNull
    public ElementIdentity<E> getIdentity();

    @NotNull
    public BasicMetaId getModelInternalKey();

    @NotNull
    public DbModelIdentity<E, S> getModelIdentity();

    @NotNull
    public Dbms getDbms();

    @NotNull
    public S getState();

    @NotNull
    public DbModelApplier<E, S> getApplier();

    @Nullable
    public DbModelMultiApplier<E, S> getMultiApplier();

    @NlsContexts.Label
    @Nullable
    public String getTitle();

    @Nullable
    default public <E2 extends BasicElement> DbEditorModel<E2, S> tryCastElement(@NotNull Class<E2> clazz) {
        if (clazz == null) {
            DbEditorModel.$$$reportNull$$$0(0);
        }
        return ElementIdentity.tryCast(this.getIdentity(), clazz) == null ? null : this;
    }

    @Nullable
    default public <E2 extends BasicElement> DbEditorModel<E2, S> tryCastElement(@NotNull BasicMetaObject<E2> meta) {
        if (meta == null) {
            DbEditorModel.$$$reportNull$$$0(1);
        }
        return ElementIdentity.tryCast(this.getIdentity(), meta) == null ? null : this;
    }

    @Nullable
    default public <S2 extends DbModelState> DbEditorModel<E, S2> tryCastState(@NotNull Function<S, @Nullable S2> conv) {
        if (conv == null) {
            DbEditorModel.$$$reportNull$$$0(2);
        }
        return this.castState((DbModelState)conv.apply(this.getState()));
    }

    @Contract(value="!null->!null;null->null")
    default public <S2 extends DbModelState> DbEditorModel<E, S2> castState(@Nullable S2 casted) {
        if (casted == null) {
            return null;
        }
        if (!1.$assertionsDisabled && this.getState() != casted) {
            throw new AssertionError();
        }
        return this;
    }

    public boolean register();

    public boolean unregister();

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conv";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/schemaEditor/model/DbEditorModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryCastElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "tryCastState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

