/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.model.MemoryTextStorage;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ModelLightCopier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMixinElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.schemaEditor.DasSchemaExporters;
import com.intellij.database.schemaEditor.SchemaExporters;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.util.ObjectUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaApplyHelper {
    private final Map<DeObject, BasicModElement> myCache;
    private final DatabaseEditorContext myContext;
    private final SchemaExporters myExporter;
    private final DeModel myModel;
    private final BasicModModel myTargetModel;

    public SchemaApplyHelper(@NotNull DatabaseEditorContext context, @NotNull DeModel model2) {
        if (context == null) {
            SchemaApplyHelper.$$$reportNull$$$0(0);
        }
        if (model2 == null) {
            SchemaApplyHelper.$$$reportNull$$$0(1);
        }
        this(DasSchemaExporters.createDefaultExporters(), context, model2);
    }

    public SchemaApplyHelper(@NotNull SchemaExporters exporter, @NotNull DatabaseEditorContext context, @NotNull DeModel model2) {
        if (exporter == null) {
            SchemaApplyHelper.$$$reportNull$$$0(2);
        }
        if (context == null) {
            SchemaApplyHelper.$$$reportNull$$$0(3);
        }
        if (model2 == null) {
            SchemaApplyHelper.$$$reportNull$$$0(4);
        }
        this.myCache = new HashMap<DeObject, BasicModElement>();
        this.myContext = context;
        this.myExporter = exporter;
        this.myModel = model2;
        this.myTargetModel = new ModelFactory(new MemoryTextStorage()).createModel(context.getDbms());
    }

    @NotNull
    public DatabaseEditorContext getContext() {
        DatabaseEditorContext databaseEditorContext = this.myContext;
        if (databaseEditorContext == null) {
            SchemaApplyHelper.$$$reportNull$$$0(5);
        }
        return databaseEditorContext;
    }

    @NotNull
    public BasicModModel getTargetModel() {
        BasicModModel basicModModel = this.myTargetModel;
        if (basicModModel == null) {
            SchemaApplyHelper.$$$reportNull$$$0(6);
        }
        return basicModModel;
    }

    public boolean contains(@NotNull DeObject obj2) {
        if (obj2 == null) {
            SchemaApplyHelper.$$$reportNull$$$0(7);
        }
        return this.myCache.containsKey(obj2);
    }

    @Nullable
    public BasicModElement apply(@Nullable DeObject object) {
        BasicModElement parent2;
        if (object == null) {
            return null;
        }
        if (object instanceof DeColumn && !((DeColumn)object).isInTable() || EditorModelUtil.isStub(object)) {
            return null;
        }
        assert (object.getKind() != ObjectKind.ROOT);
        BasicModElement res2 = this.getCached(object);
        if (res2 != null && !res2.isSyncPending()) {
            return res2;
        }
        SchemaExporters.Exporter<? extends DeObject, ? extends BasicElement> exporter = this.myExporter.getApplier(object);
        assert (exporter != null) : "No applier for " + object.getClass().getName();
        assert (object.model == this.myModel);
        DeObject deParent = object.getParent();
        BasicModElement basicModElement = parent2 = deParent == null ? this.createParent(object) : this.apply(deParent);
        if (parent2 == null) {
            return null;
        }
        res2 = this.getCached(object);
        if (res2 != null && !res2.isSyncPending()) {
            return res2;
        }
        if (res2 == null || res2.getParent() != parent2) {
            res2 = SchemaApplyHelper.create(parent2, object);
            this.created(object, res2);
        } else {
            res2.resetSyncPending();
        }
        exporter.apply(this, object, res2);
        exporter.applyChildren(this, object, res2);
        if (!object.lightExported) {
            SchemaApplyHelper.copyUnExportedChildren(object, res2);
        }
        return res2;
    }

    private static void copyUnExportedChildren(@NotNull DeObject from, @NotNull BasicModElement to) {
        DeObject prev;
        if (from == null) {
            SchemaApplyHelper.$$$reportNull$$$0(8);
        }
        if (to == null) {
            SchemaApplyHelper.$$$reportNull$$$0(9);
        }
        DeObject last2 = from;
        while ((prev = last2.getEditedDeObject()) != null) {
            last2 = prev;
        }
        BasicElement basic = last2.getEditedBasic();
        if (basic != null) {
            SchemaExporters.BasicSchemaExportHelper eh = (SchemaExporters.BasicSchemaExportHelper)last2.model.getExportHelper();
            for (BasicElement child : basic.getChildren()) {
                if (eh.contains(child)) continue;
                BasicModElement toChild = SchemaApplyHelper.createObject(to, child.getKind(), child.getName());
                ModelLightCopier.copyProperties(child, toChild, true, true);
            }
        }
    }

    private BasicModElement getCached(@Nullable DeObject object) {
        BasicModElement res2 = this.myCache.get(object);
        if (res2 != null && res2.isDropped()) {
            this.myCache.remove(object);
            return null;
        }
        return res2;
    }

    private BasicModElement createParent(@NotNull DeObject object) {
        BasicElement src2;
        if (object == null) {
            SchemaApplyHelper.$$$reportNull$$$0(10);
        }
        if ((src2 = object.unwrap()) != null) {
            return this.copyFromBaseModel(Objects.requireNonNull(src2.getParent()));
        }
        BasicModel baseModel = SchemaApplyHelper.unwrapDeModel(this.myModel);
        return this.createSomething(object.getKind(), baseModel);
    }

    private BasicModElement createSomething(ObjectKind kind, BasicModel model2) {
        BasicDatabase database = model2 == null ? null : model2.getRoot().getCurrentDatabase();
        BasicSchema schema2 = database == null ? null : ModelFun.getCurrentSchema(database);
        List first2 = (List)((BasicMetaModel)this.myTargetModel.getMetaModel()).getPathsToRoot(kind).first();
        assert (first2 != null);
        BasicModElement parent2 = (BasicModElement)((Object)this.myTargetModel.getRoot());
        int i2 = 1;
        while (i2 + 1 < first2.size()) {
            ObjectKind k = (ObjectKind)first2.get(first2.size() - i2 - 1);
            parent2 = k == ObjectKind.DATABASE && database != null ? this.copyFromBaseModel(database) : (k == ObjectKind.SCHEMA && schema2 != null ? this.copyFromBaseModel(schema2) : SchemaApplyHelper.createChild(parent2, k, DasUtil.NO_NAME, null));
            ++i2;
        }
        return parent2;
    }

    @NotNull
    private BasicModElement copyFromBaseModel(@NotNull BasicElement element2) {
        ObjectKind kind;
        if (element2 == null) {
            SchemaApplyHelper.$$$reportNull$$$0(11);
        }
        if ((kind = element2.getKind()) == ObjectKind.ROOT) {
            BasicModElement root2 = (BasicModElement)((Object)this.myTargetModel.getRoot());
            ModelLightCopier.copyProperties(element2, root2, true, true);
            BasicModElement basicModElement = root2;
            if (basicModElement == null) {
                SchemaApplyHelper.$$$reportNull$$$0(12);
            }
            return basicModElement;
        }
        BasicModElement parent2 = this.copyFromBaseModel(Objects.requireNonNull(element2.getParent()));
        return SchemaApplyHelper.createChild(parent2, kind, element2.getName(), element2);
    }

    private static BasicModElement create(@NotNull BasicModElement parent2, @NotNull DeObject object) {
        if (parent2 == null) {
            SchemaApplyHelper.$$$reportNull$$$0(13);
        }
        if (object == null) {
            SchemaApplyHelper.$$$reportNull$$$0(14);
        }
        BasicElement src2 = object.unwrap();
        return SchemaApplyHelper.createChild(parent2, object.getKind(), object.name, src2);
    }

    @NotNull
    private static BasicModElement createChild(@NotNull BasicModElement parent2, @NotNull ObjectKind kind, @NotNull String name2, @Nullable BasicElement src2) {
        if (parent2 == null) {
            SchemaApplyHelper.$$$reportNull$$$0(15);
        }
        if (kind == null) {
            SchemaApplyHelper.$$$reportNull$$$0(16);
        }
        if (name2 == null) {
            SchemaApplyHelper.$$$reportNull$$$0(17);
        }
        BasicModElement obj2 = SchemaApplyHelper.createObject(parent2, kind, name2);
        if (src2 != null) {
            ModelLightCopier.copyProperties(src2, obj2, true, true);
        }
        BasicModElement basicModElement = obj2;
        if (basicModElement == null) {
            SchemaApplyHelper.$$$reportNull$$$0(18);
        }
        return basicModElement;
    }

    @NotNull
    private static BasicModElement createObject(@NotNull BasicModElement parent2, @NotNull ObjectKind kind, @NotNull String name2) {
        if (parent2 == null) {
            SchemaApplyHelper.$$$reportNull$$$0(19);
        }
        if (kind == null) {
            SchemaApplyHelper.$$$reportNull$$$0(20);
        }
        if (name2 == null) {
            SchemaApplyHelper.$$$reportNull$$$0(21);
        }
        Family family = parent2.familyOf(kind);
        assert (family != null) : "No family " + kind.code() + " in " + parent2.getKind().code();
        BasicModMixinElement obj2 = null;
        if (family instanceof ModSingletonFamily) {
            obj2 = (BasicModMixinElement)((ModSingletonFamily)family).createOrGet();
        }
        if (obj2 == null) {
            obj2 = family.find(o2 -> o2.isSyncPending() && name2.equals(o2.getName()));
        }
        if (obj2 != null) {
            obj2.resetSyncPending();
            for (ModFamily modFamily : obj2.getFamilies()) {
                modFamily.markChildrenAsSyncPending();
            }
        } else {
            obj2 = family.createNewOne();
        }
        BasicModMixinElement basicModMixinElement = obj2;
        if (basicModMixinElement == null) {
            SchemaApplyHelper.$$$reportNull$$$0(22);
        }
        return basicModMixinElement;
    }

    @Nullable
    public BasicElement getAlreadyApplied(@Nullable DeObject object) {
        BasicModElement element2 = object == null ? null : this.getCached(object);
        return element2 == null || element2.isSyncPending() ? null : element2;
    }

    protected void created(@NotNull DeObject object, @NotNull BasicModElement res2) {
        if (object == null) {
            SchemaApplyHelper.$$$reportNull$$$0(23);
        }
        if (res2 == null) {
            SchemaApplyHelper.$$$reportNull$$$0(24);
        }
        this.myCache.put(object, res2);
    }

    public void markDirty() {
        for (ModFamily modFamily : ((BasicModRoot)this.myTargetModel.getRoot()).getFamilies()) {
            modFamily.markChildrenAsSyncPending();
        }
        for (BasicModElement basicModElement : this.myTargetModel.traverser().filter(BasicModElement.class)) {
            for (ModFamily modFamily : basicModElement.getFamilies()) {
                modFamily.markChildrenAsSyncPending();
            }
        }
    }

    public void cleanup() {
        for (ModFamily modFamily : ((BasicModRoot)this.myTargetModel.getRoot()).getFamilies()) {
            modFamily.removeSyncPendingChildren();
            modFamily.sort();
        }
        for (BasicModElement basicModElement : this.myTargetModel.traverser().filter(BasicModElement.class)) {
            for (ModFamily modFamily : basicModElement.getFamilies()) {
                modFamily.removeSyncPendingChildren();
                modFamily.sort();
            }
        }
    }

    @Nullable
    public static BasicModel unwrapDeModel(DeModel model2) {
        for (DeModel tmpModel = model2; tmpModel != null; tmpModel = tmpModel.getDeModel()) {
            if (tmpModel.getDasModel() == null) continue;
            return (BasicModel)ObjectUtils.tryCast((Object)tmpModel.getDasModel(), BasicModel.class);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 12, 18, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exporter";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/SchemaApplyHelper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 10: 
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/SchemaApplyHelper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetModel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFromBaseModel";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createChild";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 18: 
            case 22: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyUnExportedChildren";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createParent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "copyFromBaseModel";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createChild";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createObject";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "created";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 12, 18, 22 -> new IllegalStateException(string);
        };
    }
}

