/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.TypesMutator;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.UnparsedValueWithDomain;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.TypeNameColumnDescriptor;
import com.intellij.openapi.util.NlsSafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GridCellEditorsUtil {
    @NlsSafe
    @Nullable
    public static String guessTypeNameForEditing(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column2) {
        if (grid == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(0);
        }
        if (row == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(2);
        }
        if (!row.isValid(grid) || !column2.isValid(grid)) {
            return null;
        }
        Domain overriddenType = GridCellEditorsUtil.getOverriddenType(grid, row, column2);
        if (overriddenType != null) {
            return overriddenType.simpleName();
        }
        GridModel model2 = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        Object value2 = model2.getValueAt(row, column2);
        GridColumn c2 = (GridColumn)model2.getColumn(column2);
        Dbms dbms = DataGridUtilCore.getDbms(grid);
        if (c2 != null && (value2 instanceof ReservedCellValue || value2 == null) && dbms.in(Dbms.DOCUMENT_ORIENTED)) {
            return c2.getTypeName();
        }
        return ExtractorsUtil.getTypeName(c2, value2, dbms);
    }

    @Nullable
    public static Domain guessDomainForEditing(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column2) {
        if (grid == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(3);
        }
        if (row == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(4);
        }
        if (column2 == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(5);
        }
        if (!row.isValid(grid) || !column2.isValid(grid)) {
            return null;
        }
        Domain overriddenType = GridCellEditorsUtil.getOverriddenType(grid, row, column2);
        if (overriddenType != null) {
            return overriddenType;
        }
        String typeName = GridCellEditorsUtil.guessTypeNameForEditing(grid, row, column2);
        return typeName == null ? null : BaseDomainRegistry.getDomain(DataGridUtilCore.getDbms(grid), DbImplUtilCore.getDatabaseVersion(DataGridUtilCore.getDatabaseSystem(grid)), new TypeNameColumnDescriptor(typeName), true);
    }

    @Nullable
    public static Domain getOverriddenType(@NotNull CoreGrid<GridRow, GridColumn> grid, @Nullable ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column2) {
        Domain domain;
        if (grid == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(6);
        }
        if (column2 == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(7);
        }
        if (row == null) {
            return null;
        }
        GridMutator mutator = grid.getDataHookup().getMutator();
        if (mutator instanceof TypesMutator && (domain = (Domain)((TypesMutator)mutator).getType(row, column2)) != null) {
            return domain;
        }
        GridModel model2 = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        Object value2 = model2.getValueAt(row, column2);
        return value2 instanceof UnparsedValueWithDomain ? ((UnparsedValueWithDomain)((Object)value2)).getDomain() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "guessTypeNameForEditing";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "guessDomainForEditing";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getOverriddenType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

