/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.DataGridBundle;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.FormatterImpl;
import com.intellij.database.run.ui.grid.editors.lexers.PgRangeLexerAdapter;
import com.intellij.database.run.ui.grid.editors.lexers.PgRangeTokens;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.text.ParseException;
import java.text.ParsePosition;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FakeRangeFormatter
extends FormatterImpl {
    @NotNull
    private final Formatter myFormatter;

    public FakeRangeFormatter(@NotNull Formatter formatter) {
        if (formatter == null) {
            FakeRangeFormatter.$$$reportNull$$$0(0);
        }
        this.myFormatter = formatter;
    }

    @Nls
    @NotNull
    protected String getErrorMessage() {
        String string = DataGridBundle.message((String)"invalid.range.value", (Object[])new Object[0]);
        if (string == null) {
            FakeRangeFormatter.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public Object parse(@NotNull String value2, @NotNull ParsePosition position) {
        if (value2 == null) {
            FakeRangeFormatter.$$$reportNull$$$0(2);
        }
        if (position == null) {
            FakeRangeFormatter.$$$reportNull$$$0(3);
        }
        try {
            return this.rebuild(this.parseInternal(value2, position));
        }
        catch (TokenizeException e2) {
            position.setErrorIndex(e2.getPosition());
            return null;
        }
    }

    public ParsedRange parseHonestly(@NotNull String value2) {
        if (value2 == null) {
            FakeRangeFormatter.$$$reportNull$$$0(4);
        }
        return this.parseInternal(value2, new ParsePosition(0));
    }

    @NotNull
    private ParsedRange parseInternal(@NotNull String value2, @NotNull ParsePosition position) {
        if (value2 == null) {
            FakeRangeFormatter.$$$reportNull$$$0(5);
        }
        if (position == null) {
            FakeRangeFormatter.$$$reportNull$$$0(6);
        }
        PgRangeLexerAdapter lexer = new PgRangeLexerAdapter();
        lexer.start(value2);
        if (lexer.getTokenType() == PgRangeTokens.EMPTY) {
            position.setIndex(lexer.getTokenEnd());
            ParsedRange parsedRange = ParsedRange.EMPTY;
            if (parsedRange == null) {
                FakeRangeFormatter.$$$reportNull$$$0(7);
            }
            return parsedRange;
        }
        String leftBrace = FakeRangeFormatter.getTokenText((Lexer)lexer, PgRangeTokens.LEFT_BRACKET, position);
        FakeRangeFormatter.advance((Lexer)lexer);
        Pair<Object, String> first2 = this.getValueAndNext((Lexer)lexer, position, PgRangeTokens.COMMA);
        FakeRangeFormatter.advance((Lexer)lexer);
        Pair<Object, String> second = this.getValueAndNext((Lexer)lexer, position, PgRangeTokens.RIGHT_BRACKET);
        FakeRangeFormatter.advance((Lexer)lexer);
        FakeRangeFormatter.checkType((Lexer)lexer, null, position);
        return new ParsedRange(first2.getFirst(), second.getFirst(), leftBrace, (String)second.getSecond(), value2);
    }

    @NotNull
    private Pair<Object, String> getValueAndNext(@NotNull Lexer lexer, @NotNull ParsePosition position, IElementType next) {
        Pair pair;
        if (lexer == null) {
            FakeRangeFormatter.$$$reportNull$$$0(8);
        }
        if (position == null) {
            FakeRangeFormatter.$$$reportNull$$$0(9);
        }
        try {
            FakeRangeFormatter.checkType(lexer, PgRangeTokens.VALUE, position, false);
            Object result2 = this.myFormatter.parse(StringUtil.replace((String)lexer.getTokenText(), (String)"\"", (String)""));
            FakeRangeFormatter.advance(lexer);
            pair = Pair.create((Object)result2, (Object)FakeRangeFormatter.getTokenText(lexer, next, position));
        }
        catch (TokenizeException | ParseException ignore) {
            Pair pair2 = Pair.create(null, (Object)FakeRangeFormatter.getTokenText(lexer, next, position));
            if (pair2 == null) {
                FakeRangeFormatter.$$$reportNull$$$0(11);
            }
            return pair2;
        }
        if (pair == null) {
            FakeRangeFormatter.$$$reportNull$$$0(10);
        }
        return pair;
    }

    private static void advance(@NotNull Lexer lexer) {
        if (lexer == null) {
            FakeRangeFormatter.$$$reportNull$$$0(12);
        }
        lexer.advance();
        while (lexer.getTokenType() == TokenType.WHITE_SPACE) {
            lexer.advance();
        }
    }

    private static String getTokenText(@NotNull Lexer lexer, IElementType type2, @NotNull ParsePosition position) {
        if (lexer == null) {
            FakeRangeFormatter.$$$reportNull$$$0(13);
        }
        if (position == null) {
            FakeRangeFormatter.$$$reportNull$$$0(14);
        }
        FakeRangeFormatter.checkType(lexer, type2, position);
        return lexer.getTokenText();
    }

    private static void checkType(@NotNull Lexer lexer, IElementType type2, @NotNull ParsePosition position) {
        if (lexer == null) {
            FakeRangeFormatter.$$$reportNull$$$0(15);
        }
        if (position == null) {
            FakeRangeFormatter.$$$reportNull$$$0(16);
        }
        FakeRangeFormatter.checkType(lexer, type2, position, true);
    }

    private static void checkType(@NotNull Lexer lexer, IElementType type2, @NotNull ParsePosition position, boolean updatePosition) {
        if (lexer == null) {
            FakeRangeFormatter.$$$reportNull$$$0(17);
        }
        if (position == null) {
            FakeRangeFormatter.$$$reportNull$$$0(18);
        }
        if (lexer.getTokenType() != type2) {
            throw new TokenizeException(lexer.getCurrentPosition().getOffset());
        }
        if (updatePosition) {
            position.setIndex(lexer.getCurrentPosition().getOffset());
        }
    }

    @NotNull
    public String format(@NotNull Object value2) {
        if (value2 == null) {
            FakeRangeFormatter.$$$reportNull$$$0(19);
        }
        String string = (String)value2;
        if (string == null) {
            FakeRangeFormatter.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public String rebuild(@NotNull ParsedRange range) {
        if (range == null) {
            FakeRangeFormatter.$$$reportNull$$$0(21);
        }
        String stringValue = range.getString();
        if (range == ParsedRange.EMPTY) {
            String string = stringValue;
            if (string == null) {
                FakeRangeFormatter.$$$reportNull$$$0(22);
            }
            return string;
        }
        String string = range.getLeftBrace() + (range.getStart() != null ? this.myFormatter.format(range.getStart()) : "") + "," + (range.getEnd() != null ? this.myFormatter.format(range.getEnd()) : "") + range.getRightBrace();
        if (string == null) {
            FakeRangeFormatter.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public String toString() {
        String string = this.myFormatter.toString() + ", " + this.myFormatter.toString();
        if (string == null) {
            FakeRangeFormatter.$$$reportNull$$$0(24);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7, 10, 11, 20, 22, 23, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
            case 1: 
            case 7: 
            case 10: 
            case 11: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/FakeRangeFormatter";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/FakeRangeFormatter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parseInternal";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAndNext";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "rebuild";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: 
            case 10: 
            case 11: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseHonestly";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseInternal";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getValueAndNext";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "advance";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTokenText";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "rebuild";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7, 10, 11, 20, 22, 23, 24 -> new IllegalStateException(string);
        };
    }

    public static class ParsedRange {
        public static final ParsedRange EMPTY = new ParsedRange(null, null, null, null, "empty");
        private final Object myStart;
        private final Object myEnd;
        private final String myString;
        private final String myLeftBrace;
        private final String myRightBrace;

        ParsedRange(Object start2, Object end, String leftBrace, String rightBrace, String string) {
            this.myStart = start2;
            this.myEnd = end;
            this.myLeftBrace = leftBrace;
            this.myRightBrace = rightBrace;
            this.myString = string;
        }

        public Object getStart() {
            return this.myStart;
        }

        public Object getEnd() {
            return this.myEnd;
        }

        public String getString() {
            return this.myString;
        }

        public String getLeftBrace() {
            return this.myLeftBrace;
        }

        public String getRightBrace() {
            return this.myRightBrace;
        }
    }

    private static class TokenizeException
    extends RuntimeException {
        private final int myPosition;

        TokenizeException(int position) {
            this.myPosition = position;
        }

        public int getPosition() {
            return this.myPosition;
        }
    }
}

