/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.audit;

import com.intellij.database.console.JdbcConsoleBase;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.session.DatabaseLogView;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.debugger.SqlDebugAuxiliaryRequest;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.audit.SessionLogger;
import com.intellij.database.run.session.LogView;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ObjectUtils;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class DatabaseSessionLogger
extends SessionLogger {
    public static final Key<Boolean> SILENT_REQUEST = Key.create((String)"SILENT_REQUEST");

    public DatabaseSessionLogger(@NotNull LogView<?> view2) {
        if (view2 == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(0);
        }
        super(view2);
    }

    @Override
    public void jobSubmitted(@NotNull DataRequest request2, @NotNull DataProducer producer) {
        if (request2 == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(1);
        }
        if (producer == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(2);
        }
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> {
            if (!this.myView.getTarget().isValid()) {
                return;
            }
            this.myView.ensureContentInitialized();
            this.myView.beforeExecution();
        });
        super.jobSubmitted(request2, producer);
    }

    @Override
    protected boolean skipJob(@NotNull DataRequest request2) {
        if (request2 == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(3);
        }
        return super.skipJob(request2) || request2 instanceof SqlDebugAuxiliaryRequest || Boolean.TRUE.equals(SILENT_REQUEST.get((UserDataHolder)request2)) || request2 instanceof DataRequest.Cancel || request2 instanceof DataRequest.Disconnect || !this.shouldShowView(request2.owner) || request2 instanceof DataRequest.TxRequest || request2 instanceof DataRequest.SchemaSwitchRequest && !((DataRequest.SchemaSwitchRequest)request2).forced || SessionsUtil.isInternalOwner(request2.owner);
    }

    @Override
    protected boolean shouldActivate(@NotNull DataRequest request2) {
        ConsoleDataRequest cdr;
        DataRequest.Owner owner;
        if (request2 == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(4);
        }
        if ((owner = request2.owner) instanceof JdbcConsoleBase && ((JdbcConsoleBase)owner).isNotebookMode() && (cdr = (ConsoleDataRequest)ObjectUtils.tryCast((Object)((Object)request2), ConsoleDataRequest.class)) != null && cdr.produceResultSet()) {
            return false;
        }
        return DatabaseSessionLogger.getClient(owner).map(c2 -> c2.getShowOnActivity()).orElseGet(() -> super.shouldActivate(request2));
    }

    @Override
    protected boolean shouldFocusOnError(@NotNull DataRequest.Context context) {
        if (context == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(5);
        }
        return DatabaseSessionLogger.getClient(context.request.owner).map(c2 -> c2.focusOnError(context)).orElseGet(() -> super.shouldFocusOnError(context));
    }

    @Override
    protected boolean shouldShowOnAttention(@NotNull DataRequest.Context context) {
        if (context == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(6);
        }
        return this.shouldShowView(context) && !Boolean.TRUE.equals(SILENT_REQUEST.get((UserDataHolder)context.request)) && DatabaseSessionLogger.getClient(context.request.owner).map(c2 -> c2.showOnAttention(context)).orElseGet(() -> super.shouldFocusOnError(context)) != false;
    }

    @Override
    protected void bringAttentionByNotification(@NotNull DataRequest.Context context) {
        if (context == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(7);
        }
        if (this.shouldShowView(context)) {
            super.bringAttentionByNotification(context);
        }
    }

    @NotNull
    private static Optional<VisibleDatabaseSessionClient> getClient(@NotNull DataRequest.Owner owner) {
        if (owner == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(8);
        }
        Optional<VisibleDatabaseSessionClient> optional = Optional.ofNullable((VisibleDatabaseSessionClient)ObjectUtils.tryCast((Object)owner, VisibleDatabaseSessionClient.class));
        if (optional == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(9);
        }
        return optional;
    }

    private boolean shouldShowView(@NotNull DataRequest.Context context) {
        if (context == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(10);
        }
        return this.shouldShowView(context.request.owner);
    }

    private boolean shouldShowView(@NotNull DataRequest.Owner owner) {
        if (owner == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(11);
        }
        return this.getView().shouldActivateForOutput(owner);
    }

    @NotNull
    private DatabaseLogView<?> getView() {
        DatabaseLogView databaseLogView = (DatabaseLogView)this.myView;
        if (databaseLogView == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(12);
        }
        return databaseLogView;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/audit/DatabaseSessionLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/audit/DatabaseSessionLogger";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getClient";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "jobSubmitted";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "skipJob";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldActivate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldFocusOnError";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shouldShowOnAttention";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "bringAttentionByNotification";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getClient";
                break;
            }
            case 9: 
            case 12: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shouldShowView";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 12 -> new IllegalStateException(string);
        };
    }
}

