/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.run.actions.DataGridUrlNavigationActionHelper;
import com.intellij.database.run.actions.NavigateUrlActionKt;
import com.intellij.database.run.actions.URLResolver;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.project.Project;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/run/actions/WebUrlResolver;", "Lcom/intellij/database/run/actions/URLResolver;", "()V", "allowedSymbolsRegex", "Lkotlin/text/Regex;", "urlWithoutProtocolRegex", "looksLikeWebUrl", "", "urlString", "", "navigateUrl", "", "url", "Ljava/net/URL;", "project", "Lcom/intellij/openapi/project/Project;", "prependProtocol", "settings", "Lcom/intellij/database/settings/DatabaseSettings;", "urlStr", "prependProtocolIfNeeded", "tryParseUrl", "value", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nNavigateUrlAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavigateUrlAction.kt\ncom/intellij/database/run/actions/WebUrlResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,220:1\n1#2:221\n1747#3,3:222\n*S KotlinDebug\n*F\n+ 1 NavigateUrlAction.kt\ncom/intellij/database/run/actions/WebUrlResolver\n*L\n163#1:222,3\n*E\n"})
public final class WebUrlResolver
implements URLResolver {
    @NotNull
    private final Regex urlWithoutProtocolRegex = new Regex("^(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,}(?:/\\S*)?$");
    @NotNull
    private final Regex allowedSymbolsRegex = new Regex("^[a-zA-Z0-9-_:/.?&=+#%]+$");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public URL tryParseUrl(@Nullable String value2) {
        Object object;
        DatabaseSettings settings = DatabaseSettings.getSettings();
        Object object2 = value2;
        String it2 = object2;
        boolean bl = false;
        if (it2 == null) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        String string = object2;
        String string2 = string;
        if (string2 == null) return null;
        String urlStr = string2;
        boolean bl3 = false;
        Intrinsics.checkNotNull((Object)settings);
        String modifiedUrl = this.prependProtocolIfNeeded(settings, urlStr);
        object2 = DataGridUrlNavigationActionHelper.INSTANCE.buildUrlIfValid(modifiedUrl);
        if (object2 == null) return null;
        Object it3 = object = object2;
        boolean bl4 = false;
        Object[] objectArray = new String[]{"http", "https"};
        if (!CollectionsKt.listOf((Object[])objectArray).contains(((URL)it3).getProtocol())) return null;
        Object object3 = object;
        return object3;
    }

    private final String prependProtocolIfNeeded(DatabaseSettings settings, String urlStr) {
        if (!StringsKt.contains$default((CharSequence)urlStr, (CharSequence)"://", (boolean)false, (int)2, null) && this.looksLikeWebUrl(urlStr)) {
            return this.prependProtocol(settings, urlStr);
        }
        return urlStr;
    }

    private final String prependProtocol(DatabaseSettings settings, String urlStr) {
        return settings.isWebUrlWithoutProtocolAssumedHttp() ? "http://" + urlStr : "https://" + urlStr;
    }

    private final boolean looksLikeWebUrl(String urlString) {
        boolean bl;
        List lastParts;
        block5: {
            String[] stringArray;
            if (!this.urlWithoutProtocolRegex.matches((CharSequence)urlString)) {
                return false;
            }
            String urlPathAndDomain = StringsKt.substringBefore$default((String)urlString, (String)"?", null, (int)2, null);
            String domainWithPossiblePath = StringsKt.substringBefore$default((String)urlPathAndDomain, (String)"/", null, (int)2, null);
            List domainParts = StringsKt.split$default((CharSequence)domainWithPossiblePath, (String[])(stringArray = new String[]{"."}), (boolean)false, (int)0, (int)6, null);
            if (domainParts.isEmpty() || domainParts.size() < 2) {
                return false;
            }
            lastParts = CollectionsKt.takeLast((List)domainParts, (int)3);
            Iterable $this$any$iv = lastParts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it2 = (String)element$iv;
                    boolean bl2 = false;
                    if (!NavigateUrlActionKt.access$getPOPULAR_TLDS$p().contains(it2)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl || lastParts.size() > 1 && NavigateUrlActionKt.access$getPOPULAR_TLDS$p().contains(lastParts.get(lastParts.size() - 2) + "." + CollectionsKt.last((List)lastParts)) || lastParts.size() > 2 && NavigateUrlActionKt.access$getPOPULAR_TLDS$p().contains(CollectionsKt.joinToString$default((Iterable)lastParts, (CharSequence)".", null, null, (int)0, null, null, (int)62, null));
    }

    @Override
    public void navigateUrl(@NotNull URL url, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = url.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        if (!this.allowedSymbolsRegex.matches((CharSequence)string)) {
            String string2 = DatabaseBundle.message("notification.content.url.link.symbols.unsupported", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            NavigateUrlActionKt.access$showNotification(string2, project);
            return;
        }
        BrowserUtil.browse((URL)url);
    }
}

