/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.run.actions.DataGridUrlNavigationActionHelper;
import com.intellij.database.run.actions.NavigateUrlActionKt;
import com.intellij.database.run.actions.URLResolver;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/run/actions/LocalFileUrlResolver;", "Lcom/intellij/database/run/actions/URLResolver;", "()V", "unixPathRegex", "Lkotlin/text/Regex;", "windowsPathRegex", "looksLikeLocalFilePath", "", "urlString", "", "navigateUrl", "", "url", "Ljava/net/URL;", "project", "Lcom/intellij/openapi/project/Project;", "tryParseUrl", "value", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nNavigateUrlAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavigateUrlAction.kt\ncom/intellij/database/run/actions/LocalFileUrlResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,220:1\n1#2:221\n*E\n"})
public final class LocalFileUrlResolver
implements URLResolver {
    @NotNull
    private final Regex windowsPathRegex = new Regex("^[a-zA-Z]:\\\\(?:[^\\\\:*?\"<>|\r\n]+\\\\)*[^\\\\:*?\"<>|\r\n]*$");
    @NotNull
    private final Regex unixPathRegex = new Regex("^/(?:[^/:*?\"<>|\r\n]+/)*[^/:*?\"<>|\r\n]*$");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public URL tryParseUrl(@Nullable String value2) {
        String string;
        String it2 = string = value2;
        boolean bl = false;
        if (it2 == null) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        String string2 = string;
        if (string2 == null) {
            return null;
        }
        String urlStr = string2;
        String modifiedUrl = !StringsKt.contains$default((CharSequence)urlStr, (CharSequence)"://", (boolean)false, (int)2, null) && this.looksLikeLocalFilePath(urlStr) ? "file:///" + urlStr : urlStr;
        URL uRL = DataGridUrlNavigationActionHelper.INSTANCE.buildUrlIfValid(modifiedUrl);
        if (uRL == null) {
            return null;
        }
        URL url = uRL;
        if (!Intrinsics.areEqual((Object)url.getProtocol(), (Object)"file")) return null;
        String string3 = url.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getHost(...)");
        if (((CharSequence)string3).length() != 0) return null;
        boolean bl3 = true;
        if (!bl3) return null;
        URL uRL2 = url;
        return uRL2;
    }

    private final boolean looksLikeLocalFilePath(String urlString) {
        return ClientSystemInfo.Companion.isMac() || SystemInfo.isUnix ? this.unixPathRegex.matches((CharSequence)urlString) : (SystemInfo.isWindows ? this.windowsPathRegex.matches((CharSequence)urlString) : false);
    }

    @Override
    public void navigateUrl(@NotNull URL url, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Path path = Path.of(url.getPath(), new String[0]);
        Intrinsics.checkNotNull((Object)path);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Object[] objectArray = new Object[]{path.toAbsolutePath()};
            String string = DatabaseBundle.message("notification.content.url.file.not.exist", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            NavigateUrlActionKt.access$showNotification(string, project);
            return;
        }
        RevealFileAction.openFile((Path)path);
    }
}

