/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.debugger.SqlDebugSessionRunner;
import com.intellij.database.editor.PerformRoutineFromFileActionBase;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.run.actions.PerformRoutineActionBase;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ObjectUtils;
import icons.DatabaseIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DebugRoutineAction
extends PerformRoutineFromFileActionBase {
    private static final Icon debugProcedureIcon = LayeredIcon.layeredIcon(() -> new Icon[]{DatabaseIcons.Procedure, DatabaseIcons.GreenBugOverlap});
    private static final Icon debugFunctionIcon = LayeredIcon.layeredIcon(() -> new Icon[]{DatabaseIcons.Function, DatabaseIcons.GreenBugOverlap});

    public DebugRoutineAction() {
        super(DatabaseBundle.messagePointer("action.DatabaseView.DebugRoutine.procedure.text", new Object[0]), DatabaseBundle.messagePointer("action.DatabaseView.DebugRoutine.function.text", new Object[0]));
    }

    @Override
    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            DebugRoutineAction.$$$reportNull$$$0(0);
        }
        Presentation p2 = e2.getPresentation();
        if (!e2.getPlace().startsWith("Editor")) {
            p2.setEnabledAndVisible(false);
            return;
        }
        PerformRoutineActionBase.ActionData actionData = this.getActionData(e2);
        if (actionData == null) {
            p2.setEnabledAndVisible(false);
            return;
        }
        SqlDebugSessionRunner.SqlDebugAvailability availability = DebugRoutineAction.checkAvailability(actionData);
        p2.setVisible(availability.visible);
        p2.setEnabled(availability.enabled);
        if (availability.visible) {
            BasicRoutine routine2 = actionData.routine;
            p2.setText(this.getText(routine2));
            p2.setIcon(this.getIcon(e2, routine2));
        }
    }

    @Override
    @Nullable
    protected PerformRoutineActionBase.ActionData getActionData(@NotNull AnActionEvent e2) {
        DbRoutine routine2;
        BasicRoutine basic;
        if (e2 == null) {
            DebugRoutineAction.$$$reportNull$$$0(1);
        }
        return (basic = (BasicRoutine)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap(routine2 = DebugRoutineAction.getDbRoutine(e2)), BasicRoutine.class)) != null ? new PerformRoutineActionBase.PerformActionData(routine2.getDataSource(), basic) : super.getActionData(e2);
    }

    private static SqlDebugSessionRunner.SqlDebugAvailability checkAvailability(@NotNull PerformRoutineActionBase.ActionData actionData) {
        if (actionData == null) {
            DebugRoutineAction.$$$reportNull$$$0(2);
        }
        return SqlDebugSessionRunner.Handler.checkDebuggerAvailability(actionData.dataSource, actionData.routine);
    }

    @Override
    protected Icon getIcon(@NotNull AnActionEvent e2, @Nullable BasicRoutine routine2) {
        if (e2 == null) {
            DebugRoutineAction.$$$reportNull$$$0(3);
        }
        if (e2.getPlace().endsWith("Toolbar")) {
            DasRoutine.Kind routineKind;
            DasRoutine.Kind kind = routineKind = routine2 != null ? routine2.getRoutineKind() : null;
            if (routineKind == DasRoutine.Kind.PROCEDURE) {
                return debugProcedureIcon;
            }
            if (routineKind == DasRoutine.Kind.FUNCTION) {
                return debugFunctionIcon;
            }
            return DatabaseIcons.GreenBugOverlap;
        }
        return AllIcons.Actions.StartDebugger;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            DebugRoutineAction.$$$reportNull$$$0(4);
        }
        if (!e2.getPlace().startsWith("Editor")) {
            return;
        }
        super.actionPerformed(e2);
    }

    @Override
    @NotNull
    protected PerformRoutineActionBase.RequestRunner getRunner(@NotNull PerformRoutineActionBase.ActionData actionData) {
        if (actionData == null) {
            DebugRoutineAction.$$$reportNull$$$0(5);
        }
        return new DebugRequestRunner(actionData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionData";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/actions/DebugRoutineAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getActionData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAvailability";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getRunner";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DebugRequestRunner
    implements PerformRoutineActionBase.RequestRunner {
        private final PerformRoutineActionBase.ActionData myActionData;

        DebugRequestRunner(@NotNull PerformRoutineActionBase.ActionData actionData) {
            if (actionData == null) {
                DebugRequestRunner.$$$reportNull$$$0(0);
            }
            this.myActionData = actionData;
        }

        @Override
        public void runRequest(@NotNull DataRequest.OwnerEx owner, @NotNull GridDataRequest request2) {
            if (owner == null) {
                DebugRequestRunner.$$$reportNull$$$0(1);
            }
            if (request2 == null) {
                DebugRequestRunner.$$$reportNull$$$0(2);
            }
            assert (owner instanceof JdbcConsole) : "Expected the owner is a Console but it's " + owner.getClass().getName();
            JdbcConsole console = (JdbcConsole)owner;
            String title = "Debug routine " + this.myActionData.routine.getName();
            assert (request2 instanceof DataRequest.CallRequest) : "The request must be an instance of CallRequest but it's " + request2.getClass().getName();
            DataRequest.CallRequest callRequest = (DataRequest.CallRequest)request2;
            List<DataRequest.CallRequest.Statement> requestQueries = callRequest.queries;
            assert (requestQueries.size() == 1) : "We can debug exactly one statement but here is " + requestQueries.size();
            String statementText = requestQueries.get((int)0).statement;
            LightVirtualFile virtualFile = new LightVirtualFile(title, (CharSequence)statementText);
            virtualFile.setLanguage((Language)DbSqlUtilCore.getSqlDialect(this.myActionData.dataSource));
            SqlDebugSessionRunner.Handler.startDebugProcess(console, false, (VirtualFile)virtualFile, null, callRequest.path, title, model2 -> DataRequest.newCallRequest(console, callRequest.queries, callRequest.path));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/DebugRoutineAction$DebugRequestRunner";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runRequest";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

