/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi.documentation;

import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.ui.DbDocumentationHelper;
import com.intellij.database.util.QNameUtil;
import com.intellij.lang.documentation.DocumentationProviderEx;
import com.intellij.lang.documentation.ExternalDocumentationHandler;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Image;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbDocumentationProvider
extends DocumentationProviderEx
implements ExternalDocumentationHandler {
    @Nullable
    @Nls
    public String getQuickNavigateInfo(PsiElement element2, PsiElement originalElement) {
        if (element2 instanceof DbElement) {
            DbElement e2 = (DbElement)element2;
            return e2.getTypeName() + " " + QNameUtil.getQualifiedName(e2);
        }
        return null;
    }

    @Nls
    @Nullable
    private static String generateDoc(PsiElement element2, boolean hover) {
        if (element2 instanceof DbElement) {
            return ((DbElement)element2).getDocumentation(hover).toString();
        }
        return null;
    }

    @Nullable
    @Nls
    public String generateDoc(PsiElement element2, PsiElement originalElement) {
        return DbDocumentationProvider.generateDoc(element2, false);
    }

    @Nullable
    @Nls
    public String generateHoverDoc(@NotNull PsiElement element2, @Nullable PsiElement originalElement) {
        if (element2 == null) {
            DbDocumentationProvider.$$$reportNull$$$0(0);
        }
        return DbDocumentationProvider.generateDoc(element2, true);
    }

    @Nullable
    public Image getLocalImageForElement(@NotNull PsiElement element2, @NotNull String imageSpec) {
        if (element2 == null) {
            DbDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (imageSpec == null) {
            DbDocumentationProvider.$$$reportNull$$$0(2);
        }
        return DbDocumentationHelper.resolveImageRef(imageSpec);
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element2, PsiElement originalElement) {
        BasicElement basic;
        DbElement dbElement = (DbElement)ObjectUtils.tryCast((Object)element2, DbElement.class);
        BasicElement basicElement = basic = dbElement == null ? null : (BasicElement)ObjectUtils.tryCast((Object)dbElement.getDelegate(), BasicElement.class);
        if (basic != null) {
            String link = (String)Pair.getSecond(ModelFacade.forDbms(dbElement.getDataSource().getDbms()).getModelHelper().getDocumentationLink(basic));
            return ContainerUtil.createMaybeSingletonList((Object)link);
        }
        return null;
    }

    public boolean canHandleExternal(@Nullable PsiElement element2, @Nullable PsiElement originalElement) {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageSpec";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/psi/documentation/DbDocumentationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generateHoverDoc";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getLocalImageForElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

