/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.psi.ModelNameIndex;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.TreePattern;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public final class ModelNameIndexImpl
implements ModelNameIndex {
    public static final ModelNameIndex EMPTY_INDEX = new ModelNameIndexImpl(DasUtil.emptyModel());
    private final DasModel model;
    private final AtomicReference<NameIndex> myNameIndex = new AtomicReference();

    public ModelNameIndexImpl(DasModel model2) {
        this.model = model2;
    }

    @Override
    public void clear() {
        this.myNameIndex.set(null);
    }

    @Override
    @NotNull
    public Collection<String> getAllNames() {
        Set<String> set = this.getNameIndex().objects.keySet();
        if (set == null) {
            ModelNameIndexImpl.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<DasObject> getObjectsByName(@NotNull String name2) {
        if (name2 == null) {
            ModelNameIndexImpl.$$$reportNull$$$0(1);
        }
        Collection<DasObject> collection2 = this.getNameIndex().getObjects(name2);
        if (collection2 == null) {
            ModelNameIndexImpl.$$$reportNull$$$0(2);
        }
        return collection2;
    }

    @Override
    @NotNull
    public JBIterable<DasObject> getObjectsByNameInsensitive(@NotNull String name2) {
        if (name2 == null) {
            ModelNameIndexImpl.$$$reportNull$$$0(3);
        }
        NameIndex index2 = this.getNameIndex();
        Set<String> names2 = index2.insensitive.get(name2);
        JBIterable jBIterable = names2 == null ? JBIterable.empty() : JBIterable.from(names2).flatten(index2::getObjects);
        if (jBIterable == null) {
            ModelNameIndexImpl.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    @NotNull
    private NameIndex getNameIndex() {
        NameIndex res2;
        BasicRoot root2;
        BasicRoot basicRoot = root2 = this.model instanceof BaseModel ? ((BaseModel)this.model).getRoot() : null;
        do {
            NameIndex result2;
            if ((result2 = this.myNameIndex.get()) != null) {
                NameIndex nameIndex = result2;
                if (nameIndex == null) {
                    ModelNameIndexImpl.$$$reportNull$$$0(5);
                }
                return nameIndex;
            }
            res2 = new NameIndex();
            if (root2 != null) {
                res2.put(root2.getName(), root2);
            }
            int i2 = 0;
            TreePattern scope = DbImplUtilCore.getIntrospectionScope((DasDataSource)ObjectUtils.tryCast((Object)root2, DasDataSource.class));
            JBTreeTraverser traverser2 = (JBTreeTraverser)((JBTreeTraverser)this.model.traverser().expand(o2 -> o2.getKind() != ObjectKind.ROUTINE && DbImplUtilCore.isExpandable(o2, scope))).filter(o2 -> o2.getKind() != ObjectKind.ROOT);
            for (DasObject o3 : traverser2.bfsTraversal()) {
                if (++i2 % 1000 == 0) {
                    ProgressManager.checkCanceled();
                    result2 = this.myNameIndex.get();
                    if (result2 != null) {
                        NameIndex nameIndex = result2;
                        if (nameIndex == null) {
                            ModelNameIndexImpl.$$$reportNull$$$0(6);
                        }
                        return nameIndex;
                    }
                }
                String name2 = o3.getName();
                res2.put(name2, o3);
            }
            res2.compact();
        } while (!this.myNameIndex.compareAndSet(null, res2));
        NameIndex nameIndex = res2;
        if (nameIndex == null) {
            ModelNameIndexImpl.$$$reportNull$$$0(7);
        }
        return nameIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/ModelNameIndexImpl";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllNames";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/ModelNameIndexImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsByName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsByNameInsensitive";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getObjectsByName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getObjectsByNameInsensitive";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3 -> new IllegalArgumentException(string);
        };
    }

    private static final class NameIndex {
        final Map<String, List<DasObject>> objects = CollectionFactory.createSmallMemoryFootprintMap();
        private final Map<String, Set<String>> insensitive = CollectionFactory.createCaseInsensitiveStringMap();

        private NameIndex() {
        }

        void put(@NotNull String name2, @NotNull DasObject object) {
            SmartList objectsBucket;
            if (name2 == null) {
                NameIndex.$$$reportNull$$$0(0);
            }
            if (object == null) {
                NameIndex.$$$reportNull$$$0(1);
            }
            if ((objectsBucket = this.objects.get(name2)) == null) {
                objectsBucket = new SmartList();
                this.objects.put(name2, (List<DasObject>)objectsBucket);
            }
            objectsBucket.add((DasObject)object);
            ObjectOpenHashSet namesBucket = this.insensitive.get(name2);
            if (namesBucket == null) {
                namesBucket = new ObjectOpenHashSet();
                this.insensitive.put(name2, (Set<String>)namesBucket);
            }
            namesBucket.add((String)name2);
        }

        void compact() {
            CollectionFactory.trimMap(this.objects);
            for (Set<String> value2 : this.insensitive.values()) {
                CollectionFactory.trimSet(value2);
            }
            CollectionFactory.trimMap(this.insensitive);
        }

        @NotNull
        Collection<DasObject> getObjects(@NotNull String name2) {
            if (name2 == null) {
                NameIndex.$$$reportNull$$$0(2);
            }
            Collection collection2 = (Collection)ObjectUtils.chooseNotNull(this.objects.get(name2), Collections.emptyList());
            if (collection2 == null) {
                NameIndex.$$$reportNull$$$0(3);
            }
            return collection2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/psi/ModelNameIndexImpl$NameIndex";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/psi/ModelNameIndexImpl$NameIndex";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObjects";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "put";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getObjects";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

