/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbRenamePsiElementProcessor;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.RenameQueryGenerator;
import com.intellij.database.view.structure.DvHandlers;
import com.intellij.database.view.structure.DvSimpleDsGroup;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DbRenameHandler.$$$reportNull$$$0(0);
        }
        PsiElement psiElement = PsiElementRenameHandler.getElement((DataContext)dataContext);
        DbElement dbElement = DbRenamePsiElementProcessor.getDbElement(psiElement);
        BasicNode node2 = DatabaseContextFun.getSelectedSingleNode(dataContext);
        return node2 instanceof DvSimpleDsGroup || dbElement != null && !DbRenameHandler.isVetoedElement(dbElement);
    }

    public static boolean isVetoedElement(@NotNull DbElement dbElement) {
        if (dbElement == null) {
            DbRenameHandler.$$$reportNull$$$0(1);
        }
        if (dbElement instanceof DbDataSource) {
            return false;
        }
        if (DataImporter.isBusy(dbElement)) {
            return true;
        }
        if (DbSqlUtil.isSqlElement(dbElement)) {
            return false;
        }
        BasicNamedElement element2 = (BasicNamedElement)ObjectUtils.tryCast((Object)dbElement.getDelegate(), BasicNamedElement.class);
        BasicModel model2 = element2 == null ? null : element2.getModel();
        return model2 == null || !RenameQueryGenerator.canRename(model2, element2);
    }

    public void invoke(@NotNull Project project, Editor editor2, PsiFile file, DataContext dataContext) {
        DvSimpleDsGroup group2;
        String initialName;
        String newName;
        PsiElement element2;
        DbElement dbElement;
        if (project == null) {
            DbRenameHandler.$$$reportNull$$$0(2);
        }
        Object delegate = (dbElement = DbRenamePsiElementProcessor.getDbElement(element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext))) != null ? dbElement.getDelegate() : null;
        BasicNode node2 = DatabaseContextFun.getSelectedSingleNode(dataContext);
        if (delegate instanceof BasicElement) {
            RefactoringActionHandlerFactory.getInstance().createRenameHandler().invoke(project, new PsiElement[]{element2}, dataContext);
        } else if (dbElement instanceof DbDataSourceImpl) {
            String newName2;
            String initialName2 = dbElement.getName();
            String newText = Messages.showInputDialog((Project)project, (String)DatabaseBundle.message("dialog.message.rename.data.source.to", initialName2), (String)DatabaseBundle.message("dialog.title.rename", new Object[0]), (Icon)Messages.getQuestionIcon(), (String)initialName2, null);
            int idx = newText == null ? -1 : newText.lastIndexOf("/");
            String groupName = idx < 0 ? null : newText.substring(0, idx);
            String string = newName2 = idx < 0 ? newText : newText.substring(idx + 1);
            if (StringUtil.isNotEmpty((String)newName2)) {
                if (idx >= 0) {
                    DbDataSourceImpl dbDs = (DbDataSourceImpl)dbElement;
                    dbDs.getDbManager().setGroupName((RawDataSource)dbDs.getDelegate(), groupName);
                }
                dbElement.setName(newName2);
                DatabaseView.refreshViewAndSelect(project, Collections.singleton(dbElement));
            }
        } else if (node2 instanceof DvSimpleDsGroup && StringUtil.isNotEmpty((String)(newName = DbRenameHandler.askForNewName(project, initialName = (group2 = (DvSimpleDsGroup)node2).getName())))) {
            DvHandlers.renameDsGroup(project, group2, newName, this.getClass());
        }
    }

    @Nullable
    private static String askForNewName(@NotNull Project project, String initialName) {
        if (project == null) {
            DbRenameHandler.$$$reportNull$$$0(3);
        }
        String newName = Messages.showInputDialog((Project)project, (String)DatabaseBundle.message("dialog.message.rename.group.to", initialName), (String)DatabaseBundle.message("dialog.title.rename", new Object[0]), null, (String)initialName, null);
        return newName;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements2, DataContext dataContext) {
        if (project == null) {
            DbRenameHandler.$$$reportNull$$$0(4);
        }
        if (elements2 == null) {
            DbRenameHandler.$$$reportNull$$$0(5);
        }
        this.invoke(project, null, null, dataContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/psi/DbRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isVetoedElement";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "askForNewName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class DatabaseVetoRenameCondition
    implements Condition<PsiElement> {
        public boolean value(PsiElement element2) {
            return element2 instanceof DbElement && DbRenameHandler.isVetoedElement((DbElement)element2);
        }
    }
}

