/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.structure.DvFamilyId;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbPresentationCore {
    public static final SimpleTextAttributes INFO_ATTRS = SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES;
    public static final SimpleTextAttributes BOLD_INFO_ATTRS = new SimpleTextAttributes(129, NamedColorUtil.getInactiveTextColor());
    public static final @NlsContexts.Label String UNNAMED = DatabaseBundle.message("label.unnamed1", new Object[0]);
    private static final Map<ObjectKind, Icon> ourIcons = Map.ofEntries(Map.entry(ObjectKind.DATABASE, DatabaseIcons.Database), Map.entry(ObjectKind.SCHEMA, DatabaseIcons.Schema), Map.entry(ObjectKind.SEQUENCE, DatabaseIcons.Sequence), Map.entry(ObjectKind.CLUSTER, DatabaseIcons.UnspecifiedCluster), Map.entry(ObjectKind.TABLE, DatabaseIcons.Table), Map.entry(ObjectKind.COLUMN, DatabaseIcons.Col), Map.entry(ObjectKind.INDEX, DatabaseIcons.Index), Map.entry(ObjectKind.KEY, DatabaseIcons.GoldKeyAlt), Map.entry(ObjectKind.FOREIGN_KEY, DatabaseIcons.BlueKey), Map.entry(ObjectKind.MAT_LOG, DatabaseIcons.MaterializedLog), Map.entry(ObjectKind.MAT_VIEW, DatabaseIcons.MaterializedView), Map.entry(ObjectKind.VIEW, AllIcons.Nodes.DataSchema), Map.entry(ObjectKind.CHECK, DatabaseIcons.CheckConstraint), Map.entry(ObjectKind.DEFAULT, DatabaseIcons.DefaultConstraint), Map.entry(ObjectKind.RULE, DatabaseIcons.Rule), Map.entry(ObjectKind.TRIGGER, DatabaseIcons.Trigger), Map.entry(ObjectKind.PACKAGE, DatabaseIcons.Package), Map.entry(ObjectKind.ALIAS_TYPE, AllIcons.Nodes.Type), Map.entry(ObjectKind.TABLE_TYPE, AllIcons.Nodes.Type), Map.entry(ObjectKind.OBJECT_TYPE, AllIcons.Nodes.Type), Map.entry(ObjectKind.OBJECT_ATTRIBUTE, AllIcons.Nodes.ObjectTypeAttribute), Map.entry(ObjectKind.COLLECTION_TYPE, DatabaseIcons.CollectionType), Map.entry(ObjectKind.BODY, DatabaseIcons.Body), Map.entry(ObjectKind.ROUTINE, DatabaseIcons.Routine), Map.entry(ObjectKind.ARGUMENT, DatabaseIcons.Argument), Map.entry(ObjectKind.OPERATOR, DatabaseIcons.Operator), Map.entry(ObjectKind.OPERATOR_FAMILY, DatabaseIcons.OperatorFamily), Map.entry(ObjectKind.OPERATOR_CLASS, DatabaseIcons.OperatorClass), Map.entry(ObjectKind.VARIABLE, AllIcons.Nodes.Variable), Map.entry(ObjectKind.SYNONYM, DatabaseIcons.Synonym), Map.entry(ObjectKind.VIRTUAL_TABLE, DatabaseIcons.Table), Map.entry(ObjectKind.DYNAMIC_TABLE, DatabaseIcons.Table), Map.entry(ObjectKind.SCRIPT, DatabaseIcons.Scripting_script), Map.entry(ObjectKind.COLLATION, DatabaseIcons.Collation), Map.entry(ObjectKind.CONNECTION, DatabaseIcons.Connector), Map.entry(ObjectKind.USER, AllIcons.General.User), Map.entry(ObjectKind.ROLE, DatabaseIcons.Role), Map.entry(ObjectKind.GROUP, DatabaseIcons.Role), Map.entry(ObjectKind.LOGIN, AllIcons.General.User), Map.entry(ObjectKind.FOREIGN_DATA_WRAPPER, DatabaseIcons.Foreign_datawrapper), Map.entry(ObjectKind.FOREIGN_TABLE, DatabaseIcons.Foreign_table), Map.entry(ObjectKind.FOREIGN_FUNCTION, DatabaseIcons.FunctionExternal), Map.entry(ObjectKind.SERVER, DatabaseIcons.Foreign_server), Map.entry(ObjectKind.USER_MAPPING, DatabaseIcons.User_mapping), Map.entry(ObjectKind.DATASHARE, DatabaseIcons.DataShare), Map.entry(ObjectKind.DB_LINK, DatabaseIcons.DatabaseLink), Map.entry(ObjectKind.EXTERNAL_DATABASE, DatabaseIcons.DatabaseExternal), Map.entry(ObjectKind.EXTERNAL_SCHEMA, DatabaseIcons.External_schema_object), Map.entry(ObjectKind.SCHEDULED_EVENT, DatabaseIcons.ScheduledEvent), Map.entry(ObjectKind.ACCESS_METHOD, DatabaseIcons.Access_method), Map.entry(ObjectKind.AGGREGATE, DatabaseIcons.Aggregate), Map.entry(ObjectKind.EXCEPTION, AllIcons.Nodes.ExceptionClass), Map.entry(ObjectKind.EXTENSION, DatabaseIcons.Extension), Map.entry(ObjectKind.LANGUAGE, DatabaseIcons.Extension), Map.entry(ObjectKind.TABLESPACE, DatabaseIcons.Tablespace), Map.entry(ObjectKind.MACRO, DatabaseIcons.Macro), Map.entry(ObjectKind.PROJECTION, DatabaseIcons.Projection), Map.entry(ObjectKind.DATA_FILE, DatabaseIcons.DataFile), Map.entry(ObjectKind.PARTITION, DatabaseIcons.Partition), Map.entry(ObjectKind.METHOD, AllIcons.Nodes.Method), Map.entry(ObjectKind.WAREHOUSE, DatabaseIcons.Warehouse), Map.entry(ObjectKind.FORMAT, DatabaseIcons.FileFormat), Map.entry(ObjectKind.INDEX_EXTENSION, DatabaseIcons.IndexFun), Map.entry(ObjectKind.INDEX_SEARCH_METHOD, DatabaseIcons.Access_method), Map.entry(ObjectKind.CONSTANT, DatabaseIcons.Constant), Map.entry(ObjectKind.SECURITY_POLICY, DatabaseIcons.Trigger), Map.entry(ObjectKind.SECURITY_PREDICATE, DatabaseIcons.Trigger), Map.entry(ObjectKind.LINKED_SERVER, DatabaseIcons.DatabaseLink), Map.entry(ObjectKind.STRING, DatabaseIcons.String), Map.entry(ObjectKind.LIST, DatabaseIcons.List), Map.entry(ObjectKind.SET, DatabaseIcons.Set), Map.entry(ObjectKind.SORTED_SET, DatabaseIcons.SortedSet), Map.entry(ObjectKind.HASH_TABLE, DatabaseIcons.HashTable), Map.entry(ObjectKind.STREAM, DatabaseIcons.Stream), Map.entry(ObjectKind.JSON_DOCUMENT, DatabaseIcons.JsonDocument), Map.entry(ObjectKind.DATA_STRUCTURE, DatabaseIcons.DataStructure), Map.entry(ObjectKind.COLLECTION, DatabaseIcons.Collection), Map.entry(DvFamilyId.VIRTUAL_FOREIGN_KEY.getFakeKind(), DatabaseIcons.VirtualForeignKey), Map.entry(DvFamilyId.VIRTUAL_COLUMN.getFakeKind(), DatabaseIcons.VirtualColumn), Map.entry(DvFamilyId.VIRTUAL_VIEW.getFakeKind(), DatabaseIcons.VirtualView), Map.entry(ObjectKind.FILEGROUP, DatabaseIcons.Tablespace), Map.entry(ObjectKind.PARTITION_SCHEME, DatabaseIcons.Tablespace), Map.entry(ObjectKind.PARTITION_FUNCTION, DatabaseIcons.Function));
    private static final Object2IntMap<ObjectKind> KIND_WEIGHTS = DbPresentationCore.buildWeights(DbPresentationCore.buildWeights((Object2IntMap<ObjectKind>)new Object2IntOpenHashMap(100), 0, ObjectKind.ROOT, ObjectKind.DATABASE, ObjectKind.EXTERNAL_DATABASE, ObjectKind.DB_LINK, ObjectKind.SCHEMA, ObjectKind.EXTERNAL_SCHEMA, ObjectKind.TABLE, ObjectKind.FOREIGN_TABLE, ObjectKind.VIRTUAL_TABLE, ObjectKind.MAT_VIEW, ObjectKind.VIEW, ObjectKind.CLUSTER, ObjectKind.BODY, ObjectKind.ROUTINE, ObjectKind.AGGREGATE, ObjectKind.PACKAGE, ObjectKind.OPERATOR, ObjectKind.FOREIGN_FUNCTION, ObjectKind.SEQUENCE, ObjectKind.ALIAS_TYPE, ObjectKind.OBJECT_TYPE, ObjectKind.TABLE_TYPE, ObjectKind.COLLECTION_TYPE, ObjectKind.COLLATION, ObjectKind.SYNONYM, ObjectKind.EXCEPTION, ObjectKind.VARIABLE, ObjectKind.OBJECT_ATTRIBUTE, ObjectKind.COLUMN, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.INDEX, ObjectKind.CHECK, ObjectKind.DEFAULT, ObjectKind.RULE, ObjectKind.TRIGGER, ObjectKind.PARTITION), 10000000, DvFamilyId.VIRTUAL_COLUMN.getFakeKind(), DvFamilyId.VIRTUAL_FOREIGN_KEY.getFakeKind(), DvFamilyId.VIRTUAL_VIEW.getFakeKind());

    protected DbPresentationCore() {
    }

    public static String arrowToColumns(@Nullable String schemaName, @Nullable String tableName, @NotNull MultiRef<? extends DasTypedObject> columnsRef) {
        if (columnsRef == null) {
            DbPresentationCore.$$$reportNull$$$0(0);
        }
        Object prefix = schemaName != null ? schemaName + "." : "";
        return StringUtil.isEmpty((String)tableName) ? "" : DbPresentationCore.arrow() + " " + (String)prefix + tableName + " " + DbPresentationCore.multiRef(columnsRef);
    }

    @NotNull
    public static String multiRef(@NotNull MultiRef<? extends DasTypedObject> ref2) {
        if (ref2 == null) {
            DbPresentationCore.$$$reportNull$$$0(1);
        }
        Object object = ref2.size() == 0 ? "" : "(" + StringUtil.join((Iterable)JBIterable.from(ref2.names()).filter(n -> n != null), (String)", ") + ")";
        if (object == null) {
            DbPresentationCore.$$$reportNull$$$0(2);
        }
        return object;
    }

    @NlsSafe
    @NotNull
    public static String arrow() {
        String string = ApplicationManager.getApplication().isUnitTestMode() ? "->" : UIUtil.rightArrow();
        if (string == null) {
            DbPresentationCore.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public static Icon getIcon(@Nullable ObjectKind kind) {
        return kind == null ? null : ourIcons.get(kind);
    }

    @Nls
    @NotNull
    public static String getPresentableName(@NotNull ObjectKind o2, @NotNull Dbms dbms) {
        if (o2 == null) {
            DbPresentationCore.$$$reportNull$$$0(4);
        }
        if (dbms == null) {
            DbPresentationCore.$$$reportNull$$$0(5);
        }
        return DbPresentationCore.getPresentableName(o2, dbms, false);
    }

    @Nls
    @NotNull
    public static String getPresentableName(@NotNull ObjectKind o2, @NotNull Dbms dbms, int count) {
        if (o2 == null) {
            DbPresentationCore.$$$reportNull$$$0(6);
        }
        if (dbms == null) {
            DbPresentationCore.$$$reportNull$$$0(7);
        }
        return DbPresentationCore.getPresentableName(o2, dbms, count != 1);
    }

    @Nls
    @NotNull
    public static String getPresentableName(@NotNull ObjectKind o2, @NotNull Dbms dbms, boolean plural) {
        if (o2 == null) {
            DbPresentationCore.$$$reportNull$$$0(8);
        }
        if (dbms == null) {
            DbPresentationCore.$$$reportNull$$$0(9);
        }
        String string = ModelFacade.forDbms(dbms).getModelHelper().getName(o2, plural);
        if (string == null) {
            DbPresentationCore.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    public static Icon getIcon(@NotNull DasObject c2) {
        if (c2 == null) {
            DbPresentationCore.$$$reportNull$$$0(11);
        }
        Dbms dbms = DbImplUtilCore.getDbms(c2);
        ModelHelper helper = ModelFacade.forDbms(dbms).getModelHelper();
        return helper.getIcon(c2);
    }

    @Nullable
    public static Icon getIcon(@NotNull Dbms dbms, @Nullable ObjectKind kind) {
        if (dbms == null) {
            DbPresentationCore.$$$reportNull$$$0(12);
        }
        ModelHelper helper = ModelFacade.forDbms(dbms).getModelHelper();
        return kind == null ? null : helper.getIcon(kind);
    }

    @Nullable
    public static Icon getIcon(@NotNull BasicMetaObject<?> meta) {
        if (meta == null) {
            DbPresentationCore.$$$reportNull$$$0(13);
        }
        return DbPresentationCore.getIcon(meta.getModel().dbms, meta.kind);
    }

    @NotNull
    @NlsContexts.Label
    public static String getPresentableName(@NotNull DasObject o2, boolean unnamed) {
        if (o2 == null) {
            DbPresentationCore.$$$reportNull$$$0(14);
        }
        DasObject d2 = o2 instanceof DbElement ? ((DbElement)o2).getDelegate() : o2;
        String name2 = d2 instanceof BasicNode ? ((BasicNode)((Object)d2)).getDisplayName() : o2.getName();
        String string = StringUtil.isEmpty((String)name2) && unnamed ? UNNAMED : name2;
        if (string == null) {
            DbPresentationCore.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Nls
    @NotNull
    public static String getPresentableName(@NotNull BasicMetaObject<?> meta) {
        if (meta == null) {
            DbPresentationCore.$$$reportNull$$$0(16);
        }
        return DbPresentationCore.getPresentableName(meta.kind, meta.getDbms());
    }

    public static int getWeight(@NotNull ObjectKind kind, int groupCount) {
        int w;
        if (kind == null) {
            DbPresentationCore.$$$reportNull$$$0(17);
        }
        return (w = KIND_WEIGHTS.getInt((Object)kind)) != 0 ? w : 1000000 + kind.getOrder() * 1000 + groupCount;
    }

    public static int getWeight(@NotNull Object o2, boolean sortPositioned) {
        int weight;
        if (o2 == null) {
            DbPresentationCore.$$$reportNull$$$0(18);
        }
        ObjectKind kind = o2 instanceof DasObject ? ((DasObject)o2).getKind() : ObjectKind.NONE;
        int n = weight = o2 instanceof WeighedItem ? ((WeighedItem)o2).getWeight() : KIND_WEIGHTS.getInt((Object)kind);
        if (kind == ObjectKind.KEY && o2 instanceof DasTableKey && ((DasTableKey)o2).isPrimary()) {
            --weight;
        }
        if (!sortPositioned && o2 instanceof DasPositioned) {
            return weight + ((DasPositioned)o2).getPosition();
        }
        return weight;
    }

    @NotNull
    private static Object2IntMap<ObjectKind> buildWeights(Object2IntMap<ObjectKind> res2, int offset, ObjectKind ... kinds) {
        for (int i2 = 0; i2 < kinds.length; ++i2) {
            res2.put((Object)kinds[i2], offset + 1000 * (i2 + 1));
        }
        Object2IntMap<ObjectKind> object2IntMap = res2;
        if (object2IntMap == null) {
            DbPresentationCore.$$$reportNull$$$0(19);
        }
        return object2IntMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 10, 15, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnsRef";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbPresentationCore";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbPresentationCore";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "multiRef";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "arrow";
                break;
            }
            case 10: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "buildWeights";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "arrowToColumns";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "multiRef";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 15: 
            case 19: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getWeight";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 10, 15, 19 -> new IllegalStateException(string);
        };
    }
}

