/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan;

import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExplainPlanProvider {
    public static final DbmsExtension<ExplainPlanProvider> EP = new DbmsExtension("com.intellij.database.explainPlanProvider");
    protected final Dbms myDbms;

    @Nullable
    public static ExplainPlanProvider getDefaultProvider(@Nullable LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            return null;
        }
        return EP.forDbms(dataSource2.getDbms());
    }

    protected ExplainPlanProvider(@NotNull Dbms dbms) {
        if (dbms == null) {
            ExplainPlanProvider.$$$reportNull$$$0(0);
        }
        this.myDbms = dbms;
    }

    @NotNull
    public <V> ScriptModel<V> adjustModel(@NotNull ScriptModel<V> model2) {
        if (model2 == null) {
            ExplainPlanProvider.$$$reportNull$$$0(1);
        }
        ScriptModel<V> scriptModel = model2;
        if (scriptModel == null) {
            ExplainPlanProvider.$$$reportNull$$$0(2);
        }
        return scriptModel;
    }

    @Nullable
    public abstract DataRequest.RawRequest createExplainRequest(@NotNull DataRequest.OwnerEx var1, @NotNull Consumer<? super PlanModel> var2, @NotNull LocalDataSource var3, @NotNull String var4, boolean var5);

    public boolean isSupported(@NotNull Version version, boolean run2) {
        if (version == null) {
            ExplainPlanProvider.$$$reportNull$$$0(3);
        }
        return !run2;
    }

    public boolean isRawSupported(@NotNull Version version, boolean run2) {
        if (version == null) {
            ExplainPlanProvider.$$$reportNull$$$0(4);
        }
        return !run2;
    }

    @Nullable
    public abstract RawExplainTask createRawExplainTask(@NotNull LocalDataSource var1, boolean var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/plan/ExplainPlanProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/plan/ExplainPlanProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "adjustModel";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isRawSupported";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static abstract class RawExplainTask {
        @Nullable
        public DataRequest.RawRequest sqlPreExplainPlan(@NotNull DataRequest.OwnerEx owner) throws UnsupportedOperationException, IllegalArgumentException {
            if (owner == null) {
                RawExplainTask.$$$reportNull$$$0(0);
            }
            return null;
        }

        public abstract DdlBuilder sqlExplainPlan(@NotNull DdlBuilder var1, @NotNull String var2) throws UnsupportedOperationException, IllegalArgumentException;

        @Nullable
        public DataRequest.RawRequest sqlPostExplainPlan(@NotNull DataRequest.OwnerEx owner) throws UnsupportedOperationException, IllegalArgumentException {
            if (owner == null) {
                RawExplainTask.$$$reportNull$$$0(1);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "owner";
            objectArray2[1] = "com/intellij/database/plan/ExplainPlanProvider$RawExplainTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sqlPreExplainPlan";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sqlPostExplainPlan";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

