/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization.converters;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.serialization.Converter;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.model.serialization.ModelSerializationFun;
import com.intellij.database.model.serialization.MutableNameAndValue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/model/serialization/converters/Converter_4_53;", "Lcom/intellij/database/model/serialization/Converter;", "()V", "convertMem", "", "modelMem", "Lcom/intellij/database/model/serialization/ModelMem;", "intellij.database.core.impl"})
public final class Converter_4_53
extends Converter {
    @NotNull
    public static final Converter_4_53 INSTANCE = new Converter_4_53();

    private Converter_4_53() {
        int[] nArray = new int[]{4, 53};
        super(nArray);
    }

    @Override
    public void convertMem(@NotNull ModelMem modelMem) {
        Intrinsics.checkNotNullParameter((Object)modelMem, (String)"modelMem");
        Dbms dbms = modelMem.getDbms();
        for (ModelElementMem n : modelMem.getNodes()) {
            String string;
            MutableNameAndValue mutableNameAndValue = ModelSerializationFun.find(n.getProperties(), "DasType");
            if (mutableNameAndValue != null) {
                mutableNameAndValue.setName("StoredType");
            }
            if (dbms.isCassandra()) {
                if (!Intrinsics.areEqual((Object)n.getKind(), (Object)ObjectKind.AGGREGATE.code())) continue;
                MutableNameAndValue mutableNameAndValue2 = ModelSerializationFun.find(n.getProperties(), "StateType");
                if (mutableNameAndValue2 == null) continue;
                mutableNameAndValue2.setName("StateStoredType");
                continue;
            }
            if (dbms.isDb2()) {
                string = n.getKind();
                if (Intrinsics.areEqual((Object)string, (Object)ObjectKind.INDEX.code())) {
                    MutableNameAndValue mutableNameAndValue3 = ModelSerializationFun.find(n.getProperties(), "XmlDasType");
                    if (mutableNameAndValue3 != null) {
                        mutableNameAndValue3.setName("XmlStoredType");
                    }
                    MutableNameAndValue mutableNameAndValue4 = ModelSerializationFun.find(n.getProperties(), "XmlDasTypeHashed");
                    if (mutableNameAndValue4 == null) continue;
                    mutableNameAndValue4.setName("XmlTypeHashed");
                    continue;
                }
                if (!Intrinsics.areEqual((Object)string, (Object)ObjectKind.OBJECT_TYPE.code())) continue;
                MutableNameAndValue mutableNameAndValue5 = ModelSerializationFun.find(n.getProperties(), "SourceType");
                if (mutableNameAndValue5 != null) {
                    mutableNameAndValue5.setName("SourceStoredType");
                }
                MutableNameAndValue mutableNameAndValue6 = ModelSerializationFun.find(n.getProperties(), "ArrayIndexType");
                if (mutableNameAndValue6 == null) continue;
                mutableNameAndValue6.setName("ArrayIndexStoredType");
                continue;
            }
            if (dbms.isMicrosoft()) {
                string = n.getKind();
                if (Intrinsics.areEqual((Object)string, (Object)ObjectKind.SEQUENCE.code())) {
                    MutableNameAndValue mutableNameAndValue7 = ModelSerializationFun.find(n.getProperties(), "UnderlyingDasType");
                    if (mutableNameAndValue7 == null) continue;
                    mutableNameAndValue7.setName("UnderlyingStoredType");
                    continue;
                }
                if (!Intrinsics.areEqual((Object)string, (Object)ObjectKind.PARTITION_FUNCTION.code())) continue;
                MutableNameAndValue mutableNameAndValue8 = ModelSerializationFun.find(n.getProperties(), "ParameterType");
                if (mutableNameAndValue8 == null) continue;
                mutableNameAndValue8.setName("ParameterStoredType");
                continue;
            }
            if (dbms.isOracle()) {
                if (!Intrinsics.areEqual((Object)n.getKind(), (Object)ObjectKind.COLLECTION_TYPE.code())) continue;
                MutableNameAndValue mutableNameAndValue9 = ModelSerializationFun.find(n.getProperties(), "ElementType");
                if (mutableNameAndValue9 != null) {
                    mutableNameAndValue9.setName("ElementStoredType");
                }
                MutableNameAndValue mutableNameAndValue10 = ModelSerializationFun.find(n.getProperties(), "IndexElementType");
                if (mutableNameAndValue10 == null) continue;
                mutableNameAndValue10.setName("IndexElementStoredType");
                continue;
            }
            if (!dbms.isPostgres()) continue;
            string = n.getKind();
            if (Intrinsics.areEqual((Object)string, (Object)ObjectKind.AGGREGATE.code())) {
                MutableNameAndValue mutableNameAndValue11 = ModelSerializationFun.find(n.getProperties(), "TransitionDasType");
                if (mutableNameAndValue11 != null) {
                    mutableNameAndValue11.setName("TransitionStoredType");
                }
                MutableNameAndValue mutableNameAndValue12 = ModelSerializationFun.find(n.getProperties(), "MovingStateType");
                if (mutableNameAndValue12 == null) continue;
                mutableNameAndValue12.setName("MovingStateStoredType");
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)ObjectKind.OPERATOR.code())) {
                MutableNameAndValue mutableNameAndValue13 = ModelSerializationFun.find(n.getProperties(), "LeftType");
                if (mutableNameAndValue13 != null) {
                    mutableNameAndValue13.setName("LeftStoredType");
                }
                MutableNameAndValue mutableNameAndValue14 = ModelSerializationFun.find(n.getProperties(), "RightType");
                if (mutableNameAndValue14 != null) {
                    mutableNameAndValue14.setName("RightStoredType");
                }
                MutableNameAndValue mutableNameAndValue15 = ModelSerializationFun.find(n.getProperties(), "ResultType");
                if (mutableNameAndValue15 == null) continue;
                mutableNameAndValue15.setName("ResultStoredType");
                continue;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)ObjectKind.OPERATOR_CLASS.code())) continue;
            MutableNameAndValue mutableNameAndValue16 = ModelSerializationFun.find(n.getProperties(), "InType");
            if (mutableNameAndValue16 != null) {
                mutableNameAndValue16.setName("InStoredType");
            }
            MutableNameAndValue mutableNameAndValue17 = ModelSerializationFun.find(n.getProperties(), "KeyType");
            if (mutableNameAndValue17 == null) continue;
            mutableNameAndValue17.setName("KeyStoredType");
        }
    }
}

