/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization.converters;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.serialization.Converter;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.model.serialization.ModelSerializationFun;
import com.intellij.database.model.serialization.MutableNameAndValue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/model/serialization/converters/Converter_4_51;", "Lcom/intellij/database/model/serialization/Converter;", "()V", "SEQUENCE_IDENTITY_PROPERTY_NAME", "", "checkDbms", "", "dbms", "Lcom/intellij/database/Dbms;", "convertMem", "", "modelMem", "Lcom/intellij/database/model/serialization/ModelMem;", "convertSequence", "elementMem", "Lcom/intellij/database/model/serialization/ModelElementMem;", "convertSequences", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nConverter_4_51.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Converter_4_51.kt\ncom/intellij/database/model/serialization/converters/Converter_4_51\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1313#2,2:44\n1#3:46\n*S KotlinDebug\n*F\n+ 1 Converter_4_51.kt\ncom/intellij/database/model/serialization/converters/Converter_4_51\n*L\n29#1:44,2\n*E\n"})
public final class Converter_4_51
extends Converter {
    @NotNull
    public static final Converter_4_51 INSTANCE = new Converter_4_51();
    @NotNull
    private static final String SEQUENCE_IDENTITY_PROPERTY_NAME = "SequenceIdentity";

    private Converter_4_51() {
        int[] nArray = new int[]{4, 51};
        super(nArray);
    }

    @Override
    public void convertMem(@NotNull ModelMem modelMem) {
        Intrinsics.checkNotNullParameter((Object)modelMem, (String)"modelMem");
        if (!this.checkDbms(modelMem.getDbms())) {
            return;
        }
        this.convertSequences(modelMem);
    }

    private final boolean checkDbms(Dbms dbms) {
        return dbms.isPostgres();
    }

    private final void convertSequences(ModelMem modelMem) {
        String sequenceCode = ObjectKind.SEQUENCE.code();
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)modelMem.getNodes()), (Function1)((Function1)new Function1<ModelElementMem, Boolean>(sequenceCode){
            final /* synthetic */ String $sequenceCode;
            {
                this.$sequenceCode = $sequenceCode;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ModelElementMem it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                return Intrinsics.areEqual((Object)it2.getKind(), (Object)this.$sequenceCode);
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModelElementMem it2 = (ModelElementMem)element$iv;
            boolean bl = false;
            INSTANCE.convertSequence(it2);
        }
    }

    private final void convertSequence(ModelElementMem elementMem) {
        MutableNameAndValue mutableNameAndValue = ModelSerializationFun.find(elementMem.getProperties(), SEQUENCE_IDENTITY_PROPERTY_NAME);
        if (mutableNameAndValue == null) {
            return;
        }
        MutableNameAndValue sequenceIdentityProperty = mutableNameAndValue;
        Object it2 = sequenceIdentityProperty;
        boolean bl = false;
        SequenceIdentity sequenceIdentity = PropertyConverter.importSequenceIdentity(sequenceIdentityProperty.getValue());
        if (sequenceIdentity == null) {
            return;
        }
        SequenceIdentity sequenceIdentity2 = sequenceIdentity;
        if (sequenceIdentity2.next != null) {
            it2 = sequenceIdentity2;
            boolean bl2 = false;
            String newSequenceIdentityValue = PropertyConverter.export(SequenceIdentity.of(((SequenceIdentity)it2).min, null, ((SequenceIdentity)it2).increment, ((SequenceIdentity)it2).max));
            Intrinsics.checkNotNull((Object)newSequenceIdentityValue);
            sequenceIdentityProperty.setValue(newSequenceIdentityValue);
        }
    }
}

