/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization.converters;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.serialization.Converter;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.model.serialization.ModelSerializationFun;
import com.intellij.database.model.serialization.MutableNameAndValue;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/database/model/serialization/converters/Converter_4_45;", "Lcom/intellij/database/model/serialization/Converter;", "()V", "convertMem", "", "modelMem", "Lcom/intellij/database/model/serialization/ModelMem;", "convertRelations", "convertSequenceReferences", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nConverter_4_45.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Converter_4_45.kt\ncom/intellij/database/model/serialization/converters/Converter_4_45\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,66:1\n1313#2,2:67\n*S KotlinDebug\n*F\n+ 1 Converter_4_45.kt\ncom/intellij/database/model/serialization/converters/Converter_4_45\n*L\n21#1:67,2\n*E\n"})
public final class Converter_4_45
extends Converter {
    @NotNull
    public static final Converter_4_45 INSTANCE = new Converter_4_45();

    private Converter_4_45() {
        int[] nArray = new int[]{4, 45};
        super(nArray);
    }

    @Override
    public void convertMem(@NotNull ModelMem modelMem) {
        Intrinsics.checkNotNullParameter((Object)modelMem, (String)"modelMem");
        Object[] objectArray = new Dbms[]{Dbms.POSTGRES, Dbms.GREENPLUM, Dbms.COCKROACH};
        if (!ArraysKt.contains((Object[])objectArray, (Object)modelMem.getDbms())) {
            return;
        }
        this.convertSequenceReferences(modelMem);
        this.convertRelations(modelMem);
    }

    private final void convertSequenceReferences(ModelMem modelMem) {
        String columnCode = ObjectKind.COLUMN.code();
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)modelMem.getNodes()), (Function1)((Function1)new Function1<ModelElementMem, Boolean>(columnCode){
            final /* synthetic */ String $columnCode;
            {
                this.$columnCode = $columnCode;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ModelElementMem it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                return Intrinsics.areEqual((Object)it2.getKind(), (Object)this.$columnCode);
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModelElementMem it2 = (ModelElementMem)element$iv;
            boolean bl = false;
            ModelSerializationFun.remove(it2.getProperties(), "SequenceIdentity");
            MutableNameAndValue mutableNameAndValue = ModelSerializationFun.find(it2.getProperties(), "BelongingSequenceId");
            if (mutableNameAndValue == null) continue;
            mutableNameAndValue.setName("SequenceId");
        }
    }

    private final void convertRelations(ModelMem modelMem) {
        Object relFields;
        HashMap relations = new HashMap();
        for (ModelElementMem node2 : modelMem.getNodes()) {
            Object object;
            if (!Intrinsics.areEqual((Object)node2.getKind(), (Object)ObjectKind.DATABASE.code()) || (object = ModelSerializationFun.find(node2.getProperties(), "Relations")) == null || (object = ((MutableNameAndValue)object).getValue()) == null) continue;
            Object relationsSerialized = object;
            for (String r : StringsKt.lineSequence((CharSequence)((CharSequence)relationsSerialized))) {
                String[] stringArray;
                relFields = StringsKt.split$default((CharSequence)r, (String[])(stringArray = new String[]{"|"}), (boolean)false, (int)0, (int)6, null);
                if (relFields.size() != 5) continue;
                String seqId = (String)relFields.get(2);
                String tableId = (String)relFields.get(3);
                String colPos = (String)relFields.get(4);
                Pair key2 = TuplesKt.to((Object)tableId, (Object)colPos);
                ((Map)relations).put(key2, seqId);
            }
        }
        HashMap tables2 = new HashMap();
        for (ModelElementMem node3 : modelMem.getNodes()) {
            if (!Intrinsics.areEqual((Object)node3.getKind(), (Object)ObjectKind.TABLE.code())) continue;
            Integer n = node3.getId();
            if (n == null) {
                continue;
            }
            int id = n;
            relFields = id;
            ((Map)tables2).put(relFields, node3);
        }
        for (ModelElementMem node3 : modelMem.getNodes()) {
            Object colPos;
            Pair key3;
            String seqId;
            ModelElementMem tableElement;
            Object object;
            if (!Intrinsics.areEqual((Object)node3.getKind(), (Object)ObjectKind.COLUMN.code())) continue;
            Integer n = node3.getParentId();
            if (n == null) {
                continue;
            }
            int parentId = n;
            if ((ModelElementMem)tables2.get(parentId) == null || (object = ModelSerializationFun.find(tableElement.getProperties(), "ObjectId")) == null || (object = ((MutableNameAndValue)object).getValue()) == null) continue;
            Object tableId = object;
            Object object2 = ModelSerializationFun.find(node3.getProperties(), "Position");
            if (object2 == null) continue;
            if ((object2 = ((MutableNameAndValue)object2).getValue()) == null || (seqId = (String)relations.get(key3 = TuplesKt.to((Object)tableId, (Object)(colPos = object2)))) == null) continue;
            node3.getProperties().add(new MutableNameAndValue("SequenceId", seqId));
        }
    }
}

