/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization.converters;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.serialization.Converter;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.model.serialization.ModelSerializationFun;
import com.intellij.database.model.serialization.MutableNameAndValue;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/model/serialization/converters/Converter_4_43;", "Lcom/intellij/database/model/serialization/Converter;", "()V", "convertMem", "", "modelMem", "Lcom/intellij/database/model/serialization/ModelMem;", "intellij.database.core.impl"})
public final class Converter_4_43
extends Converter {
    @NotNull
    public static final Converter_4_43 INSTANCE = new Converter_4_43();

    private Converter_4_43() {
        int[] nArray = new int[]{4, 43};
        super(nArray);
    }

    @Override
    public void convertMem(@NotNull ModelMem modelMem) {
        Intrinsics.checkNotNullParameter((Object)modelMem, (String)"modelMem");
        if (modelMem.getDbms().in(Dbms.POSTGRES_LIKE)) {
            String ftCode = ObjectKind.FOREIGN_TABLE.code();
            String fdwCode = ObjectKind.FOREIGN_DATA_WRAPPER.code();
            String srvCode = ObjectKind.SERVER.code();
            Int2IntOpenHashMap fdwParents = new Int2IntOpenHashMap();
            for (ModelElementMem node2 : modelMem.getNodes()) {
                if (!Intrinsics.areEqual((Object)node2.getKind(), (Object)fdwCode)) continue;
                Integer n = node2.getId();
                Integer n3 = node2.getParentId();
                fdwParents.put(n != null ? n : -1, n3 != null ? n3 : -1);
            }
            for (ModelElementMem node2 : modelMem.getNodes()) {
                String string = node2.getKind();
                if (Intrinsics.areEqual((Object)string, (Object)ftCode)) {
                    MutableNameAndValue mutableNameAndValue = ModelSerializationFun.find(node2.getProperties(), "Server");
                    if (mutableNameAndValue == null) continue;
                    mutableNameAndValue.setName("ServerName");
                    continue;
                }
                if (!Intrinsics.areEqual((Object)string, (Object)srvCode)) continue;
                Integer n = node2.getParentId();
                if (n == null) {
                    continue;
                }
                int fdwId = n;
                ((Collection)node2.getProperties()).add(new MutableNameAndValue("ForeignDataWrapperId", String.valueOf(fdwId)));
                node2.setParentId(fdwParents.get(fdwId));
            }
        }
    }
}

