/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization.converters;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.serialization.Converter;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.model.serialization.ModelSerializationFun;
import com.intellij.database.model.serialization.MutableNameAndValue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/model/serialization/converters/Converter_4_37;", "Lcom/intellij/database/model/serialization/Converter;", "()V", "convertMem", "", "modelMem", "Lcom/intellij/database/model/serialization/ModelMem;", "intellij.database.core.impl"})
public final class Converter_4_37
extends Converter {
    @NotNull
    public static final Converter_4_37 INSTANCE = new Converter_4_37();

    private Converter_4_37() {
        int[] nArray = new int[]{4, 37};
        super(nArray);
    }

    @Override
    public void convertMem(@NotNull ModelMem modelMem) {
        block9: {
            String tableCode;
            block10: {
                String userCode;
                block8: {
                    Intrinsics.checkNotNullParameter((Object)modelMem, (String)"modelMem");
                    userCode = ObjectKind.USER.code();
                    tableCode = ObjectKind.TABLE.code();
                    if (!Intrinsics.areEqual((Object)modelMem.getDbms(), (Object)Dbms.HIVE)) break block8;
                    for (ModelElementMem node2 : modelMem.getNodes()) {
                        MutableNameAndValue mutableNameAndValue;
                        if (!Intrinsics.areEqual((Object)node2.getKind(), (Object)tableCode)) continue;
                        if (ModelSerializationFun.find(node2.getProperties(), "StoredAsDirictories") == null) continue;
                        MutableNameAndValue $this$convertMem_u24lambda_u240 = mutableNameAndValue;
                        boolean bl = false;
                        $this$convertMem_u24lambda_u240.setName("StoredAsDirectories");
                    }
                    break block9;
                }
                if (!Intrinsics.areEqual((Object)modelMem.getDbms(), (Object)Dbms.ORACLE)) break block10;
                for (ModelElementMem node3 : modelMem.getNodes()) {
                    MutableNameAndValue mutableNameAndValue;
                    if (!Intrinsics.areEqual((Object)node3.getKind(), (Object)userCode)) continue;
                    if (ModelSerializationFun.find(node3.getProperties(), "DefaultTablespace") != null) {
                        MutableNameAndValue $this$convertMem_u24lambda_u241 = mutableNameAndValue;
                        boolean bl = false;
                        $this$convertMem_u24lambda_u241.setName("DefaultTablespaceName");
                    }
                    if (ModelSerializationFun.find(node3.getProperties(), "TemporaryTablespace") == null) continue;
                    MutableNameAndValue $this$convertMem_u24lambda_u242 = mutableNameAndValue;
                    boolean bl = false;
                    $this$convertMem_u24lambda_u242.setName("TemporaryTablespaceName");
                }
                break block9;
            }
            if (!modelMem.getDbms().in(Dbms.DB2_LIKE)) break block9;
            for (ModelElementMem node4 : modelMem.getNodes()) {
                String string;
                MutableNameAndValue mutableNameAndValue;
                if (!Intrinsics.areEqual((Object)node4.getKind(), (Object)tableCode)) continue;
                if (ModelSerializationFun.find(node4.getProperties(), "RCTCheckName") == null) continue;
                MutableNameAndValue $this$convertMem_u24lambda_u243 = mutableNameAndValue;
                boolean bl = false;
                $this$convertMem_u24lambda_u243.setName("RCTCheck");
                String string2 = $this$convertMem_u24lambda_u243.getValue();
                if (Intrinsics.areEqual((Object)string2, (Object)"RCT")) {
                    String string3 = PropertyConverter.exportEnumValue("DISALLOW_OVERFLOW");
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"exportEnumValue(...)");
                } else if (Intrinsics.areEqual((Object)string2, (Object)"RCT_OFLOW")) {
                    String string4 = PropertyConverter.exportEnumValue("ALLOW_OVERFLOW");
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"exportEnumValue(...)");
                } else {
                    string = $this$convertMem_u24lambda_u243.getValue();
                }
                $this$convertMem_u24lambda_u243.setValue(string);
            }
        }
    }
}

