/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties;

import org.jetbrains.annotations.Nullable;

public enum Level {
    L1(1),
    L2(2),
    L3(3);

    public final byte level;

    private Level(byte level) {
        this.level = level;
    }

    @Nullable
    public static Level of(byte level) {
        return switch (level) {
            case 1 -> L1;
            case 2 -> L2;
            case 3 -> L3;
            default -> null;
        };
    }

    @Nullable
    public String export() {
        return switch (this.level) {
            case 1 -> "1";
            case 2 -> "2";
            case 3 -> "3";
            default -> null;
        };
    }

    @Nullable
    public static Level of(@Nullable String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        String s2 = str.trim();
        if (s2.length() >= 2 && s2.charAt(0) == 'L') {
            s2 = s2.substring(1);
        }
        try {
            byte b2 = Byte.parseByte(s2);
            return switch (b2) {
                case 1 -> L1;
                case 2 -> L2;
                case 3 -> L3;
                default -> null;
            };
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public String toString() {
        return "L" + Byte.toString(this.level);
    }
}

