/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties;

import com.google.common.collect.ImmutableSortedSet;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicGrantee;
import com.intellij.database.model.basic.BasicGrantsHolder;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.model.properties.GrantsKt;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.text.StringKt;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.PrimitiveIterator;
import java.util.SortedSet;
import java.util.stream.IntStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0003-./B#\b\u0016\u0012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB%\u0012\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J6\u0010\u0014\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0015\"\b\b\u0001\u0010\u0016*\u00020\u00172\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00160\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0019J\u001c\u0010\u001d\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001e\u0018\u00010\u00032\u0006\u0010\u001c\u001a\u00020\u0019J\u0016\u0010\u001f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010 2\u0006\u0010\u0018\u001a\u00020\u0019J\u001c\u0010!\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001e\u0018\u00010 2\u0006\u0010\"\u001a\u00020\u0019J\b\u0010#\u001a\u00020$H\u0016J\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000&H\u0096\u0002J\u0006\u0010'\u001a\u00020\u0007J\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)J\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bJ\b\u0010+\u001a\u00020\u0007H\u0016J\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003R\u001b\u0010\t\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/database/model/properties/Grants;", "T", "Lcom/intellij/database/model/properties/Grants$Grant;", "", "c", "Lcom/intellij/database/model/properties/Grants$Controller;", "text", "", "(Lcom/intellij/database/model/properties/Grants$Controller;Ljava/lang/String;)V", "controller", "gs", "(Lcom/intellij/database/model/properties/Grants$Controller;Ljava/lang/Iterable;)V", "getController", "()Lcom/intellij/database/model/properties/Grants$Controller;", "grants", "Ljava/util/NavigableSet;", "equals", "", "other", "", "granteeFilter", "Lcom/intellij/openapi/util/Condition;", "U", "Lcom/intellij/database/model/basic/BasicGrantee;", "u", "Lcom/intellij/database/model/basic/BasicElement;", "grantsFor", "Ljava/util/SortedSet;", "e", "grantsForByGrantee", "", "grantsForGrantee", "Lcom/intellij/util/containers/JBIterable;", "grantsForGranteeByTarget", "g", "hashCode", "", "iterator", "", "serialize", "toMutableList", "", "toMutableSet", "toString", "with", "Controller", "Grant", "State", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nGrants.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Grants.kt\ncom/intellij/database/model/properties/Grants\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,291:1\n1#2:292\n14#3:293\n*S KotlinDebug\n*F\n+ 1 Grants.kt\ncom/intellij/database/model/properties/Grants\n*L\n32#1:293\n*E\n"})
public final class Grants<T extends Grant>
implements Iterable<T>,
KMappedMarker {
    @NotNull
    private final Controller<T, ?> controller;
    @NotNull
    private final NavigableSet<T> grants;

    public Grants(@NotNull Controller<T, ?> controller, @NotNull Iterable<? extends T> gs) {
        Intrinsics.checkNotNullParameter(controller, (String)"controller");
        Intrinsics.checkNotNullParameter(gs, (String)"gs");
        this.controller = controller;
        ImmutableSortedSet immutableSortedSet = ImmutableSortedSet.copyOf((Comparator)this.controller, gs);
        Intrinsics.checkNotNullExpressionValue((Object)immutableSortedSet, (String)"copyOf(...)");
        this.grants = (NavigableSet)immutableSortedSet;
    }

    @NotNull
    public final Controller<T, ?> getController() {
        return this.controller;
    }

    /*
     * WARNING - void declaration
     */
    public Grants(final @NotNull Controller<T, ?> c2, @Nullable String text2) {
        Iterable iterable;
        JBIterable jBIterable;
        Iterator iterator;
        Sequence sequence;
        char[] cArray;
        Sequence sequence2;
        Intrinsics.checkNotNullParameter(c2, (String)"c");
        Grants<T> grants = this;
        Controller<T, ?> controller = c2;
        String string = StringKt.nullize$default((String)text2, (boolean)false, (int)1, null);
        if (string != null && (sequence2 = StringsKt.splitToSequence$default((CharSequence)string, (char[])(cArray = new char[]{'\n'}), (boolean)false, (int)0, (int)6, null)) != null && (sequence = SequencesKt.map((Sequence)sequence2, (Function1)new Function1<String, T>(){

            @NotNull
            public final T invoke(@NotNull String it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                String string = StringUtil.unescapeStringCharacters((String)it2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unescapeStringCharacters(...)");
                return c2.deserialize(string);
            }
        })) != null && (iterator = sequence.iterator()) != null) {
            void it2;
            Iterator iterator2 = iterator;
            Controller<T, ?> controller2 = controller;
            Grants<T> grants2 = grants;
            boolean bl = false;
            JBIterable jBIterable2 = JBIterable.once((Iterator)it2);
            grants = grants2;
            controller = controller2;
            v2 = jBIterable2;
        } else {
            v2 = jBIterable = null;
        }
        if (jBIterable == null) {
            JBIterable jBIterable3 = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"empty(...)");
            iterable = (Iterable)jBIterable3;
        } else {
            iterable = (Iterable)jBIterable;
        }
        grants(controller, iterable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        Object object = other;
        Object object2 = object;
        if (object == null) return false;
        Object $this$asSafely$iv = object2;
        boolean $i$f$asSafely = false;
        Object object3 = $this$asSafely$iv;
        if (!(object3 instanceof Grants)) {
            object3 = null;
        }
        Grants grants = (Grants)object3;
        object2 = grants;
        if (grants == null) return false;
        Object it2 = object2;
        boolean bl = false;
        boolean bl2 = Intrinsics.areEqual(this.grants, ((Grants)it2).grants);
        return bl2;
    }

    public int hashCode() {
        return this.grants.hashCode();
    }

    @NotNull
    public final Grants<T> with(@NotNull Iterable<? extends T> gs) {
        Intrinsics.checkNotNullParameter(gs, (String)"gs");
        return new Grants<T>(this.controller, gs);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        Iterator<T> iterator = this.grants.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        return iterator;
    }

    @Nullable
    public final SortedSet<T> grantsFor(@NotNull BasicElement e2) {
        SortedSet<T> sortedSet;
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        if (this.grants.isEmpty()) {
            return null;
        }
        T t = this.controller.lower(e2);
        if (t == null) {
            return Collections.emptySortedSet();
        }
        T l = t;
        T u = this.controller.upper(l);
        SortedSet<T> it2 = sortedSet = this.grants.subSet(l, u);
        boolean bl = false;
        Intrinsics.checkNotNull(it2);
        return !((Collection)it2).isEmpty() ? sortedSet : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final Iterable<Collection<T>> grantsForByGrantee(@NotNull BasicElement e2) {
        Collection collection2;
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Object object = this.grantsFor(e2);
        if (object != null) {
            JBIterable it2 = object;
            boolean bl = false;
            JBIterable jBIterable = JBIterable.from((Iterable)((Iterable)it2));
            object = jBIterable;
            if (jBIterable != null && (object = GrantsKt.groupByGrantee((Iterable)object, this.controller)) != null) {
                collection2 = object.values();
                return collection2;
            }
        }
        collection2 = null;
        return collection2;
    }

    @Nullable
    public final JBIterable<T> grantsForGrantee(@NotNull BasicElement u) {
        Intrinsics.checkNotNullParameter((Object)u, (String)"u");
        if (this.grants.isEmpty()) {
            return null;
        }
        Condition<T> condition2 = this.granteeFilter(this.controller, u);
        if (condition2 == null) {
            return null;
        }
        Condition<T> filter2 = condition2;
        return JBIterable.from((Iterable)this.grants).filter(filter2);
    }

    private final <U extends BasicGrantee> Condition<T> granteeFilter(Controller<T, U> c2, BasicElement u) {
        U u2 = c2.asGrantee(u);
        if (u2 == null) {
            return null;
        }
        U g2 = u2;
        T key2 = c2.withGrantee(c2.create(), g2);
        return arg_0 -> Grants.granteeFilter$lambda$4(c2, key2, arg_0);
    }

    @Nullable
    public final JBIterable<Collection<T>> grantsForGranteeByTarget(@NotNull BasicElement g2) {
        Object object;
        block3: {
            block2: {
                JBIterable jBIterable;
                Intrinsics.checkNotNullParameter((Object)g2, (String)"g");
                object = this.grantsForGrantee(g2);
                if (object == null || (object = object.collect()) == null) break block2;
                JBIterable it2 = jBIterable = object;
                boolean bl = false;
                object = it2.isNotEmpty() ? jBIterable : null;
                if (object != null) break block3;
            }
            return null;
        }
        JBIterable res2 = object;
        return res2.split(JBIterable.Split.BEFORE, (Condition)new JBIterable.SCond<T>(this){
            @Nullable
            private T u;
            final /* synthetic */ Grants<T> this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean value(@NotNull T t) {
                Intrinsics.checkNotNullParameter(t, (String)"t");
                T fu = this.u;
                if (fu != null && this.this$0.getController().compare(t, fu) < 0) {
                    return false;
                }
                this.u = this.this$0.getController().upper(t);
                return fu != null;
            }
        }).map(arg_0 -> Grants.grantsForGranteeByTarget$lambda$6(grantsForGranteeByTarget.2.INSTANCE, arg_0));
    }

    @NotNull
    public String toString() {
        return "Grants(size=" + this.grants.size() + ")";
    }

    @NotNull
    public final List<T> toMutableList() {
        return CollectionsKt.toMutableList((Collection)this.grants);
    }

    @NotNull
    public final SortedSet<T> toMutableSet() {
        return CollectionsKt.toSortedSet((Iterable)this.grants, (Comparator)this.controller);
    }

    @NotNull
    public final String serialize() {
        StringBuilder sb = new StringBuilder();
        for (Grant grant : this.grants) {
            if (((CharSequence)sb).length() > 0) {
                sb.append('\n');
            }
            Intrinsics.checkNotNull((Object)grant);
            sb.append(PropertyConverter.escapeSlashN(this.controller.serialize(grant)));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final boolean granteeFilter$lambda$4(Controller $c, Grant $key, Grant it2) {
        Intrinsics.checkNotNullParameter((Object)$c, (String)"$c");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        return $c.getGranteeStrategy().equals((Object)$key, (Object)it2);
    }

    private static final Collection grantsForGranteeByTarget$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Collection)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0005\b&\u0018\u0000 h*\b\b\u0001\u0010\u0001*\u00020\u0002*\b\b\u0002\u0010\u0003*\u00020\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0005:\u0001hB\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0013\u001a\u0004\u0018\u00018\u00022\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H&\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u0002H\u00190\u0018\"\u0004\b\u0003\u0010\u0019J\u0018\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u0002H\u00190\u0018\"\u0004\b\u0003\u0010\u0019J\u001d\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u00012\u0006\u0010\u001e\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001fJ\r\u0010 \u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010!J\u0015\u0010\"\u001a\u00028\u00012\u0006\u0010#\u001a\u00020$H&\u00a2\u0006\u0002\u0010%J+\u0010&\u001a\u0004\u0018\u00018\u00022\b\u0010'\u001a\u0004\u0018\u00018\u00012\b\u0010(\u001a\u0004\u0018\u00010\u00152\u0006\u0010)\u001a\u00020*H&\u00a2\u0006\u0002\u0010+J\u001f\u0010&\u001a\u0004\u0018\u00018\u00022\u0006\u0010(\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$H\u0016\u00a2\u0006\u0002\u0010,J+\u0010-\u001a\u0004\u0018\u00010\u00152\b\u0010'\u001a\u0004\u0018\u00018\u00012\b\u0010(\u001a\u0004\u0018\u00010\u00152\u0006\u0010)\u001a\u00020*H&\u00a2\u0006\u0002\u0010.J \u0010/\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u000201002\b\u0010(\u001a\u0004\u0018\u00010\u0015H&J!\u00102\u001a\u00020$2\b\u0010\u0014\u001a\u0004\u0018\u00018\u00022\b\u0010'\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u00103J\u0016\u00104\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u0001052\u0006\u00106\u001a\u00020\u0015J\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u0015J\u0014\u00107\u001a\u0002082\n\u0010:\u001a\u0006\u0012\u0002\b\u00030;H&J\u0017\u0010<\u001a\u0004\u0018\u00018\u00012\u0006\u00106\u001a\u00020\u0015H&\u00a2\u0006\u0002\u0010=J\u001a\u0010>\u001a\b\u0012\u0004\u0012\u00020$0?2\n\u0010:\u001a\u0006\u0012\u0002\b\u00030;H&J\u001f\u0010@\u001a\b\u0012\u0004\u0012\u00020B0A2\n\u0010:\u001a\u0006\u0012\u0002\b\u00030;H&\u00a2\u0006\u0002\u0010CJ\u0017\u0010D\u001a\u0004\u0018\u00010$2\u0006\u0010'\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010EJ\u0013\u0010F\u001a\u00020$2\u0006\u0010'\u001a\u00028\u0001\u00a2\u0006\u0002\u0010EJ\u001e\u0010G\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001501002\b\u0010(\u001a\u0004\u0018\u00010\u0015J!\u0010H\u001a\u00020$2\b\u00106\u001a\u0004\u0018\u00010\u00152\b\u0010'\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010IJ\u0015\u0010J\u001a\u00028\u00012\u0006\u0010'\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010KJ\u0013\u0010L\u001a\u00028\u00012\u0006\u0010'\u001a\u00028\u0001\u00a2\u0006\u0002\u0010KJ\u001d\u0010M\u001a\u00028\u00012\u0006\u0010'\u001a\u00028\u00012\u0006\u0010\u0014\u001a\u00028\u0002H&\u00a2\u0006\u0002\u0010NJ\u001d\u0010O\u001a\u00028\u00012\u0006\u0010'\u001a\u00028\u00012\u0006\u0010P\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010QJ/\u0010R\u001a\u00028\u00012\u0006\u0010'\u001a\u00028\u00012\u0006\u0010S\u001a\u00020$2\b\u0010T\u001a\u0004\u0018\u00010U2\u0006\u0010V\u001a\u00020BH&\u00a2\u0006\u0002\u0010WJ\u001d\u0010X\u001a\u00028\u00012\u0006\u0010'\u001a\u00028\u00012\u0006\u0010V\u001a\u00020BH&\u00a2\u0006\u0002\u0010YJ\u001b\u0010Z\u001a\u00028\u00012\u0006\u0010'\u001a\u00028\u00012\u0006\u00106\u001a\u00020\u0015\u00a2\u0006\u0002\u0010[J\u001d\u0010\\\u001a\u00028\u00012\u0006\u0010'\u001a\u00028\u00012\u0006\u0010P\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010QJ\u001d\u0010]\u001a\u00028\u00012\u0006\u0010'\u001a\u00028\u00012\u0006\u00106\u001a\u00020\u0015H$\u00a2\u0006\u0002\u0010[J\u001d\u0010^\u001a\u00028\u00012\u0006\u0010'\u001a\u00028\u00012\u0006\u0010#\u001a\u00020$H&\u00a2\u0006\u0002\u0010_J\u001d\u0010`\u001a\u00028\u00012\u0006\u0010'\u001a\u00028\u00012\u0006\u0010#\u001a\u00020$H&\u00a2\u0006\u0002\u0010_J\u001e\u0010a\u001a\u00020\u001c*\u00020\u001c2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020\u001c0cH\u0084\b\u00f8\u0001\u0000J3\u0010a\u001a\u00020\u001c\"\f\b\u0003\u0010\u0019*\u0006\u0012\u0002\b\u00030d*\u00020\u001c2\b\u0010e\u001a\u0004\u0018\u0001H\u00192\b\u0010f\u001a\u0004\u0018\u0001H\u0019H\u0004\u00a2\u0006\u0002\u0010gR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\n\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006i"}, d2={"Lcom/intellij/database/model/properties/Grants$Controller;", "G", "Lcom/intellij/database/model/properties/Grants$Grant;", "U", "Lcom/intellij/database/model/basic/BasicGrantee;", "Ljava/util/Comparator;", "()V", "bothStrategy", "Lit/unimi/dsi/fastutil/Hash$Strategy;", "getBothStrategy", "()Lit/unimi/dsi/fastutil/Hash$Strategy;", "granteeStrategy", "getGranteeStrategy", "noGrants", "Lcom/intellij/database/model/properties/Grants;", "getNoGrants", "()Lcom/intellij/database/model/properties/Grants;", "targetStrategy", "getTargetStrategy", "asGrantee", "u", "Lcom/intellij/database/model/basic/BasicElement;", "(Lcom/intellij/database/model/basic/BasicElement;)Lcom/intellij/database/model/basic/BasicGrantee;", "byGrantee", "", "V", "byTarget", "compare", "", "o1", "o2", "(Lcom/intellij/database/model/properties/Grants$Grant;Lcom/intellij/database/model/properties/Grants$Grant;)I", "create", "()Lcom/intellij/database/model/properties/Grants$Grant;", "deserialize", "text", "", "(Ljava/lang/String;)Lcom/intellij/database/model/properties/Grants$Grant;", "findGrantee", "g", "h", "assistant", "Lcom/intellij/database/model/meta/BasicResolveAssistant;", "(Lcom/intellij/database/model/properties/Grants$Grant;Lcom/intellij/database/model/basic/BasicElement;Lcom/intellij/database/model/meta/BasicResolveAssistant;)Lcom/intellij/database/model/basic/BasicGrantee;", "(Lcom/intellij/database/model/basic/BasicElement;Ljava/lang/String;)Lcom/intellij/database/model/basic/BasicGrantee;", "findTarget", "(Lcom/intellij/database/model/properties/Grants$Grant;Lcom/intellij/database/model/basic/BasicElement;Lcom/intellij/database/model/meta/BasicResolveAssistant;)Lcom/intellij/database/model/basic/BasicElement;", "granteeFamiliesFor", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/model/families/Family;", "granteeText", "(Lcom/intellij/database/model/basic/BasicGrantee;Lcom/intellij/database/model/properties/Grants$Grant;)Ljava/lang/String;", "grantsHolder", "Lcom/intellij/database/model/basic/BasicGrantsHolder;", "e", "holdsItsGrants", "", "element", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "lower", "(Lcom/intellij/database/model/basic/BasicElement;)Lcom/intellij/database/model/properties/Grants$Grant;", "possiblePrivileges", "", "possibleStates", "", "Lcom/intellij/database/model/properties/Grants$State;", "(Lcom/intellij/database/model/meta/BasicMetaObject;)[Lcom/intellij/database/model/properties/Grants$State;", "serialize", "(Lcom/intellij/database/model/properties/Grants$Grant;)Ljava/lang/String;", "serializeState", "targetFamiliesFor", "targetText", "(Lcom/intellij/database/model/basic/BasicElement;Lcom/intellij/database/model/properties/Grants$Grant;)Ljava/lang/String;", "upper", "(Lcom/intellij/database/model/properties/Grants$Grant;)Lcom/intellij/database/model/properties/Grants$Grant;", "withAntiState", "withGrantee", "(Lcom/intellij/database/model/properties/Grants$Grant;Lcom/intellij/database/model/basic/BasicGrantee;)Lcom/intellij/database/model/properties/Grants$Grant;", "withGranteeFrom", "src", "(Lcom/intellij/database/model/properties/Grants$Grant;Lcom/intellij/database/model/properties/Grants$Grant;)Lcom/intellij/database/model/properties/Grants$Grant;", "withPermission", "perm", "subs", "Ljava/util/BitSet;", "state", "(Lcom/intellij/database/model/properties/Grants$Grant;Ljava/lang/String;Ljava/util/BitSet;Lcom/intellij/database/model/properties/Grants$State;)Lcom/intellij/database/model/properties/Grants$Grant;", "withState", "(Lcom/intellij/database/model/properties/Grants$Grant;Lcom/intellij/database/model/properties/Grants$State;)Lcom/intellij/database/model/properties/Grants$Grant;", "withTarget", "(Lcom/intellij/database/model/properties/Grants$Grant;Lcom/intellij/database/model/basic/BasicElement;)Lcom/intellij/database/model/properties/Grants$Grant;", "withTargetFrom", "withTargetImpl", "withUnresolvedGrantee", "(Lcom/intellij/database/model/properties/Grants$Grant;Ljava/lang/String;)Lcom/intellij/database/model/properties/Grants$Grant;", "withUnresolvedTarget", "thenCompare", "nextStage", "Lkotlin/Function0;", "", "a", "b", "(ILjava/lang/Comparable;Ljava/lang/Comparable;)I", "Companion", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nGrants.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Grants.kt\ncom/intellij/database/model/properties/Grants$Controller\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Grants.kt\ncom/intellij/database/model/properties/GrantsKt\n*L\n1#1,291:1\n150#1:293\n150#1:295\n1#2:292\n1#2:294\n1#2:296\n268#3:297\n*S KotlinDebug\n*F\n+ 1 Grants.kt\ncom/intellij/database/model/properties/Grants$Controller\n*L\n151#1:293\n156#1:295\n151#1:294\n156#1:296\n212#1:297\n*E\n"})
    public static abstract class Controller<G extends Grant, U extends BasicGrantee>
    implements Comparator<G> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Grants<G> noGrants = new Grants(this, CollectionsKt.emptyList());
        @NotNull
        private final Hash.Strategy<G> bothStrategy = new Hash.Strategy<G>(this){
            final /* synthetic */ Controller<G, U> this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean equals(@Nullable G o1, @Nullable G o2) {
                return this.this$0.getGranteeStrategy().equals(o1, o2) && this.this$0.getTargetStrategy().equals(o1, o2);
            }

            public int hashCode(@Nullable G object) {
                return this.this$0.getGranteeStrategy().hashCode(object) + 31 * this.this$0.getTargetStrategy().hashCode(object);
            }
        };

        @NotNull
        public final Grants<G> getNoGrants() {
            return this.noGrants;
        }

        @NotNull
        public abstract Hash.Strategy<G> getGranteeStrategy();

        @NotNull
        public abstract Hash.Strategy<G> getTargetStrategy();

        @NotNull
        public final Hash.Strategy<G> getBothStrategy() {
            return this.bothStrategy;
        }

        @NotNull
        public final <V> Map<G, V> byGrantee() {
            return (Map)new Object2ObjectOpenCustomHashMap(this.getGranteeStrategy());
        }

        @NotNull
        public final <V> Map<G, V> byTarget() {
            return (Map)new Object2ObjectOpenCustomHashMap(this.getTargetStrategy());
        }

        protected final int thenCompare(int $this$thenCompare, @NotNull Function0<Integer> nextStage) {
            Intrinsics.checkNotNullParameter(nextStage, (String)"nextStage");
            boolean $i$f$thenCompare = false;
            Integer n = $this$thenCompare;
            int it2 = ((Number)n).intValue();
            boolean bl = false;
            Integer n3 = it2 != 0 ? n : null;
            return n3 != null ? n3.intValue() : ((Number)nextStage.invoke()).intValue();
        }

        protected final <V extends Comparable<?>> int thenCompare(int $this$thenCompare, @Nullable V a, @Nullable V b2) {
            int n;
            Controller controller = this;
            int $this$thenCompare$iv = $this$thenCompare;
            boolean $i$f$thenCompare = false;
            Integer n3 = $this$thenCompare$iv;
            int it$iv = ((Number)n3).intValue();
            boolean bl = false;
            Integer n4 = it$iv != 0 ? n3 : null;
            if (n4 != null) {
                n = n4;
            } else {
                boolean bl2 = false;
                n = ComparisonsKt.compareValues(a, b2);
            }
            return n;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compare(@NotNull G o1, @NotNull G o2) {
            int n;
            void $this$thenCompare$iv;
            Controller controller;
            Intrinsics.checkNotNullParameter(o1, (String)"o1");
            Intrinsics.checkNotNullParameter(o2, (String)"o2");
            Controller controller2 = controller = this;
            BitSet bitSet = ((Grant)o1).getSubs();
            BitSet bitSet2 = ((Grant)o2).getSubs();
            int n3 = this.thenCompare(ComparisonsKt.compareValues((Comparable)((Comparable)((Object)((Grant)o1).getPermission())), (Comparable)((Comparable)((Object)((Grant)o2).getPermission()))), (Comparable)(bitSet != null ? Integer.valueOf(bitSet.length()) : null), (Comparable)(bitSet2 != null ? Integer.valueOf(bitSet2.length()) : null));
            boolean $i$f$thenCompare = false;
            Integer n4 = (int)$this$thenCompare$iv;
            int it$iv = ((Number)n4).intValue();
            boolean bl = false;
            Integer n5 = it$iv != 0 ? n4 : null;
            if (n5 != null) {
                n = n5;
            } else {
                int n6;
                Controller controller3;
                block3: {
                    controller3 = controller2;
                    boolean bl2 = false;
                    PrimitiveIterator.OfInt it1 = ((Grant)o1).getSubsStream().iterator();
                    PrimitiveIterator.OfInt it2 = ((Grant)o2).getSubsStream().iterator();
                    while (it1.hasNext() && it2.hasNext()) {
                        int res2 = ComparisonsKt.compareValues((Comparable)Integer.valueOf(it1.nextInt()), (Comparable)Integer.valueOf(it2.nextInt()));
                        if (res2 == 0) continue;
                        n6 = res2;
                        break block3;
                    }
                    n6 = ComparisonsKt.compareValues((Comparable)Boolean.valueOf(it1.hasNext()), (Comparable)Boolean.valueOf(it2.hasNext()));
                }
                int n7 = n6;
                controller2 = controller3;
                n = n7;
            }
            return controller2.thenCompare(n, (Comparable)((Object)((Grant)o1).getState()), (Comparable)((Object)((Grant)o2).getState()));
        }

        @Nullable
        public abstract String serialize(@NotNull G var1);

        @NotNull
        public abstract G deserialize(@NotNull String var1);

        @NotNull
        public abstract Iterable<String> possiblePrivileges(@NotNull BasicMetaObject<?> var1);

        @NotNull
        public abstract State[] possibleStates(@NotNull BasicMetaObject<?> var1);

        @NotNull
        public abstract G create();

        @Nullable
        public abstract G lower(@NotNull BasicElement var1);

        @NotNull
        public abstract G upper(@NotNull G var1);

        @Nullable
        public abstract U asGrantee(@Nullable BasicElement var1);

        @Nullable
        public abstract U findGrantee(@Nullable G var1, @Nullable BasicElement var2, @NotNull BasicResolveAssistant var3);

        @NotNull
        public String granteeText(@Nullable U u, @Nullable G g2) {
            U u2 = u;
            String string = u2 != null ? u2.getName() : null;
            if (string == null) {
                string = "";
            }
            return string;
        }

        @NotNull
        public abstract JBIterable<Family<? extends U>> granteeFamiliesFor(@Nullable BasicElement var1);

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final JBIterable<Family<? extends BasicElement>> targetFamiliesFor(@Nullable BasicElement h2) {
            JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)JBTreeTraverser.from(arg_0 -> Controller.targetFamiliesFor$lambda$3(targetFamiliesFor.1.INSTANCE, arg_0)).filter(arg_0 -> Controller.targetFamiliesFor$lambda$4((Function1)new Function1<Family<? extends BasicElement>, Boolean>(this){
                final /* synthetic */ Controller<G, U> this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                @NotNull
                public final Boolean invoke(Family<? extends BasicElement> it2) {
                    boolean bl;
                    if (!Intrinsics.areEqual((Object)it2.getMetaObject().kind, (Object)ObjectKind.COLUMN)) {
                        BasicMetaObject<?> basicMetaObject = it2.getMetaObject();
                        Intrinsics.checkNotNullExpressionValue(basicMetaObject, (String)"getMetaObject(...)");
                        if (this.this$0.possiblePrivileges(basicMetaObject).iterator().hasNext()) {
                            bl = true;
                            return bl;
                        }
                    }
                    bl = false;
                    return bl;
                }
            }, arg_0));
            Object object = h2;
            if (object == null || (object = object.getParent()) == null || (object = object.getFamilies()) == null) {
                BasicNode basicNode = h2;
                if (basicNode != null && (basicNode = basicNode.getParentFamily()) != null) {
                    void it2;
                    BasicNode basicNode2 = basicNode;
                    JBTreeTraverser jBTreeTraverser2 = jBTreeTraverser;
                    boolean bl = false;
                    object = CollectionsKt.listOf((Object)it2);
                    jBTreeTraverser = jBTreeTraverser2;
                } else {
                    object = null;
                }
            }
            JBIterable jBIterable = ((JBTreeTraverser)jBTreeTraverser.withRoots((Iterable)object)).traverse();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"traverse(...)");
            return jBIterable;
        }

        @Nullable
        public U findGrantee(@NotNull BasicElement h2, @NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)h2, (String)"h");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            return (U)((BasicGrantee)this.granteeFamiliesFor(h2).filterMap(arg_0 -> Controller.findGrantee$lambda$6((Function1)new Function1<Family<? extends U>, U>(this, text2){
                final /* synthetic */ Controller<G, U> this$0;
                final /* synthetic */ String $text;
                {
                    this.this$0 = $receiver;
                    this.$text = $text;
                    super(1);
                }

                @Nullable
                public final U invoke(Family<? extends U> f) {
                    return (U)((BasicGrantee)f.find(arg_0 -> findGrantee.1.invoke$lambda$0((Function1)new Function1<U, Boolean>(this.this$0, this.$text){
                        final /* synthetic */ Controller<G, U> this$0;
                        final /* synthetic */ String $text;
                        {
                            this.this$0 = $receiver;
                            this.$text = $text;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(U it2) {
                            return Intrinsics.areEqual((Object)this.this$0.granteeText(it2, null), (Object)this.$text);
                        }
                    }, arg_0)));
                }

                private static final boolean invoke$lambda$0(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    return (Boolean)$tmp0.invoke(p0);
                }
            }, arg_0)).first());
        }

        @Nullable
        public abstract BasicElement findTarget(@Nullable G var1, @Nullable BasicElement var2, @NotNull BasicResolveAssistant var3);

        @NotNull
        public String targetText(@Nullable BasicElement e2, @Nullable G g2) {
            Object object;
            block5: {
                block6: {
                    Object object2;
                    block8: {
                        block7: {
                            block4: {
                                if (!(e2 instanceof BasicRoot)) break block4;
                                object = "server";
                                break block5;
                            }
                            object = e2;
                            if (object == null) break block6;
                            Object it2 = object;
                            boolean bl = false;
                            object2 = StringKt.nullize$default((String)BasicPaths.getIdentity(e2), (boolean)false, (int)1, null);
                            if (object2 == null) break block7;
                            String it3 = object2;
                            boolean bl2 = false;
                            String string = e2.getName() + it3;
                            object2 = string;
                            if (string != null) break block8;
                        }
                        String string = e2.getName();
                        object2 = string;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    }
                    object = object2;
                    if (object2 != null) break block5;
                }
                object = "";
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final G withTarget(@NotNull G g2, @NotNull BasicElement e2) {
            Object object;
            block5: {
                block2: {
                    void $this$withTarget_u24lambda_u2410;
                    BitSet bitSet;
                    Controller controller;
                    BasicElement basicElement;
                    Controller controller2;
                    block4: {
                        block3: {
                            void it2;
                            Intrinsics.checkNotNullParameter(g2, (String)"g");
                            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                            if (!(e2 instanceof BasicLikeColumn)) break block2;
                            controller2 = this;
                            basicElement = ((BasicLikeColumn)e2).getParent();
                            if (basicElement == null) break block3;
                            BasicElement basicElement2 = basicElement;
                            controller = controller2;
                            boolean bl = false;
                            G g3 = this.withTargetImpl(g2, (BasicElement)it2);
                            controller2 = controller;
                            basicElement = g3;
                            if (g3 != null) break block4;
                        }
                        basicElement = this.withUnresolvedTarget(g2, "");
                    }
                    BitSet bitSet2 = bitSet = new BitSet();
                    String string = ((Grant)g2).getPermission();
                    BasicElement basicElement3 = basicElement;
                    controller = controller2;
                    boolean bl = false;
                    $this$withTarget_u24lambda_u2410.set(((BasicLikeColumn)e2).getPosition());
                    Unit unit = Unit.INSTANCE;
                    object = controller.withPermission(basicElement3, string, bitSet, ((Grant)g2).getState());
                    break block5;
                }
                object = this.withTargetImpl(g2, e2);
            }
            return object;
        }

        @NotNull
        protected abstract G withTargetImpl(@NotNull G var1, @NotNull BasicElement var2);

        @NotNull
        public abstract G withTargetFrom(@NotNull G var1, @NotNull G var2);

        @NotNull
        public abstract G withUnresolvedTarget(@NotNull G var1, @NotNull String var2);

        @NotNull
        public abstract G withGrantee(@NotNull G var1, @NotNull U var2);

        @NotNull
        public abstract G withUnresolvedGrantee(@NotNull G var1, @NotNull String var2);

        @NotNull
        public abstract G withGranteeFrom(@NotNull G var1, @NotNull G var2);

        @NotNull
        public abstract G withPermission(@NotNull G var1, @NotNull String var2, @Nullable BitSet var3, @NotNull State var4);

        @NotNull
        public abstract G withState(@NotNull G var1, @NotNull State var2);

        @NotNull
        public final G withAntiState(@NotNull G g2) {
            Intrinsics.checkNotNullParameter(g2, (String)"g");
            return this.withState(g2, switch (WhenMappings.$EnumSwitchMapping$0[((Grant)g2).getState().ordinal()]) {
                case 1, 2 -> State.REVOKE;
                case 3, 4 -> State.GRANT;
                default -> throw new NoWhenBranchMatchedException();
            });
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final BasicGrantsHolder<G> grantsHolder(@NotNull BasicElement e2) {
            void $this$grantsHolder$iv;
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            BasicElement basicElement = e2;
            boolean strict$iv = !this.holdsItsGrants(e2);
            boolean $i$f$grantsHolder = false;
            return DasUtil.getParentOfClass((DasObject)$this$grantsHolder$iv, BasicGrantsHolder.class, strict$iv);
        }

        public final boolean holdsItsGrants(@NotNull BasicElement element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            BasicMetaObject<?> basicMetaObject = element2.getMetaObject();
            Intrinsics.checkNotNullExpressionValue(basicMetaObject, (String)"getMetaObject(...)");
            return this.holdsItsGrants(basicMetaObject);
        }

        public abstract boolean holdsItsGrants(@NotNull BasicMetaObject<?> var1);

        @NotNull
        public final String serializeState(@NotNull G g2) {
            Intrinsics.checkNotNullParameter(g2, (String)"g");
            return String.valueOf(((Grant)g2).getState().getCode());
        }

        private static final Iterable targetFamiliesFor$lambda$3(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Iterable)$tmp0.invoke(p0);
        }

        private static final boolean targetFamiliesFor$lambda$4(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final BasicGrantee findGrantee$lambda$6(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (BasicGrantee)$tmp0.invoke(p0);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\t\u001a\u00020\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J \u0010\r\u001a\u0002H\u000e\"\u0010\b\u0003\u0010\u000e\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u000e0\u000fH\u0082\b\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u0004J\u0006\u0010\u0012\u001a\u00020\nJ\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/model/properties/Grants$Controller$Companion;", "", "()V", "deserializeId", "", "text", "", "deserializeKind", "Lcom/intellij/database/model/ObjectKind;", "deserializeState", "Lcom/intellij/database/model/properties/Grants$State;", "deserializeSubs", "Ljava/util/BitSet;", "minEnum", "T", "", "()Ljava/lang/Enum;", "minId", "minState", "nextId", "id", "nextName", "name", "serializeKind", "kind", "intellij.database.core.impl"})
        @SourceDebugExtension(value={"SMAP\nGrants.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Grants.kt\ncom/intellij/database/model/properties/Grants$Controller$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,291:1\n219#1:292\n1#2:293\n1313#3,2:294\n*S KotlinDebug\n*F\n+ 1 Grants.kt\ncom/intellij/database/model/properties/Grants$Controller$Companion\n*L\n220#1:292\n248#1:294,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            private final /* synthetic */ <T extends Enum<T>> T minEnum() {
                boolean $i$f$minEnum = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                Object[] objectArray = Enum.class.getEnumConstants();
                Intrinsics.checkNotNullExpressionValue(objectArray, (String)"getEnumConstants(...)");
                Object object = ArraysKt.first((Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
                return (T)((Enum)object);
            }

            @NotNull
            public final State minState() {
                Companion this_$iv = this;
                boolean $i$f$minEnum = false;
                Object[] objectArray = State.class.getEnumConstants();
                Intrinsics.checkNotNullExpressionValue(objectArray, (String)"getEnumConstants(...)");
                Object object = ArraysKt.first((Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
                return (State)((Enum)object);
            }

            public final long minId() {
                return Long.MIN_VALUE;
            }

            public final long nextId(long id) {
                return id + 1L;
            }

            @NotNull
            public final String nextName(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return name2 + "\u0000";
            }

            @NotNull
            public final State deserializeState(@Nullable String text2) {
                State state;
                State state2;
                block3: {
                    String string = text2;
                    if (!(string != null ? string.length() == 1 : false)) {
                        return State.GRANT;
                    }
                    char c2 = text2.charAt(0);
                    State[] stateArray = State.values();
                    int n = stateArray.length;
                    for (int j = 0; j < n; ++j) {
                        State state3;
                        State it2 = state3 = stateArray[j];
                        boolean bl = false;
                        if (!(it2.getCode() == c2)) continue;
                        state2 = state3;
                        break block3;
                    }
                    state2 = state = null;
                }
                if (state2 == null) {
                    state = State.GRANT;
                }
                return state;
            }

            @NotNull
            public final ObjectKind deserializeKind(@Nullable String text2) {
                CharSequence charSequence = text2;
                if (charSequence == null || charSequence.length() == 0) {
                    ObjectKind objectKind = ObjectKind.NONE;
                    Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"NONE");
                    return objectKind;
                }
                ObjectKind objectKind = ObjectKind.getKind(text2);
                if (objectKind == null) {
                    ObjectKind objectKind2 = ObjectKind.NONE;
                    objectKind = objectKind2;
                    Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"NONE");
                }
                return objectKind;
            }

            public final long deserializeId(@Nullable String text2) {
                String string = StringKt.nullize$default((String)text2, (boolean)false, (int)1, null);
                return string != null ? Long.parseLong(string) : Long.MIN_VALUE;
            }

            @NotNull
            public final String serializeKind(@NotNull ObjectKind kind) {
                ObjectKind objectKind;
                Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
                ObjectKind it2 = objectKind = kind;
                boolean bl = false;
                ObjectKind objectKind2 = !Intrinsics.areEqual((Object)it2, (Object)ObjectKind.NONE) ? objectKind : null;
                String string = objectKind2 != null ? objectKind2.code() : null;
                if (string == null) {
                    string = "";
                }
                return string;
            }

            @Nullable
            public final BitSet deserializeSubs(@Nullable String text2) {
                CharSequence charSequence = text2;
                if (charSequence == null || charSequence.length() == 0) {
                    return null;
                }
                BitSet subs2 = new BitSet();
                String[] stringArray = new String[]{","};
                Sequence $this$forEach$iv = SequencesKt.mapNotNull((Sequence)StringsKt.splitToSequence$default((CharSequence)text2, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (Function1)deserializeSubs.1.INSTANCE);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    int it2 = ((Number)element$iv).intValue();
                    boolean bl = false;
                    subs2.set(it2);
                }
                return subs2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[State.values().length];
                try {
                    nArray[State.GRANT_WITH_GRANT_OPTION.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.GRANT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.REVOKE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.DENY.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B!\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0019\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010\u001b\u001a\u00020\nJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0006\u0010\u001e\u001a\u00020\u0005R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/model/properties/Grants$Grant;", "", "subs", "Ljava/util/BitSet;", "permission", "", "state", "Lcom/intellij/database/model/properties/Grants$State;", "(Ljava/util/BitSet;Ljava/lang/String;Lcom/intellij/database/model/properties/Grants$State;)V", "isSub", "", "()Z", "mySubs", "getPermission", "()Ljava/lang/String;", "permissionName", "getPermissionName", "getState", "()Lcom/intellij/database/model/properties/Grants$State;", "getSubs", "()Ljava/util/BitSet;", "subsStream", "Ljava/util/stream/IntStream;", "getSubsStream", "()Ljava/util/stream/IntStream;", "equals", "other", "hasGrantOption", "hashCode", "", "serializeSubs", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nGrants.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Grants.kt\ncom/intellij/database/model/properties/Grants$Grant\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,291:1\n1#2:292\n*E\n"})
    public static abstract class Grant {
        @NotNull
        private final State state;
        @NotNull
        private final String permission;
        @Nullable
        private final BitSet mySubs;

        /*
         * Unable to fully structure code
         */
        protected Grant(@Nullable BitSet subs, @NotNull String permission, @NotNull State state) {
            Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            super();
            this.state = state;
            v0 = DbUtil.intern(permission);
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"intern(...)");
            this.permission = v0;
            v1 = this;
            v2 = subs;
            if (v2 == null) ** GOTO lbl-1000
            var5_5 = var4_4 = v2;
            var7_6 = v1;
            $i$a$-takeIf-Grants$Grant$mySubs$1 = false;
            var8_8 = it.isEmpty() == false;
            v1 = var7_6;
            v2 = var8_8 != false ? var4_4 : null;
            if (v2 != null) {
                it = v2;
                var7_6 = v1;
                $i$a$-run-Grants$Grant$mySubs$2 = false;
                v3 = $this$mySubs_u24lambda_u241.clone();
                Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type java.util.BitSet");
                v4 = (BitSet)v3;
                v1 = var7_6;
            } else lbl-1000:
            // 2 sources

            {
                v4 = null;
            }
            v1.mySubs = v4;
        }

        @NotNull
        public final State getState() {
            return this.state;
        }

        @NotNull
        public final String getPermission() {
            return this.permission;
        }

        @NotNull
        public final String getPermissionName() {
            String string = StringUtil.toLowerCase((String)this.permission);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return string;
        }

        public final boolean isSub() {
            return this.mySubs != null;
        }

        @NotNull
        public final IntStream getSubsStream() {
            IntStream intStream;
            if (this.mySubs == null) {
                IntStream intStream2 = IntStream.empty();
                intStream = intStream2;
                Intrinsics.checkNotNullExpressionValue((Object)intStream2, (String)"empty(...)");
            } else {
                IntStream intStream3 = this.mySubs.stream();
                intStream = intStream3;
                Intrinsics.checkNotNullExpressionValue((Object)intStream3, (String)"stream(...)");
            }
            return intStream;
        }

        @Nullable
        public final BitSet getSubs() {
            BitSet bitSet = this.mySubs;
            return (BitSet)(bitSet != null ? bitSet.clone() : null);
        }

        public final boolean hasGrantOption() {
            return this.state.getWithGrantOption();
        }

        @NotNull
        public final String serializeSubs() {
            StringBuilder sb = new StringBuilder();
            if (this.mySubs != null) {
                int l = sb.length();
                PrimitiveIterator.OfInt it2 = this.mySubs.stream().iterator();
                while (it2.hasNext()) {
                    if (l != sb.length()) {
                        sb.append(",");
                    }
                    Integer n = it2.next();
                    Intrinsics.checkNotNullExpressionValue((Object)n, (String)"next(...)");
                    sb.append(((Number)n).intValue());
                }
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Grant && Intrinsics.areEqual((Object)this.permission, (Object)((Grant)other).permission) && this.state == ((Grant)other).state && Intrinsics.areEqual((Object)this.mySubs, (Object)((Grant)other).mySubs);
        }

        public int hashCode() {
            int result2 = this.permission.hashCode();
            result2 = 31 * result2 + this.state.hashCode();
            BitSet bitSet = this.mySubs;
            result2 = 31 * result2 + (bitSet != null ? bitSet.hashCode() : 0);
            return result2;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/model/properties/Grants$State;", "", "code", "", "(Ljava/lang/String;IC)V", "getCode", "()C", "term", "", "getTerm", "()Ljava/lang/String;", "withGrantOption", "", "getWithGrantOption", "()Z", "GRANT", "GRANT_WITH_GRANT_OPTION", "REVOKE", "DENY", "intellij.database.core.impl"})
    public static final class State
    extends Enum<State> {
        private final char code;
        public static final /* enum */ State GRANT = new State('G');
        public static final /* enum */ State GRANT_WITH_GRANT_OPTION = new GRANT_WITH_GRANT_OPTION("GRANT_WITH_GRANT_OPTION", 1);
        public static final /* enum */ State REVOKE = new State('R');
        public static final /* enum */ State DENY = new State('D');
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private State(char code) {
            this.code = code;
        }

        public final char getCode() {
            return this.code;
        }

        @NotNull
        public String getTerm() {
            String string = StringUtil.toLowerCase((String)this.name());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return string;
        }

        public final boolean getWithGrantOption() {
            return this == GRANT_WITH_GRANT_OPTION;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value2) {
            return Enum.valueOf(State.class, value2);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ State(String $enum$name, int $enum$ordinal, char code, DefaultConstructorMarker $constructor_marker) {
            this(code);
        }

        static {
            $VALUES = stateArray = new State[]{State.GRANT, State.GRANT_WITH_GRANT_OPTION, State.REVOKE, State.DENY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0001\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/model/properties/Grants$State$GRANT_WITH_GRANT_OPTION;", "Lcom/intellij/database/model/properties/Grants$State;", "term", "", "getTerm", "()Ljava/lang/String;", "intellij.database.core.impl"})
        static final class GRANT_WITH_GRANT_OPTION
        extends State {
            /*
             * WARNING - void declaration
             */
            GRANT_WITH_GRANT_OPTION() {
                void var1_1;
            }

            @Override
            @NotNull
            public String getTerm() {
                return GRANT.getTerm();
            }
        }
    }
}

