/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.diff;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.MemoryTextStorage;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.script.generator.CustomScriptingOptions;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ObjectUtils;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DbDiffRoot {
    private final DbDataSource myDataSource;
    private final DirDiffSettings mySettings;
    private final BasicModel myModel;
    private BasicModModel myAltModel;
    private final List<BasicElement> myRootElements;
    private final Condition<DasObject> myFilter;

    public DbDiffRoot(@NotNull DbDataSource source, @NotNull DirDiffSettings settings, @NotNull Dbms otherDbms, @NotNull List<BasicElement> rootElements) {
        if (source == null) {
            DbDiffRoot.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            DbDiffRoot.$$$reportNull$$$0(1);
        }
        if (otherDbms == null) {
            DbDiffRoot.$$$reportNull$$$0(2);
        }
        if (rootElements == null) {
            DbDiffRoot.$$$reportNull$$$0(3);
        }
        this.myDataSource = source;
        this.mySettings = settings;
        this.myRootElements = rootElements;
        this.myModel = (BasicModel)this.myDataSource.getDelegate().getModel();
        this.myAltModel = new ModelFactory(new MemoryTextStorage()).createModel(otherDbms);
        this.myFilter = (Condition)ObjectUtils.notNull(DbImplUtilCore.buildFilter(this.myDataSource), (Object)Conditions.alwaysTrue());
    }

    public DbDiffRoot(@NotNull DbDataSource source, @NotNull DirDiffSettings settings, @NotNull Dbms otherDbms, @NotNull BasicElement rootElement) {
        if (source == null) {
            DbDiffRoot.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            DbDiffRoot.$$$reportNull$$$0(5);
        }
        if (otherDbms == null) {
            DbDiffRoot.$$$reportNull$$$0(6);
        }
        if (rootElement == null) {
            DbDiffRoot.$$$reportNull$$$0(7);
        }
        this(source, settings, otherDbms, List.of(rootElement));
    }

    public void reinitializeAltModel() {
        Dbms otherDbms = this.myAltModel.getDbms();
        this.myAltModel = new ModelFactory(new MemoryTextStorage()).createModel(otherDbms);
    }

    @NotNull
    public BasicElement getRootElement() {
        if (this.myRootElements.size() != 1) {
            throw new IllegalStateException();
        }
        BasicElement basicElement = this.myRootElements.get(0);
        if (basicElement == null) {
            DbDiffRoot.$$$reportNull$$$0(8);
        }
        return basicElement;
    }

    @NotNull
    public List<BasicElement> getRootElements() {
        List<BasicElement> list = this.myRootElements;
        if (list == null) {
            DbDiffRoot.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public DbDataSource getDataSource() {
        DbDataSource dbDataSource = this.myDataSource;
        if (dbDataSource == null) {
            DbDiffRoot.$$$reportNull$$$0(10);
        }
        return dbDataSource;
    }

    @NotNull
    public DirDiffSettings getSettings() {
        DirDiffSettings dirDiffSettings = this.mySettings;
        if (dirDiffSettings == null) {
            DbDiffRoot.$$$reportNull$$$0(11);
        }
        return dirDiffSettings;
    }

    @NotNull
    public BasicModel getModel() {
        BasicModel basicModel = this.myModel;
        if (basicModel == null) {
            DbDiffRoot.$$$reportNull$$$0(12);
        }
        return basicModel;
    }

    @NotNull
    public BasicModModel getAltModel() {
        BasicModModel basicModModel = this.myAltModel;
        if (basicModModel == null) {
            DbDiffRoot.$$$reportNull$$$0(13);
        }
        return basicModModel;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myDataSource.getProject();
        if (project == null) {
            DbDiffRoot.$$$reportNull$$$0(14);
        }
        return project;
    }

    @NotNull
    public Language getLanguage() {
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtilCore.getSqlDialect(this.myDataSource);
        if (sqlLanguageDialect == null) {
            DbDiffRoot.$$$reportNull$$$0(15);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public ScriptingOptions createOptions() {
        return DbDiffRoot.createOptions(this.mySettings);
    }

    @NotNull
    public static ScriptingOptions createOptions(DirDiffSettings settings) {
        HashMap opts = new HashMap();
        opts.put(ScriptingOptionStatic.IGNORE_OWNER, settings.customSettings.get("PG_IGNORE_OWNER"));
        opts.put(ScriptingOptionStatic.IGNORE_ORDER, settings.customSettings.get("IGNORE_ORDER"));
        opts.put(ScriptingOptionStatic.IGNORE_DEFINER, settings.customSettings.get("MYSQL_IGNORE_DEFINER"));
        opts.put(ScriptingOptionStatic.IGNORE_CASE_CHANGES, settings.customSettings.get("IGNORE_CASE"));
        return new CustomScriptingOptions(opts);
    }

    @NotNull
    public Condition<DasObject> getFilter() {
        Condition<DasObject> condition2 = this.myFilter;
        if (condition2 == null) {
            DbDiffRoot.$$$reportNull$$$0(16);
        }
        return condition2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12, 13, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherDbms";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElements";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/diff/DbDiffRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/diff/DbDiffRoot";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElements";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAltModel";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12, 13, 14, 15, 16 -> new IllegalStateException(string);
        };
    }
}

