/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasOperator;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicArgument;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicConstraint;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicOverloadable;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.SingletonFamily;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystem;
import com.intellij.database.types.DasTypeSystems;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPaths;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Comparator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModelUtil {
    public static final Comparator<? super BasicElement> DISPLAY_ORDER_COMPARATOR = (e1, e2) -> e1.getDisplayOrder((BasicElement)e2);
    public static final Comparator<? super BasicArrangedElement> POSITIONS_COMPARATOR = (e1, e2) -> {
        short p2;
        short p1 = e1.getPosition();
        return p1 < (p2 = e2.getPosition()) ? -1 : (p1 > p2 ? 1 : 0);
    };

    public static String calculateSybProcedureIdentity(short pos) {
        return Short.toString(pos);
    }

    public static String calculateRoutineIdentity(@Nullable String name2, @NotNull Iterable<? extends DasArgument> args2, @Nullable DasTypeSystem normalizer) {
        if (args2 == null) {
            ModelUtil.$$$reportNull$$$0(0);
        }
        return ModelUtil.calculateRoutineIdentityByType(name2, (Iterable<DasType>)JBIterable.from(args2).filterMap(a -> a.getArgumentDirection().isIn() ? a.getDasType() : null), normalizer);
    }

    public static String calculateRoutineIdentityByType(@Nullable String name2, @NotNull Iterable<DasType> types2, @Nullable DasTypeSystem normalizer) {
        if (types2 == null) {
            ModelUtil.$$$reportNull$$$0(1);
        }
        StringBuilder b2 = new StringBuilder();
        b2.append(name2);
        boolean w = false;
        b2.append('(');
        for (DasType dasType : types2) {
            if (w) {
                b2.append(',');
            }
            DataType type2 = dasType.toDataType();
            if (normalizer != null) {
                type2 = normalizer.normalizeType(type2);
            }
            b2.append(type2.getSpecification());
            w = true;
        }
        b2.append(')');
        return b2.toString();
    }

    @NotNull
    public static String calculateOverloadableIdentity(@NotNull BasicOverloadable o2, boolean includingSurrogate, boolean normalize) {
        String name2;
        if (o2 == null) {
            ModelUtil.$$$reportNull$$$0(2);
        }
        Dbms dbms = DbImplUtilCore.getDbms(o2);
        if (o2 instanceof DasPositioned && dbms == Dbms.SYBASE) {
            String string = ModelUtil.calculateSybProcedureIdentity(((DasPositioned)((Object)o2)).getPosition());
            if (string == null) {
                ModelUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        BasicNamedElement ne = (BasicNamedElement)ObjectUtils.tryCast((Object)o2, BasicNamedElement.class);
        String string = ne == null ? "" : (name2 = includingSurrogate ? ne.getRealName() : ne.getNaturalName());
        if (o2 instanceof BasicRoutine) {
            String string2 = ModelUtil.calculateRoutineIdentity(name2, ((BasicRoutine)((Object)o2)).getArguments(), ModelUtil.getNormalizer(dbms, normalize));
            if (string2 == null) {
                ModelUtil.$$$reportNull$$$0(4);
            }
            return string2;
        }
        if (o2 instanceof DasOperator) {
            String string3 = ModelUtil.calculateRoutineIdentityByType(name2, ((DasOperator)((Object)o2)).getArgumentTypes(), ModelUtil.getNormalizer(dbms, normalize));
            if (string3 == null) {
                ModelUtil.$$$reportNull$$$0(5);
            }
            return string3;
        }
        String string4 = String.valueOf(name2);
        if (string4 == null) {
            ModelUtil.$$$reportNull$$$0(6);
        }
        return string4;
    }

    @Nullable
    public static DasTypeSystem getNormalizer(Dbms dbms, boolean normalize) {
        return normalize ? DasTypeSystems.getTypeSystem(dbms) : null;
    }

    @Nullable
    public static BasicElement findObject(@NotNull Family<?> target2, @NotNull BasicElement child) {
        BasicElement res2;
        if (target2 == null) {
            ModelUtil.$$$reportNull$$$0(7);
        }
        if (child == null) {
            ModelUtil.$$$reportNull$$$0(8);
        }
        if (target2 instanceof SingletonFamily) {
            return ((SingletonFamily)target2).get();
        }
        String name2 = child.getName();
        if (child instanceof BasicOverloadable) {
            String identity = ObjectPaths.getIdentity(child);
            return target2.find(x -> name2.equals(x.getName()) && Objects.equals(ObjectPaths.getIdentity(x), identity));
        }
        boolean surrogate = ModelUtil.isSurrogate(child);
        if (!surrogate) {
            res2 = target2.find(x -> x.getName().equals(name2));
        } else {
            String id = child.identity(false);
            res2 = target2.find(x -> ModelUtil.isSurrogate(x) && x.identity(false).equals(id));
        }
        return res2;
    }

    private static boolean isSurrogate(@NotNull BasicElement child) {
        if (child == null) {
            ModelUtil.$$$reportNull$$$0(9);
        }
        return child instanceof BasicModNamedElement && ((BasicModNamedElement)child).isNameSurrogate() || child.getName().isEmpty() && (child instanceof BasicConstraint || child instanceof BasicLikeColumn || child instanceof BasicArgument);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/ModelUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/ModelUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateOverloadableIdentity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateRoutineIdentity";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calculateRoutineIdentityByType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calculateOverloadableIdentity";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findObject";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSurrogate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

