/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.MergingRenameQueue;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.script.CompositeTextFun;
import com.intellij.database.util.ObjectNamePart;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u001d2\b\u0010 \u001a\u0004\u0018\u00010\tH\u0016J\u001f\u0010!\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\"\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010#J\u0018\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u001c\u0010)\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b*\u00020\u0016H\u0002R*\u0010\u0003\u001a\u001e\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b\u0012\u0004\u0012\u00020\u000f0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/database/model/MemoryTextStorage;", "Lcom/intellij/database/model/ModelTextStorage;", "()V", "content", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkotlin/Pair;", "", "Lcom/intellij/database/util/ObjectPath;", "Lcom/intellij/database/model/Key;", "Lcom/intellij/database/model/properties/CompositeText;", "renameProcessor", "Lcom/intellij/database/model/MemoryTextStorage$MyRenameProcessor;", "renameQueue", "Lcom/intellij/database/model/MergingRenameQueue;", "versions", "", "clear", "", "flushQueues", "flushRenameQueue", "getVersion", "element", "Lcom/intellij/database/model/basic/BasicElement;", "(Lcom/intellij/database/model/basic/BasicElement;)Ljava/lang/Long;", "handleRename", "e", "oldName", "Lcom/intellij/database/util/ObjectNamePart;", "load", "Lcom/intellij/database/model/basic/BasicSourceAware;", "queueDelete", "save", "text", "setVersion", "version", "(Lcom/intellij/database/model/basic/BasicElement;Ljava/lang/Long;)V", "writeSession", "model", "Lcom/intellij/database/model/basic/BasicModModel;", "runnable", "Ljava/lang/Runnable;", "composeElementKey", "MyRenameProcessor", "intellij.database.core.impl"})
public final class MemoryTextStorage
implements ModelTextStorage {
    @NotNull
    private final ConcurrentHashMap<Pair<String, ObjectPath>, CompositeText> content = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<Pair<String, ObjectPath>, Long> versions = new ConcurrentHashMap();
    @NotNull
    private final MergingRenameQueue<Pair<String, ObjectPath>> renameQueue = new MergingRenameQueue();
    @NotNull
    private final MyRenameProcessor renameProcessor = new MyRenameProcessor();

    @Override
    public void save(@NotNull BasicSourceAware element2, @Nullable CompositeText text2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        this.flushRenameQueue();
        Pair<String, ObjectPath> key2 = this.composeElementKey(element2);
        if (text2 != null) {
            ((Map)this.content).put(key2, CompositeTextFun.copy(text2));
        } else {
            this.content.remove(key2);
        }
    }

    @Override
    public void handleRename(@NotNull BasicElement e2, @NotNull ObjectNamePart oldName) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
        Pair<String, ObjectPath> newKey = this.composeElementKey(e2);
        Object object = newKey.getFirst();
        ObjectPath objectPath = ObjectPath.create(oldName.name, ((ObjectPath)newKey.getSecond()).kind, oldName.isQuoted(), oldName.getIdentity(), ((ObjectPath)newKey.getSecond()).parent);
        Intrinsics.checkNotNullExpressionValue((Object)objectPath, (String)"create(...)");
        Pair oldKey = new Pair(object, (Object)objectPath);
        if (Intrinsics.areEqual((Object)oldKey, newKey)) {
            return;
        }
        this.renameQueue.queueRename(newKey, (Pair<String, ObjectPath>)oldKey, e2.hashCode());
    }

    private final void flushRenameQueue() {
        List<MergingRenameQueue.RenameItem<Pair<String, ObjectPath>>> list = this.renameQueue.clear();
        Intrinsics.checkNotNullExpressionValue(list, (String)"clear(...)");
        List<MergingRenameQueue.RenameItem<Pair<String, ObjectPath>>> renames = list;
        if (renames.isEmpty()) {
            return;
        }
        this.renameProcessor.perform(renames);
    }

    @Override
    public void queueDelete(@NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        this.flushRenameQueue();
        this.content.remove(this.composeElementKey(element2));
    }

    @Override
    public void flushQueues() {
        this.flushRenameQueue();
    }

    @Override
    public void clear() {
        this.flushRenameQueue();
        this.content.clear();
    }

    @Override
    @Nullable
    public CompositeText load(@NotNull BasicSourceAware element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        this.flushRenameQueue();
        Pair<String, ObjectPath> key2 = this.composeElementKey(element2);
        return this.content.get(key2);
    }

    @Override
    public void writeSession(@NotNull BasicModModel model2, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        runnable.run();
        this.flushRenameQueue();
    }

    @Override
    @Nullable
    public Long getVersion(@NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        this.flushRenameQueue();
        return this.versions.get(this.composeElementKey(element2));
    }

    @Override
    public void setVersion(@NotNull BasicElement element2, @Nullable Long version) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        this.flushRenameQueue();
        Pair<String, ObjectPath> key2 = this.composeElementKey(element2);
        if (version != null) {
            ((Map)this.versions).put(key2, version);
        } else {
            this.versions.remove(key2);
        }
    }

    private final Pair<String, ObjectPath> composeElementKey(BasicElement $this$composeElementKey) {
        BasicModel model2;
        BasicModel basicModel = model2 = $this$composeElementKey.getModel();
        String prefix = String.valueOf(basicModel != null ? basicModel.hashCode() : 0);
        ObjectPath objectPath = ObjectPaths.of($this$composeElementKey, model2);
        Intrinsics.checkNotNullExpressionValue((Object)objectPath, (String)"of(...)");
        return new Pair((Object)prefix, (Object)objectPath);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\b\u0086\u0004\u0018\u00002\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00050\u0001B\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005H\u0016J \u0010\t\u001a\u00020\n2\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005H\u0016JJ\u0010\t\u001a\u00020\n\"\u0004\b\u0000\u0010\u000b2\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\"\u0010\f\u001a\u001e\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005\u0012\u0004\u0012\u0002H\u000b0\rH\u0002J4\u0010\u000e\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0002j\u0004\u0018\u0001`\u00052\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005H\u0016J8\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005H\u0016Jb\u0010\u000f\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u000b2\"\u0010\f\u001a\u001e\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005\u0012\u0004\u0012\u0002H\u000b0\u00132\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/model/MemoryTextStorage$MyRenameProcessor;", "Lcom/intellij/database/model/MergingRenameQueue$RenameProcessor;", "Lkotlin/Pair;", "", "Lcom/intellij/database/util/ObjectPath;", "Lcom/intellij/database/model/Key;", "(Lcom/intellij/database/model/MemoryTextStorage;)V", "createTempName", "p", "exists", "", "T", "map", "", "getParent", "processRename", "", "from", "to", "", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nMemoryTextStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryTextStorage.kt\ncom/intellij/database/model/MemoryTextStorage$MyRenameProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1747#2,3:113\n1855#2,2:117\n1#3:116\n*S KotlinDebug\n*F\n+ 1 MemoryTextStorage.kt\ncom/intellij/database/model/MemoryTextStorage$MyRenameProcessor\n*L\n90#1:113,3\n104#1:117,2\n*E\n"})
    public final class MyRenameProcessor
    extends MergingRenameQueue.RenameProcessor<Pair<? extends String, ? extends ObjectPath>> {
        @Override
        public boolean exists(@NotNull Pair<String, ? extends ObjectPath> p2) {
            Intrinsics.checkNotNullParameter(p2, (String)"p");
            return this.exists(p2, MemoryTextStorage.this.content) || this.exists(p2, MemoryTextStorage.this.versions);
        }

        private final <T> boolean exists(Pair<String, ? extends ObjectPath> p2, Map<Pair<String, ObjectPath>, ? extends T> map2) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = map2.keySet();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Pair it2 = (Pair)element$iv;
                        boolean bl2 = false;
                        if (!(Intrinsics.areEqual((Object)p2.getFirst(), (Object)it2.getFirst()) && ((ObjectPath)p2.getSecond()).isAncestorOf((ObjectPath)it2.getSecond(), false))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        @Nullable
        public Pair<String, ObjectPath> getParent(@NotNull Pair<String, ? extends ObjectPath> p2) {
            Pair pair;
            Intrinsics.checkNotNullParameter(p2, (String)"p");
            ObjectPath objectPath = ((ObjectPath)p2.getSecond()).parent;
            if (objectPath != null) {
                ObjectPath it2 = objectPath;
                boolean bl = false;
                pair = new Pair(p2.getFirst(), (Object)it2);
            } else {
                pair = null;
            }
            return pair;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Pair<String, ObjectPath> createTempName(@NotNull Pair<String, ? extends ObjectPath> p2) {
            void $this$createTempName_u24lambda_u242;
            Intrinsics.checkNotNullParameter(p2, (String)"p");
            ObjectPath objectPath = (ObjectPath)p2.getSecond();
            Object object = p2.getFirst();
            boolean bl = false;
            ObjectPath objectPath2 = ObjectPath.create("tmp-cycle-rename", $this$createTempName_u24lambda_u242.kind, false, null, $this$createTempName_u24lambda_u242.parent);
            Intrinsics.checkNotNullExpressionValue((Object)objectPath2, (String)"run(...)");
            ObjectPath objectPath3 = objectPath2;
            Object object2 = object;
            return new Pair(object2, (Object)objectPath3);
        }

        @Override
        public void processRename(@NotNull Pair<String, ? extends ObjectPath> from, @NotNull Pair<String, ? extends ObjectPath> to) {
            Intrinsics.checkNotNullParameter(from, (String)"from");
            Intrinsics.checkNotNullParameter(to, (String)"to");
            this.processRename(MemoryTextStorage.this.content, from, to);
            this.processRename(MemoryTextStorage.this.versions, from, to);
        }

        private final <T> void processRename(Map<Pair<String, ObjectPath>, T> map2, Pair<String, ? extends ObjectPath> from, Pair<String, ? extends ObjectPath> to) {
            T t = map2.remove(from);
            if (t != null) {
                T it2 = t;
                boolean bl = false;
                map2.put(to, it2);
            }
            Iterable $this$forEach$iv = map2.keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                T it3;
                Pair k = (Pair)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)k.getFirst(), (Object)from.getFirst()) || !((ObjectPath)from.getSecond()).isAncestorOf((ObjectPath)k.getSecond(), false)) continue;
                if (map2.remove(k) == null) continue;
                boolean bl2 = false;
                Map<Pair<String, ObjectPath>, T> map3 = map2;
                Object object = k.getFirst();
                ObjectPath objectPath = ((ObjectPath)k.getSecond()).rebase((ObjectPath)to.getSecond());
                Intrinsics.checkNotNullExpressionValue((Object)objectPath, (String)"rebase(...)");
                map3.put((Pair<String, ObjectPath>)new Pair(object, (Object)objectPath), it3);
            }
        }
    }
}

