/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.liveTemplates.macros;

import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.database.liveTemplates.macros.DbContextMacroBase;
import com.intellij.database.model.DasColumn;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.editor.SqlEditorOptions;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/liveTemplates/macros/DbColumnsMacro;", "Lcom/intellij/database/liveTemplates/macros/DbContextMacroBase;", "()V", "calcResultFromDbContext", "Lcom/intellij/codeInsight/template/Result;", "target", "Lcom/intellij/database/psi/DbElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getName", "", "intellij.database.impl"})
public final class DbColumnsMacro
extends DbContextMacroBase {
    @NotNull
    public String getName() {
        return "dbColumns";
    }

    @Override
    @NotNull
    protected Result calcResultFromDbContext(@NotNull DbElement target2, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Project project = target2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor2.getDocument());
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect(target2);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"getSqlDialect(...)");
        SqlLanguageDialect dialect = sqlLanguageDialect;
        DdlBuilder ddlBuilder = new DdlBuilder().applyCodeStyle(project2, dialect);
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"applyCodeStyle(...)");
        DdlBuilder builder = ddlBuilder;
        if (psiFile != null) {
            builder.configureBuilder(SqlCodeStyles.getSqlSettings((PsiFile)psiFile));
        }
        SqlEditorOptions sqlEditorOptions = SqlEditorOptions.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)sqlEditorOptions, (String)"getInstance(...)");
        SqlEditorOptions options2 = sqlEditorOptions;
        SqlEditorOptions.QualificationType qualificationType = options2.getTableQualification().and(options2.getLiveTemplateQualification());
        Intrinsics.checkNotNullExpressionValue((Object)qualificationType, (String)"and(...)");
        SqlEditorOptions.QualificationType qualification = qualificationType;
        boolean shouldQualify = qualification.shouldQualify(1);
        Iterator iterator = DasUtil.getColumns(target2).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index2 = n++;
            DasColumn column2 = (DasColumn)iterator.next();
            if (index2 > 0) {
                builder.symbol(", ");
            }
            if (shouldQualify) {
                builder.identifier(target2, target2.getName()).symbol(".");
            }
            builder.identifier(column2, column2.getName());
        }
        return (Result)new TextResult(builder.getStatement());
    }
}

