/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection.query;

import com.intellij.database.util.common.StringFun;
import com.intellij.openapi.util.NlsSafe;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0007\u0018\u0000 #2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002#$B\u001b\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0096\u0001J\u0011\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0003H\u0096\u0001J\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\u0002H\u0096\u0003J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001eH\u0002J\u0006\u0010\u001f\u001a\u00020\u0002J\t\u0010 \u001a\u00020\u0018H\u0096\u0001J\u000e\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0002R$\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\t0\bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0012\u0010\u000e\u001a\u00020\u000fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006%"}, d2={"Lcom/intellij/database/introspection/query/QueryStats;", "", "", "Lcom/intellij/database/introspection/query/QueryStats$StatEntry;", "stats", "", "(Ljava/util/Map;)V", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "size", "", "getSize", "()I", "turnSequence", "values", "", "getValues", "()Ljava/util/Collection;", "containsKey", "", "key", "containsValue", "value", "get", "getSortedList", "", "getSortedText", "isEmpty", "registerStart", "name", "Companion", "StatEntry", "intellij.database.core.impl"})
public final class QueryStats
implements Map<String, StatEntry>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, StatEntry> stats;
    private volatile int turnSequence;
    public static final int prettyTextWidth = 140;

    public QueryStats(@NotNull Map<String, StatEntry> stats) {
        Intrinsics.checkNotNullParameter(stats, (String)"stats");
        this.stats = stats;
    }

    public /* synthetic */ QueryStats(Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map2 = new HashMap();
        }
        this(map2);
    }

    @NotNull
    public Set<Map.Entry<String, StatEntry>> getEntries() {
        return this.stats.entrySet();
    }

    @NotNull
    public Set<String> getKeys() {
        return this.stats.keySet();
    }

    public int getSize() {
        return this.stats.size();
    }

    @NotNull
    public Collection<StatEntry> getValues() {
        return this.stats.values();
    }

    public boolean containsKey(@NotNull String key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        return this.stats.containsKey(key2);
    }

    public boolean containsValue(@NotNull StatEntry value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return this.stats.containsValue(value2);
    }

    @Nullable
    public StatEntry get(@NotNull String key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        return this.stats.get(key2);
    }

    @Override
    public boolean isEmpty() {
        return this.stats.isEmpty();
    }

    @NotNull
    public final StatEntry registerStart(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        StatEntry statEntry = this.stats.computeIfAbsent(name2, arg_0 -> QueryStats.registerStart$lambda$0((Function1)new Function1<String, StatEntry>(this, name2){
            final /* synthetic */ QueryStats this$0;
            final /* synthetic */ String $name;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                super(1);
            }

            @NotNull
            public final StatEntry invoke(@NotNull String it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                QueryStats queryStats = this.this$0;
                QueryStats.access$setTurnSequence$p(queryStats, QueryStats.access$getTurnSequence$p(queryStats) + 1);
                return new StatEntry(QueryStats.access$getTurnSequence$p(queryStats), this.$name);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)statEntry, (String)"computeIfAbsent(...)");
        StatEntry e2 = statEntry;
        e2.registerStart();
        return e2;
    }

    private final List<StatEntry> getSortedList() {
        return CollectionsKt.sortedWith((Iterable)this.stats.values(), (Comparator)StatEntry.DurationComparator.INSTANCE);
    }

    @NotNull
    public final String getSortedText() {
        List<StatEntry> rows = this.getSortedList();
        long totalDuration = 0L;
        for (StatEntry row : rows) {
            totalDuration += row.getDurationSum();
        }
        StringBuilder b2 = new StringBuilder(1000);
        String horizontalLine = StringFun.replicate$default("-", 140, null, null, 6, null);
        b2.append("Query Performance Statistics:\n");
        b2.append(horizontalLine).append('\n');
        b2.append("##  count err    T.min     T.avg     T.max     T.sum   %     rows packs  Query \n");
        b2.append(horizontalLine).append('\n');
        for (StatEntry row : rows) {
            String nr = StringsKt.padStart$default((String)String.valueOf(row.getTurn()), (int)2, (char)'\u0000', (int)2, null);
            String count = StringsKt.padStart$default((String)String.valueOf(row.getNumberOfFinishes()), (int)5, (char)'\u0000', (int)2, null);
            String errs = StringsKt.padStart$default((String)QueryStats.Companion.toStringIfNotZero(row.getNumberOfFails()), (int)3, (char)'\u0000', (int)2, null);
            String tMin = QueryStats.Companion.formatToSeconds(row.getDurationMin());
            String tAvg = QueryStats.Companion.formatToSeconds(row.getDurationAvg());
            String tMax = QueryStats.Companion.formatToSeconds(row.getDurationMax());
            String tSum = QueryStats.Companion.formatToSeconds(row.getDurationSum());
            String percent = StringsKt.padStart$default((String)String.valueOf(totalDuration == 0L ? 0 : MathKt.roundToInt((double)(100.0 * (double)row.getDurationSum() / (double)totalDuration))), (int)3, (char)'\u0000', (int)2, null);
            String nRows = StringsKt.padStart$default((String)QueryStats.Companion.toStringIfNotZero(row.getFetchedRows()), (int)8, (char)'\u0000', (int)2, null);
            String nPacks = StringsKt.padStart$default((String)QueryStats.Companion.toStringIfNotZero(row.getFetchedPacks()), (int)5, (char)'\u0000', (int)2, null);
            StringBuilder stringBuilder = b2.append(nr);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            StringBuilder stringBuilder2 = QueryStats.Companion.space(stringBuilder).append(count);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            StringBuilder stringBuilder3 = QueryStats.Companion.space(stringBuilder2).append(errs);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            StringBuilder stringBuilder4 = QueryStats.Companion.space(stringBuilder3).append(tMin);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
            StringBuilder stringBuilder5 = QueryStats.Companion.space(stringBuilder4).append(tAvg);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
            StringBuilder stringBuilder6 = QueryStats.Companion.space(stringBuilder5).append(tMax);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
            StringBuilder stringBuilder7 = QueryStats.Companion.space(stringBuilder6).append(tSum);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
            StringBuilder stringBuilder8 = QueryStats.Companion.space(stringBuilder7).append(percent);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
            StringBuilder stringBuilder9 = QueryStats.Companion.space(stringBuilder8).append(nRows);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(...)");
            StringBuilder stringBuilder10 = QueryStats.Companion.space(stringBuilder9).append(nPacks);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(...)");
            QueryStats.Companion.space(QueryStats.Companion.space(stringBuilder10)).append(row.getName()).append('\n');
        }
        b2.append(horizontalLine).append('\n');
        b2.append("Total duration of all queries: ").append(QueryStats.Companion.formatToSeconds(totalDuration)).append(" s.");
        String string = b2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public StatEntry compute(String p0, BiFunction<? super String, ? super StatEntry, ? extends StatEntry> p1) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public StatEntry computeIfAbsent(String p0, Function<? super String, ? extends StatEntry> p1) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public StatEntry computeIfPresent(String p0, BiFunction<? super String, ? super StatEntry, ? extends StatEntry> p1) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public StatEntry merge(String p0, StatEntry p1, BiFunction<? super StatEntry, ? super StatEntry, ? extends StatEntry> p2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public StatEntry put(String key2, StatEntry value2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void putAll(Map<? extends String, ? extends StatEntry> from) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public StatEntry putIfAbsent(String p0, StatEntry p1) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public StatEntry remove(Object key2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object key2, Object value2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean replace(String p0, StatEntry p1, StatEntry p2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public StatEntry replace(String p0, StatEntry p1) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super StatEntry, ? extends StatEntry> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    private static final StatEntry registerStart$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (StatEntry)$tmp0.invoke(p0);
    }

    public QueryStats() {
        this(null, 1, null);
    }

    public static final /* synthetic */ void access$setTurnSequence$p(QueryStats $this, int n) {
        $this.turnSequence = n;
    }

    public static final /* synthetic */ int access$getTurnSequence$p(QueryStats $this) {
        return $this.turnSequence;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0002J\u0014\u0010\b\u001a\u00060\tj\u0002`\n*\u00060\tj\u0002`\nH\u0002J\f\u0010\u000b\u001a\u00020\u0006*\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/database/introspection/query/QueryStats$Companion;", "", "()V", "prettyTextWidth", "", "formatToSeconds", "", "", "space", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "toStringIfNotZero", "intellij.database.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final String toStringIfNotZero(int $this$toStringIfNotZero) {
            return $this$toStringIfNotZero != 0 ? String.valueOf($this$toStringIfNotZero) : "";
        }

        private final String formatToSeconds(long $this$formatToSeconds) {
            return StringsKt.padStart$default((String)String.valueOf($this$formatToSeconds / (long)1000), (int)5, (char)'\u0000', (int)2, null) + "." + StringsKt.padStart((String)String.valueOf($this$formatToSeconds % (long)1000), (int)3, (char)'0');
        }

        private final StringBuilder space(StringBuilder $this$space) {
            StringBuilder stringBuilder = $this$space.append(' ');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            return stringBuilder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u001f\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001/B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u00032\b\b\u0002\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020(R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\n\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\n\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\n\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0017\"\u0004\b!\u0010\u0019R\u001a\u0010\"\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0017\"\u0004\b$\u0010\u0019R\u000e\u0010%\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0017\u00a8\u00060"}, d2={"Lcom/intellij/database/introspection/query/QueryStats$StatEntry;", "", "turn", "", "name", "", "(ILjava/lang/String;)V", "durationAvg", "", "getDurationAvg", "()J", "durationMax", "getDurationMax", "setDurationMax", "(J)V", "durationMin", "getDurationMin", "setDurationMin", "durationSum", "getDurationSum", "setDurationSum", "fetchedPacks", "getFetchedPacks", "()I", "setFetchedPacks", "(I)V", "fetchedRows", "getFetchedRows", "setFetchedRows", "getName", "()Ljava/lang/String;", "numberOfFails", "getNumberOfFails", "setNumberOfFails", "numberOfFinishes", "getNumberOfFinishes", "setNumberOfFinishes", "numberOfStarts", "getTurn", "registerFinish", "", "duration", "packs", "rows", "failed", "", "registerStart", "DurationComparator", "intellij.database.core.impl"})
    public static final class StatEntry {
        private final int turn;
        @NotNull
        private final String name;
        private int numberOfStarts;
        private int numberOfFinishes;
        private int numberOfFails;
        private int fetchedPacks;
        private int fetchedRows;
        private long durationMin;
        private long durationMax;
        private long durationSum;

        public StatEntry(int turn, @NlsSafe @NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            this.turn = turn;
            this.name = name2;
        }

        public final int getTurn() {
            return this.turn;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final int getNumberOfFinishes() {
            return this.numberOfFinishes;
        }

        public final void setNumberOfFinishes(int n) {
            this.numberOfFinishes = n;
        }

        public final int getNumberOfFails() {
            return this.numberOfFails;
        }

        public final void setNumberOfFails(int n) {
            this.numberOfFails = n;
        }

        public final int getFetchedPacks() {
            return this.fetchedPacks;
        }

        public final void setFetchedPacks(int n) {
            this.fetchedPacks = n;
        }

        public final int getFetchedRows() {
            return this.fetchedRows;
        }

        public final void setFetchedRows(int n) {
            this.fetchedRows = n;
        }

        public final long getDurationMin() {
            return this.durationMin;
        }

        public final void setDurationMin(long l) {
            this.durationMin = l;
        }

        public final long getDurationMax() {
            return this.durationMax;
        }

        public final void setDurationMax(long l) {
            this.durationMax = l;
        }

        public final long getDurationSum() {
            return this.durationSum;
        }

        public final void setDurationSum(long l) {
            this.durationSum = l;
        }

        public final long getDurationAvg() {
            return this.durationSum / (long)this.numberOfFinishes;
        }

        public final void registerStart() {
            int n = this.numberOfStarts;
            this.numberOfStarts = n + 1;
        }

        public final void registerFinish(long duration, int packs, int rows, boolean failed) {
            long d2;
            long l = d2 = duration >= 0L ? duration : 1L;
            if (this.durationMin == 0L) {
                this.durationMin = d2;
                this.durationMax = d2;
                this.durationSum = d2;
            } else {
                this.durationMin = Math.min(this.durationMin, d2);
                this.durationMax = Math.max(this.durationMax, d2);
                this.durationSum += d2;
            }
            this.fetchedPacks += packs;
            this.fetchedRows += rows;
            int n = this.numberOfFinishes;
            this.numberOfFinishes = n + 1;
            if (failed) {
                n = this.numberOfFails;
                this.numberOfFails = n + 1;
            }
        }

        public static /* synthetic */ void registerFinish$default(StatEntry statEntry, long l, int n, int n3, boolean bl, int n4, Object object) {
            if ((n4 & 8) != 0) {
                bl = false;
            }
            statEntry.registerFinish(l, n, n3, bl);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/database/introspection/query/QueryStats$StatEntry$DurationComparator;", "Ljava/util/Comparator;", "Lcom/intellij/database/introspection/query/QueryStats$StatEntry;", "Lkotlin/Comparator;", "()V", "compare", "", "o1", "o2", "intellij.database.core.impl"})
        public static final class DurationComparator
        implements Comparator<StatEntry> {
            @NotNull
            public static final DurationComparator INSTANCE = new DurationComparator();

            private DurationComparator() {
            }

            @Override
            public int compare(@NotNull StatEntry o1, @NotNull StatEntry o2) {
                Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
                if (o1.getDurationSum() < o2.getDurationSum()) {
                    return 1;
                }
                if (o1.getDurationSum() > o2.getDurationSum()) {
                    return -1;
                }
                if (o1.getDurationMax() < o2.getDurationMax()) {
                    return 1;
                }
                if (o1.getDurationMax() > o2.getDurationMax()) {
                    return -1;
                }
                if (o1.getTurn() < o2.getTurn()) {
                    return -1;
                }
                if (o1.getTurn() > o2.getTurn()) {
                    return 1;
                }
                return 0;
            }
        }
    }
}

