/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.DefiniteIntrospectionTask;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.IntrospectionTaskHelper;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicSingleDatabaseRoot;
import com.intellij.database.util.ObjectPath;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/introspection/SingleDatabaseIntrospectionTaskHelper;", "Lcom/intellij/database/introspection/IntrospectionTaskHelper;", "root", "Lcom/intellij/database/model/basic/BasicSingleDatabaseRoot;", "(Lcom/intellij/database/model/basic/BasicSingleDatabaseRoot;)V", "getRoot", "()Lcom/intellij/database/model/basic/BasicSingleDatabaseRoot;", "databaseIsKnown", "", "task", "Lcom/intellij/database/introspection/DefiniteIntrospectionTask;", "databaseOf", "Lcom/intellij/database/model/basic/BasicDatabase;", "Lcom/intellij/database/introspection/IntrospectionTask;", "distributeObjectPathsBetweenDatabases", "", "Lcom/intellij/database/model/basic/BasicNamespaceOwner;", "", "Lcom/intellij/database/util/ObjectPath;", "paths", "", "specifiedDatabaseOf", "intellij.database.core.impl"})
public final class SingleDatabaseIntrospectionTaskHelper
extends IntrospectionTaskHelper {
    @NotNull
    private final BasicSingleDatabaseRoot root;

    public SingleDatabaseIntrospectionTaskHelper(@NotNull BasicSingleDatabaseRoot root2) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        super(null);
        this.root = root2;
    }

    @Override
    @NotNull
    public BasicSingleDatabaseRoot getRoot() {
        return this.root;
    }

    @Override
    @Nullable
    public BasicDatabase specifiedDatabaseOf(@NotNull IntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return this.getRoot();
    }

    @Override
    @Nullable
    public BasicDatabase databaseOf(@NotNull IntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return this.getRoot();
    }

    @Override
    public boolean databaseIsKnown(@NotNull DefiniteIntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String dbName = task.getDatabaseName();
        return Intrinsics.areEqual((Object)dbName, (Object)"@") || Intrinsics.areEqual((Object)this.getRoot().getName(), (Object)dbName);
    }

    @Override
    @NotNull
    public Map<BasicNamespaceOwner, Set<ObjectPath>> distributeObjectPathsBetweenDatabases(@NotNull Collection<? extends ObjectPath> paths2) {
        Intrinsics.checkNotNullParameter(paths2, (String)"paths");
        Set set = paths2 instanceof Set ? (Set)paths2 : null;
        if (set == null) {
            Iterable iterable = paths2;
            Comparator<ObjectPath> comparator2 = ObjectPath.PATH_COMPARATOR;
            Intrinsics.checkNotNullExpressionValue(comparator2, (String)"PATH_COMPARATOR");
            set = CollectionsKt.toSortedSet((Iterable)iterable, comparator2);
        }
        Set allPaths = set;
        Map<BasicNamespaceOwner, Set<ObjectPath>> map2 = Collections.singletonMap(this.getRoot(), allPaths);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"singletonMap(...)");
        return map2;
    }
}

