/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.DefiniteIntrospectionTask;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.IntrospectionTaskHelper;
import com.intellij.database.introspection.MultiDatabaseIntrospectionTaskHelper;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicMateDatabase;
import com.intellij.database.model.basic.BasicMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.util.ObjectNamePart;
import com.intellij.database.util.ObjectPart;
import com.intellij.database.util.ObjectPath;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/introspection/MultiDatabaseIntrospectionTaskHelper;", "Lcom/intellij/database/introspection/IntrospectionTaskHelper;", "root", "Lcom/intellij/database/model/basic/BasicMultiDatabaseRoot;", "(Lcom/intellij/database/model/basic/BasicMultiDatabaseRoot;)V", "getRoot", "()Lcom/intellij/database/model/basic/BasicMultiDatabaseRoot;", "databaseIsKnown", "", "task", "Lcom/intellij/database/introspection/DefiniteIntrospectionTask;", "databaseOf", "Lcom/intellij/database/model/basic/BasicDatabase;", "Lcom/intellij/database/introspection/IntrospectionTask;", "distributeObjectPathsBetweenDatabases", "", "Lcom/intellij/database/model/basic/BasicNamespaceOwner;", "", "Lcom/intellij/database/util/ObjectPath;", "paths", "", "specifiedDatabaseOf", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nIntrospectionTaskHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntrospectionTaskHelper.kt\ncom/intellij/database/introspection/MultiDatabaseIntrospectionTaskHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 AnyFun.kt\ncom/intellij/database/util/common/AnyFunKt\n*L\n1#1,145:1\n1#2:146\n60#3:147\n*S KotlinDebug\n*F\n+ 1 IntrospectionTaskHelper.kt\ncom/intellij/database/introspection/MultiDatabaseIntrospectionTaskHelper\n*L\n100#1:147\n*E\n"})
public final class MultiDatabaseIntrospectionTaskHelper
extends IntrospectionTaskHelper {
    @NotNull
    private final BasicMultiDatabaseRoot root;

    public MultiDatabaseIntrospectionTaskHelper(@NotNull BasicMultiDatabaseRoot root2) {
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        super(null);
        this.root = root2;
    }

    @Override
    @NotNull
    public BasicMultiDatabaseRoot getRoot() {
        return this.root;
    }

    @Override
    @Nullable
    public BasicDatabase specifiedDatabaseOf(@NotNull IntrospectionTask task) {
        BasicMateDatabase basicMateDatabase;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String string = task.getDatabaseName();
        if (string != null) {
            String it2 = string;
            boolean bl = false;
            basicMateDatabase = this.getRoot().findDatabaseByName(it2);
        } else {
            basicMateDatabase = null;
        }
        return basicMateDatabase;
    }

    @Override
    @Nullable
    public BasicDatabase databaseOf(@NotNull IntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String string = task.getDatabaseName();
        return string == null ? (BasicDatabase)this.getRoot().getCurrentDatabase() : ((Intrinsics.areEqual((Object)string, (Object)"") ? true : Intrinsics.areEqual((Object)string, (Object)"@")) ? (BasicDatabase)this.getRoot().getCurrentDatabase() : this.specifiedDatabaseOf(task));
    }

    @Override
    public boolean databaseIsKnown(@NotNull DefiniteIntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String dbName = task.getDatabaseName();
        if (Intrinsics.areEqual((Object)dbName, (Object)"@")) {
            return this.getRoot().getCurrentDatabase() != null;
        }
        return this.getRoot().findDatabaseByName(dbName) != null;
    }

    @Override
    @NotNull
    public Map<BasicNamespaceOwner, Set<ObjectPath>> distributeObjectPathsBetweenDatabases(@NotNull Collection<? extends ObjectPath> paths2) {
        Intrinsics.checkNotNullParameter(paths2, (String)"paths");
        Map distribution = new HashMap();
        HashMap<Object, Optional> dbs2 = new HashMap<Object, Optional>();
        for (ObjectPath objectPath : paths2) {
            Set basket2;
            ObjectPart dp = objectPath.findParent(ObjectKind.DATABASE, false);
            if (dp != null) {
                Set basket3;
                Optional db2;
                Optional optional;
                if (Intrinsics.areEqual((Object)dp.name, (Object)"@")) {
                    BasicMateDatabase $this$asOptional$iv = this.getRoot().getCurrentDatabase();
                    boolean $i$f$getAsOptional = false;
                    Optional optional2 = Optional.ofNullable($this$asOptional$iv);
                    optional = optional2;
                    Intrinsics.checkNotNullExpressionValue(optional2, (String)"ofNullable(...)");
                } else {
                    Optional optional3 = dbs2.computeIfAbsent(dp, arg_0 -> MultiDatabaseIntrospectionTaskHelper.distributeObjectPathsBetweenDatabases$lambda$1((Function1)new Function1<ObjectNamePart, Optional<BasicDatabase>>(this){
                        final /* synthetic */ MultiDatabaseIntrospectionTaskHelper this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        @NotNull
                        public final Optional<BasicDatabase> invoke(@NotNull ObjectNamePart dp) {
                            Intrinsics.checkNotNullParameter((Object)dp, (String)"dp");
                            NamingFamily<? extends BasicMateDatabase> namingFamily = this.this$0.getRoot().getDatabases();
                            Intrinsics.checkNotNullExpressionValue(namingFamily, (String)"getDatabases(...)");
                            E $this$asOptional$iv = ModelFun.findByScriptName((Family)namingFamily, dp);
                            boolean $i$f$getAsOptional = false;
                            Optional<BasicDatabase> optional = Optional.ofNullable($this$asOptional$iv);
                            Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
                            return optional;
                        }
                    }, arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)optional3, (String)"computeIfAbsent(...)");
                    optional = optional3;
                }
                if ((db2 = optional).isEmpty()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)distribution.computeIfAbsent(db2.get(), arg_0 -> MultiDatabaseIntrospectionTaskHelper.distributeObjectPathsBetweenDatabases$lambda$2(distributeObjectPathsBetweenDatabases.basket.1.INSTANCE, arg_0)), (String)"computeIfAbsent(...)");
                basket3.add(objectPath);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)distribution.computeIfAbsent(this.getRoot(), arg_0 -> MultiDatabaseIntrospectionTaskHelper.distributeObjectPathsBetweenDatabases$lambda$3(distributeObjectPathsBetweenDatabases.basket.2.INSTANCE, arg_0)), (String)"computeIfAbsent(...)");
            basket2.add(objectPath);
        }
        return distribution;
    }

    private static final Optional distributeObjectPathsBetweenDatabases$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)$tmp0.invoke(p0);
    }

    private static final Set distributeObjectPathsBetweenDatabases$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set distributeObjectPathsBetweenDatabases$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }
}

