/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.Impactees;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.sql.psi.SqlDbElementType;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0002!\"B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J&\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cJ6\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cJH\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00062\b\u0010\u001d\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/database/introspection/ImpacteesBuilder;", "", "currentDatabase", "Lcom/intellij/database/util/ObjectPath;", "currentSchema", "checkInput", "", "(Lcom/intellij/database/util/ObjectPath;Lcom/intellij/database/util/ObjectPath;Z)V", "alteredObjects", "", "getCheckInput", "()Z", "getCurrentDatabase", "()Lcom/intellij/database/util/ObjectPath;", "getCurrentSchema", "droppedObjects", "build", "Lcom/intellij/database/introspection/Impactees;", "check", "", "o", "include", "actionType", "Lcom/intellij/database/introspection/ImpacteesBuilder$ActionType;", "objectName", "", "objectNameIsQuoted", "objectKind", "Lcom/intellij/database/model/ObjectKind;", "schemaName", "schemaNameIsQuoted", "databaseName", "databaseNameIsQuoted", "ActionType", "Companion", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nImpacteesBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImpacteesBuilder.kt\ncom/intellij/database/introspection/ImpacteesBuilder\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,97:1\n13#2:98\n*S KotlinDebug\n*F\n+ 1 ImpacteesBuilder.kt\ncom/intellij/database/introspection/ImpacteesBuilder\n*L\n93#1:98\n*E\n"})
public final class ImpacteesBuilder {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private final ObjectPath currentDatabase;
    @NotNull
    private final ObjectPath currentSchema;
    private final boolean checkInput;
    @NotNull
    private final Set<ObjectPath> alteredObjects;
    @NotNull
    private final Set<ObjectPath> droppedObjects;
    @NotNull
    private static final Logger log;

    public ImpacteesBuilder(@Nullable ObjectPath currentDatabase, @NotNull ObjectPath currentSchema, boolean checkInput) {
        Intrinsics.checkNotNullParameter((Object)currentSchema, (String)"currentSchema");
        this.currentDatabase = currentDatabase;
        this.currentSchema = currentSchema;
        this.checkInput = checkInput;
        this.alteredObjects = new TreeSet<ObjectPath>(ObjectPath.PATH_COMPARATOR);
        this.droppedObjects = new TreeSet<ObjectPath>(ObjectPath.PATH_COMPARATOR);
    }

    @Nullable
    public final ObjectPath getCurrentDatabase() {
        return this.currentDatabase;
    }

    @NotNull
    public final ObjectPath getCurrentSchema() {
        return this.currentSchema;
    }

    public final boolean getCheckInput() {
        return this.checkInput;
    }

    public final void include(@NotNull ActionType actionType, @NotNull String objectName, boolean objectNameIsQuoted, @NotNull ObjectKind objectKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
        Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
        Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
        ObjectPath objectPath = this.currentSchema.append(objectName, objectKind, objectNameIsQuoted, null);
        Intrinsics.checkNotNullExpressionValue((Object)objectPath, (String)"append(...)");
        ObjectPath o2 = objectPath;
        this.check(o2);
        switch (WhenMappings.$EnumSwitchMapping$0[actionType.ordinal()]) {
            case 1: {
                this.alteredObjects.add(o2);
                break;
            }
            case 2: {
                this.droppedObjects.add(o2);
            }
        }
    }

    public final void include(@NotNull ActionType actionType, @NotNull String schemaName, boolean schemaNameIsQuoted, @NotNull String objectName, boolean objectNameIsQuoted, @NotNull ObjectKind objectKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
        Intrinsics.checkNotNullParameter((Object)schemaName, (String)"schemaName");
        Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
        Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
        ObjectPath schema2 = ObjectPath.create(schemaName, ObjectKind.SCHEMA, schemaNameIsQuoted, null, this.currentDatabase);
        ObjectPath objectPath = schema2.append(objectName, objectKind, objectNameIsQuoted, null);
        Intrinsics.checkNotNullExpressionValue((Object)objectPath, (String)"append(...)");
        ObjectPath o2 = objectPath;
        this.check(o2);
        switch (WhenMappings.$EnumSwitchMapping$0[actionType.ordinal()]) {
            case 1: {
                this.alteredObjects.add(o2);
                break;
            }
            case 2: {
                this.droppedObjects.add(o2);
            }
        }
    }

    public final void include(@NotNull ActionType actionType, @NotNull String databaseName, boolean databaseNameIsQuoted, @Nullable String schemaName, boolean schemaNameIsQuoted, @NotNull String objectName, boolean objectNameIsQuoted, @NotNull ObjectKind objectKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
        Intrinsics.checkNotNullParameter((Object)objectKind, (String)"objectKind");
        ObjectPath database = ObjectPath.create(databaseName, ObjectKind.DATABASE, databaseNameIsQuoted, null, null);
        String string = schemaName;
        ObjectPath schema2 = string != null ? database.append(string, ObjectKind.SCHEMA, schemaNameIsQuoted, null) : database.append("@", ObjectKind.SCHEMA, false, null);
        ObjectPath objectPath = schema2.append(objectName, objectKind, objectNameIsQuoted, null);
        Intrinsics.checkNotNullExpressionValue((Object)objectPath, (String)"append(...)");
        ObjectPath o2 = objectPath;
        this.check(o2);
        switch (WhenMappings.$EnumSwitchMapping$0[actionType.ordinal()]) {
            case 1: {
                this.alteredObjects.add(o2);
                break;
            }
            case 2: {
                this.droppedObjects.add(o2);
            }
        }
    }

    private final void check(ObjectPath o2) {
        if (this.checkInput) {
            ObjectKind kind;
            int depth = o2.getSize();
            ObjectPath step1 = o2.getParentAtDepth(1);
            ObjectPath step2 = o2.getParentAtDepth(2);
            if (depth == 0 || step1 == null) {
                ImpacteesBuilder.Companion.warn(o2, "it is empty");
            }
            if (this.currentDatabase != null) {
                ObjectPath objectPath = step1;
                if (!Intrinsics.areEqual((Object)(objectPath != null ? objectPath.kind : null), (Object)ObjectKind.DATABASE)) {
                    ImpacteesBuilder.Companion.warn(o2, "it doesn't start with kind DATABASE");
                }
                ObjectPath objectPath2 = step2;
                if (!Intrinsics.areEqual((Object)(objectPath2 != null ? objectPath2.kind : null), (Object)ObjectKind.SCHEMA)) {
                    ImpacteesBuilder.Companion.warn(o2, "the second part kind is not SCHEMA");
                }
                if (depth > 3) {
                    ImpacteesBuilder.Companion.warn(o2, "it is too long! (longer than 3)");
                }
            } else {
                ObjectPath objectPath = step1;
                if (!Intrinsics.areEqual((Object)(objectPath != null ? objectPath.kind : null), (Object)ObjectKind.SCHEMA)) {
                    ImpacteesBuilder.Companion.warn(o2, "it doesn't start with kind SCHEMA");
                }
                if (depth > 2) {
                    ImpacteesBuilder.Companion.warn(o2, "it is too long! (longer than 2)");
                }
            }
            if (Intrinsics.areEqual((Object)(kind = o2.kind), (Object)ObjectKind.NONE) || Intrinsics.areEqual((Object)kind, (Object)SqlDbElementType.ANY) || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.UNKNOWN_OBJECT)) {
                ImpacteesBuilder.Companion.warn(o2, "The kind of the object is not specified!");
            } else if (kind.getOrder() > ObjectKind.UNKNOWN_OBJECT.getOrder()) {
                ImpacteesBuilder.Companion.warn(o2, "The kind of the object is not model-applicable: " + kind);
            }
        }
    }

    @NotNull
    public final Impactees build() {
        return new Impactees(this.alteredObjects, this.droppedObjects);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(ImpacteesBuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/introspection/ImpacteesBuilder$ActionType;", "", "(Ljava/lang/String;I)V", "ALTER", "DROP", "intellij.database.core.impl"})
    public static final class ActionType
    extends Enum<ActionType> {
        public static final /* enum */ ActionType ALTER = new ActionType();
        public static final /* enum */ ActionType DROP = new ActionType();
        private static final /* synthetic */ ActionType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ActionType[] values() {
            return (ActionType[])$VALUES.clone();
        }

        public static ActionType valueOf(String value2) {
            return Enum.valueOf(ActionType.class, value2);
        }

        @NotNull
        public static EnumEntries<ActionType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = actionTypeArray = new ActionType[]{ActionType.ALTER, ActionType.DROP};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/database/introspection/ImpacteesBuilder$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "warn", "", "o", "Lcom/intellij/database/util/ObjectPath;", "message", "", "intellij.database.core.impl"})
    private static final class Companion {
        private Companion() {
        }

        private final void warn(ObjectPath o2, String message2) {
            String warnMessage = "Passing wrong object path as an impactee: " + o2 + "\n\tProblem: " + message2;
            this.getLog().warn(warnMessage, (Throwable)new Exception(warnMessage));
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ActionType.values().length];
            try {
                nArray[ActionType.ALTER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionType.DROP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

