/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.DatabaseObjectsIntrospectionTask;
import com.intellij.database.introspection.DefiniteIntrospectionTask;
import com.intellij.database.util.ObjectPath;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/introspection/DatabaseObjectsIntrospectionTask;", "Lcom/intellij/database/introspection/DefiniteIntrospectionTask;", "databaseName", "", "objectPaths", "", "Lcom/intellij/database/util/ObjectPath;", "all", "", "(Ljava/lang/String;Ljava/util/Set;Z)V", "getAll", "()Z", "getObjectPaths", "()Ljava/util/Set;", "taskTypeOrder", "", "getTaskTypeOrder", "()B", "toString", "intellij.database.core.impl"})
public final class DatabaseObjectsIntrospectionTask
extends DefiniteIntrospectionTask {
    @Nullable
    private final Set<ObjectPath> objectPaths;
    private final boolean all;

    public DatabaseObjectsIntrospectionTask(@NotNull String databaseName, @Nullable Set<? extends ObjectPath> objectPaths, boolean all2) {
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        super(databaseName, null);
        this.objectPaths = objectPaths;
        this.all = all2;
    }

    @Nullable
    public final Set<ObjectPath> getObjectPaths() {
        return this.objectPaths;
    }

    public final boolean getAll() {
        return this.all;
    }

    @Override
    public byte getTaskTypeOrder() {
        return 10;
    }

    @NotNull
    public String toString() {
        Object object;
        if (this.all) {
            object = "Introspect all auxiliary database objects in database " + this.getDatabaseName();
        } else {
            StringBuilder stringBuilder;
            StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            Set<ObjectPath> set = this.objectPaths;
            $this$toString_u24lambda_u240.append("Introspect " + (set != null ? set.size() : 0) + " auxiliary database objects in database " + this.getDatabaseName() + ":");
            Set<ObjectPath> set2 = this.objectPaths;
            if (set2 != null) {
                StringBuilder cfr_ignored_0 = (StringBuilder)CollectionsKt.joinTo$default((Iterable)set2, (Appendable)$this$toString_u24lambda_u240, null, null, null, (int)0, null, (Function1)toString.1.1.INSTANCE, (int)62, null);
            }
            String string = stringBuilder.toString();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        }
        return object;
    }
}

