/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.fulltextsearch;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.actions.FullTextSearchAction;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.DasColumnRef;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.fulltextsearch.FullTextSearchOptions;
import com.intellij.database.fulltextsearch.SearchableTargetsSearchResult;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableImpl;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001aH\u0010\u0000\u001a$\u0012 \u0012\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0002j\u0002`\u00070\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001aH\u0010\u000e\u001a$\u0012 \u0012\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0002j\u0002`\u00070\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001aF\u0010\u000f\u001a$\u0012 \u0012\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0002j\u0002`\u00070\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a$\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r\u001a$\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\t2\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r*:\u0010\u001a\"\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00022\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0002\u00a8\u0006\u001b"}, d2={"byColumn", "Lkotlin/sequences/Sequence;", "Lkotlin/Triple;", "", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "Lcom/intellij/database/model/basic/BasicTableOrView;", "Lcom/intellij/database/psi/DbElement;", "Lcom/intellij/database/fulltextsearch/FtsElement;", "tables", "", "dataSource", "Lcom/intellij/database/psi/DbDataSource;", "options", "Lcom/intellij/database/fulltextsearch/FullTextSearchOptions;", "byTable", "chooseElementsIterator", "getQueryForFirstNElements", "", "elements", "Lcom/intellij/database/psi/DbTable;", "maxElementsCount", "", "tryFindSearchableTargets", "Lcom/intellij/database/fulltextsearch/SearchableTargetsSearchResult;", "targets", "perTargetCheckAtMost", "FtsElement", "intellij.database.impl"})
public final class FtsUtilKt {
    @NotNull
    public static final String getQueryForFirstNElements(@NotNull List<? extends DbTable> elements2, int maxElementsCount, @NotNull FullTextSearchOptions options2) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        DbDataSource dbDataSource = ((DbTable)CollectionsKt.first(elements2)).getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"getDataSource(...)");
        DbDataSource dataSource2 = dbDataSource;
        DatabaseDialectEx databaseDialectEx = DbImplUtil.getDatabaseDialect(dataSource2.getDbms());
        Intrinsics.checkNotNullExpressionValue((Object)databaseDialectEx, (String)"getDatabaseDialect(...)");
        DatabaseDialectEx dialect = databaseDialectEx;
        DdlBuilder ddlBuilder = new DdlBuilder().withDialect(dialect).qualifyReferences(true);
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"qualifyReferences(...)");
        DdlBuilder builder = ddlBuilder;
        int count = 0;
        List<FullTextSearchAction.SearchGroup> groups2 = new FullTextSearchAction.TableGrouper((Collection<? extends DbTable>)elements2).getGroups();
        Iterator<FullTextSearchAction.SearchGroup> iterator = groups2.iterator();
        while (iterator.hasNext()) {
            Set<BasicTableOrView> tables2 = iterator.next().component1();
            for (Triple triple : FtsUtilKt.chooseElementsIterator((Collection<? extends BasicTableOrView>)tables2, dataSource2, options2)) {
                List predicates = (List)triple.component1();
                BasicTableOrView table = (BasicTableOrView)triple.component2();
                if (predicates.isEmpty()) continue;
                FullTextSearchAction.Companion.searchStatement(builder, table, dataSource2, options2, predicates, true);
                builder.newStatement().newLine();
                if (++count < maxElementsCount) continue;
                Object[] objectArray = new Object[]{maxElementsCount};
                String comment = "-- " + DatabaseBundle.message("full.text.search.first.N.queries", objectArray);
                return comment + "\n\n" + builder.getStatement() + "\n" + comment;
            }
        }
        String string = builder.getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatement(...)");
        return string;
    }

    @NotNull
    public static final SearchableTargetsSearchResult tryFindSearchableTargets(@NotNull Collection<? extends DbTable> targets2, int perTargetCheckAtMost, @NotNull FullTextSearchOptions options2) {
        Intrinsics.checkNotNullParameter(targets2, (String)"targets");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        boolean someTablesAreSkipped = false;
        block0: for (DbTable dbTable : targets2) {
            int count = 0;
            List<FullTextSearchAction.SearchGroup> groups2 = new FullTextSearchAction.TableGrouper(CollectionsKt.listOf((Object)dbTable)).getGroups();
            Iterator<FullTextSearchAction.SearchGroup> iterator = groups2.iterator();
            while (iterator.hasNext()) {
                Set<BasicTableOrView> tables2 = iterator.next().component1();
                Collection collection2 = tables2;
                DbDataSource dbDataSource = dbTable.getDataSource();
                Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"getDataSource(...)");
                Sequence<Triple<List<PredicatesHelper.PredicateProducer>, BasicTableOrView, DbElement>> it2 = FtsUtilKt.chooseElementsIterator(collection2, dbDataSource, options2);
                Iterator iterator2 = it2.iterator();
                while (iterator2.hasNext()) {
                    List predicates = (List)((Triple)iterator2.next()).component1();
                    if (!((Collection)predicates).isEmpty()) {
                        return SearchableTargetsSearchResult.FOUND;
                    }
                    if (++count < perTargetCheckAtMost) continue;
                    someTablesAreSkipped = true;
                    continue block0;
                }
            }
        }
        return someTablesAreSkipped ? SearchableTargetsSearchResult.UNKNOWN : SearchableTargetsSearchResult.NOT_FOUND;
    }

    @NotNull
    public static final Sequence<Triple<List<PredicatesHelper.PredicateProducer>, BasicTableOrView, DbElement>> chooseElementsIterator(@NotNull Collection<? extends BasicTableOrView> tables2, @NotNull DbDataSource dataSource2, @NotNull FullTextSearchOptions options2) {
        Intrinsics.checkNotNullParameter(tables2, (String)"tables");
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        return Intrinsics.areEqual((Object)dataSource2.getDbms(), (Object)Dbms.CASSANDRA) ? FtsUtilKt.byColumn(tables2, dataSource2, options2) : FtsUtilKt.byTable(tables2, dataSource2, options2);
    }

    private static final Sequence<Triple<List<PredicatesHelper.PredicateProducer>, BasicTableOrView, DbElement>> byTable(Collection<? extends BasicTableOrView> tables2, DbDataSource dataSource2, FullTextSearchOptions options2) {
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)tables2), (Function1)((Function1)new Function1<BasicTableOrView, Triple<? extends List<PredicatesHelper.PredicateProducer>, ? extends BasicTableOrView, ? extends DbTableImpl>>(dataSource2, options2){
            final /* synthetic */ DbDataSource $dataSource;
            final /* synthetic */ FullTextSearchOptions $options;
            {
                this.$dataSource = $dataSource;
                this.$options = $options;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Triple<List<PredicatesHelper.PredicateProducer>, BasicTableOrView, DbTableImpl> invoke(@NotNull BasicTableOrView table) {
                void destination$iv;
                void $this$flatMapTo$iv;
                Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                Dbms dbms = this.$dataSource.getDbms();
                Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
                Map<ColumnRef, List<PredicatesHelper.PredicateProducer>> predicates = FullTextSearchAction.Companion.getPredicates$intellij_database_impl(dbms, this.$dataSource.getVersion(), table, this.$options);
                Object object = DbImplUtilCore.findElement(this.$dataSource, table);
                DbTableImpl dbTableImpl = object instanceof DbTableImpl ? (DbTableImpl)object : null;
                if (dbTableImpl == null) {
                    return null;
                }
                DbTableImpl dbElement = dbTableImpl;
                object = predicates;
                Collection collection2 = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                Iterator<Map.Entry<K, V>> iterator = $this$flatMapTo$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> it2 = element$iv = iterator.next();
                    boolean bl = false;
                    Iterable list$iv = (List)it2.getValue();
                    CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                }
                List uniquePredicates = (List)destination$iv;
                ContainerUtil.removeDuplicates((Collection)uniquePredicates);
                return new Triple((Object)uniquePredicates, (Object)table, (Object)dbElement);
            }
        }));
    }

    private static final Sequence<Triple<List<PredicatesHelper.PredicateProducer>, BasicTableOrView, DbElement>> byColumn(Collection<? extends BasicTableOrView> tables2, DbDataSource dataSource2, FullTextSearchOptions options2) {
        return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)tables2), (Function1)((Function1)new Function1<BasicTableOrView, Sequence<? extends Triple<? extends List<? extends PredicatesHelper.PredicateProducer>, ? extends BasicTableOrView, ? extends DbColumn>>>(dataSource2, options2){
            final /* synthetic */ DbDataSource $dataSource;
            final /* synthetic */ FullTextSearchOptions $options;
            {
                this.$dataSource = $dataSource;
                this.$options = $options;
                super(1);
            }

            @NotNull
            public final Sequence<Triple<List<PredicatesHelper.PredicateProducer>, BasicTableOrView, DbColumn>> invoke(@NotNull BasicTableOrView table) {
                Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                Dbms dbms = this.$dataSource.getDbms();
                Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
                return SequencesKt.mapNotNull((Sequence)MapsKt.asSequence(FullTextSearchAction.Companion.getPredicates$intellij_database_impl(dbms, this.$dataSource.getVersion(), table, this.$options)), (Function1)((Function1)new Function1<Map.Entry<? extends ColumnRef, ? extends List<? extends PredicatesHelper.PredicateProducer>>, Triple<? extends List<? extends PredicatesHelper.PredicateProducer>, ? extends BasicTableOrView, ? extends DbColumn>>(this.$dataSource, table){
                    final /* synthetic */ DbDataSource $dataSource;
                    final /* synthetic */ BasicTableOrView $table;
                    {
                        this.$dataSource = $dataSource;
                        this.$table = $table;
                        super(1);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Triple<List<PredicatesHelper.PredicateProducer>, BasicTableOrView, DbColumn> invoke(@NotNull Map.Entry<? extends ColumnRef, ? extends List<PredicatesHelper.PredicateProducer>> entry) {
                        Intrinsics.checkNotNullParameter(entry, (String)"<name for destructuring parameter 0>");
                        ColumnRef column2 = entry.getKey();
                        List<PredicatesHelper.PredicateProducer> predicates = entry.getValue();
                        if (!(column2 instanceof DasColumnRef)) return null;
                        DasColumnRef dasColumnRef = (DasColumnRef)column2;
                        DasColumnRef dasColumnRef2 = dasColumnRef;
                        if (dasColumnRef2 == null) return null;
                        Object object = dasColumnRef2;
                        DbDataSource dbDataSource = this.$dataSource;
                        Object it2 = object;
                        boolean bl = false;
                        DbElement dbElement = DbImplUtilCore.findElement(dbDataSource, ((DasColumnRef)column2).getCol());
                        if (!(dbElement instanceof DbColumn)) return null;
                        DbColumn dbColumn = (DbColumn)dbElement;
                        DbColumn dbColumn2 = dbColumn;
                        if (dbColumn2 == null) return null;
                        object = dbColumn2;
                        BasicTableOrView basicTableOrView = this.$table;
                        it2 = object;
                        boolean bl2 = false;
                        Triple triple = new Triple(predicates, (Object)basicTableOrView, it2);
                        return triple;
                    }
                }));
            }
        }));
    }
}

