/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.diff.DiffSupport;
import com.intellij.database.diff.TableDiffEditor;
import com.intellij.database.diff.TableDiffSupport;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.util.Side;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.function.IntUnaryOperator;
import org.jetbrains.annotations.NotNull;

public class TableSyncScrollSupport {
    @NotNull
    private static MyScrollHelper create(@NotNull TableDiffEditor master, @NotNull TableDiffEditor slave, @NotNull SyncScrollSupport.SyncScrollable scrollable, @NotNull Side side) {
        if (master == null) {
            TableSyncScrollSupport.$$$reportNull$$$0(0);
        }
        if (slave == null) {
            TableSyncScrollSupport.$$$reportNull$$$0(1);
        }
        if (scrollable == null) {
            TableSyncScrollSupport.$$$reportNull$$$0(2);
        }
        if (side == null) {
            TableSyncScrollSupport.$$$reportNull$$$0(3);
        }
        return new MyScrollHelper(new TableDiffSupport(master), new TableDiffSupport(slave), value2 -> scrollable.transfer(side, value2));
    }

    private static void doScrollVertically(@NotNull ScrollingModel model2, int offset) {
        if (model2 == null) {
            TableSyncScrollSupport.$$$reportNull$$$0(4);
        }
        model2.disableAnimation();
        try {
            model2.scrollVertically(offset);
        }
        finally {
            model2.enableAnimation();
        }
    }

    private static void doScrollHorizontally(@NotNull ScrollingModel model2, int offset) {
        if (model2 == null) {
            TableSyncScrollSupport.$$$reportNull$$$0(5);
        }
        model2.disableAnimation();
        try {
            model2.scrollHorizontally(offset);
        }
        finally {
            model2.enableAnimation();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "master";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slave";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/diff/TableSyncScrollSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doScrollVertically";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doScrollHorizontally";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyScrollHelper
    implements VisibleAreaListener {
        @NotNull
        private final DiffSupport myMaster;
        @NotNull
        private final DiffSupport mySlave;
        @NotNull
        private final IntUnaryOperator myConvertor;

        MyScrollHelper(@NotNull DiffSupport master, @NotNull DiffSupport slave, @NotNull IntUnaryOperator convertor) {
            if (master == null) {
                MyScrollHelper.$$$reportNull$$$0(0);
            }
            if (slave == null) {
                MyScrollHelper.$$$reportNull$$$0(1);
            }
            if (convertor == null) {
                MyScrollHelper.$$$reportNull$$$0(2);
            }
            this.myMaster = master;
            this.mySlave = slave;
            this.myConvertor = convertor;
        }

        public void visibleAreaChanged(@NotNull VisibleAreaEvent e2) {
            if (e2 == null) {
                MyScrollHelper.$$$reportNull$$$0(3);
            }
            Rectangle newRectangle = e2.getNewRectangle();
            Rectangle oldRectangle = e2.getOldRectangle();
            if (oldRectangle == null) {
                return;
            }
            this.syncVerticalScroll(newRectangle, oldRectangle);
            this.syncHorizontalScroll(newRectangle, oldRectangle);
        }

        private void syncVerticalScroll(@NotNull Rectangle newRectangle, @NotNull Rectangle oldRectangle) {
            if (newRectangle == null) {
                MyScrollHelper.$$$reportNull$$$0(4);
            }
            if (oldRectangle == null) {
                MyScrollHelper.$$$reportNull$$$0(5);
            }
            if (newRectangle.y == oldRectangle.y) {
                return;
            }
            int masterVerticalScrollOffset = this.myMaster.getScrollingModel().getVerticalScrollOffset();
            Rectangle viewRect = this.myMaster.getScrollingModel().getVisibleArea();
            int middleY = viewRect.height / 3;
            LogicalPosition masterPos = this.myMaster.xyToLogicalPosition(new Point(viewRect.x, masterVerticalScrollOffset + middleY));
            int masterCenterLine = masterPos.line;
            int scrollToLine = this.myConvertor.applyAsInt(masterCenterLine);
            int height = this.myMaster.getLineHeight(masterCenterLine);
            int correction = height == 0 ? 0 : (masterVerticalScrollOffset + middleY) % height;
            Point point = this.mySlave.logicalPositionToXY(new LogicalPosition(scrollToLine, masterPos.column));
            int offset = point.y - middleY + correction;
            int deltaHeaderOffset = this.mySlave.getHeaderOffset() - this.myMaster.getHeaderOffset();
            TableSyncScrollSupport.doScrollVertically(this.mySlave.getScrollingModel(), offset + deltaHeaderOffset);
        }

        private void syncHorizontalScroll(@NotNull Rectangle newRectangle, @NotNull Rectangle oldRectangle) {
            if (newRectangle == null) {
                MyScrollHelper.$$$reportNull$$$0(6);
            }
            if (oldRectangle == null) {
                MyScrollHelper.$$$reportNull$$$0(7);
            }
            if (newRectangle.x == oldRectangle.x) {
                return;
            }
            int offset = newRectangle.x;
            TableSyncScrollSupport.doScrollHorizontally(this.mySlave.getScrollingModel(), offset);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "master";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "slave";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "convertor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newRectangle";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldRectangle";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/diff/TableSyncScrollSupport$MyScrollHelper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visibleAreaChanged";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "syncVerticalScroll";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "syncHorizontalScroll";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TableViewerSyncScrollSupport {
        @NotNull
        private final TableDiffEditor myEditor1;
        @NotNull
        private final TableDiffEditor myEditor2;
        @NotNull
        private final SyncScrollSupport.SyncScrollable myScrollable;
        @NotNull
        private final MyScrollHelper myHelper1;
        @NotNull
        private final MyScrollHelper myHelper2;
        public boolean myDuringSyncScroll;

        public TableViewerSyncScrollSupport(@NotNull TableDiffEditor editor1, @NotNull TableDiffEditor editor2, @NotNull SyncScrollSupport.SyncScrollable scrollable) {
            if (editor1 == null) {
                TableViewerSyncScrollSupport.$$$reportNull$$$0(0);
            }
            if (editor2 == null) {
                TableViewerSyncScrollSupport.$$$reportNull$$$0(1);
            }
            if (scrollable == null) {
                TableViewerSyncScrollSupport.$$$reportNull$$$0(2);
            }
            this.myDuringSyncScroll = false;
            this.myEditor1 = editor1;
            this.myEditor2 = editor2;
            this.myScrollable = scrollable;
            this.myHelper1 = TableSyncScrollSupport.create(this.myEditor1, this.myEditor2, this.myScrollable, Side.LEFT);
            this.myHelper2 = TableSyncScrollSupport.create(this.myEditor2, this.myEditor1, this.myScrollable, Side.RIGHT);
        }

        public void visibleAreaChanged(@NotNull VisibleAreaEvent e2) {
            if (e2 == null) {
                TableViewerSyncScrollSupport.$$$reportNull$$$0(3);
            }
            if (!this.myScrollable.isSyncScrollEnabled() || this.myDuringSyncScroll) {
                return;
            }
            this.myDuringSyncScroll = true;
            try {
                if (e2.getEditor() == this.myEditor1.getScrollingModel().getFakeEditor()) {
                    this.myHelper1.visibleAreaChanged(e2);
                } else if (e2.getEditor() == this.myEditor2.getScrollingModel().getFakeEditor()) {
                    this.myHelper2.visibleAreaChanged(e2);
                }
            }
            finally {
                this.myDuringSyncScroll = false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scrollable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/diff/TableSyncScrollSupport$TableViewerSyncScrollSupport";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visibleAreaChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

