/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridAppearance;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.Index;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.ResultView;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.ViewIndexSet;
import com.intellij.database.diff.GridScrollingModel;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.grid.CellAttributesKey;
import com.intellij.database.run.ui.grid.GridMarkupModel;
import com.intellij.database.run.ui.grid.GridRowHeader;
import com.intellij.database.run.ui.table.TableResultRowHeader;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.database.vfs.fragment.TableDataFragmentFile;
import com.intellij.diff.DiffContext;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.MathUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableDiffEditor
extends TableEditorBase {
    private final DiffTablePanel myDataGrid;
    private final GridScrollingModel myScrollingModel;
    private final LightVirtualFile myFile;

    public TableDiffEditor(@NotNull DiffContext context, @NotNull GridDataHookUp<GridRow, GridColumn> hookUp) {
        if (context == null) {
            TableDiffEditor.$$$reportNull$$$0(0);
        }
        if (hookUp == null) {
            TableDiffEditor.$$$reportNull$$$0(1);
        }
        super(context.getProject());
        this.myDataGrid = new DiffTablePanel((FileEditor)this, context, hookUp, ((BiConsumer<DataGrid, DataGridAppearance>)DataGridUtil::configure).andThen(GridUtil::configureFullSizeTable).andThen(GridUtil::disableLocalFilterByDefault));
        this.myScrollingModel = new GridScrollingModel((DataGrid)this.getDataGrid());
        Disposer.register((Disposable)this, (Disposable)this.myDataGrid);
        this.myFile = new LightVirtualFile(this.getName(), (FileType)TableDataFragmentFile.MyFileType.INSTANCE, (CharSequence)"");
    }

    public void dispose() {
        super.dispose();
        this.myFile.setValid(false);
    }

    public boolean isValid() {
        return this.myFile.isValid();
    }

    @Nullable
    public VirtualFile getFile() {
        return null;
    }

    @NotNull
    public DiffTablePanel getDataGrid() {
        DiffTablePanel diffTablePanel = this.myDataGrid;
        if (diffTablePanel == null) {
            TableDiffEditor.$$$reportNull$$$0(2);
        }
        return diffTablePanel;
    }

    @NotNull
    public GridScrollingModel getScrollingModel() {
        GridScrollingModel gridScrollingModel = this.myScrollingModel;
        if (gridScrollingModel == null) {
            TableDiffEditor.$$$reportNull$$$0(3);
        }
        return gridScrollingModel;
    }

    @NotNull
    public String getName() {
        String string = this.myDataGrid.getDisplayName();
        if (string == null) {
            TableDiffEditor.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static int[] range(int a, int b2) {
        assert (a < b2);
        int[] res2 = new int[b2 - a];
        for (int i2 = 0; i2 < res2.length; ++i2) {
            res2[i2] = i2 + a;
        }
        return res2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUp";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/diff/TableDiffEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/diff/TableDiffEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataGrid";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getScrollingModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    public static class DiffTablePanel
    extends TableResultPanel {
        public static final Function<ModelIndex<?>, Integer> MI_AS_INT = Index::asInteger;
        private final FileEditor myEditor;
        private final Alarm myAlarm;
        private final List<GridMarkupModel.Highlighting> myHighlightings;
        private final Int2ObjectMap<InclusionState> myRowsInclusion;
        private final Int2ObjectMap<InclusionState> myColumnsInclusion;
        private static final AnAction[] ROW_ACTIONS = new AnAction[]{new GenericControlAction(DatabaseBundle.message("TableDiff.action.include.selected.text", new Object[0]), true, null, InclusionState.ACTIVE), new GenericControlAction(DatabaseBundle.message("TableDiff.action.exclude.selected.text", new Object[0]), true, null, InclusionState.INACTIVE), new GenericControlAction(DatabaseBundle.message("TableDiff.action.remove.selected.text", new Object[0]), true, null, InclusionState.REMOVED)};
        private static final AnAction[] COL_ACTIONS = new AnAction[]{new GenericControlAction(DatabaseBundle.message("TableDiff.action.include.selected.text", new Object[0]), null, true, InclusionState.ACTIVE), new GenericControlAction(DatabaseBundle.message("TableDiff.action.exclude.selected.text", new Object[0]), null, true, InclusionState.INACTIVE), new GenericControlAction(DatabaseBundle.message("TableDiff.action.remove.selected.text", new Object[0]), null, true, InclusionState.REMOVED)};
        private static final AnAction[] CROSS_ACTIONS = new AnAction[]{new GenericControlAction(DatabaseBundle.message("TableDiff.action.include.selected.text", new Object[0]), true, true, InclusionState.ACTIVE), new GenericControlAction(DatabaseBundle.message("TableDiff.action.exclude.selected.text", new Object[0]), false, false, InclusionState.INACTIVE), new GenericControlAction(DatabaseBundle.message("TableDiff.action.remove.selected.text", new Object[0]), false, false, InclusionState.REMOVED)};

        DiffTablePanel(@NotNull FileEditor editor2, @NotNull DiffContext context, @NotNull GridDataHookUp<GridRow, GridColumn> hookUp, @NotNull BiConsumer<DataGrid, DataGridAppearance> configurator) {
            if (editor2 == null) {
                DiffTablePanel.$$$reportNull$$$0(0);
            }
            if (context == null) {
                DiffTablePanel.$$$reportNull$$$0(1);
            }
            if (hookUp == null) {
                DiffTablePanel.$$$reportNull$$$0(2);
            }
            if (configurator == null) {
                DiffTablePanel.$$$reportNull$$$0(3);
            }
            super(Objects.requireNonNull(context.getProject()), hookUp, DiffTablePanel.createTableActionGroup(), DiffTablePanel.createGutterActionGroup(), DiffTablePanel.createHeaderActionGroup(), DiffTablePanel.createHeaderActionGroup(), false, configurator);
            this.myHighlightings = ContainerUtil.createConcurrentList();
            this.myRowsInclusion = new Int2ObjectOpenHashMap();
            this.myColumnsInclusion = new Int2ObjectOpenHashMap();
            this.myAlarm = new Alarm((Disposable)this);
            this.myEditor = editor2;
            ResultView resultView = this.getResultView();
            if (!(resultView instanceof TableResultView)) {
                return;
            }
            final TableResultView table = (TableResultView)resultView;
            table.getTableHeader().setDefaultRenderer((TableCellRenderer)new TableResultView.MyCellRenderer(table){

                protected void paintComponent(Graphics g2) {
                    super.paintComponent(g2);
                    this.strikeColumn(g2, this.getNameRect(), this.getModelIdx());
                }
            });
            table.getTableHeader().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e2) {
                    if (myAlarm.cancelAllRequests() != 0) {
                        table.tableChanged(null);
                    }
                }
            });
            table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

                @Override
                public void columnMoved(TableColumnModelEvent e2) {
                    if (e2.getFromIndex() == e2.getToIndex()) {
                        return;
                    }
                    myAlarm.cancelAllRequests();
                    myAlarm.addRequest(() -> table.tableChanged(null), 1000);
                }

                @Override
                public void columnAdded(TableColumnModelEvent e2) {
                }

                @Override
                public void columnRemoved(TableColumnModelEvent e2) {
                }

                @Override
                public void columnMarginChanged(ChangeEvent e2) {
                }

                @Override
                public void columnSelectionChanged(ListSelectionEvent e2) {
                }
            });
        }

        private static Condition<Integer> skip(int[] vals) {
            IntOpenHashSet skip = new IntOpenHashSet(vals);
            return arg_0 -> DiffTablePanel.lambda$skip$0((IntSet)skip, arg_0);
        }

        private JBIterable<Integer> selectedColumns(boolean inverse) {
            if (!inverse) {
                return JBIterable.from((Iterable)this.getSelectionModel().getSelectedColumns().asIterable()).transform(MI_AS_INT);
            }
            return JBIterable.from((Iterable)this.getVisibleColumns().asIterable()).transform(MI_AS_INT).filter(DiffTablePanel.skip(this.getSelectionModel().getSelectedColumns().asArray()));
        }

        private JBIterable<Integer> selectedRows(boolean inverse) {
            if (!inverse) {
                return JBIterable.from((Iterable)this.getSelectionModel().getSelectedRows().asIterable()).transform(MI_AS_INT);
            }
            return JBIterable.from((Iterable)this.getVisibleRows().asIterable()).transform(MI_AS_INT).filter(DiffTablePanel.skip(this.getSelectionModel().getSelectedRows().asArray()));
        }

        private static ActionGroup createTableActionGroup() {
            DefaultActionGroup row = DefaultActionGroup.createPopupGroup(DatabaseBundle.messagePointer("TableDiff.action.rows.text", new Object[0]));
            row.addAll(ROW_ACTIONS);
            DefaultActionGroup column2 = DefaultActionGroup.createPopupGroup(DatabaseBundle.messagePointer("TableDiff.action.columns.text", new Object[0]));
            column2.addAll(COL_ACTIONS);
            DefaultActionGroup cell = DefaultActionGroup.createPopupGroup(DatabaseBundle.messagePointer("TableDiff.action.cells.text", new Object[0]));
            cell.addAll(CROSS_ACTIONS);
            return new DefaultActionGroup(new AnAction[]{DataGridUtil.getGridDatabasePopupActions(), row, column2, cell});
        }

        private static ActionGroup createGutterActionGroup() {
            return new DefaultActionGroup(ROW_ACTIONS);
        }

        private static ActionGroup createHeaderActionGroup() {
            return new DefaultActionGroup(COL_ACTIONS);
        }

        public int getRowHeight(int row) {
            ResultView resultView = this.getResultView();
            return resultView instanceof TableResultView ? ((TableResultView)resultView).getRowHeight(row) : 0;
        }

        public void clearHighlighting() {
            this.getMarkupModel().removeAllHighlightings(this.myHighlightings);
            this.myHighlightings.clear();
        }

        public void highlightRowsOrCols(List<Integer> ids, CellAttributesKey cellAttributes, boolean row) {
            for (int i2 = 0; i2 < ids.size(); ++i2) {
                int idx = ids.get(i2);
                this.highlightRowOrCol(idx, idx + 1, cellAttributes, row);
            }
        }

        public void highlightRowOrCol(int begin, int end, CellAttributesKey cellAttributes, boolean row) {
            if (this.getResultView().isTransposed() == row) {
                this.highlightColumns(begin, end, cellAttributes);
            } else {
                this.highlightRows(begin, end, cellAttributes);
            }
        }

        public void highlightRows(int begin, int end, CellAttributesKey cellAttributes) {
            if (end == begin && end == 0) {
                return;
            }
            int[] range = TableDiffEditor.range(begin - (begin == end ? 1 : 0), end);
            ModelIndexSet rows = ViewIndexSet.forRows((CoreGrid)this, (int[])range).toModel((CoreGrid)this);
            this.myHighlightings.add((GridMarkupModel.Highlighting)this.getMarkupModel().highlightCells(rows, this.getVisibleColumns(), cellAttributes, 1));
            this.myHighlightings.add((GridMarkupModel.Highlighting)this.getMarkupModel().highlightRowHeaders(rows, cellAttributes, 1));
        }

        public void highlightColumns(int begin, int end, CellAttributesKey cellAttributes) {
            if (end == begin && end == 0) {
                return;
            }
            ModelIndexSet rows = this.getVisibleRows();
            int[] range = TableDiffEditor.range(begin - (begin == end ? 1 : 0), end);
            ModelIndexSet cols2 = ViewIndexSet.forColumns((CoreGrid)this, (int[])range).toModel((CoreGrid)this);
            this.myHighlightings.add((GridMarkupModel.Highlighting)this.getMarkupModel().highlightCells(rows, cols2, cellAttributes, 1));
            this.myHighlightings.add((GridMarkupModel.Highlighting)this.getMarkupModel().highlightColumnHeaders(cols2, cellAttributes, 1));
        }

        public void highlightCell(int row, int col, CellAttributesKey key2) {
            ModelIndexSet rows = ViewIndexSet.forRows((CoreGrid)this, (int[])new int[]{this.getResultView().isTransposed() ? col : row}).toModel((CoreGrid)this);
            ModelIndexSet cols2 = ViewIndexSet.forColumns((CoreGrid)this, (int[])new int[]{this.getResultView().isTransposed() ? row : col}).toModel((CoreGrid)this);
            this.myHighlightings.add((GridMarkupModel.Highlighting)this.getMarkupModel().highlightCells(rows, cols2, key2, 1));
        }

        @NotNull
        public JBIterable<ModelIndex<GridRow>> getInactiveRows() {
            JBIterable jBIterable = JBIterable.from((Iterable)this.getVisibleRows().asList()).filter(index2 -> DiffTablePanel.get(this.myRowsInclusion, index2.asInteger()) == InclusionState.INACTIVE);
            if (jBIterable == null) {
                DiffTablePanel.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        @NotNull
        public JBIterable<ModelIndex<GridColumn>> getInactiveCols() {
            JBIterable jBIterable = JBIterable.from((Iterable)this.getVisibleColumns().asList()).filter(index2 -> DiffTablePanel.get(this.myColumnsInclusion, index2.asInteger()) == InclusionState.INACTIVE);
            if (jBIterable == null) {
                DiffTablePanel.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        @NotNull
        public GridRowHeader createRowHeader(@NotNull TableResultView table) {
            if (table == null) {
                DiffTablePanel.$$$reportNull$$$0(6);
            }
            return new TableResultRowHeader((DataGrid)this, table, this.myGutterPopupActions){

                @NotNull
                protected TableResultRowHeader.RowHeaderCellComponentBase createRegularRenderer() {
                    return new TableResultRowHeader.RowNumberRowHeaderCellComponent(){

                        protected void drawEffects(Graphics g2, Rectangle r) {
                            this.strikeRow(g2, r, ViewIndex.forRow((CoreGrid)this, (int)this.getRow()).toModel((CoreGrid)this).asInteger());
                        }
                    };
                }

                @NotNull
                protected TableResultRowHeader.RowHeaderCellComponentBase createTransposedRenderer() {
                    return new TableResultRowHeader.ColumnInfoRowHeaderCellComponent(){

                        protected void drawEffects(Graphics g2, Rectangle r) {
                            this.strikeRow(g2, r, ViewIndex.forColumn((CoreGrid)this, (int)this.getRow()).toModel((CoreGrid)this).asInteger());
                        }
                    };
                }
            };
        }

        protected void strikeRow(Graphics g2, Rectangle r, int row) {
            InclusionState state = DiffTablePanel.get(this.getResultView().isTransposed() ? this.myColumnsInclusion : this.myRowsInclusion, row);
            if (state == InclusionState.INACTIVE) {
                this.strikeText(g2, r);
            }
        }

        protected void strikeColumn(Graphics g2, Rectangle r, int col) {
            InclusionState state = DiffTablePanel.get(!this.getResultView().isTransposed() ? this.myColumnsInclusion : this.myRowsInclusion, col);
            if (state == InclusionState.INACTIVE) {
                this.strikeText(g2, r);
            }
        }

        protected void strikeText(Graphics g2, Rectangle r) {
            int y = r.y + r.height / 2;
            g2.drawLine(r.x, y, r.x + r.width, y);
        }

        public boolean isRowFilteredOut(@NotNull ModelIndex<?> rowIdx) {
            if (rowIdx == null) {
                DiffTablePanel.$$$reportNull$$$0(7);
            }
            return DiffTablePanel.get(this.myRowsInclusion, rowIdx.asInteger()) == InclusionState.REMOVED;
        }

        public boolean isHeaderSelecting() {
            return true;
        }

        public void setState(int modelIdx, boolean row, InclusionState state) {
            DiffTablePanel.set(row ? this.myRowsInclusion : this.myColumnsInclusion, modelIdx, state);
            if (row) {
                if (this.getResultView().isTransposed()) {
                    this.updateRowState(modelIdx, state);
                } else {
                    this.getResultView().searchSessionUpdated();
                }
            } else {
                this.updateColumnState(modelIdx, state);
            }
        }

        public void updateStates() {
            int i2;
            GridModel model2 = this.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
            if (this.getResultView().isTransposed()) {
                for (i2 = 0; i2 < model2.getRowCount(); ++i2) {
                    this.updateRowState(i2, DiffTablePanel.get(this.myRowsInclusion, i2));
                }
            } else {
                this.getResultView().searchSessionUpdated();
            }
            for (i2 = 0; i2 < model2.getColumnCount(); ++i2) {
                this.updateColumnState(i2, DiffTablePanel.get(this.myColumnsInclusion, i2));
            }
        }

        private void updateColumnState(int columnModelIdx, InclusionState state) {
            ModelIndex index2 = ModelIndex.forColumn((CoreGrid)this, (int)columnModelIdx);
            boolean shouldBeEnabled = state != InclusionState.REMOVED;
            boolean enabled = this.isColumnEnabled(index2);
            if (enabled == shouldBeEnabled) {
                return;
            }
            this.setColumnEnabled(index2, shouldBeEnabled);
        }

        private void updateRowState(int rowModelIndex, InclusionState state) {
            ModelIndex modelRow = ModelIndex.forRow((CoreGrid)this, (int)rowModelIndex);
            ViewIndex viewRow = modelRow.toView((CoreGrid)this);
            boolean shouldBeEnabled = state != InclusionState.REMOVED;
            boolean enabled = viewRow.isValid((CoreGrid)this);
            if (enabled == shouldBeEnabled) {
                return;
            }
            this.setRowEnabled(modelRow, shouldBeEnabled);
        }

        public boolean isEditable() {
            return false;
        }

        public boolean isCellEditingAllowed() {
            return false;
        }

        @NotNull
        public Point getCellPosition(int row, int column2) {
            boolean columnLess;
            ResultView resultView = this.getResultView();
            if (!(resultView instanceof TableResultView)) {
                return new Point();
            }
            TableResultView table = (TableResultView)resultView;
            boolean rowLess = row < table.getRowCount();
            boolean bl = columnLess = column2 < table.getColumnCount();
            if (table.getRowCount() == 0 || table.getColumnCount() == 0) {
                return new Point();
            }
            row = MathUtil.clamp((int)row, (int)0, (int)(table.getRowCount() - 1));
            column2 = MathUtil.clamp((int)column2, (int)0, (int)(table.getColumnCount() - 1));
            Rectangle cellRect = table.getCellRect(row, column2, true);
            return new Point((int)(columnLess ? cellRect.getMinX() : cellRect.getMaxX()), (int)(rowLess ? cellRect.getMinY() : cellRect.getMaxY()));
        }

        public int getRowAtPosition(@NotNull Point position) {
            ResultView resultView;
            if (position == null) {
                DiffTablePanel.$$$reportNull$$$0(8);
            }
            return (resultView = this.getResultView()) instanceof TableResultView ? ((TableResultView)resultView).rowAtPoint(position) : 0;
        }

        public int getColumnAtPosition(@NotNull Point position) {
            ResultView resultView;
            if (position == null) {
                DiffTablePanel.$$$reportNull$$$0(9);
            }
            return (resultView = this.getResultView()) instanceof TableResultView ? ((TableResultView)resultView).columnAtPoint(position) : 0;
        }

        public int getHeaderOffset() {
            ResultView resultView = this.getResultView();
            return resultView instanceof TableResultView ? ((TableResultView)resultView).getTableHeader().getHeight() : 0;
        }

        protected Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                DiffTablePanel.$$$reportNull$$$0(10);
            }
            if (PlatformCoreDataKeys.FILE_EDITOR.is(dataId)) {
                return this.myEditor;
            }
            return super.getData(dataId);
        }

        private static InclusionState get(Int2ObjectMap<InclusionState> states2, int num) {
            return states2.containsKey(num) ? (InclusionState)((Object)states2.get(num)) : InclusionState.ACTIVE;
        }

        private static void set(Int2ObjectMap<InclusionState> states2, int num, InclusionState state) {
            if (state == InclusionState.ACTIVE) {
                states2.remove(num);
            } else {
                states2.put(num, (Object)state);
            }
        }

        private static /* synthetic */ boolean lambda$skip$0(IntSet skip, Integer integer) {
            return !skip.contains((Object)integer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hookUp";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurator";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/diff/TableDiffEditor$DiffTablePanel";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rowIdx";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/diff/TableDiffEditor$DiffTablePanel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInactiveRows";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInactiveCols";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createRowHeader";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isRowFilteredOut";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getRowAtPosition";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getColumnAtPosition";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }

        private static enum InclusionState {
            ACTIVE,
            INACTIVE,
            REMOVED;


            Icon toIcon() {
                if (this == ACTIVE) {
                    return AllIcons.General.Add;
                }
                if (this == INACTIVE) {
                    return AllIcons.General.Remove;
                }
                return AllIcons.Actions.Cancel;
            }
        }

        private static class GenericControlAction
        extends AnAction {
            private final Boolean myRowDir;
            private final Boolean myColDir;
            private final InclusionState myState;

            GenericControlAction(@NlsActions.ActionText @NotNull String name2, @Nullable Boolean rowDir, @Nullable Boolean colDir, @NotNull InclusionState state) {
                if (name2 == null) {
                    GenericControlAction.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    GenericControlAction.$$$reportNull$$$0(1);
                }
                super(name2, "", state.toIcon());
                this.myRowDir = rowDir;
                this.myColDir = colDir;
                this.myState = state;
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    GenericControlAction.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e2) {
                if (e2 == null) {
                    GenericControlAction.$$$reportNull$$$0(3);
                }
                boolean enabled = false;
                DiffTablePanel panel2 = (DiffTablePanel)((Object)ObjectUtils.tryCast((Object)e2.getData(DatabaseDataKeys.DATA_GRID_KEY), DiffTablePanel.class));
                if (panel2 != null) {
                    for (Integer row : this.getSelectedRows(panel2)) {
                        if (enabled) break;
                        enabled = DiffTablePanel.get(panel2.myRowsInclusion, row) != this.myState;
                    }
                    for (Integer col : this.getSelectedColumns(panel2)) {
                        if (enabled) break;
                        enabled = DiffTablePanel.get(panel2.myColumnsInclusion, col) != this.myState;
                    }
                }
                e2.getPresentation().setEnabledAndVisible(enabled);
            }

            private Iterable<Integer> getSelected(@NotNull DiffTablePanel panel2, boolean row) {
                Boolean colDir;
                if (panel2 == null) {
                    GenericControlAction.$$$reportNull$$$0(4);
                }
                Boolean rowDir = panel2.getResultView().isTransposed() ? this.myColDir : this.myRowDir;
                Boolean bl = colDir = !panel2.getResultView().isTransposed() ? this.myColDir : this.myRowDir;
                if (row && rowDir != null) {
                    return panel2.selectedRows(rowDir == false);
                }
                if (!row && colDir != null) {
                    return panel2.selectedColumns(colDir == false);
                }
                return JBIterable.empty();
            }

            private Iterable<Integer> getSelectedColumns(@NotNull DiffTablePanel panel2) {
                if (panel2 == null) {
                    GenericControlAction.$$$reportNull$$$0(5);
                }
                return this.getSelected(panel2, false);
            }

            private Iterable<Integer> getSelectedRows(@NotNull DiffTablePanel panel2) {
                if (panel2 == null) {
                    GenericControlAction.$$$reportNull$$$0(6);
                }
                return this.getSelected(panel2, true);
            }

            public void actionPerformed(@NotNull AnActionEvent e2) {
                DiffTablePanel panel2;
                if (e2 == null) {
                    GenericControlAction.$$$reportNull$$$0(7);
                }
                if ((panel2 = (DiffTablePanel)((Object)ObjectUtils.tryCast((Object)e2.getData(DatabaseDataKeys.DATA_GRID_KEY), DiffTablePanel.class))) == null) {
                    return;
                }
                for (int idx : this.getSelectedColumns(panel2)) {
                    panel2.setState(idx, false, this.myState);
                }
                for (int idx : this.getSelectedRows(panel2)) {
                    panel2.setState(idx, true, this.myState);
                }
                ResultView view2 = panel2.getResultView();
                if (view2 instanceof TableResultView) {
                    ((TableResultView)view2).tableChanged(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/diff/TableDiffEditor$DiffTablePanel$GenericControlAction";
                        break;
                    }
                    case 3: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "panel";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/diff/TableDiffEditor$DiffTablePanel$GenericControlAction";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getSelected";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "getSelectedColumns";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "getSelectedRows";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }
    }
}

