/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ContainsInIndexedTextOperation;
import com.intellij.database.data.types.FormatTester;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.StringPredicateValue;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.dialects.base.BasePredicatesHelper;
import com.intellij.database.dialects.sqlite.model.SqliteVirtualTable;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J&\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/dialects/sqlite/SqlitePredicatesHelper;", "Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "ftsModules", "", "", "supportsInOperator", "", "getSupportsInOperator", "()Z", "ftsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "columnRef", "Lcom/intellij/database/data/types/ColumnRef;", "value", "Lcom/intellij/database/data/types/PredicateValue;", "alias", "version", "Lcom/intellij/database/util/Version;", "getFormatTester", "Lcom/intellij/database/data/types/FormatTester;", "domain", "Lcom/intellij/database/data/types/domain/Domain;", "intellij.database.dialects.sqlite"})
@SourceDebugExtension(value={"SMAP\nSqlitePredicatesHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlitePredicatesHelper.kt\ncom/intellij/database/dialects/sqlite/SqlitePredicatesHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n1#2:38\n*E\n"})
public final class SqlitePredicatesHelper
extends BasePredicatesHelper {
    @NotNull
    private final Set<String> ftsModules;

    public SqlitePredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
        Object[] objectArray = new String[]{"FTS4", "FTS5"};
        this.ftsModules = SetsKt.setOf((Object[])objectArray);
    }

    @Override
    public boolean getSupportsInOperator() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected PredicatesHelper.PredicateProducer ftsPredicate(@NotNull ColumnRef columnRef, @NotNull PredicateValue value2, @Nullable String alias, @Nullable Version version) {
        String string;
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        BasicTableOrViewColumn column2 = PredicatesUtilKt.toBasicColumn(columnRef);
        if (column2 == null || !(value2 instanceof StringPredicateValue)) {
            return null;
        }
        BasicTableOrView basicTableOrView = column2.getTable();
        SqliteVirtualTable sqliteVirtualTable = basicTableOrView instanceof SqliteVirtualTable ? (SqliteVirtualTable)basicTableOrView : null;
        if (sqliteVirtualTable == null) {
            return null;
        }
        SqliteVirtualTable table = sqliteVirtualTable;
        Iterable iterable = this.ftsModules;
        Object object = table.getModuleRef();
        if (object != null && (object = object.getName(table.getModule())) != null) {
            void it2;
            Object object2 = object;
            Iterable iterable2 = iterable;
            boolean bl = false;
            string = StringUtil.toUpperCase((String)it2);
            iterable = iterable2;
        } else {
            string = null;
        }
        if (!CollectionsKt.contains((Iterable)iterable, string)) {
            return null;
        }
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)columnRef), value2, ContainsInIndexedTextOperation.INSTANCE, (Function1<? super DdlBuilder, Unit>)((Function1)new Function1<DdlBuilder, Unit>(alias, columnRef, value2, this){
            final /* synthetic */ String $alias;
            final /* synthetic */ ColumnRef $columnRef;
            final /* synthetic */ PredicateValue $value;
            final /* synthetic */ SqlitePredicatesHelper this$0;
            {
                this.$alias = $alias;
                this.$columnRef = $columnRef;
                this.$value = $value;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull DdlBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                DdlBuilder ddlBuilder = PredicatesUtilKt.identifier(builder, this.$alias, this.$columnRef).space().keyword("MATCH").space();
                Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"space(...)");
                PredicatesUtilKt.value(ddlBuilder, this.$value, this.$columnRef, this.this$0.getDbms(), DbImplUtilCore.StringLiteralDecorator.PLAIN);
            }
        }));
    }

    @Override
    @Nullable
    protected FormatTester getFormatTester(@NotNull ColumnRef columnRef, @Nullable Domain domain, @Nullable Version version) {
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        return null;
    }
}

