/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.EitherKt;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.ParameterizedSmartStatement;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementData;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactory;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.AbstractDefinitionProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PairConsumer;
import org.jetbrains.annotations.NotNull;

public final class SqliteDefinitionProvider
extends AbstractDefinitionProvider {
    @Override
    public boolean isSupported(@NotNull DasObject object) {
        ObjectKind kind;
        if (object == null) {
            SqliteDefinitionProvider.$$$reportNull$$$0(0);
        }
        return (kind = object.getKind()) == ObjectKind.VIEW || kind == ObjectKind.TABLE || kind == ObjectKind.VIRTUAL_TABLE || kind == ObjectKind.TRIGGER || kind == ObjectKind.INDEX;
    }

    @Override
    protected void fetchSources(@NotNull Iterable<? extends DasObject> objects2, @NotNull DatabaseConnectionCore connection2, @NotNull PairConsumer<DasObject, Object> consumer2) {
        if (objects2 == null) {
            SqliteDefinitionProvider.$$$reportNull$$$0(1);
        }
        if (connection2 == null) {
            SqliteDefinitionProvider.$$$reportNull$$$0(2);
        }
        if (consumer2 == null) {
            SqliteDefinitionProvider.$$$reportNull$$$0(3);
        }
        SmartStatementFactory statements2 = SmartStatementFactoryService.getInstance().poweredBy(connection2);
        for (DasObject dasObject : objects2) {
            String query = SqliteDefinitionProvider.getQuery(dasObject);
            ParameterizedSmartStatement statement2 = statements2.parameterized();
            ParameterizedStatementData data = new StatementParameters().text(dasObject.getName()).asData(query);
            consumer2.consume((Object)dasObject, EitherKt.any(statement2.execute(data, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.FIRST_STRING)));
        }
    }

    private static String getQuery(@NotNull DasObject obj2) {
        if (obj2 == null) {
            SqliteDefinitionProvider.$$$reportNull$$$0(4);
        }
        NamingService namingService2 = NamingServices.getNamingService(Dbms.SQLITE);
        ObjectKind kind = obj2.getKind();
        if (kind == ObjectKind.VIRTUAL_TABLE) {
            kind = ObjectKind.TABLE;
        }
        StringBuilder res2 = new StringBuilder("SELECT sql FROM ");
        String schema2 = DasUtil.getSchema(obj2);
        if (StringUtil.isNotEmpty((String)schema2)) {
            res2.append(namingService2.enquote(schema2, ObjectKind.SCHEMA)).append(".");
        }
        res2.append("sqlite_master WHERE name=? AND type='").append(kind.code()).append("'");
        return res2.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/sqlite/SqliteDefinitionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchSources";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getQuery";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

