/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redshift.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.dialects.postgresbase.model.PgBaseModelHelper;
import com.intellij.database.dialects.redshift.model.RsExternalTable;
import com.intellij.database.dialects.redshift.model.properties.RsExternalTableStorageType;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.util.Version;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\n\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J$\u0010\u0012\u001a\u000e\u0018\u00010\u000f\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\b\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/dialects/redshift/model/RsModelHelper;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModelHelper;", "()V", "sequenceTypeSince", "Lcom/intellij/database/util/Version;", "getSequenceTypeSince", "()Lcom/intellij/database/util/Version;", "fillPropertiesWithExamples", "", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "variant", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "vars", "", "", "modifyParent", "", "getCustomName", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/annotations/Nullable;", "kind", "Lcom/intellij/database/model/ObjectKind;", "plural", "getSyntheticColumnNameByPosition", "position", "", "intellij.database.dialects.redshift"})
@SourceDebugExtension(value={"SMAP\nRsModelHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsModelHelper.kt\ncom/intellij/database/dialects/redshift/model/RsModelHelper\n+ 2 BooleanFun.kt\ncom/intellij/database/util/common/BooleanFun\n*L\n1#1,49:1\n18#2:50\n18#2:51\n*S KotlinDebug\n*F\n+ 1 RsModelHelper.kt\ncom/intellij/database/dialects/redshift/model/RsModelHelper\n*L\n18#1:50\n19#1:51\n*E\n"})
public final class RsModelHelper
extends PgBaseModelHelper {
    @NotNull
    public static final RsModelHelper INSTANCE = new RsModelHelper();
    @NotNull
    private static final Version sequenceTypeSince;

    private RsModelHelper() {
    }

    @Override
    @NotNull
    public Version getSequenceTypeSince() {
        return sequenceTypeSince;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String getCustomName(@NotNull ObjectKind kind, boolean plural) {
        String string;
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        ObjectKind objectKind = kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.FOREIGN_TABLE)) {
            int _true_$iv;
            void $this$choose$iv;
            Object[] objectArray = new Object[1];
            boolean bl = plural;
            int n = 2;
            int _false_$iv = 1;
            boolean $i$f$choose = false;
            objectArray[0] = $this$choose$iv != false ? _true_$iv : _false_$iv;
            string = DatabaseBundle.message("CustomObjectKind.external.table", objectArray);
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.FOREIGN_FUNCTION)) {
            Object[] objectArray = new Object[1];
            boolean $this$choose$iv = plural;
            int _true_$iv = 2;
            int _false_$iv = 1;
            boolean $i$f$choose = false;
            objectArray[0] = $this$choose$iv ? _true_$iv : _false_$iv;
            string = DatabaseBundle.message("CustomObjectKind.external.function", objectArray);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    public String getSyntheticColumnNameByPosition(short position) {
        return switch (position) {
            case -1 -> "ctid";
            case -2 -> "oid";
            case -3 -> "xmin";
            case -4 -> "cmin";
            case -5 -> "xmax";
            case -6 -> "cmax";
            case -7 -> "tableoid";
            default -> super.getSyntheticColumnNameByPosition(position);
        };
    }

    @Override
    public void fillPropertiesWithExamples(@NotNull BasicModElement e2, @NotNull ModelHelper.ObjectKindVariant variant, @NotNull Map<String, String> vars, boolean modifyParent) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        super.fillPropertiesWithExamples(e2, variant, vars, modifyParent);
        if (e2 instanceof RsExternalTable) {
            if (modifyParent) {
                this.setTemplateName(((RsExternalTable)e2).getSchema(), "schema_name");
            }
            Map<String, String> map2 = vars;
            String string = ((RsExternalTable)e2).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = string;
            String string3 = "schema_name." + ((RsExternalTable)e2).getName();
            map2.put(string2, string3);
            ((RsExternalTable)e2).setStorageType(RsExternalTableStorageType.PARQUET);
            vars.put("storage_type", "parquet");
            ((RsExternalTable)e2).setSerializationLib("org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe");
            vars.put("serialisation_lib", ScriptGeneratorHelperKt.getSqlString("org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe"));
        }
    }

    static {
        Version version = Version.INFINITY;
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"INFINITY");
        sequenceTypeSince = version;
    }
}

