/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redis.generator.dml.sortedSet;

import com.intellij.database.dialects.base.generator.dml.DmlGenerator;
import com.intellij.database.dialects.redis.generator.dml.UtilKt;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.SelectGenerationResult;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.util.DdlBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/redis/generator/dml/sortedSet/RedisSortedSetSelectGenerator;", "Lcom/intellij/database/dialects/base/generator/dml/DmlGenerator;", "Lcom/intellij/database/script/generator/dml/SelectGenerationResult;", "Lcom/intellij/database/script/generator/dml/SelectTask;", "task", "kind", "Lcom/intellij/database/model/ObjectKind;", "(Lcom/intellij/database/script/generator/dml/SelectTask;Lcom/intellij/database/model/ObjectKind;)V", "generate", "intellij.database.dialects.redis"})
public final class RedisSortedSetSelectGenerator
extends DmlGenerator<SelectGenerationResult, SelectTask> {
    @NotNull
    private final ObjectKind kind;

    public RedisSortedSetSelectGenerator(@NotNull SelectTask task, @NotNull ObjectKind kind) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        super((DmlTask)task);
        this.kind = kind;
    }

    @Override
    @NotNull
    public SelectGenerationResult generate() {
        DdlBuilder builder = ((SelectTask)this.getTask()).getOutput();
        DasObject table = ((SelectTask)this.getTask()).getTable();
        if (UtilKt.isNotBlank(((SelectTask)this.getTask()).getWhereClause())) {
            UtilKt.generateWhereHint(builder, "value", ((SelectTask)this.getTask()).getWhereClause());
            DdlBuilder ddlBuilder = builder.plain("ZMSCORE").space();
            Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"space(...)");
            DdlBuilder ddlBuilder2 = UtilKt.key(ddlBuilder, table, this.kind).space();
            Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder2, (String)"space(...)");
            UtilKt.generateWhere(ddlBuilder2, ((SelectTask)this.getTask()).getWhereClause());
            return new SelectGenerationResult(builder, null, null, 6, null);
        }
        int start2 = ((SelectTask)this.getTask()).getOffset();
        int stop = ((SelectTask)this.getTask()).getLimit() > 0 ? ((SelectTask)this.getTask()).getOffset() + ((SelectTask)this.getTask()).getLimit() : ((SelectTask)this.getTask()).getLimit();
        DdlBuilder ddlBuilder = builder.plain("ZRANGE").space();
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"space(...)");
        UtilKt.key(ddlBuilder, table, this.kind).space().number(start2).space().number(stop).space().plain("WITHSCORES");
        return new SelectGenerationResult(builder, null, null, 6, null);
    }
}

