/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redis.generator.dml;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.redis.RedisDbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.script.generator.dml.PlainWhereClause;
import com.intellij.database.script.generator.dml.PredicatesWhereClause;
import com.intellij.database.script.generator.dml.ValuesWhereClause;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.script.generator.dml.WrapInSelectTask;
import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.sql.dialects.redis.RedisDialect;
import com.intellij.sql.psi.SqlTokens;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001a\u0010\u000b\u001a\u00020\u00012\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\f\u0010\u0015\u001a\u00020\u0011*\u00020\u0011H\u0002\u001a\f\u0010\u0016\u001a\u00020\u0011*\u00020\u0011H\u0002\u001a\u001b\u0010\u0017\u001a\u00070\u0018\u00a2\u0006\u0002\b\u0019*\u00020\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u0007H\u0000\u001a\u001e\u0010\u001b\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00012\b\u0010\u001a\u001a\u0004\u0018\u00010\u0007H\u0000\u001a\u001e\u0010\t\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0014\u0010\t\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0002H\u0000\u001a\f\u0010\u001e\u001a\u00020\u0011*\u00020\u0011H\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u00020\u0006*\u0004\u0018\u00010\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\"\u0018\u0010\t\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0004\u00a8\u0006\u001f"}, d2={"command", "", "Lcom/intellij/database/script/generator/dml/WrapInSelectTask;", "getCommand", "(Lcom/intellij/database/script/generator/dml/WrapInSelectTask;)Ljava/lang/String;", "isNotBlank", "", "Lcom/intellij/database/script/generator/dml/WhereClause;", "(Lcom/intellij/database/script/generator/dml/WhereClause;)Z", "key", "getKey", "keyScrName", "table", "Lcom/intellij/database/model/DasObject;", "kind", "Lcom/intellij/database/model/ObjectKind;", "startLexer", "Lcom/intellij/lexer/Lexer;", "project", "Lcom/intellij/openapi/project/Project;", "query", "advanceToCommand", "advanceToKey", "generateWhere", "Lcom/intellij/database/util/DdlBuilder;", "Lorg/jetbrains/annotations/NotNull;", "whereClause", "generateWhereHint", "hintColumnTitle", "task", "skipHintIfExists", "intellij.database.dialects.redis"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\ncom/intellij/database/dialects/redis/generator/dml/UtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class UtilKt {
    @NotNull
    public static final DdlBuilder key(@NotNull DdlBuilder $this$key, @NotNull DasObject table, @NotNull ObjectKind kind) {
        Intrinsics.checkNotNullParameter((Object)$this$key, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        DdlBuilder ddlBuilder = $this$key.identifier(table.getName(), kind);
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"identifier(...)");
        return ddlBuilder;
    }

    public static /* synthetic */ DdlBuilder key$default(DdlBuilder ddlBuilder, DasObject dasObject, ObjectKind objectKind, int n, Object object) {
        if ((n & 2) != 0) {
            ObjectKind objectKind2 = dasObject.getKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"getKind(...)");
            objectKind = objectKind2;
        }
        return UtilKt.key(ddlBuilder, dasObject, objectKind);
    }

    @NotNull
    public static final DdlBuilder key(@NotNull DdlBuilder $this$key, @NotNull WrapInSelectTask task) {
        Intrinsics.checkNotNullParameter((Object)$this$key, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        DdlBuilder ddlBuilder = $this$key.plain(UtilKt.getKey(task));
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"plain(...)");
        return ddlBuilder;
    }

    @NotNull
    public static final String keyScrName(@Nullable DasObject table, @NotNull ObjectKind kind) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
                object = table;
                if (object == null) break block2;
                DasObject it2 = object;
                boolean bl = false;
                Dbms dbms = RedisDbms.REDIS;
                Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"REDIS");
                NamingService namingService2 = NamingServices.getNamingService$default(dbms, null, null, 6, null);
                String string = it2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = namingService2.catToScript(string, kind);
                object = string2;
                if (string2 != null) break block3;
            }
            object = "???";
        }
        return object;
    }

    public static final boolean isNotBlank(@Nullable WhereClause $this$isNotBlank) {
        WhereClause whereClause2 = $this$isNotBlank;
        return whereClause2 instanceof ValuesWhereClause ? false : (whereClause2 instanceof PlainWhereClause ? !StringsKt.isBlank((CharSequence)((PlainWhereClause)$this$isNotBlank).getFilter()) : (whereClause2 instanceof PredicatesWhereClause ? false : false));
    }

    @NotNull
    public static final DdlBuilder generateWhereHint(@NotNull DdlBuilder $this$generateWhereHint, @NotNull String hintColumnTitle, @Nullable WhereClause whereClause2) {
        Intrinsics.checkNotNullParameter((Object)$this$generateWhereHint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)hintColumnTitle, (String)"hintColumnTitle");
        DdlBuilder ddlBuilder = $this$generateWhereHint.plain("--").space().plain(hintColumnTitle).space().symbol(":").space();
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"space(...)");
        DdlBuilder ddlBuilder2 = UtilKt.generateWhere(ddlBuilder, whereClause2).newLine();
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder2, (String)"newLine(...)");
        return ddlBuilder2;
    }

    @NotNull
    public static final DdlBuilder generateWhere(@NotNull DdlBuilder $this$generateWhere, @Nullable WhereClause whereClause2) {
        Intrinsics.checkNotNullParameter((Object)$this$generateWhere, (String)"<this>");
        DdlBuilder ddlBuilder = whereClause2 instanceof PlainWhereClause ? $this$generateWhere.plain(((PlainWhereClause)whereClause2).getFilter()) : $this$generateWhere;
        Intrinsics.checkNotNull((Object)ddlBuilder);
        return ddlBuilder;
    }

    @NotNull
    public static final String getCommand(@NotNull WrapInSelectTask $this$command) {
        Intrinsics.checkNotNullParameter((Object)$this$command, (String)"<this>");
        String string = UtilKt.advanceToCommand(UtilKt.startLexer($this$command.getProject(), $this$command.getQuery())).getTokenText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTokenText(...)");
        return string;
    }

    private static final Lexer advanceToCommand(Lexer $this$advanceToCommand) {
        UtilKt.skipHintIfExists($this$advanceToCommand);
        return $this$advanceToCommand;
    }

    @NotNull
    public static final String getKey(@NotNull WrapInSelectTask $this$key) {
        Intrinsics.checkNotNullParameter((Object)$this$key, (String)"<this>");
        String string = UtilKt.advanceToKey(UtilKt.startLexer($this$key.getProject(), $this$key.getQuery())).getTokenText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTokenText(...)");
        return string;
    }

    private static final Lexer advanceToKey(Lexer $this$advanceToKey) {
        UtilKt.advanceToCommand($this$advanceToKey);
        $this$advanceToKey.advance();
        $this$advanceToKey.advance();
        return $this$advanceToKey;
    }

    private static final Lexer skipHintIfExists(Lexer $this$skipHintIfExists) {
        if (Intrinsics.areEqual((Object)$this$skipHintIfExists.getTokenType(), (Object)SqlTokens.SQL_LINE_COMMENT)) {
            $this$skipHintIfExists.advance();
            $this$skipHintIfExists.advance();
        }
        return $this$skipHintIfExists;
    }

    private static final Lexer startLexer(Project project, String query) {
        RedisDialect language = RedisDialect.INSTANCE;
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)language);
        Lexer lexer = parserDefinition.createLexer(project);
        Intrinsics.checkNotNullExpressionValue((Object)lexer, (String)"createLexer(...)");
        Lexer lexer2 = lexer;
        lexer2.start((CharSequence)query);
        return lexer2;
    }
}

