/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redis;

import com.intellij.database.dialects.redis.RedisTree;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.view.structure.DvExtraTreeNode;
import com.intellij.database.view.structure.DvTreeIconItem;
import com.intellij.database.view.structure.DvTreeNodeRank;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\b\u0010#\u001a\u00020\nH\u0016J\u000f\u0010$\u001a\t\u0018\u00010%\u00a2\u0006\u0002\b&H\u0016J\b\u0010'\u001a\u00020\nH\u0016R\u001c\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006("}, d2={"Lcom/intellij/database/dialects/redis/RedisFolder;", "Lcom/intellij/database/view/structure/DvExtraTreeNode;", "schema", "Lcom/intellij/database/model/basic/BasicSchema;", "family", "Lcom/intellij/database/model/families/HostFamily;", "Lcom/intellij/database/model/basic/BasicElement;", "parentFolder", "Lcom/intellij/database/model/basic/BasicNode;", "path", "", "delimiter", "(Lcom/intellij/database/model/basic/BasicSchema;Lcom/intellij/database/model/families/HostFamily;Lcom/intellij/database/model/basic/BasicNode;Ljava/lang/String;Ljava/lang/String;)V", "getFamily", "()Lcom/intellij/database/model/families/HostFamily;", "folderName", "iconItem", "Lcom/intellij/database/view/structure/DvTreeIconItem;", "getIconItem", "()Lcom/intellij/database/view/structure/DvTreeIconItem;", "isItselfMeaningful", "", "()Z", "getParentFolder", "()Lcom/intellij/database/model/basic/BasicNode;", "parentNode", "getParentNode", "getPath", "()Ljava/lang/String;", "getSchema", "()Lcom/intellij/database/model/basic/BasicSchema;", "treeNodeRank", "Lcom/intellij/database/view/structure/DvTreeNodeRank;", "getTreeNodeRank", "()Lcom/intellij/database/view/structure/DvTreeNodeRank;", "getDisplayName", "getModel", "Lcom/intellij/database/model/basic/BasicModel;", "Lorg/jetbrains/annotations/Nullable;", "toString", "intellij.database.dialects.redis"})
final class RedisFolder
implements DvExtraTreeNode {
    @NotNull
    private final BasicSchema schema;
    @NotNull
    private final HostFamily<? extends BasicElement> family;
    @Nullable
    private final BasicNode parentFolder;
    @NotNull
    private final String path;
    @NotNull
    private final String folderName;

    public RedisFolder(@NotNull BasicSchema schema2, @NotNull HostFamily<? extends BasicElement> family, @Nullable BasicNode parentFolder, @NotNull String path, @NotNull String delimiter) {
        Intrinsics.checkNotNullParameter((Object)schema2, (String)"schema");
        Intrinsics.checkNotNullParameter(family, (String)"family");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
        this.schema = schema2;
        this.family = family;
        this.parentFolder = parentFolder;
        this.path = path;
        this.folderName = ((Object)RedisTree.Companion.extractName(this.path, delimiter)).toString();
    }

    @NotNull
    public final BasicSchema getSchema() {
        return this.schema;
    }

    @Override
    @NotNull
    public HostFamily<? extends BasicElement> getFamily() {
        return this.family;
    }

    @Nullable
    public final BasicNode getParentFolder() {
        return this.parentFolder;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public BasicModel getModel() {
        return this.schema.getModel();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.folderName;
    }

    @Override
    @NotNull
    public DvTreeNodeRank getTreeNodeRank() {
        return DvTreeNodeRank.TL_SYNTHETIC;
    }

    @Override
    @Nullable
    public BasicNode getParentNode() {
        BasicNode basicNode = this.parentFolder;
        if (basicNode == null) {
            basicNode = this.getFamily();
        }
        return basicNode;
    }

    @Override
    public boolean isItselfMeaningful() {
        return true;
    }

    @Override
    @Nullable
    public DvTreeIconItem getIconItem() {
        return DvTreeIconItem.GRAY_FOLDER_ICON;
    }

    @NotNull
    public String toString() {
        return this.path + " (folder)";
    }
}

