/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redis;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.database.BasicModelRegistry;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.redis.RedisDvStructureExtensionKt;
import com.intellij.database.dialects.redis.RedisFamilyTree;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.view.structure.DvFamilyHierarchyDescriptor;
import com.intellij.database.view.structure.DvFamilyRelocationDescriptor;
import com.intellij.database.view.structure.DvStructureExtension;
import com.intellij.database.view.structure.DvTransformDescriptor;
import com.intellij.database.view.structure.DvTreeInternalFunKt;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.database.view.structure.HostFamilyKin;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.UtilKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0016J \u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u001dH\u0002J(\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u001f2\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u001f2\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0005H\u0002J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0018H\u0002J\u0014\u0010#\u001a\u00020\u000b2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\"\u0010$\u001a\u0004\u0018\u00010\u001a2\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0018H\u0002J,\u0010&\u001a\u001e\u0012\u0004\u0012\u00020(\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0'0'j\u0002`*2\u0006\u0010+\u001a\u00020,H\u0016J\u0018\u0010-\u001a\u00020\u00062\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0005H\u0002J\u0010\u0010.\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u0018H\u0002J\u0010\u0010/\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\nH\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/database/dialects/redis/RedisDvStructureExtension;", "Lcom/intellij/database/view/structure/DvStructureExtension;", "()V", "forest", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lcom/intellij/database/model/families/Family;", "Lcom/intellij/database/dialects/redis/RedisFamilyTree;", "keyHierarchyDescriptor", "Lcom/intellij/database/view/structure/DvFamilyHierarchyDescriptor;", "modelDelimiters", "Lcom/intellij/database/model/basic/BasicModel;", "", "modelRegistry", "Lcom/intellij/database/BasicModelRegistry;", "schemaKeyRelocationDescriptor", "Lcom/intellij/database/view/structure/DvFamilyRelocationDescriptor;", "clearCachesForDataSource", "", "dataSource", "Lcom/intellij/database/model/RawDataSource;", "model", "countChildren", "", "family", "Lcom/intellij/database/model/basic/BasicElement;", "node", "Lcom/intellij/database/model/basic/BasicNode;", "enableTransformationForFamily", "", "Lcom/intellij/database/model/families/HostFamily;", "fetchChildren", "Lcom/intellij/util/containers/JBIterable;", "fetchTopNodes", "getElementDelimiter", "element", "getFamilyDelimiter", "getParent", "getPresentableName", "getTransformDescriptors", "", "Lcom/intellij/database/model/ObjectKind;", "Lcom/intellij/database/view/structure/DvTransformDescriptor;", "Lcom/intellij/database/view/structure/DvTransformDescriptors;", "viewOptions", "Lcom/intellij/database/view/structure/DvViewOptions;", "growRedisFamilyTree", "hasElementParent", "obtainModelDelimiter", "intellij.database.dialects.redis"})
public final class RedisDvStructureExtension
implements DvStructureExtension {
    private BasicModelRegistry modelRegistry;
    @NotNull
    private final LoadingCache<Family<?>, RedisFamilyTree> forest;
    @NotNull
    private final LoadingCache<BasicModel, String> modelDelimiters;
    @NotNull
    private final DvFamilyHierarchyDescriptor keyHierarchyDescriptor;
    @NotNull
    private final DvFamilyRelocationDescriptor schemaKeyRelocationDescriptor;

    public RedisDvStructureExtension() {
        LoadingCache loadingCache = Caffeine.newBuilder().weakKeys().build(arg_0 -> RedisDvStructureExtension.forest$lambda$0((Function1)new Function1<Family<? extends BasicElement>, RedisFamilyTree>((Object)this){

            @NotNull
            public final RedisFamilyTree invoke(@NotNull Family<? extends BasicElement> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return RedisDvStructureExtension.access$growRedisFamilyTree((RedisDvStructureExtension)this.receiver, p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        this.forest = loadingCache;
        LoadingCache loadingCache2 = Caffeine.newBuilder().weakKeys().build(arg_0 -> RedisDvStructureExtension.modelDelimiters$lambda$1((Function1)new Function1<BasicModel, String>((Object)this){

            @NotNull
            public final String invoke(@NotNull BasicModel p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RedisDvStructureExtension.access$obtainModelDelimiter((RedisDvStructureExtension)this.receiver, p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache2, (String)"build(...)");
        this.modelDelimiters = loadingCache2;
        ObjectKind objectKind = ObjectKind.COLUMN;
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
        this.keyHierarchyDescriptor = new DvFamilyHierarchyDescriptor(objectKind, (Function1<? super Family<? extends BasicElement>, ? extends JBIterable<? extends BasicNode>>)((Function1)new Function1<Family<? extends BasicElement>, JBIterable<? extends BasicNode>>((Object)this){

            @NotNull
            public final JBIterable<? extends BasicNode> invoke(@NotNull Family<? extends BasicElement> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return RedisDvStructureExtension.access$fetchTopNodes((RedisDvStructureExtension)this.receiver, p0);
            }
        }), (Function2<? super Family<? extends BasicElement>, ? super BasicNode, ? extends JBIterable<? extends BasicNode>>)((Function2)new Function2<Family<? extends BasicElement>, BasicNode, JBIterable<? extends BasicNode>>((Object)this){

            @NotNull
            public final JBIterable<? extends BasicNode> invoke(@NotNull Family<? extends BasicElement> p0, @NotNull BasicNode p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return RedisDvStructureExtension.access$fetchChildren((RedisDvStructureExtension)this.receiver, p0, p1);
            }
        }), (Function2<? super Family<? extends BasicElement>, ? super BasicNode, Integer>)((Function2)new Function2<Family<? extends BasicElement>, BasicNode, Integer>((Object)this){

            @NotNull
            public final Integer invoke(@NotNull Family<? extends BasicElement> p0, @NotNull BasicNode p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return RedisDvStructureExtension.access$countChildren((RedisDvStructureExtension)this.receiver, p0, p1);
            }
        }), (Function2<? super Family<? extends BasicElement>, ? super BasicNode, ? extends BasicNode>)((Function2)new Function2<Family<? extends BasicElement>, BasicNode, BasicNode>((Object)this){

            @Nullable
            public final BasicNode invoke(@NotNull Family<? extends BasicElement> p0, @NotNull BasicNode p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return RedisDvStructureExtension.access$getParent((RedisDvStructureExtension)this.receiver, p0, p1);
            }
        }), (Function1<? super BasicElement, String>)((Function1)new Function1<BasicElement, String>((Object)this){

            @NotNull
            public final String invoke(@NotNull BasicElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RedisDvStructureExtension.access$getPresentableName((RedisDvStructureExtension)this.receiver, p0);
            }
        }));
        ObjectKind objectKind2 = ObjectKind.SCHEMA;
        Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"SCHEMA");
        ObjectKind objectKind3 = ObjectKind.COLLECTION;
        Intrinsics.checkNotNullExpressionValue((Object)objectKind3, (String)"COLLECTION");
        this.schemaKeyRelocationDescriptor = new DvFamilyRelocationDescriptor(new HostFamilyKin(objectKind2, objectKind3), this.keyHierarchyDescriptor, arg_0 -> RedisDvStructureExtension.schemaKeyRelocationDescriptor$lambda$2((Function1)new Function1<HostFamily<? extends BasicElement>, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull HostFamily<? extends BasicElement> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return RedisDvStructureExtension.access$enableTransformationForFamily((RedisDvStructureExtension)this.receiver, p0);
            }
        }, arg_0), arg_0 -> RedisDvStructureExtension.schemaKeyRelocationDescriptor$lambda$3((Function1)new Function1<BasicElement, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull BasicElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RedisDvStructureExtension.access$hasElementParent((RedisDvStructureExtension)this.receiver, p0);
            }
        }, arg_0));
    }

    @Override
    @NotNull
    public Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> getTransformDescriptors(@NotNull DvViewOptions viewOptions) {
        Intrinsics.checkNotNullParameter((Object)viewOptions, (String)"viewOptions");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ObjectKind.SCHEMA, (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)ObjectKind.COLLECTION, (Object)this.schemaKeyRelocationDescriptor))), TuplesKt.to((Object)ObjectKind.COLLECTION, (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)ObjectKind.COLLECTION, (Object)this.keyHierarchyDescriptor)))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final boolean enableTransformationForFamily(HostFamily<? extends BasicElement> family) {
        BasicModel basicModel = family.getModel();
        if (basicModel == null) {
            return false;
        }
        BasicModel model2 = basicModel;
        Object object = this.modelDelimiters.get((Object)model2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String delimiter = (String)object;
        return !Intrinsics.areEqual((Object)delimiter, (Object)RedisDvStructureExtensionKt.access$getNoDelimiter$p());
    }

    private final String obtainModelDelimiter(BasicModel model2) {
        BasicModelRegistry basicModelRegistry;
        if (this.modelRegistry == null) {
            this.modelRegistry = BasicModelRegistry.Companion.instance();
        }
        if ((basicModelRegistry = this.modelRegistry) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modelRegistry");
            basicModelRegistry = null;
        }
        LocalDataSource localDataSource = basicModelRegistry.getLocalDataSource(model2);
        if (localDataSource == null) {
            return RedisDvStructureExtensionKt.access$getNoDelimiter$p();
        }
        LocalDataSource dataSource2 = localDataSource;
        String string = dataSource2.getAdditionalProperty("database.redis.view.hierarchy.delimiter");
        if (string == null) {
            string = RedisDvStructureExtensionKt.access$getNoDelimiter$p();
        }
        String delimiter = string;
        return delimiter;
    }

    private final RedisFamilyTree growRedisFamilyTree(Family<? extends BasicElement> family) {
        String delimiter = this.getFamilyDelimiter(family);
        return new RedisFamilyTree(family, delimiter);
    }

    private final String getFamilyDelimiter(Family<?> family) {
        BasicModel basicModel = family.getModel();
        if (basicModel == null) {
            return RedisDvStructureExtensionKt.access$getNoDelimiter$p();
        }
        BasicModel model2 = basicModel;
        Object object = this.modelDelimiters.get((Object)model2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (String)object;
    }

    private final String getElementDelimiter(BasicElement element2) {
        Family<? extends BasicElement> family = element2.getParentFamily();
        if (family == null) {
            return RedisDvStructureExtensionKt.access$getNoDelimiter$p();
        }
        Family<? extends BasicElement> family2 = family;
        return this.getFamilyDelimiter(family2);
    }

    private final boolean hasElementParent(BasicElement element2) {
        String delimiter = this.getElementDelimiter(element2);
        String string = element2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)delimiter, (boolean)false, (int)2, null);
    }

    private final JBIterable<? extends BasicNode> fetchTopNodes(Family<? extends BasicElement> family) {
        if (family.isEmpty()) {
            return RedisDvStructureExtensionKt.access$getNoElements$p();
        }
        RedisFamilyTree tree2 = (RedisFamilyTree)this.forest.get(family);
        return UtilKt.asJBIterable((Iterable)tree2.getTopNodes());
    }

    private final JBIterable<? extends BasicNode> fetchChildren(Family<? extends BasicElement> family, BasicNode node2) {
        if (family.isEmpty()) {
            return RedisDvStructureExtensionKt.access$getNoElements$p();
        }
        RedisFamilyTree tree2 = (RedisFamilyTree)this.forest.get(family);
        if (tree2.getTree().getNodeChildrenCount(node2) == 0) {
            return RedisDvStructureExtensionKt.access$getNoElements$p();
        }
        return UtilKt.asJBIterable((Iterable)tree2.getTree().getNodeChildren(node2));
    }

    private final int countChildren(Family<? extends BasicElement> family, BasicNode node2) {
        if (family.isEmpty()) {
            return 0;
        }
        RedisFamilyTree tree2 = (RedisFamilyTree)this.forest.get(family);
        return tree2.getTree().getNodeChildrenCount(node2);
    }

    private final BasicNode getParent(Family<? extends BasicElement> family, BasicNode node2) {
        RedisFamilyTree tree2 = (RedisFamilyTree)this.forest.get(family);
        return tree2.getTree().getNodeParent(node2);
    }

    private final String getPresentableName(BasicElement element2) {
        String delimiter = this.getElementDelimiter(element2);
        String string = element2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String s2 = StringsKt.substringAfterLast$default((String)string, (String)delimiter, null, (int)2, null);
        if (((CharSequence)s2).length() == 0) {
            s2 = "(unnamed)";
        }
        return s2;
    }

    @Override
    public void clearCachesForDataSource(@NotNull RawDataSource dataSource2, @NotNull BasicModel model2) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        DvTreeInternalFunKt.invalidateThat((Cache)this.forest, (Function1)new Function1<Family<?>, Boolean>(model2){
            final /* synthetic */ BasicModel $model;
            {
                this.$model = $model;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Family<?> it2) {
                return it2.getModel() == this.$model;
            }
        });
        this.modelDelimiters.invalidate((Object)model2);
    }

    private static final RedisFamilyTree forest$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (RedisFamilyTree)$tmp0.invoke(p0);
    }

    private static final String modelDelimiters$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final boolean schemaKeyRelocationDescriptor$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean schemaKeyRelocationDescriptor$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ RedisFamilyTree access$growRedisFamilyTree(RedisDvStructureExtension $this, Family family) {
        return $this.growRedisFamilyTree(family);
    }

    public static final /* synthetic */ String access$obtainModelDelimiter(RedisDvStructureExtension $this, BasicModel model2) {
        return $this.obtainModelDelimiter(model2);
    }

    public static final /* synthetic */ JBIterable access$fetchTopNodes(RedisDvStructureExtension $this, Family family) {
        return $this.fetchTopNodes(family);
    }

    public static final /* synthetic */ JBIterable access$fetchChildren(RedisDvStructureExtension $this, Family family, BasicNode node2) {
        return $this.fetchChildren(family, node2);
    }

    public static final /* synthetic */ int access$countChildren(RedisDvStructureExtension $this, Family family, BasicNode node2) {
        return $this.countChildren(family, node2);
    }

    public static final /* synthetic */ BasicNode access$getParent(RedisDvStructureExtension $this, Family family, BasicNode node2) {
        return $this.getParent(family, node2);
    }

    public static final /* synthetic */ String access$getPresentableName(RedisDvStructureExtension $this, BasicElement element2) {
        return $this.getPresentableName(element2);
    }

    public static final /* synthetic */ boolean access$enableTransformationForFamily(RedisDvStructureExtension $this, HostFamily family) {
        return $this.enableTransformationForFamily(family);
    }

    public static final /* synthetic */ boolean access$hasElementParent(RedisDvStructureExtension $this, BasicElement element2) {
        return $this.hasElementParent(element2);
    }
}

