/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresgreenplumbase.model;

import com.intellij.database.dialects.postgresbase.model.PgBaseLanguage;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRoutine;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseSchema;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseSequence;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseTable;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseTableColumn;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseTrigger;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.properties.BasicReferenceInfo;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Condition;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u000e\u001a\n\u0010\u000f\u001a\u00020\u0007*\u00020\u000e\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0012\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0015\u001a\n\u0010\u0016\u001a\u00020\u0014*\u00020\u000e\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0017"}, d2={"callRoutineName", "", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseTrigger;", "getCallRoutineName", "(Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseTrigger;)Ljava/lang/String;", "pgFloatToString", "f", "", "addSuccessor", "", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseTable;", "id", "", "costAsString", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRoutine;", "defaultCost", "getSchemaOfDataType", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseSchema;", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseTableColumn;", "hasDefaultCacheSize", "", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseSequence;", "isCostDefined", "intellij.database.dialects.postgresgreenplumbase"})
@JvmName(name="PgGPlumBaseUtil")
public final class PgGPlumBaseUtil {
    public static final void addSuccessor(@NotNull PgGPlumBaseTable $this$addSuccessor, long id) {
        Intrinsics.checkNotNullParameter((Object)$this$addSuccessor, (String)"<this>");
        Set<Long> set = $this$addSuccessor.getSuccessorIds();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getSuccessorIds(...)");
        Set<Long> ids = set;
        if (!ids.contains(id)) {
            $this$addSuccessor.setSuccessorIds(SetsKt.plus(ids, (Object)id));
        }
    }

    public static final boolean isCostDefined(@NotNull PgGPlumBaseRoutine $this$isCostDefined) {
        Intrinsics.checkNotNullParameter((Object)$this$isCostDefined, (String)"<this>");
        return Float.compare($this$isCostDefined.getCost(), 0.0f) != 0 && !($this$isCostDefined.getCost() == PgGPlumBaseUtil.defaultCost($this$isCostDefined));
    }

    public static final float defaultCost(@NotNull PgGPlumBaseRoutine $this$defaultCost) {
        Intrinsics.checkNotNullParameter((Object)$this$defaultCost, (String)"<this>");
        BasicReferenceInfo<? extends PgBaseLanguage> basicReferenceInfo = $this$defaultCost.getLanguageRefInfo();
        return StringsKt.equals((String)(basicReferenceInfo != null ? basicReferenceInfo.getName() : null), (String)"c", (boolean)true) ? 1.0f : 100.0f;
    }

    @NotNull
    public static final String costAsString(@NotNull PgGPlumBaseRoutine $this$costAsString) {
        Intrinsics.checkNotNullParameter((Object)$this$costAsString, (String)"<this>");
        return PgGPlumBaseUtil.pgFloatToString($this$costAsString.getCost());
    }

    public static final boolean hasDefaultCacheSize(@NotNull PgGPlumBaseSequence $this$hasDefaultCacheSize) {
        Intrinsics.checkNotNullParameter((Object)$this$hasDefaultCacheSize, (String)"<this>");
        long l = $this$hasDefaultCacheSize.getCacheSize();
        return 0L <= l ? l < 2L : false;
    }

    @Nullable
    public static final PgGPlumBaseSchema getSchemaOfDataType(@NotNull PgGPlumBaseTableColumn $this$getSchemaOfDataType) {
        Intrinsics.checkNotNullParameter((Object)$this$getSchemaOfDataType, (String)"<this>");
        DasType dasType = $this$getSchemaOfDataType.getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        if (DasTypeUtilsKt.getSchemaName(dasType) == null) {
            return $this$getSchemaOfDataType.getSchema();
        }
        DasType dasType2 = $this$getSchemaOfDataType.getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"getDasType(...)");
        String string = DasTypeUtilsKt.getSchemaName(dasType2);
        CasingProvider casingProvider = BasicMixinElement.getCasingProvider($this$getSchemaOfDataType);
        if (casingProvider == null) {
            casingProvider = DasUtil.NO_CASING_PROVIDER;
        }
        Condition condition2 = DasUtil.byName(string, casingProvider);
        Intrinsics.checkNotNullExpressionValue(condition2, (String)"byName(...)");
        Condition nameCondition = condition2;
        BasicNode basicNode = $this$getSchemaOfDataType.getDatabase();
        BasicSchema basicSchema = basicNode != null && (basicNode = basicNode.getSchemas()) != null ? (BasicSchema)basicNode.find(arg_0 -> PgGPlumBaseUtil.getSchemaOfDataType$lambda$0((Function1)new Function1<BasicSchema, Boolean>(nameCondition){
            final /* synthetic */ Condition<DasObject> $nameCondition;
            {
                this.$nameCondition = $nameCondition;
                super(1);
            }

            @NotNull
            public final Boolean invoke(BasicSchema it2) {
                return this.$nameCondition.value((Object)it2);
            }
        }, arg_0)) : null;
        return basicSchema instanceof PgGPlumBaseSchema ? (PgGPlumBaseSchema)basicSchema : null;
    }

    @NotNull
    public static final String pgFloatToString(float f) {
        return Float.isInfinite(f) ? "infinity" : String.valueOf((long)f);
    }

    @Nullable
    public static final String getCallRoutineName(@NotNull PgGPlumBaseTrigger $this$callRoutineName) {
        Intrinsics.checkNotNullParameter((Object)$this$callRoutineName, (String)"<this>");
        PgGPlumBaseRoutine pgGPlumBaseRoutine = $this$callRoutineName.getCallRoutine();
        return pgGPlumBaseRoutine != null ? pgGPlumBaseRoutine.getName() : null;
    }

    private static final boolean getSchemaOfDataType$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

