/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresgreenplumbase;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.dialects.base.BaseDmlHelper;
import com.intellij.database.dialects.base.generator.dml.DmlGenerator;
import com.intellij.database.dialects.postgresgreenplumbase.PgGPlumBaseDmlHelperKt;
import com.intellij.database.dialects.postgresgreenplumbase.generator.dml.PgGPlumBaseQueryColumnsGenerator;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseLikeColumn;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.QueryColumnsTask;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000bH\u0002J(\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J \u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u001e\u001a\u0004\u0018\u00010\u000bH\u0016J0\u0010\u001f\u001a\u0016\u0012\u0004\u0012\u0002H!\u0012\n\u0012\b\u0012\u0004\u0012\u0002H!0\"\u0018\u00010 \"\u0004\b\u0000\u0010!2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H!0\"H\u0014J\u0012\u0010$\u001a\u00020\u00062\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u0012\u0010'\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\b\u00a8\u0006("}, d2={"Lcom/intellij/database/dialects/postgresgreenplumbase/PgGPlumBaseDmlHelper;", "Lcom/intellij/database/dialects/base/BaseDmlHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "needAliasInUpdateStatement", "", "getNeedAliasInUpdateStatement", "()Z", "needsCastWhenValueIsPassedAsParameterInInsertOrUpdate", "", "", "supportsInsertDefaultValues", "getSupportsInsertDefaultValues", "appendCastIfNeeded", "", "builder", "Lcom/intellij/database/util/DdlBuilder;", "table", "Lcom/intellij/database/model/DasObject;", "columnName", "typeName", "appendPlaceholderForInsert", "d", "Lcom/intellij/database/datagrid/AutoValueDescriptor;", "forcePlaceholderForDefaults", "appendPlaceholderForUpdate", "data", "Lcom/intellij/database/datagrid/mutating/ColumnQueryData;", "appendRowId", "alias", "getGenerator", "Lcom/intellij/database/dialects/base/generator/dml/DmlGenerator;", "OUT", "Lcom/intellij/database/script/generator/dml/DmlTask;", "task", "isEditableTable", "kind", "Lcom/intellij/database/model/ObjectKind;", "supportsOffset", "intellij.database.dialects.postgresgreenplumbase"})
public abstract class PgGPlumBaseDmlHelper
extends BaseDmlHelper {
    @NotNull
    private final Set<String> needsCastWhenValueIsPassedAsParameterInInsertOrUpdate;

    public PgGPlumBaseDmlHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
        Object[] objectArray = new String[]{"daterange", "int4range", "int8range", "numrange", "tsrange", "tstzrange", "inet"};
        this.needsCastWhenValueIsPassedAsParameterInInsertOrUpdate = SetsKt.setOf((Object[])objectArray);
    }

    @Override
    public boolean getSupportsInsertDefaultValues() {
        return true;
    }

    @Override
    public boolean getNeedAliasInUpdateStatement() {
        return false;
    }

    @Override
    @Nullable
    protected <OUT> DmlGenerator<OUT, DmlTask<OUT>> getGenerator(@NotNull DmlTask<? extends OUT> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        DmlGenerator dmlGenerator = task instanceof QueryColumnsTask ? (DmlGenerator)new PgGPlumBaseQueryColumnsGenerator((QueryColumnsTask)task, this.getDbms(), this) : super.getGenerator(task);
        return dmlGenerator instanceof DmlGenerator ? dmlGenerator : null;
    }

    @Override
    @NotNull
    public DdlBuilder appendRowId(@NotNull DdlBuilder builder, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        DdlBuilder ddlBuilder = builder.symbol(",").space().literal("CTID");
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"literal(...)");
        return ddlBuilder;
    }

    @Override
    public boolean supportsOffset(@Nullable DasObject table) {
        return true;
    }

    @Override
    public boolean isEditableTable(@Nullable ObjectKind kind) {
        return Intrinsics.areEqual((Object)kind, (Object)ObjectKind.VIEW) ? true : super.isEditableTable(kind);
    }

    @Override
    public void appendPlaceholderForInsert(@NotNull AutoValueDescriptor d2, @NotNull DasObject table, @NotNull DdlBuilder builder, boolean forcePlaceholderForDefaults) {
        Intrinsics.checkNotNullParameter((Object)d2, (String)"d");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (!forcePlaceholderForDefaults && (d2.isAutogenerated() || d2.hasDefault())) {
            builder.plain("DEFAULT");
            return;
        }
        builder.placeholder();
        String string = d2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.appendCastIfNeeded(builder, table, string, d2.getTypeName());
    }

    @Override
    public boolean appendPlaceholderForUpdate(@NotNull ColumnQueryData data, @NotNull DasObject table, @NotNull DdlBuilder builder) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Object value2 = data.getObject();
        if (value2 == ReservedCellValue.DEFAULT) {
            builder.keyword("DEFAULT");
            bl = false;
        } else {
            builder.placeholder();
            String string = data.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            this.appendCastIfNeeded(builder, table, string, data.getTypeName());
            bl = true;
        }
        return bl;
    }

    private final void appendCastIfNeeded(DdlBuilder builder, DasObject table, String columnName, String typeName) {
        PgGPlumBaseLikeColumn column2;
        DasColumn dasColumn = DasUtil.findChild(table, DasColumn.class, ObjectKind.COLUMN, columnName);
        Object object = DbImplUtilCore.unwrap(dasColumn);
        PgGPlumBaseLikeColumn pgGPlumBaseLikeColumn = column2 = object instanceof PgGPlumBaseLikeColumn ? (PgGPlumBaseLikeColumn)object : null;
        if (column2 != null && PgGPlumBaseDmlHelperKt.isNonBasicType(column2)) {
            builder.symbol("::").type(column2.getDasType().toDataType());
        } else if (typeName != null) {
            object = typeName;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string = ((String)object).toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (this.needsCastWhenValueIsPassedAsParameterInInsertOrUpdate.contains(string)) {
                DdlBuilder ddlBuilder = builder.symbol("::");
                object = typeName;
                Locale locale2 = Locale.ENGLISH;
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"ENGLISH");
                String string2 = ((String)object).toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                ddlBuilder.type(string2);
            }
        }
    }
}

