/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.pgpass;

import com.intellij.database.dialects.postgresbase.pgpass.PgPassEntry;
import com.intellij.database.dialects.postgresbase.pgpass.PgPassFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CharIterator;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J(\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/postgresbase/pgpass/PgPassFile;", "", "entries", "", "Lcom/intellij/database/dialects/postgresbase/pgpass/PgPassEntry;", "stamp", "", "(Ljava/util/List;J)V", "getEntries", "()Ljava/util/List;", "getStamp", "()J", "entry", "host", "", "port", "database", "user", "Companion", "intellij.database.dialects.postgresbase"})
public final class PgPassFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<PgPassEntry> entries;
    private final long stamp;
    @NotNull
    private static final Logger logger;

    public PgPassFile(@NotNull List<PgPassEntry> entries, long stamp) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        this.entries = entries;
        this.stamp = stamp;
    }

    @NotNull
    public final List<PgPassEntry> getEntries() {
        return this.entries;
    }

    public final long getStamp() {
        return this.stamp;
    }

    @Nullable
    public final PgPassEntry entry(@NotNull String host, @NotNull String port, @NotNull String database, @NotNull String user) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)port, (String)"port");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            if (logger.isDebugEnabled()) {
                logger.debug("lookup `" + host + ":" + port + ":" + database + ":" + user + "` among .pgpass " + this.entries.size() + " entries");
            }
            Iterable iterable = this.entries;
            for (Object t : iterable) {
                boolean bl;
                PgPassEntry it2 = (PgPassEntry)t;
                boolean bl2 = false;
                boolean res2 = bl = it2.matches(host, port, database, user);
                boolean bl3 = false;
                if (logger.isDebugEnabled()) {
                    logger.debug("check " + it2 + " = " + res2);
                }
                if (!bl) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        return v0;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    static {
        Logger logger2 = Logger.getInstance(PgPassFile.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\fH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dialects/postgresbase/pgpass/PgPassFile$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "parse", "Lcom/intellij/database/dialects/postgresbase/pgpass/PgPassFile;", "file", "Ljava/io/File;", "splitLine", "", "", "line", "intellij.database.dialects.postgresbase"})
    @SourceDebugExtension(value={"SMAP\nPgPassFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgPassFile.kt\ncom/intellij/database/dialects/postgresbase/pgpass/PgPassFile$Companion\n+ 2 FileReadWrite.kt\nkotlin/io/FilesKt__FileReadWriteKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n230#2,2:72\n1#3:74\n*S KotlinDebug\n*F\n+ 1 PgPassFile.kt\ncom/intellij/database/dialects/postgresbase/pgpass/PgPassFile$Companion\n*L\n24#1:72,2\n24#1:74\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final PgPassFile parse(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            File $this$useLines_u24default$iv = file;
            Charset charset$iv = Charsets.UTF_8;
            boolean $i$f$useLines = false;
            Object object = $this$useLines_u24default$iv;
            int n = 8192;
            Object object2 = object;
            object2 = new InputStreamReader((InputStream)new FileInputStream((File)object2), charset$iv);
            object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            Throwable throwable = null;
            try {
                BufferedReader it$iv = (BufferedReader)object;
                boolean bl = false;
                Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl2 = false;
                object2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)lines, (Function1)((Function1)new Function1<String, PgPassEntry>(file){
                    final /* synthetic */ File $file;
                    {
                        this.$file = $file;
                        super(1);
                    }

                    @Nullable
                    public final PgPassEntry invoke(@NotNull String line) {
                        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                        if (StringsKt.startsWith$default((CharSequence)line, (char)'#', (boolean)false, (int)2, null)) {
                            return null;
                        }
                        if (StringUtil.isEmptyOrSpaces((String)line)) {
                            return null;
                        }
                        List info2 = com.intellij.database.dialects.postgresbase.pgpass.PgPassFile$Companion.access$splitLine(PgPassFile.Companion, line);
                        if (info2.size() != 5) {
                            PgPassFile.access$getLogger$cp().warn("Unable to parse pgpass file entry `" + this.$file.getPath() + "` line `" + line + "`");
                            return null;
                        }
                        return new PgPassEntry(parse.1.1.invoke$asPattern((String)info2.get(0)), parse.1.1.invoke$asPattern((String)info2.get(1)), parse.1.1.invoke$asPattern((String)info2.get(2)), parse.1.1.invoke$asPattern((String)info2.get(3)), (String)info2.get(4));
                    }

                    private static final String invoke$asPattern(String $this$invoke_u24asPattern) {
                        String string;
                        String it2 = string = $this$invoke_u24asPattern;
                        boolean bl = false;
                        return !Intrinsics.areEqual((Object)it2, (Object)"*") ? string : null;
                    }
                })));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            long l = file.lastModified();
            Object object3 = object2;
            return new PgPassFile((List<PgPassEntry>)object3, l);
        }

        private final List<String> splitLine(String line) {
            CharIterator cur = StringsKt.iterator((CharSequence)line);
            ArrayList res2 = new ArrayList();
            StringBuilder buffer = new StringBuilder();
            while (cur.hasNext()) {
                char c2 = cur.nextChar();
                if (c2 == '\\') {
                    if (!cur.hasNext()) continue;
                    buffer.append(cur.nextChar());
                    continue;
                }
                if (c2 == ':') {
                    ((Collection)res2).add(buffer.toString());
                    StringsKt.clear((StringBuilder)buffer);
                    continue;
                }
                buffer.append(c2);
            }
            ((Collection)res2).add(buffer.toString());
            return res2;
        }

        public static final /* synthetic */ List access$splitLine(Companion $this, String line) {
            return $this.splitLine(line);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

