/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.pgpass;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseCredentialsAuthProvider;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.ui.AuthWidgetBuilder;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dialects.postgresbase.pgpass.PgPassAuthProvider;
import com.intellij.database.dialects.postgresbase.pgpass.PgPassEntry;
import com.intellij.database.dialects.postgresbase.pgpass.PgPassFile;
import com.intellij.database.view.DatabaseCoreUiService;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0005H\u0017J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\b\u0010\u001e\u001a\u00020\u0005H\u0016J\u001e\u0010\u001f\u001a\u00020\u00052\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010!H\u0002J\u001e\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020#H\u0096@\u00a2\u0006\u0002\u0010%J$\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010(\u001a\u00020#H\u0016J,\u0010)\u001a\u00020*2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010+\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020#H\u0016R/\u0010\u0003\u001a#\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/database/dialects/postgresbase/pgpass/PgPassAuthProvider;", "Lcom/intellij/database/dataSource/DatabaseAuthProvider;", "()V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "", "kotlin.jvm.PlatformType", "Lcom/intellij/database/dialects/postgresbase/pgpass/PgPassFile;", "Lorg/jetbrains/annotations/NotNull;", "createWidget", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$AuthWidget;", "project", "Lcom/intellij/openapi/project/Project;", "credentials", "Lcom/intellij/database/access/DatabaseCredentials;", "config", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "getApplicability", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel$Result;", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "level", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel;", "getCredentials", "Lcom/intellij/credentialStore/Credentials;", "proto", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "getDisplayName", "getFile", "path", "getId", "getLocation", "vmEnv", "", "interceptConnection", "", "silent", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadAuthConfig", "", "external", "saveAuthConfig", "", "data", "Companion", "intellij.database.dialects.postgresbase"})
@SourceDebugExtension(value={"SMAP\nPgPassAuthProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgPassAuthProvider.kt\ncom/intellij/database/dialects/postgresbase/pgpass/PgPassAuthProvider\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n14#2:106\n1#3:107\n*S KotlinDebug\n*F\n+ 1 PgPassAuthProvider.kt\ncom/intellij/database/dialects/postgresbase/pgpass/PgPassAuthProvider\n*L\n64#1:106\n*E\n"})
public final class PgPassAuthProvider
implements DatabaseAuthProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<String, PgPassFile> cache;
    @NotNull
    public static final String ID = "pgpass";

    public PgPassAuthProvider() {
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.create(arg_0 -> PgPassAuthProvider.cache$lambda$0(cache.1.INSTANCE, arg_0), ContainerUtil::createConcurrentSoftValueMap);
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"create(...)");
        this.cache = concurrentMap;
    }

    @Override
    @Nullable
    public Object interceptConnection(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, boolean silent, @NotNull Continuation<? super Boolean> $completion) {
        DatabaseCredentialsAuthProvider.Companion.applyCredentials(proto2, this.getCredentials(proto2), false);
        return Boxing.boxBoolean((boolean)true);
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    @NotNull
    public DatabaseAuthProvider.ApplicabilityLevel.Result getApplicability(@NotNull DatabaseConnectionPoint point, @NotNull DatabaseAuthProvider.ApplicabilityLevel level) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (!point.getDbms().isPostgres()) {
            return DatabaseAuthProvider.ApplicabilityLevel.Result.NOT_APPLICABLE;
        }
        if (level == DatabaseAuthProvider.ApplicabilityLevel.DEFAULT) {
            DatabaseDriver databaseDriver = point.getDatabaseDriver();
            Map map2 = databaseDriver != null ? databaseDriver.getVmEnv() : null;
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            Map<String, String> map3 = point.getDataSource().getVmEnv();
            Intrinsics.checkNotNullExpressionValue(map3, (String)"getVmEnv(...)");
            File hasPgPass = new File(this.getLocation(MapsKt.plus((Map)map2, map3)));
            if (hasPgPass.exists()) {
                return DatabaseAuthProvider.ApplicabilityLevel.Result.DEFAULT;
            }
        }
        return DatabaseAuthProvider.ApplicabilityLevel.Result.APPLICABLE;
    }

    @Override
    @NlsSafe
    @NotNull
    public String getDisplayName() {
        return ID;
    }

    @Override
    @Nullable
    public Object loadAuthConfig(@NotNull DatabaseConnectionPoint point, @Nullable DatabaseCredentials credentials, boolean external) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        if (external) {
            return null;
        }
        return StringUtil.nullize((String)LocalDataSource.getUsername(point));
    }

    @Override
    public void saveAuthConfig(@NotNull DatabaseConnectionConfig config, @Nullable DatabaseCredentials credentials, @Nullable Object data, boolean external) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (external) {
            return;
        }
        Object $this$asSafely$iv = data;
        boolean $i$f$asSafely = false;
        Object object = $this$asSafely$iv;
        if (!(object instanceof String)) {
            object = null;
        }
        LocalDataSource.setUsername(config, (String)object);
    }

    @Override
    @Nullable
    public DatabaseAuthProvider.AuthWidget createWidget(@Nullable Project project, @NotNull DatabaseCredentials credentials, @NotNull DatabaseConnectionConfig config) {
        DatabaseAuthProvider.AuthWidget authWidget;
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        AuthWidgetBuilder authWidgetBuilder = DatabaseCoreUiService.getInstance().createAuthWidgetBuilder();
        if (authWidgetBuilder != null) {
            AuthWidgetBuilder $this$createWidget_u24lambda_u241 = authWidgetBuilder;
            boolean bl = false;
            $this$createWidget_u24lambda_u241.addUserField();
            authWidget = $this$createWidget_u24lambda_u241.build(project, credentials, config);
        } else {
            authWidget = null;
        }
        return authWidget;
    }

    private final PgPassFile getFile(String path) {
        String string = PathManager.getAbsolutePath((String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        String absolutePath = string;
        PgPassFile res2 = (PgPassFile)this.cache.get(absolutePath);
        if (res2 != null && res2.getStamp() != new File(absolutePath).lastModified()) {
            this.cache.remove(absolutePath);
            return (PgPassFile)this.cache.get(absolutePath);
        }
        return res2;
    }

    private final String getLocation(Map<String, String> vmEnv) {
        String string;
        if (vmEnv != null && (string = vmEnv.get("PGPASSFILE")) != null) {
            String it2 = string;
            boolean bl = false;
            return it2;
        }
        string = EnvironmentUtil.getValue((String)"PGPASSFILE");
        if (string != null) {
            String it3 = string;
            boolean bl = false;
            return it3;
        }
        if (SystemInfo.isWindows) {
            return EnvironmentUtil.getValue((String)"APPDATA") + "\\postgresql\\pgpass.conf";
        }
        return PathMacroUtil.getUserHomePath() + "/.pgpass";
    }

    private final Credentials getCredentials(DatabaseConnectionInterceptor.ProtoConnection proto2) {
        String string;
        String db2;
        String path = this.getLocation(proto2.getVmEnv());
        PgPassFile pgPassFile = this.getFile(path);
        if (pgPassFile == null) {
            throw new RuntimeException("No pgpass file at `" + path + "`");
        }
        PgPassFile file = pgPassFile;
        JdbcUrlParser jdbcUrlParser = JdbcUrlParserUtil.parsed(proto2.getConnectionPoint(), proto2.getUrl());
        if (jdbcUrlParser == null) {
            throw new RuntimeException("Unable to parse `" + proto2.getUrl() + "`");
        }
        JdbcUrlParser props = jdbcUrlParser;
        String string2 = props.getParameter("host");
        if (string2 == null) {
            throw new RuntimeException("Host not found in `" + proto2.getUrl() + "`");
        }
        String host = string2;
        String string3 = props.getParameter("port");
        if (string3 == null) {
            throw new RuntimeException("Port not found in `" + proto2.getUrl() + "`");
        }
        String port = string3;
        String string4 = props.getParameter("database");
        if (string4 == null) {
            string4 = db2 = "postgres";
        }
        if ((string = DatabaseCredentialsAuthProvider.Companion.getUser(proto2)) == null && (string = StringUtil.nullize((String)props.getParameter("user"))) == null) {
            String string5 = proto2.getConnectionPoint().getDataSource().getUsername();
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getUsername(...)");
        }
        String user = string;
        PgPassEntry pgPassEntry = file.entry(host, port, db2, user);
        if (pgPassEntry == null) {
            throw new RuntimeException("No matching entry for `" + proto2.getUrl() + "` found in `" + path + "`");
        }
        PgPassEntry it2 = pgPassEntry;
        boolean bl = false;
        return new Credentials(user, it2.getPass());
    }

    private static final PgPassFile cache$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PgPassFile)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dialects/postgresbase/pgpass/PgPassAuthProvider$Companion;", "", "()V", "ID", "", "intellij.database.dialects.postgresbase"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

