/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.introspector.jdbc;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgBaseMetadataWrapper
extends DatabaseMetaDataWrapper {
    PgBaseMetadataWrapper(@NotNull DatabaseConnectionCore connection2, @NotNull RemoteDatabaseMetaData data) {
        if (connection2 == null) {
            PgBaseMetadataWrapper.$$$reportNull$$$0(0);
        }
        if (data == null) {
            PgBaseMetadataWrapper.$$$reportNull$$$0(1);
        }
        super(connection2, data);
    }

    @Override
    protected ClosableIt<String> catalogs() throws SQLException {
        RemoteStatement statement2 = (RemoteStatement)JdbcNativeUtil.computeRemote(() -> this.getConnection().getRemoteConnection().createStatement());
        if (statement2 == null) {
            return ClosableIt.empty();
        }
        ClosableIt.AutoCloseableGuard<AutoCloseable> g2 = ClosableIt.AutoCloseableGuard.guarded(() -> ((RemoteStatement)statement2).close());
        try {
            1 res2 = this.setUp(new ClosableIt.ResultSetDelegateIt<String>((RemoteResultSet)JdbcNativeUtil.computeRemote(() -> statement2.executeQuery("select datname as name from pg_catalog.pg_database")), g2.get()){

                @Override
                protected String calcValue() throws SQLException {
                    return this.myRs.getString("name", 1);
                }
            });
            g2.release();
            1 var4_6 = res2;
            if (g2 != null) {
                g2.close();
            }
            return var4_6;
        }
        catch (Throwable throwable) {
            try {
                if (g2 != null) {
                    try {
                        g2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e2) {
                LOG.debug((Throwable)e2);
                return super.catalogs();
            }
        }
    }

    @Override
    @NotNull
    public ClosableIt<? extends DatabaseMetaDataWrapper.Table> tables(@NotNull DatabaseMetaDataWrapper.Schema schema2, @Nullable String name2, String @Nullable [] types2) throws SQLException {
        if (schema2 == null) {
            PgBaseMetadataWrapper.$$$reportNull$$$0(2);
        }
        ClosableIt<? extends DatabaseMetaDataWrapper.Table> tableIt = super.tables(schema2, name2, types2);
        tableIt.filter(tab2 -> !"INDEX".equals(tab2.type));
        ClosableIt<? extends DatabaseMetaDataWrapper.Table> closableIt = tableIt;
        if (closableIt == null) {
            PgBaseMetadataWrapper.$$$reportNull$$$0(3);
        }
        return closableIt;
    }

    @Override
    protected boolean isUnimplemented(SQLException e2) {
        String message2 = e2.getMessage();
        if (this.getDbms() == Dbms.COCKROACH && message2 != null && message2.contains("pg_function_is_visible")) {
            return true;
        }
        return super.isUnimplemented(e2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgresbase/introspector/jdbc/PgBaseMetadataWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgresbase/introspector/jdbc/PgBaseMetadataWrapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "tables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tables";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static final class Factory
    extends DatabaseMetaDataWrapper.MDFactory {
        @Override
        @NotNull
        public DatabaseMetaDataWrapper create(@NotNull DatabaseConnectionCore connection2, @NotNull RemoteDatabaseMetaData metaData) {
            if (connection2 == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (metaData == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return new PgBaseMetadataWrapper(connection2, metaData);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "metaData";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dialects/postgresbase/introspector/jdbc/PgBaseMetadataWrapper$Factory";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

