/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.IntrospectionQueryContext;
import com.intellij.database.dialects.postgresbase.PgNoDatabaseXminOption;
import com.intellij.database.dialects.postgresbase.PgSystemSchemasOption;
import com.intellij.database.dialects.postgresbase.PgTemplateDatabaseOption;
import com.intellij.database.dialects.postgresbase.introspector.IntroStep;
import com.intellij.database.dialects.postgresbase.introspector.PgAclItem;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntroQueries;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntrospector;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntrospector$SchemaRetriever$retrieveConstraints$1$invoke$;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntrospectorKt;
import com.intellij.database.dialects.postgresbase.model.PgBaseAggregate;
import com.intellij.database.dialects.postgresbase.model.PgBaseArgument;
import com.intellij.database.dialects.postgresbase.model.PgBaseCast;
import com.intellij.database.dialects.postgresbase.model.PgBaseCatalogObject;
import com.intellij.database.dialects.postgresbase.model.PgBaseDatabase;
import com.intellij.database.dialects.postgresbase.model.PgBaseDefType;
import com.intellij.database.dialects.postgresbase.model.PgBaseDefTypeAttribute;
import com.intellij.database.dialects.postgresbase.model.PgBaseForeignKey;
import com.intellij.database.dialects.postgresbase.model.PgBaseKey;
import com.intellij.database.dialects.postgresbase.model.PgBaseLanguage;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeColumn;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeDatabase;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeSchema;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeStoredTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseMatView;
import com.intellij.database.dialects.postgresbase.model.PgBaseModelHelper;
import com.intellij.database.dialects.postgresbase.model.PgBaseObjectWithOwner;
import com.intellij.database.dialects.postgresbase.model.PgBaseOperator;
import com.intellij.database.dialects.postgresbase.model.PgBaseRegularTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseRoot;
import com.intellij.database.dialects.postgresbase.model.PgBaseRoutine;
import com.intellij.database.dialects.postgresbase.model.PgBaseSchema;
import com.intellij.database.dialects.postgresbase.model.PgBaseSourceAware;
import com.intellij.database.dialects.postgresbase.model.PgBaseTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseTableColumn;
import com.intellij.database.dialects.postgresbase.model.PgBaseView;
import com.intellij.database.dialects.postgresbase.model.properties.PgCastContext;
import com.intellij.database.dialects.postgresbase.model.properties.PgCastMethod;
import com.intellij.database.dialects.postgresbase.model.properties.PgDataTypeSubKind;
import com.intellij.database.dialects.postgresbase.model.properties.PgDateInputStyle;
import com.intellij.database.dialects.postgresbase.model.properties.PgObjectGrant;
import com.intellij.database.dialects.postgresbase.model.properties.PgObjectGrantController;
import com.intellij.database.dialects.postgresbase.model.properties.PgOperatorKind;
import com.intellij.database.dialects.postgresbase.model.properties.PgPrivilege;
import com.intellij.database.dialects.postgresbase.model.properties.PgRoutineKind;
import com.intellij.database.dialects.postgresbase.model.properties.PgTimeZone;
import com.intellij.database.dialects.postgresbase.model.properties.PgVolatilityKind;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModColumniation;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModLikeTable;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.PositioningFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.model.properties.references.BasicByColumnPositionsReference;
import com.intellij.database.model.properties.references.BasicIdOrNameReference;
import com.intellij.database.model.properties.references.BasicIdReference;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.model.properties.references.BasicParentReference;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.sql.Rewriters;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.common.StringFun;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ArrayListSet;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.StringKt;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 \u0089\u0001*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050\u0007:\b\u0089\u0001\u008a\u0001\u008b\u0001\u008c\u0001B%\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\"\u0010.\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u001f0/2\f\u00101\u001a\b\u0012\u0004\u0012\u00020002H\u0016J\n\u00103\u001a\u0004\u0018\u000104H\u0002J$\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u00020\u00132\b\u00108\u001a\u0004\u0018\u0001092\b\u0010:\u001a\u0004\u0018\u000109J,\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u0002092\f\u0010>\u001a\b\u0012\u0004\u0012\u0002090?2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020B0AH\u0004J\u0010\u0010C\u001a\u0002092\u0006\u0010D\u001a\u000209H&J\u0017\u0010E\u001a\u0004\u0018\u00010\u00132\u0006\u0010F\u001a\u00020GH\u0002\u00a2\u0006\u0002\u0010HJ&\u0010I\u001a\b\u0012\u0004\u0012\u00028\u0001022\u0006\u0010F\u001a\u00020G2\u000e\u0010J\u001a\n\u0012\u0004\u0012\u00020L\u0018\u00010KH\u0014J\b\u0010M\u001a\u00020NH\u0002J$\u0010O\u001a\u00020P2\b\u0010Q\u001a\u0004\u0018\u00010P2\u0006\u0010R\u001a\u00020S2\b\u0010T\u001a\u0004\u0018\u00010UH\u0016J!\u0010V\u001a\u00020<2\u0012\u0010W\u001a\n\u0012\u0006\b\u0001\u0012\u0002040X\"\u000204H\u0016\u00a2\u0006\u0002\u0010YJ\u0010\u0010Z\u001a\u00020<2\u0006\u0010F\u001a\u00020GH\u0014J \u0010[\u001a\u00020<2\u0006\u0010\\\u001a\u00020G2\u0006\u0010]\u001a\u00020\u001f2\u0006\u0010^\u001a\u00020\u001fH\u0002J\b\u0010_\u001a\u00020<H\u0014J\u0010\u0010`\u001a\u00020<2\u0006\u0010F\u001a\u00020GH\u0014J\u0012\u0010a\u001a\u00020\u001f2\b\u0010b\u001a\u0004\u0018\u000109H\u0004J\b\u0010c\u001a\u00020\u001fH\u0014J\u0010\u0010d\u001a\u00020\u001f2\u0006\u0010e\u001a\u00020fH\u0014J\b\u0010g\u001a\u00020\u001fH\u0014J\u0010\u0010h\u001a\u0002092\u0006\u0010i\u001a\u000209H\u0002J\"\u0010j\u001a\u0004\u0018\u00010k2\u0006\u0010l\u001a\u00020m2\u0006\u0010n\u001a\u00020o2\u0006\u0010p\u001a\u000209H\u0014J\u0014\u0010q\u001a\u0004\u0018\u00010r2\b\u0010s\u001a\u0004\u0018\u000109H\u0002J\u001d\u0010t\u001a\u00020<2\u0006\u0010F\u001a\u00020G2\u0006\u0010u\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010vJ \u0010w\u001a\u00020<2\u0006\u0010F\u001a\u00020G2\u0006\u0010]\u001a\u00020\u001f2\u0006\u0010^\u001a\u00020\u001fH\u0002J \u0010x\u001a\u00020<2\u0006\u0010\\\u001a\u00020G2\u0006\u0010]\u001a\u00020\u001f2\u0006\u0010^\u001a\u00020\u001fH\u0014J\u0010\u0010y\u001a\u00020<2\u0006\u0010z\u001a\u00020GH\u0014J\u0010\u0010{\u001a\u00020<2\u0006\u0010z\u001a\u00020GH\u0014J\u0016\u0010|\u001a\b\u0012\u0004\u0012\u00020~0}2\u0006\u0010\\\u001a\u00020GH\u0014J,\u0010\u007f\u001a\u0002092\t\u0010\u0080\u0001\u001a\u0004\u0018\u0001092\u0007\u0010\u0081\u0001\u001a\u00020\u001f2\u000e\u0010\u0082\u0001\u001a\t\u0012\u0004\u0012\u0002090\u0083\u0001H\u0004J\u0019\u0010\u0084\u0001\u001a\u0004\u0018\u000106*\u0002092\b\u0010:\u001a\u0004\u0018\u000109H\u0002J(\u0010\u0085\u0001\u001a\u00020<*\u00030\u0086\u00012\u0007\u0010\u0087\u0001\u001a\u00020\u00132\u0006\u0010D\u001a\u0002092\u0007\u0010\u0088\u0001\u001a\u000209H\u0002R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00020\u0015X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u0004\u0018\u00010\u0013X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001d\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001e\u001a\u00020\u001fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0012\u0010$\u001a\u00020%X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020\u001fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010!\"\u0004\b*\u0010#R\u001a\u0010+\u001a\u00020\u001fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010!\"\u0004\b-\u0010#\u00a8\u0006\u008d\u0001"}, d2={"Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector;", "MR", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseRoot;", "D", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeDatabase;", "S", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "nature", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;Lcom/intellij/database/Dbms;Lcom/intellij/database/model/ModelFactory;)V", "affectedKeySchemaIds", "Lcom/intellij/util/containers/ArrayListSet;", "", "helper", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModelHelper;", "getHelper", "()Lcom/intellij/database/dialects/postgresbase/model/PgBaseModelHelper;", "introspectionXid", "getIntrospectionXid", "()Ljava/lang/Long;", "setIntrospectionXid", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "noDbXmin", "", "getNoDbXmin", "()Z", "setNoDbXmin", "(Z)V", "queries", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries;", "getQueries", "()Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries;", "showSystemScs", "getShowSystemScs", "setShowSystemScs", "showTemplateDbs", "getShowTemplateDbs", "setShowTemplateDbs", "checkElementsUptodate", "", "Lcom/intellij/database/model/basic/BasicElement;", "elements", "", "connectionDatabase", "Lcom/intellij/database/model/basic/BasicDatabase;", "createIdOrQNameRef", "Lcom/intellij/database/model/properties/BasicReference;", "id", "name", "", "pDefault", "freezeOnWrapAround", "", "param", "memory", "", "ageComputable", "Lkotlin/Function0;", "", "generateDbAge", "tx", "getCurrentXid", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "(Lcom/intellij/database/layoutedQueries/DBTransaction;)Ljava/lang/Long;", "getDatabasesToIntrospect", "namespaces", "", "Lcom/intellij/database/model/basic/BasicNamespace;", "getServerIntrospectionMode", "Lcom/intellij/database/introspection/IntrospectionMode;", "init", "Lcom/intellij/database/model/basic/BasicModModel;", "model", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "introspectionScope", "Lcom/intellij/database/util/TreePattern;", "introspectDatabaseSchemas", "databases", "", "([Lcom/intellij/database/model/basic/BasicDatabase;)V", "introspectPreDatabaseObjects", "introspectServerObjects", "trans", "detectDropped", "loadNew", "introspectSpecificSessionInfo", "introspectTheServerObjects", "isColumnNameSurrogate", "it", "isItPossibleToRetrieveCurrentXid", "isNameSurrogate", "columniation", "Lcom/intellij/database/model/basic/BasicModColumniation;", "loadNewServerObjects", "mapNegativeAgeToMax", "age", "parseAclItem", "Lcom/intellij/database/dialects/postgresbase/introspector/PgAclItem;", "lex", "Lcom/intellij/lexer/Lexer;", "ns", "Lcom/intellij/database/script/generator/NamingService;", "item", "parseDateStyle", "Lcom/intellij/database/dialects/postgresbase/model/properties/PgDateInputStyle;", "s", "postProcessDatabase", "database", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeDatabase;)V", "retrieveAcls", "retrieveComments", "retrieveSettings", "transaction", "retrieveTimeZones", "steps", "", "Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "surrogateKeyName", "tableName", "primary", "colNames", "", "parseNameRef", "setTx", "Lcom/intellij/database/dialects/base/introspector/IntrospectionQueryContext;", "stateNumber", "txage", "Companion", "DatabaseRetriever", "NativeRetriever", "SchemaRetriever", "intellij.database.dialects.postgresbase"})
@SourceDebugExtension(value={"SMAP\nPgBaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgBaseIntrospector.kt\ncom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector\n+ 2 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,1636:1\n620#2,7:1637\n620#2,7:1644\n620#2,2:1651\n623#2,4:1658\n1620#3,3:1653\n1002#3,2:1656\n1747#3,3:1664\n1726#3,3:1667\n1855#3,2:1670\n1855#3,2:1672\n37#4,2:1662\n1#5:1674\n1#5:1688\n1#5:1704\n990#6,11:1675\n1183#6,2:1686\n1185#6:1689\n1001#6:1690\n990#6,11:1691\n1183#6,2:1702\n1185#6:1705\n1001#6:1706\n*S KotlinDebug\n*F\n+ 1 PgBaseIntrospector.kt\ncom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector\n*L\n181#1:1637,7\n207#1:1644,7\n214#1:1651,2\n214#1:1658,4\n216#1:1653,3\n219#1:1656,2\n254#1:1664,3\n257#1:1667,3\n266#1:1670,2\n277#1:1672,2\n249#1:1662,2\n512#1:1688\n515#1:1704\n512#1:1675,11\n512#1:1686,2\n512#1:1689\n512#1:1690\n515#1:1691,11\n515#1:1702,2\n515#1:1705\n515#1:1706\n*E\n"})
public abstract class PgBaseIntrospector<MR extends PgBaseRoot, D extends PgBaseLikeDatabase, S extends PgBaseLikeSchema>
extends BaseMultiDatabaseIntrospector<MR, D, S> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayListSet<Long> affectedKeySchemaIds;
    @Nullable
    private Long introspectionXid;
    private boolean showTemplateDbs;
    private boolean showSystemScs;
    private boolean noDbXmin;
    @Deprecated
    public static final int FROZEN_TXID = 2;

    public PgBaseIntrospector(@NotNull DBIntrospectionContext context, @NotNull BaseIntrospector.Nature nature, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)nature, (String)"nature");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        super(context, nature, dbms, modelFactory);
        this.affectedKeySchemaIds = new ArrayListSet();
    }

    @NotNull
    protected abstract PgBaseModelHelper getHelper();

    @NotNull
    protected abstract PgBaseIntroQueries getQueries();

    @Nullable
    protected final Long getIntrospectionXid() {
        return this.introspectionXid;
    }

    protected final void setIntrospectionXid(@Nullable Long l) {
        this.introspectionXid = l;
    }

    protected final boolean getShowTemplateDbs() {
        return this.showTemplateDbs;
    }

    protected final void setShowTemplateDbs(boolean bl) {
        this.showTemplateDbs = bl;
    }

    protected final boolean getShowSystemScs() {
        return this.showSystemScs;
    }

    protected final void setShowSystemScs(boolean bl) {
        this.showSystemScs = bl;
    }

    protected final boolean getNoDbXmin() {
        return this.noDbXmin;
    }

    protected final void setNoDbXmin(boolean bl) {
        this.noDbXmin = bl;
    }

    @Override
    @NotNull
    public BasicModModel init(@Nullable BasicModModel model2, @NotNull LocalDataSource dataSource2, @Nullable TreePattern introspectionScope) {
        Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
        this.showTemplateDbs = Intrinsics.areEqual(DbOptionProvider.getOptionValue(dataSource2, PgTemplateDatabaseOption.class), (Object)true);
        this.showSystemScs = Intrinsics.areEqual(DbOptionProvider.getOptionValue(dataSource2, PgSystemSchemasOption.class), (Object)true);
        this.noDbXmin = Intrinsics.areEqual(DbOptionProvider.getOptionValue(dataSource2, PgNoDatabaseXminOption.class), (Object)true);
        return super.init(model2, dataSource2, introspectionScope);
    }

    @Override
    protected void introspectSpecificSessionInfo() {
        super.introspectSpecificSessionInfo();
        this.inTransactionUnit((Function1<DBTransaction, Unit>)((Function1)new Function1<DBTransaction, Unit>(this){
            final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull DBTransaction it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                this.this$0.setIntrospectionXid(null);
                BaseNativeIntrospector baseNativeIntrospector = this.this$0;
                PgBaseIntrospector<MR, D, S> pgBaseIntrospector = this.this$0;
                boolean $i$f$continueOnDbError = false;
                try {
                    boolean bl = false;
                    Long stateNumber = (Long)BaseNativeIntrospector.performQuery$default(pgBaseIntrospector, pgBaseIntrospector.getQueries().stateNumber, null, 2, null);
                    Long l = stateNumber;
                    if (l == null) {
                        l = PgBaseIntrospector.access$getCurrentXid(pgBaseIntrospector, it2);
                    }
                    pgBaseIntrospector.setIntrospectionXid(l);
                }
                catch (DBException e$iv) {
                    void this_$iv;
                    this_$iv.getErrorSink().consume(null, (Object)((Object)e$iv));
                }
            }
        }));
    }

    private final BasicDatabase connectionDatabase() {
        String databaseName = this.getDbConnectionInfo().databaseName;
        return databaseName == null ? null : (BasicDatabase)((PgBaseRoot)this.getRoot()).findDatabaseByName(databaseName);
    }

    @Override
    protected void introspectPreDatabaseObjects(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        super.introspectPreDatabaseObjects(tran);
        this.introspectServerObjectsInTran(tran);
    }

    @Override
    protected void postProcessDatabase(@NotNull DBTransaction tran, @NotNull D database) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Intrinsics.checkNotNullParameter(database, (String)"database");
        this.handleErrors("Detect and handle cross-schema foreign keys", (Function0<Unit>)((Function0)new Function0<Unit>(this, tran, database){
            final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;
            final /* synthetic */ DBTransaction $tran;
            final /* synthetic */ D $database;
            {
                this.this$0 = $receiver;
                this.$tran = $tran;
                this.$database = $database;
                super(0);
            }

            public final void invoke() {
                if (!((Collection)PgBaseIntrospector.access$getAffectedKeySchemaIds$p(this.this$0)).isEmpty()) {
                    String signs = StringFun.replicate("?", PgBaseIntrospector.access$getAffectedKeySchemaIds$p(this.this$0).size(), ",", "null");
                    SqlQuery sqlQuery = this.this$0.getQueries().getListReferencingSchemas().rewrite(Rewriters.replace((String)"SCHEMAIDS", (String)signs));
                    Intrinsics.checkNotNullExpressionValue((Object)sqlQuery, (String)"rewrite(...)");
                    SqlQuery query = sqlQuery;
                    Collection $this$toTypedArray$iv = (Collection)PgBaseIntrospector.access$getAffectedKeySchemaIds$p(this.this$0);
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    Long[] longArray = thisCollection$iv.toArray(new Long[0]);
                    long[] referencingSchemaIds = (long[])this.$tran.query(query).withParams(Arrays.copyOf(longArray, longArray.length)).runOnce();
                    Intrinsics.checkNotNull((Object)referencingSchemaIds);
                    if (referencingSchemaIds.length == 0) {
                        return;
                    }
                    this.this$0.getModel().modify((BasicElement)this.$database, PgBaseDatabase.class, new ModelModifier(referencingSchemaIds, this.this$0){
                        final /* synthetic */ long[] $referencingSchemaIds;
                        final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;
                        {
                            this.$referencingSchemaIds = $referencingSchemaIds;
                            this.this$0 = $receiver;
                        }

                        public final void perform(PgBaseDatabase database) {
                            for (PgBaseSchema schema2 : database.getSchemas()) {
                                Intrinsics.checkNotNullExpressionValue((Object)this.$referencingSchemaIds, (String)"$referencingSchemaIds");
                                if (!ArraysKt.contains((long[])this.$referencingSchemaIds, (long)schema2.getObjectId())) continue;
                                for (PgBaseRegularTable pgBaseRegularTable : schema2.getTables()) {
                                    PgBaseForeignKey fk;
                                    Iterator<T> iterator = pgBaseRegularTable.getForeignKeys().iterator();
                                    while (iterator.hasNext() && (fk = (PgBaseForeignKey)iterator.next()).getRefTable() != null) {
                                        BasicTable refTable;
                                        if (Intrinsics.areEqual((Object)schema2, (Object)refTable.getSchema())) continue;
                                        PgBaseModelHelper pgBaseModelHelper = this.this$0.getHelper();
                                        Intrinsics.checkNotNull((Object)fk);
                                        pgBaseModelHelper.resolveReference(fk, refTable);
                                    }
                                }
                            }
                        }
                    });
                }
            }
        }));
    }

    @Override
    protected void introspectTheServerObjects(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        IntrospectionMode mode = this.getServerIntrospectionMode();
        long stateNumber = mode.increment ? ((PgBaseRoot)this.getRoot()).getIntrospectionStateNumber() : 0L;
        boolean detectDropped = mode.increment;
        boolean loadNew = mode.full || this.loadNewServerObjects();
        this.setTx(this, stateNumber, "tx", "TXAGE");
        String string = IntrospectionMode.INCREMENT.code;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"code");
        this.setQueryParameter(string, mode.increment);
        this.introspectServerObjects(tran, detectDropped, loadNew);
    }

    private final IntrospectionMode getServerIntrospectionMode() {
        return ((PgBaseRoot)this.getRoot()).getIntrospectionStateNumber() != 0L && !this.getForbidIncremental() ? IntrospectionMode.INCREMENT : IntrospectionMode.FULL;
    }

    protected boolean loadNewServerObjects() {
        Long l = this.introspectionXid;
        long l2 = ((PgBaseRoot)this.getRoot()).getIntrospectionStateNumber();
        return l == null || l != l2;
    }

    private final void setTx(IntrospectionQueryContext $this$setTx, long stateNumber, String tx, String txage) {
        $this$setTx.setQueryParameter(tx, stateNumber);
        $this$setTx.setQueryParameter(txage, this.mapNegativeAgeToMax(this.generateDbAge(":" + tx)));
    }

    private final String mapNegativeAgeToMax(String age) {
        return "coalesce(nullif(greatest(" + age + ", -1), -1), 2147483647)";
    }

    @NotNull
    public abstract String generateDbAge(@NotNull String var1);

    private final void introspectServerObjects(DBTransaction trans, boolean detectDropped, boolean loadNew) {
        block1: {
            List<IntroStep> steps2 = this.steps(trans);
            CollectionsKt.sort(steps2);
            for (IntroStep step2 : steps2) {
                step2.getPerform().invoke((Object)detectDropped, (Object)loadNew);
            }
            Long l = this.introspectionXid;
            if (l == null) break block1;
            long xid = ((Number)l).longValue();
            boolean bl = false;
            this.inModel((Function1)new Function1<MR, Unit>(xid){
                final /* synthetic */ long $xid;
                {
                    this.$xid = $xid;
                    super(1);
                }

                public final void invoke(@NotNull MR it2) {
                    Intrinsics.checkNotNullParameter(it2, (String)"it");
                    it2.setIntrospectionStateNumber(this.$xid);
                }
            });
        }
    }

    @NotNull
    protected List<IntroStep> steps(@NotNull DBTransaction trans) {
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        return PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(new ArrayList(), 20, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this, trans){
            final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;
            final /* synthetic */ DBTransaction $trans;
            {
                this.this$0 = $receiver;
                this.$trans = $trans;
                super(2);
            }

            public final void invoke(boolean detectDropped, boolean loadNew) {
                this.this$0.retrieveSettings(this.$trans);
            }
        })), 30, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this, trans){
            final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;
            final /* synthetic */ DBTransaction $trans;
            {
                this.this$0 = $receiver;
                this.$trans = $trans;
                super(2);
            }

            public final void invoke(boolean detectDropped, boolean loadNew) {
                this.this$0.retrieveTimeZones(this.$trans);
            }
        })), 40, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this, trans){
            final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;
            final /* synthetic */ DBTransaction $trans;
            {
                this.this$0 = $receiver;
                this.$trans = $trans;
                super(2);
            }

            public final void invoke(boolean detectDropped, boolean loadNew) {
                this.this$0.retrieveComments(this.$trans, detectDropped, loadNew);
            }
        })), 100, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this, trans){
            final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;
            final /* synthetic */ DBTransaction $trans;
            {
                this.this$0 = $receiver;
                this.$trans = $trans;
                super(2);
            }

            public final void invoke(boolean detectDropped, boolean loadNew) {
                PgBaseIntrospector.access$retrieveAcls(this.this$0, this.$trans, detectDropped, loadNew);
            }
        }));
    }

    private final void retrieveAcls(DBTransaction tran, boolean detectDropped, boolean loadNew) {
        this.reportRetrieving("ACL", "introspection.retrieve.ACL");
        BaseNativeIntrospector this_$iv = this;
        boolean $i$f$continueOnDbError = false;
        try {
            boolean bl = false;
            this.inModel((Function1)new Function1<MR, Unit>(detectDropped, loadNew, this, tran){
                final /* synthetic */ boolean $detectDropped;
                final /* synthetic */ boolean $loadNew;
                final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;
                final /* synthetic */ DBTransaction $tran;
                {
                    this.$detectDropped = $detectDropped;
                    this.$loadNew = $loadNew;
                    this.this$0 = $receiver;
                    this.$tran = $tran;
                    super(1);
                }

                public final void invoke(@NotNull MR r) {
                    Intrinsics.checkNotNullParameter(r, (String)"r");
                    Grants.Controller<PgObjectGrant, ?> ctl = r.getGrants().getController();
                    List<PgObjectGrant> newGrants = r.getGrants().toMutableList();
                    if (this.$detectDropped) {
                        newGrants.removeIf(arg_0 -> retrieveAcls.1.1.invoke$lambda$0((Function1)new Function1<PgObjectGrant, Boolean>(ctl, r){
                            final /* synthetic */ Grants.Controller<PgObjectGrant, ?> $ctl;
                            final /* synthetic */ MR $r;
                            {
                                this.$ctl = $ctl;
                                this.$r = $r;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(PgObjectGrant it2) {
                                Grants.Grant grant = it2;
                                BasicElement basicElement = (BasicElement)this.$r;
                                BasicResolveAssistant basicResolveAssistant = BasicResolveAssistant.DEFAULT;
                                Intrinsics.checkNotNullExpressionValue((Object)basicResolveAssistant, (String)"DEFAULT");
                                return this.$ctl.findTarget((PgObjectGrant)grant, basicElement, basicResolveAssistant) == null;
                            }
                        }, arg_0));
                    }
                    if (this.$loadNew) {
                        Long l = r.getIntrospectionStateNumber();
                        boolean bl = this.$detectDropped;
                        long it2 = ((Number)l).longValue();
                        boolean bl2 = false;
                        Long tx = bl ? l : null;
                        Lexer lexer = PgBaseIntrospector.access$getSqlHelper(this.this$0).createLexer();
                        NamingService ns = NamingServices.getNamingService$default(this.this$0.dbms, this.this$0.getModel(), null, 4, null);
                        this.this$0.getQueries().processObjectAcls(this.$tran, (PgBaseRoot)r, tx, this.this$0.getNoDbXmin(), (Function1<? super PgBaseIntroQueries.OneAcl, Unit>)((Function1)new Function1<PgBaseIntroQueries.OneAcl, Unit>(this.this$0, lexer, ns, newGrants){
                            final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;
                            final /* synthetic */ Lexer $lexer;
                            final /* synthetic */ NamingService $ns;
                            final /* synthetic */ List<PgObjectGrant> $newGrants;
                            {
                                this.this$0 = $receiver;
                                this.$lexer = $lexer;
                                this.$ns = $ns;
                                this.$newGrants = $newGrants;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull PgBaseIntroQueries.OneAcl acl) {
                                block1: {
                                    void $this$forEach$iv;
                                    Intrinsics.checkNotNullParameter((Object)acl, (String)"acl");
                                    if (acl.acl == null) break block1;
                                    String[] stringArray = acl.acl;
                                    PgBaseIntrospector<MR, D, S> pgBaseIntrospector = this.this$0;
                                    Lexer lexer = this.$lexer;
                                    NamingService namingService2 = this.$ns;
                                    List<PgObjectGrant> list = this.$newGrants;
                                    boolean $i$f$forEach = false;
                                    int n = ((void)$this$forEach$iv).length;
                                    for (int j = 0; j < n; ++j) {
                                        void element$iv;
                                        void it2 = element$iv = $this$forEach$iv[j];
                                        boolean bl = false;
                                        PgAclItem pgAclItem = pgBaseIntrospector.parseAclItem(lexer, namingService2, (String)it2);
                                        if (pgAclItem == null) continue;
                                        pgAclItem.toGrants(acl.object_id, (Collection<PgObjectGrant>)list);
                                    }
                                }
                            }
                        }));
                    }
                    r.setGrants(r.getGrants().with((Iterable<PgObjectGrant>)newGrants));
                }

                private static final boolean invoke$lambda$0(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    return (Boolean)$tmp0.invoke(p0);
                }
            });
        }
        catch (DBException e$iv) {
            this_$iv.getErrorSink().consume(null, (Object)e$iv);
        }
    }

    protected void retrieveComments(@NotNull DBTransaction trans, boolean detectDropped, boolean loadNew) {
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
    }

    protected void retrieveSettings(@NotNull DBTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        BaseNativeIntrospector this_$iv = this;
        boolean $i$f$continueOnDbError = false;
        try {
            boolean bl = false;
            String dateStyle = this.performQuery(transaction, this.getQueries().getRetrieveDateStyle());
            this.inModel((Function1)new Function1<MR, Unit>(this, dateStyle){
                final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;
                final /* synthetic */ String $dateStyle;
                {
                    this.this$0 = $receiver;
                    this.$dateStyle = $dateStyle;
                    super(1);
                }

                public final void invoke(@NotNull MR root2) {
                    Intrinsics.checkNotNullParameter(root2, (String)"root");
                    root2.setDateStyle(PgBaseIntrospector.access$parseDateStyle(this.this$0, this.$dateStyle));
                }
            });
        }
        catch (DBException e$iv) {
            this_$iv.getErrorSink().consume(null, (Object)e$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void retrieveTimeZones(@NotNull DBTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        BaseNativeIntrospector this_$iv = this;
        boolean $i$f$continueOnDbError = false;
        try {
            Iterable iterable;
            boolean bl = false;
            try {
                void $this$mapTo$iv;
                List<PgBaseIntroQueries.OneTimeZone> list = this.performQuery(transaction, this.getQueries().getRetrieveTimeZones());
                Intrinsics.checkNotNullExpressionValue(list, (String)"performQuery(...)");
                iterable = list;
                Collection destination$iv = new ArrayList();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it2;
                    PgBaseIntroQueries.OneTimeZone oneTimeZone = (PgBaseIntroQueries.OneTimeZone)item$iv;
                    Collection collection2 = destination$iv;
                    boolean bl2 = false;
                    collection2.add(new PgTimeZone(it2.name, it2.is_dst));
                }
                iterable = destination$iv;
                ArrayList $this$retrieveTimeZones_u24lambda_u246_u24lambda_u245 = (ArrayList)iterable;
                boolean bl3 = false;
                List $this$sortBy$iv = $this$retrieveTimeZones_u24lambda_u246_u24lambda_u245;
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.size() > 1) {
                    CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b2) {
                            PgTimeZone it2 = (PgTimeZone)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)it2.getName());
                            it2 = (PgTimeZone)b2;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it2.getName())));
                        }
                    });
                }
                iterable = (List)iterable;
            }
            catch (Exception e2) {
                int[] nArray = new int[]{10};
                if (this.getServerVersion().isOrGreater(nArray)) {
                    throw e2;
                }
                this.log.warn((Throwable)e2);
                iterable = CollectionsKt.emptyList();
            }
            Iterable zones = iterable;
            this.inModel((Function1)new Function1<MR, Unit>((List<PgTimeZone>)zones){
                final /* synthetic */ List<PgTimeZone> $zones;
                {
                    this.$zones = $zones;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull MR root2) {
                    void $this$associateByTo$iv$iv;
                    void $this$associateBy$iv;
                    Intrinsics.checkNotNullParameter(root2, (String)"root");
                    Iterable iterable = this.$zones;
                    MR MR = root2;
                    boolean $i$f$associateBy = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                    void var5_6 = $this$associateBy$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                    boolean $i$f$associateByTo = false;
                    for (T element$iv$iv : $this$associateByTo$iv$iv) {
                        PgTimeZone pgTimeZone = (PgTimeZone)element$iv$iv;
                        Map map2 = destination$iv$iv;
                        boolean bl = false;
                        PgTimeZone it2 = (PgTimeZone)element$iv$iv;
                        String string = StringUtil.toLowerCase((String)it2.getName());
                        boolean bl2 = false;
                        PgTimeZone pgTimeZone2 = new PgTimeZone(it2.getName(), it2.isDST());
                        map2.put(string, pgTimeZone2);
                    }
                    MR.setTimeZones(destination$iv$iv);
                }
            });
        }
        catch (DBException e$iv) {
            this_$iv.getErrorSink().consume(null, (Object)e$iv);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final PgDateInputStyle parseDateStyle(String s2) {
        if (s2 == null) {
            return null;
        }
        int i2 = StringsKt.indexOf$default((CharSequence)s2, (String)",", (int)0, (boolean)false, (int)6, null);
        if (i2 < 0) {
            return null;
        }
        String string = s2.substring(i2 + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = StringUtil.toUpperCase((String)((Object)StringsKt.trim((CharSequence)string)).toString());
        if (string2 == null) return null;
        int n = -1;
        switch (string2.hashCode()) {
            case 67824: {
                if (string2.equals("DMY")) {
                    n = 1;
                }
                break;
            }
            case 87984: {
                if (string2.equals("YMD")) {
                    n = 2;
                }
                break;
            }
            case 76194: {
                if (string2.equals("MDY")) {
                    n = 3;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                PgDateInputStyle pgDateInputStyle = PgDateInputStyle.DMY;
                return pgDateInputStyle;
            }
            case 3: {
                PgDateInputStyle pgDateInputStyle = PgDateInputStyle.MDY;
                return pgDateInputStyle;
            }
            case 2: {
                PgDateInputStyle pgDateInputStyle = PgDateInputStyle.YMD;
                return pgDateInputStyle;
            }
            default: {
                return null;
            }
        }
    }

    @Override
    public void introspectDatabaseSchemas(BasicDatabase ... databases2) {
        Intrinsics.checkNotNullParameter((Object)databases2, (String)"databases");
        Iterable dbs2 = (Iterable)this.inTransaction((Function1)new Function1<DBTransaction, Iterable<? extends BasicDatabase>>(this, databases2){
            final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;
            final /* synthetic */ BasicDatabase[] $databases;
            {
                this.this$0 = $receiver;
                this.$databases = $databases;
                super(1);
            }

            @NotNull
            public final Iterable<BasicDatabase> invoke(@NotNull DBTransaction it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                return this.this$0.getDatabasesToIntrospect(it2, ArraysKt.toList((Object[])this.$databases));
            }
        });
        Collection $this$toTypedArray$iv = CollectionsKt.toList((Iterable)dbs2);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        BasicDatabase[] basicDatabaseArray = thisCollection$iv.toArray(new BasicDatabase[0]);
        super.introspectDatabaseSchemas(Arrays.copyOf(basicDatabaseArray, basicDatabaseArray.length));
    }

    @Override
    @NotNull
    protected Iterable<D> getDatabasesToIntrospect(@NotNull DBTransaction tran, @Nullable Collection<? extends BasicNamespace> namespaces2) {
        BasicDatabase connectionDatabase;
        block20: {
            block19: {
                boolean bl;
                block16: {
                    List databases2;
                    List list;
                    block18: {
                        block17: {
                            boolean bl2;
                            block15: {
                                Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
                                List list2 = namespaces2;
                                if (list2 == null || list2.isEmpty()) break block17;
                                Iterable $this$any$iv = namespaces2;
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl2 = false;
                                } else {
                                    for (Object element$iv : $this$any$iv) {
                                        BasicNamespace it2 = (BasicNamespace)element$iv;
                                        boolean bl3 = false;
                                        if (!(it2 instanceof PgBaseDatabase)) continue;
                                        bl2 = true;
                                        break block15;
                                    }
                                    bl2 = false;
                                }
                            }
                            if (!bl2) break block18;
                        }
                        this.introspectNamespacesInTran(tran);
                    }
                    if ((list = namespaces2) == null || (list = CollectionsKt.filterIsInstance((Iterable)list, PgBaseDatabase.class)) == null) {
                        list = databases2 = CollectionsKt.emptyList();
                    }
                    if ((connectionDatabase = this.connectionDatabase()) == null) break block19;
                    if (!(!((Collection)databases2).isEmpty())) break block20;
                    Iterable $this$all$iv = databases2;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            PgBaseDatabase it3 = (PgBaseDatabase)element$iv;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it3.getName(), (Object)connectionDatabase.getName())) continue;
                            bl = false;
                            break block16;
                        }
                        bl = true;
                    }
                }
                if (!bl) break block20;
            }
            JBIterable jBIterable = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
            return (Iterable)jBIterable;
        }
        JBIterable jBIterable = JBIterable.of((Object)((PgBaseLikeDatabase)connectionDatabase));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"of(...)");
        return (Iterable)jBIterable;
    }

    @Override
    @NotNull
    public Map<BasicElement, Boolean> checkElementsUptodate(@NotNull Iterable<? extends BasicElement> elements2) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        BasicElement basicElement = (BasicElement)CollectionsKt.firstOrNull(elements2);
        if (basicElement == null || (basicElement = basicElement.getDatabase()) == null) {
            return MapsKt.emptyMap();
        }
        BasicElement database = basicElement;
        LinkedHashMap<Object, Object> ids = new LinkedHashMap<Object, Object>();
        Iterable<? extends BasicElement> $this$forEach$iv = elements2;
        boolean $i$f$forEach = false;
        Iterator<? extends BasicElement> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            BasicElement element$iv;
            BasicElement it2 = element$iv = iterator.next();
            boolean bl = false;
            if (!PgBaseIntrospectorKt.canCheckOutdated(it2)) continue;
            Intrinsics.checkNotNull((Object)it2, (String)"null cannot be cast to non-null type com.intellij.database.dialects.postgresbase.model.PgBaseCatalogObject");
            PgBaseCatalogObject cfr_ignored_0 = (PgBaseCatalogObject)it2;
            if (!Intrinsics.areEqual((Object)database, (Object)((PgBaseCatalogObject)it2).getDatabase())) {
                this.log.error("Element from different database");
            }
            ((Map)ids).put(((PgBaseCatalogObject)it2).getObjectId(), it2);
        }
        if (ids.isEmpty()) {
            return MapsKt.emptyMap();
        }
        BaseNativeIntrospector baseNativeIntrospector = this;
        SqlQuery sqlQuery = this.getQueries().getRetrieveStates().rewrite(arg_0 -> PgBaseIntrospector.checkElementsUptodate$lambda$10(ids, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)sqlQuery, (String)"rewrite(...)");
        List states2 = (List)BaseNativeIntrospector.performQuery$default(baseNativeIntrospector, sqlQuery, null, 2, null);
        LinkedHashMap<BasicElement, Boolean> res2 = new LinkedHashMap<BasicElement, Boolean>();
        ids.forEach((arg_0, arg_1) -> PgBaseIntrospector.checkElementsUptodate$lambda$11((Function2)new Function2<Long, PgBaseCatalogObject, Unit>(res2){
            final /* synthetic */ LinkedHashMap<BasicElement, Boolean> $res;
            {
                this.$res = $res;
                super(2);
            }

            public final void invoke(@NotNull Long l, @NotNull PgBaseCatalogObject v2) {
                Intrinsics.checkNotNullParameter((Object)l, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
                ((Map)this.$res).put(v2, false);
            }
        }, arg_0, arg_1));
        Intrinsics.checkNotNull((Object)states2);
        Iterable $this$forEach$iv2 = states2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            PgBaseCatalogObject pgBaseCatalogObject;
            PgBaseIntroQueries.OneState s2 = (PgBaseIntroQueries.OneState)element$iv;
            boolean bl = false;
            if ((PgBaseCatalogObject)ids.get(s2.oid) == null) continue;
            Intrinsics.checkNotNull((Object)pgBaseCatalogObject);
            PgBaseCatalogObject obj2 = pgBaseCatalogObject;
            ((Map)res2).put(obj2, obj2.getStateNumber() == s2.xmin);
        }
        this.inModel((Function1)new Function1<MR, Unit>(res2){
            final /* synthetic */ LinkedHashMap<BasicElement, Boolean> $res;
            {
                this.$res = $res;
                super(1);
            }

            public final void invoke(@NotNull MR it2) {
                Intrinsics.checkNotNullParameter(it2, (String)"it");
                Set<Map.Entry<BasicElement, Boolean>> set = this.$res.entrySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)entry);
                    BasicElement obj2 = (BasicElement)entry.getKey();
                    Boolean ok2 = (Boolean)entry.getValue();
                    Intrinsics.checkNotNull((Object)obj2, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModElement");
                    ((BasicModElement)obj2).setOutdated(ok2 == false);
                }
            }
        });
        return res2;
    }

    protected final void freezeOnWrapAround(@NotNull String param, @NotNull Set<String> memory, @NotNull Function0<Integer> ageComputable) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        Intrinsics.checkNotNullParameter(memory, (String)"memory");
        Intrinsics.checkNotNullParameter(ageComputable, (String)"ageComputable");
        if (memory.contains(param)) {
            return;
        }
        int age = ((Number)ageComputable.invoke()).intValue();
        if (age >= 0 && age != Integer.MAX_VALUE) {
            return;
        }
        this.setQueryParameter(param, 2);
        ((Collection)memory).add(param);
    }

    private final Long getCurrentXid(DBTransaction tran) {
        return this.isItPossibleToRetrieveCurrentXid() ? this.performQuery(tran, this.getQueries().currentXid) : null;
    }

    protected boolean isItPossibleToRetrieveCurrentXid() {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    protected PgAclItem parseAclItem(@NotNull Lexer lex, @NotNull NamingService ns, @NotNull String item) {
        Intrinsics.checkNotNullParameter((Object)lex, (String)"lex");
        Intrinsics.checkNotNullParameter((Object)ns, (String)"ns");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        gp = "group ";
        isGroup = StringsKt.startsWith$default((String)item, (String)gp, (boolean)false, (int)2, null);
        v0 = so = isGroup != false ? gp.length() : 0;
        if (StringsKt.startsWith$default((CharSequence)item, (char)'=', (boolean)false, (int)2, null)) {
            v1 = 0;
        } else {
            lex.start((CharSequence)item, so, item.length());
            var9_7 = lex.getTokenEnd();
            it = ((Number)var9_7).intValue();
            $i$a$-takeIf-PgBaseIntrospector$parseAclItem$eq$1 = false;
            v1 = item.charAt(it) == '=' != false ? var9_7 : null;
            if (v1 == null) {
                var9_7 = StringsKt.indexOf$default((CharSequence)item, (char)'=', (int)0, (boolean)false, (int)6, null);
                it = ((Number)var9_7).intValue();
                $i$a$-takeIf-PgBaseIntrospector$parseAclItem$eq$2 = false;
                v1 = eq = it != -1 != false ? var9_7 : null;
            }
        }
        if (eq == null) {
            return null;
        }
        it = StringsKt.indexOf$default((CharSequence)item, (char)'/', (int)eq, (boolean)false, (int)4, null);
        it = ((Number)it).intValue();
        $i$a$-takeIf-PgBaseIntrospector$parseAclItem$sl$1 = 0;
        v2 = it != -1 != false ? it : null;
        sl = v2 != null ? v2.intValue() : item.length();
        $i$a$-takeIf-PgBaseIntrospector$parseAclItem$sl$1 = eq;
        v3 = item.substring(so, $i$a$-takeIf-PgBaseIntrospector$parseAclItem$sl$1);
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"substring(...)");
        it = v3;
        $i$a$-let-PgBaseIntrospector$parseAclItem$grantee$1 = false;
        it = StringsKt.startsWith$default((CharSequence)it, (char)'\\', (boolean)false, (int)2, null) ? StringUtil.unescapeStringCharacters((String)it) : it;
        $i$a$-let-PgBaseIntrospector$parseAclItem$grantee$2 = false;
        Intrinsics.checkNotNull((Object)it);
        v4 = StringKt.nullize$default((String)ns.unquoteIdentifier(it), (boolean)false, (int)1, null);
        if (v4 == null) {
            v4 = "public";
        }
        grantee = v4;
        v5 = this.getModel().getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getRoot(...)");
        v6 = PgObjectGrantController.INSTANCE.findGranteeId(v5, grantee);
        granteeId = v6 != null ? v6 : -9223372036854775807L;
        v7 = item.substring(eq + 1, sl);
        Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"substring(...)");
        privilegesText = v7;
        $this$mapIndexedNotNull$iv = privilegesText;
        $i$f$mapIndexedNotNull = false;
        var16_21 = $this$mapIndexedNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapIndexedNotNullTo = false;
        $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        $i$f$forEachIndexed = false;
        index$iv$iv$iv = 0;
        for (var22_31 = 0; var22_31 < $this$forEachIndexed$iv$iv$iv.length(); ++var22_31) {
            block13: {
                item$iv$iv$iv = $this$forEachIndexed$iv$iv$iv.charAt(var22_31);
                v8 = index$iv$iv$iv++;
                var24_33 = item$iv$iv$iv;
                index$iv$iv = v8;
                $i$a$-forEachIndexed-StringsKt___StringsKt$mapIndexedNotNullTo$1$iv$iv = false;
                var27_36 = element$iv$iv;
                i = index$iv$iv;
                $i$a$-mapIndexedNotNull-PgBaseIntrospector$parseAclItem$privileges$1 = false;
                if (c == 42) ** GOTO lbl-1000
                v9 = StringsKt.getOrNull((CharSequence)privilegesText, (int)(i + 1));
                var30_39 = '*';
                if (v9 != null && v9.charValue() == var30_39) lbl-1000:
                // 2 sources

                {
                    v10 = null;
                } else {
                    var31_40 = PgPrivilege.values();
                    var33_45 = var31_40.length;
                    for (var32_42 = 0; var32_42 < var33_45; ++var32_42) {
                        it = var34_46 = var31_40[var32_42];
                        $i$a$-find-PgBaseIntrospector$parseAclItem$privileges$1$1 = false;
                        if (!(it.getCode() == c)) continue;
                        v10 = var34_46;
                        break block13;
                    }
                    v10 = null;
                }
            }
            if (v10 == null) continue;
            it$iv$iv = v10;
            $i$a$-let-StringsKt___StringsKt$mapIndexedNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        privileges = (List)destination$iv$iv;
        $this$mapIndexedNotNull$iv = privilegesText;
        $i$f$mapIndexedNotNull = false;
        destination$iv$iv = $this$mapIndexedNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapIndexedNotNullTo = false;
        $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        $i$f$forEachIndexed = false;
        index$iv$iv$iv = 0;
        for (var23_32 = 0; var23_32 < $this$forEachIndexed$iv$iv$iv.length(); ++var23_32) {
            block14: {
                item$iv$iv$iv = $this$forEachIndexed$iv$iv$iv.charAt(var23_32);
                v11 = index$iv$iv$iv++;
                index$iv$iv = item$iv$iv$iv;
                index$iv$iv = v11;
                $i$a$-forEachIndexed-StringsKt___StringsKt$mapIndexedNotNullTo$1$iv$iv = false;
                i = element$iv$iv;
                i = index$iv$iv;
                $i$a$-mapIndexedNotNull-PgBaseIntrospector$parseAclItem$grantablePrivileges$1 = false;
                if (c == 42) ** GOTO lbl-1000
                v12 = StringsKt.getOrNull((CharSequence)privilegesText, (int)(i + 1));
                var31_41 = '*';
                if (v12 == null || v12.charValue() != var31_41) lbl-1000:
                // 2 sources

                {
                    v13 = null;
                } else {
                    var32_44 = PgPrivilege.values();
                    var34_47 = var32_44.length;
                    for (var33_45 = 0; var33_45 < var34_47; ++var33_45) {
                        it = var35_48 = var32_44[var33_45];
                        $i$a$-find-PgBaseIntrospector$parseAclItem$grantablePrivileges$1$1 = false;
                        if (!(it.getCode() == c)) continue;
                        v13 = var35_48;
                        break block14;
                    }
                    v13 = null;
                }
            }
            if (v13 == null) continue;
            it$iv$iv = v13;
            $i$a$-let-StringsKt___StringsKt$mapIndexedNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        grantablePrivileges = (List)destination$iv$iv;
        return new PgAclItem(granteeId, privileges, grantablePrivileges);
    }

    protected boolean isNameSurrogate(@NotNull BasicModColumniation columniation) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)columniation, (String)"columniation");
        BasicModColumniation basicModColumniation = columniation;
        if (basicModColumniation instanceof PgBaseKey) {
            String string = ((PgBaseKey)columniation).getName();
            DasTable dasTable = ((PgBaseKey)columniation).getTable();
            String string2 = dasTable != null ? dasTable.getName() : null;
            boolean bl2 = ((PgBaseKey)columniation).isPrimary();
            List<String> list = ((PgBaseKey)columniation).getColNames();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getColNames(...)");
            bl = Intrinsics.areEqual((Object)string, (Object)this.surrogateKeyName(string2, bl2, list));
        } else if (basicModColumniation instanceof PgBaseForeignKey) {
            String string = ((PgBaseForeignKey)columniation).getName();
            DasTable dasTable = ((PgBaseForeignKey)columniation).getTable();
            String string3 = dasTable != null ? dasTable.getName() : null;
            List<String> list = ((PgBaseForeignKey)columniation).getColNames();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getColNames(...)");
            bl = Intrinsics.areEqual((Object)string, (Object)(string3 + "_" + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"_", null, null, (int)0, null, null, (int)62, null) + "_fkey"));
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    protected final String surrogateKeyName(@Nullable String tableName, boolean primary, @NotNull List<String> colNames) {
        Intrinsics.checkNotNullParameter(colNames, (String)"colNames");
        return tableName + "_" + (String)(primary ? "pkey" : CollectionsKt.joinToString$default((Iterable)colNames, (CharSequence)"_", null, null, (int)0, null, null, (int)62, null) + "_key");
    }

    protected final boolean isColumnNameSurrogate(@Nullable String it2) {
        return it2 != null && StringsKt.startsWith$default((String)it2, (String)"?", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)it2, (String)"?", (boolean)false, (int)2, null);
    }

    @Nullable
    public final BasicReference createIdOrQNameRef(long id, @Nullable String name2, @Nullable String pDefault) {
        String string = name2;
        return BasicIdOrNameReference.create(BasicIdReference.create(PgBaseIntrospectorKt.nullizeOid(id)), string != null ? this.parseNameRef(string, pDefault) : null);
    }

    private final BasicReference parseNameRef(String $this$parseNameRef, String pDefault) {
        NamingService ns = NamingServices.getNamingService$default(this.dbms, null, null, 6, null);
        Lexer lexer = this.getSqlHelper().createLexer();
        Pair<String, String> pair = BasicParentReference.parseNameRef($this$parseNameRef, ns, lexer);
        Intrinsics.checkNotNullExpressionValue(pair, (String)"parseNameRef(...)");
        Pair<String, String> p2 = pair;
        String string = (String)p2.first;
        if (string == null) {
            string = pDefault;
        }
        Object object = p2.second;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
        return BasicParentReference.create(string, BasicNameReference.create(ns.unquoteIdentifier((String)object)));
    }

    private static final String checkElementsUptodate$lambda$10(LinkedHashMap $ids, String s2) {
        Intrinsics.checkNotNullParameter((Object)$ids, (String)"$ids");
        Intrinsics.checkNotNull((Object)s2);
        Set set = $ids.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        return StringsKt.replace$default((String)s2, (String)"OIDS", (String)CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, (Function1)checkElementsUptodate.states.1.1.INSTANCE, (int)31, null), (boolean)false, (int)4, null);
    }

    private static final void checkElementsUptodate$lambda$11(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ Long access$getCurrentXid(PgBaseIntrospector $this, DBTransaction tran) {
        return $this.getCurrentXid(tran);
    }

    public static final /* synthetic */ void access$retrieveAcls(PgBaseIntrospector $this, DBTransaction tran, boolean detectDropped, boolean loadNew) {
        $this.retrieveAcls(tran, detectDropped, loadNew);
    }

    public static final /* synthetic */ PgDateInputStyle access$parseDateStyle(PgBaseIntrospector $this, String s2) {
        return $this.parseDateStyle(s2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$Companion;", "", "()V", "FROZEN_TXID", "", "intellij.database.dialects.postgresbase"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0094\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0014J)\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00028\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0014J\b\u0010\u001c\u001a\u00020\rH\u0002J\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0014J\u0012\u0010\u001e\u001a\u00020\u001a2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010 \u001a\u00020\u001aH\u0014J\u0010\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#H\u0014J\u0018\u0010$\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u0018\u0010%\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0014J\u0018\u0010&\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0014J\b\u0010'\u001a\u00020\rH\u0016J\u0006\u0010(\u001a\u00020\rJ\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0014R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$DatabaseRetriever;", "D", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "(Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgresbase/model/PgBaseDatabase;)V", "myFrozen", "", "", "beforeServerAndDatabaseObjectsRetrieval", "", "findObjectById", "Lcom/intellij/database/model/basic/BasicModNamedElement;", "db", "kind", "", "id", "", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseDatabase;Ljava/lang/Character;J)Lcom/intellij/database/model/basic/BasicModNamedElement;", "getDatabaseIntrospectionMode", "Lcom/intellij/database/introspection/IntrospectionMode;", "introspectComments", "detectDropped", "", "loadNew", "introspectDatabase", "introspectDatabaseObjects", "isSystem", "name", "loadNewIntrospectDatabase", "removeDroppedDatabaseComments", "ids", "Lit/unimi/dsi/fastutil/longs/LongSet;", "retrieveAcls", "retrieveCasts", "retrieveLanguages", "retrieveSchemas", "retrieveServerAndDatabaseObjects", "steps", "", "Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "intellij.database.dialects.postgresbase"})
    @SourceDebugExtension(value={"SMAP\nPgBaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgBaseIntrospector.kt\ncom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$DatabaseRetriever\n+ 2 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1636:1\n620#2,2:1637\n623#2,4:1640\n620#2,7:1644\n1#3:1639\n*S KotlinDebug\n*F\n+ 1 PgBaseIntrospector.kt\ncom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$DatabaseRetriever\n*L\n312#1:1637,2\n312#1:1640,4\n378#1:1644,7\n*E\n"})
    protected static class DatabaseRetriever<D extends PgBaseDatabase>
    extends BaseMultiDatabaseIntrospector.BaseDatabaseRetriever<D> {
        @NotNull
        private final Set<String> myFrozen;
        final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;

        public DatabaseRetriever(@NotNull DBTransaction tran, D database) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter(database, (String)"database");
            this.this$0 = this$0;
            super((BaseMultiDatabaseIntrospector)this$0, tran, (BasicModMateDatabase)database);
            this.myFrozen = new HashSet();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveAcls(boolean detectDropped, boolean loadNew) {
            this.this$0.reportRetrieving("ACL", "introspection.retrieve.ACL");
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl = false;
                Grants.Controller<PgObjectGrant, ?> ctl = ((PgBaseDatabase)this.getDatabase()).getGrants().getController();
                List<PgObjectGrant> newGrants = ((PgBaseDatabase)this.getDatabase()).getGrants().toMutableList();
                if (detectDropped) {
                    newGrants.removeIf(arg_0 -> DatabaseRetriever.retrieveAcls$lambda$2$lambda$0((Function1)new Function1<PgObjectGrant, Boolean>(ctl, this){
                        final /* synthetic */ Grants.Controller<PgObjectGrant, ?> $ctl;
                        final /* synthetic */ DatabaseRetriever<D> this$0;
                        {
                            this.$ctl = $ctl;
                            this.this$0 = $receiver;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(PgObjectGrant it2) {
                            Grants.Grant grant = it2;
                            BasicElement basicElement = DatabaseRetriever.access$getDatabase(this.this$0);
                            BasicResolveAssistant basicResolveAssistant = BasicResolveAssistant.DEFAULT;
                            Intrinsics.checkNotNullExpressionValue((Object)basicResolveAssistant, (String)"DEFAULT");
                            return this.$ctl.findTarget((PgObjectGrant)grant, basicElement, basicResolveAssistant) == null;
                        }
                    }, arg_0));
                }
                if (loadNew) {
                    Long l = ((PgBaseDatabase)this.getDatabase()).getIntrospectionStateNumber();
                    long it2 = ((Number)l).longValue();
                    boolean bl2 = false;
                    Long tx = detectDropped ? l : null;
                    Lexer lexer = pgBaseIntrospector.getSqlHelper().createLexer();
                    NamingService ns = NamingServices.getNamingService(pgBaseIntrospector.dbms, this.getModel(), (BasicDatabase)this.getDatabase());
                    pgBaseIntrospector.getQueries().processObjectAcls(this.getTransaction(), (PgBaseDatabase)this.getDatabase(), tx, (Function1<? super PgBaseIntroQueries.OneAcl, Unit>)((Function1)new Function1<PgBaseIntroQueries.OneAcl, Unit>(newGrants, pgBaseIntrospector, lexer, ns){
                        final /* synthetic */ List<PgObjectGrant> $newGrants;
                        final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;
                        final /* synthetic */ Lexer $lexer;
                        final /* synthetic */ NamingService $ns;
                        {
                            this.$newGrants = $newGrants;
                            this.this$0 = $receiver;
                            this.$lexer = $lexer;
                            this.$ns = $ns;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull PgBaseIntroQueries.OneAcl acl) {
                            block1: {
                                void $this$forEach$iv;
                                Intrinsics.checkNotNullParameter((Object)acl, (String)"acl");
                                this.$newGrants.removeIf(arg_0 -> retrieveAcls.1.2.invoke$lambda$0((Function1)new Function1<PgObjectGrant, Boolean>(acl){
                                    final /* synthetic */ PgBaseIntroQueries.OneAcl $acl;
                                    {
                                        this.$acl = $acl;
                                        super(1);
                                    }

                                    @NotNull
                                    public final Boolean invoke(PgObjectGrant it2) {
                                        return it2.getObjectId() == this.$acl.object_id;
                                    }
                                }, arg_0));
                                if (acl.acl == null) break block1;
                                String[] stringArray = acl.acl;
                                PgBaseIntrospector<MR, D, S> pgBaseIntrospector = this.this$0;
                                Lexer lexer = this.$lexer;
                                NamingService namingService2 = this.$ns;
                                List<PgObjectGrant> list = this.$newGrants;
                                boolean $i$f$forEach = false;
                                int n = ((void)$this$forEach$iv).length;
                                for (int j = 0; j < n; ++j) {
                                    void element$iv;
                                    void it2 = element$iv = $this$forEach$iv[j];
                                    boolean bl = false;
                                    PgAclItem pgAclItem = pgBaseIntrospector.parseAclItem(lexer, namingService2, (String)it2);
                                    if (pgAclItem == null) continue;
                                    pgAclItem.toGrants(acl.object_id, (Collection<PgObjectGrant>)list);
                                }
                            }
                        }

                        private static final boolean invoke$lambda$0(Function1 $tmp0, Object p0) {
                            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                            return (Boolean)$tmp0.invoke(p0);
                        }
                    }));
                }
                ((PgBaseDatabase)this.getDatabase()).setGrants(((PgBaseDatabase)this.getDatabase()).getGrants().with((Iterable<PgObjectGrant>)newGrants));
            }
            catch (DBException e$iv) {
                void this_$iv;
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
        }

        @Override
        public final void retrieveServerAndDatabaseObjects() {
            block0: {
                super.retrieveServerAndDatabaseObjects();
                this.introspectDatabase();
                Long l = this.this$0.getIntrospectionXid();
                if (l == null) break block0;
                long xid = ((Number)l).longValue();
                boolean bl = false;
                this.inDatabase((Function1)new Function1<D, Unit>(xid){
                    final /* synthetic */ long $xid;
                    {
                        this.$xid = $xid;
                        super(1);
                    }

                    public final void invoke(@NotNull D it2) {
                        Intrinsics.checkNotNullParameter(it2, (String)"it");
                        it2.setIntrospectionStateNumber(this.$xid);
                    }
                });
            }
        }

        @Override
        protected void beforeServerAndDatabaseObjectsRetrieval() {
            IntrospectionMode mode = this.getDatabaseIntrospectionMode();
            this.this$0.setTx(this, ((PgBaseDatabase)this.getDatabase()).getIntrospectionStateNumber(), "tx", "TXAGE");
            String string = IntrospectionMode.INCREMENT.code;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"code");
            this.setQueryParameter(string, mode.increment);
        }

        private final IntrospectionMode getDatabaseIntrospectionMode() {
            return ((PgBaseDatabase)this.getDatabase()).getIntrospectionStateNumber() != 0L && !this.this$0.getForbidIncremental() ? IntrospectionMode.INCREMENT : IntrospectionMode.FULL;
        }

        protected void removeDroppedDatabaseComments(@NotNull LongSet ids) {
            Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
            this.inDatabase((Function1)new Function1<D, Unit>(ids){
                final /* synthetic */ LongSet $ids;
                {
                    this.$ids = $ids;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull D db2) {
                    void $this$forEach$iv;
                    Intrinsics.checkNotNullParameter(db2, (String)"db");
                    ModNamingIdentifyingFamily<? extends PgBaseLanguage> modNamingIdentifyingFamily = db2.getLanguages();
                    Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getLanguages(...)");
                    Iterable iterable = modNamingIdentifyingFamily;
                    LongSet longSet = this.$ids;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        PgBaseLanguage it2 = (PgBaseLanguage)element$iv;
                        boolean bl = false;
                        if (longSet.contains(it2.getObjectId())) continue;
                        it2.setComment(null);
                    }
                }
            });
        }

        private final void introspectDatabase() {
            IntrospectionMode mode = this.getDatabaseIntrospectionMode();
            boolean detectDropped = mode.increment;
            boolean loadNew = mode.full || this.loadNewIntrospectDatabase();
            this.introspectDatabaseObjects(detectDropped, loadNew);
        }

        protected boolean loadNewIntrospectDatabase() {
            Long l = this.this$0.getIntrospectionXid();
            long l2 = ((PgBaseDatabase)this.getDatabase()).getIntrospectionStateNumber();
            return l == null || l != l2;
        }

        @NotNull
        protected List<IntroStep> steps() {
            return PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(new ArrayList(), 10, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this){
                final /* synthetic */ DatabaseRetriever<D> this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(boolean detectDropped, boolean loadNew) {
                    this.this$0.retrieveLanguages(detectDropped, loadNew);
                }
            })), 20, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this){
                final /* synthetic */ DatabaseRetriever<D> this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(boolean detectDropped, boolean loadNew) {
                    this.this$0.introspectComments(detectDropped, loadNew);
                }
            })), 30, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this){
                final /* synthetic */ DatabaseRetriever<D> this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(boolean detectDropped, boolean loadNew) {
                    DatabaseRetriever.access$retrieveAcls(this.this$0, detectDropped, loadNew);
                }
            })), 40, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this){
                final /* synthetic */ DatabaseRetriever<D> this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(boolean detectDropped, boolean loadNew) {
                    this.this$0.retrieveCasts(detectDropped, loadNew);
                }
            }));
        }

        protected void introspectDatabaseObjects(boolean detectDropped, boolean loadNew) {
            List<IntroStep> steps2 = this.steps();
            CollectionsKt.sort(steps2);
            for (IntroStep step2 : steps2) {
                step2.getPerform().invoke((Object)detectDropped, (Object)loadNew);
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void introspectComments(boolean detectDropped, boolean loadNew) {
            this.this$0.reportRetrieving("comments", "introspection.retrieve.comments");
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl = false;
                LongOpenHashSet commentsIds = detectDropped ? new LongOpenHashSet(this.performQuery(pgBaseIntrospector.getQueries().getListExistentDatabaseComments())) : new LongOpenHashSet();
                this.removeDroppedDatabaseComments((LongSet)commentsIds);
                if (loadNew) {
                    this.inDatabase((Function1)new Function1<D, Unit>(this, pgBaseIntrospector){
                        final /* synthetic */ DatabaseRetriever<D> this$0;
                        final /* synthetic */ PgBaseIntrospector<MR, D, S> this$1;
                        {
                            this.this$0 = $receiver;
                            this.this$1 = $receiver2;
                            super(1);
                        }

                        public final void invoke(@NotNull D db2) {
                            Intrinsics.checkNotNullParameter(db2, (String)"db");
                            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this.this$0, this.this$1.getQueries().getRetrieveDatabaseComments(), 0, (Function1)new Function1<PgBaseIntroQueries.OneComment, Unit>(this.this$0, db2){
                                final /* synthetic */ DatabaseRetriever<D> this$0;
                                final /* synthetic */ D $db;
                                {
                                    this.this$0 = $receiver;
                                    this.$db = $db;
                                    super(1);
                                }

                                public final void invoke(@NotNull PgBaseIntroQueries.OneComment it2) {
                                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                                    BasicModNamedElement basicModNamedElement = this.this$0.findObjectById(this.$db, it2.kind, it2.id);
                                    if (basicModNamedElement == null) {
                                        return;
                                    }
                                    BasicModNamedElement obj2 = basicModNamedElement;
                                    obj2.setComment(it2.description);
                                }
                            }, 2, null);
                        }
                    });
                }
            }
            catch (DBException e$iv) {
                void this_$iv;
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
        }

        @Nullable
        protected BasicModNamedElement findObjectById(@NotNull D db2, @Nullable Character kind, long id) {
            BasicModNamedElement basicModNamedElement;
            Character c2;
            Intrinsics.checkNotNullParameter(db2, (String)"db");
            Character c3 = c2 = kind;
            char c4 = 'L';
            if (c3 != null && c3.charValue() == c4) {
                basicModNamedElement = (BasicModNamedElement)db2.getLanguages().getByObjectId(id);
            } else {
                Character c5 = c2;
                c4 = 'C';
                basicModNamedElement = c5 != null && c5.charValue() == c4 ? (BasicModNamedElement)db2.getCasts().getByObjectId(id) : null;
            }
            return basicModNamedElement;
        }

        protected void retrieveLanguages(boolean detectDropped, boolean loadNew) {
            this.inDatabase((Function1)new Function1<D, Unit>(this.this$0, detectDropped, this, loadNew){
                final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;
                final /* synthetic */ boolean $detectDropped;
                final /* synthetic */ DatabaseRetriever<D> this$1;
                final /* synthetic */ boolean $loadNew;
                {
                    this.this$0 = $receiver;
                    this.$detectDropped = $detectDropped;
                    this.this$1 = $receiver2;
                    this.$loadNew = $loadNew;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull D db2) {
                    void $this$modifyAndCleanup_u24default$iv;
                    Intrinsics.checkNotNullParameter(db2, (String)"db");
                    ModFamily modFamily = db2.getLanguages();
                    PgBaseIntrospector<MR, D, S> pgBaseIntrospector = this.this$0;
                    boolean bl = this.$detectDropped;
                    DatabaseRetriever<D> databaseRetriever = this.this$1;
                    boolean bl2 = this.$loadNew;
                    boolean inc$iv = true;
                    boolean $i$f$modifyAndCleanup = false;
                    $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                    ModNamingIdentifyingFamily languages2 = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
                    boolean bl3 = false;
                    BaseNativeIntrospector this_$iv = pgBaseIntrospector;
                    boolean $i$f$continueOnDbError = false;
                    try {
                        boolean bl4 = false;
                        if (bl) {
                            long[] $this$forEach$iv = (long[])DatabaseRetriever.access$performQuery(databaseRetriever, pgBaseIntrospector.getQueries().getListExistentLanguages());
                            boolean $i$f$forEach = false;
                            int n = $this$forEach$iv.length;
                            for (int j = 0; j < n; ++j) {
                                long element$iv;
                                long it2 = element$iv = $this$forEach$iv[j];
                                boolean bl5 = false;
                                PgBaseLanguage pgBaseLanguage = (PgBaseLanguage)languages2.getByObjectId(it2);
                                if (pgBaseLanguage != null) {
                                    pgBaseLanguage.resetSyncPending();
                                }
                            }
                        }
                        if (bl2) {
                            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(databaseRetriever, pgBaseIntrospector.getQueries().getListLanguages(), 0, (Function1)new Function1<PgBaseIntroQueries.OneLanguage, Unit>((ModNamingIdentifyingFamily<? extends PgBaseLanguage>)languages2){
                                final /* synthetic */ ModNamingIdentifyingFamily<? extends PgBaseLanguage> $languages;
                                {
                                    this.$languages = $languages;
                                    super(1);
                                }

                                public final void invoke(@NotNull PgBaseIntroQueries.OneLanguage it2) {
                                    PgBaseLanguage pgBaseLanguage;
                                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                                    PgBaseLanguage $this$invoke_u24lambda_u240 = pgBaseLanguage = this.$languages.renew(it2.id, it2.name);
                                    boolean bl = false;
                                    $this$invoke_u24lambda_u240.setStateNumber(it2.state_number);
                                    $this$invoke_u24lambda_u240.setTrusted(it2.trusted);
                                    $this$invoke_u24lambda_u240.setHandlerName(it2.handler);
                                    $this$invoke_u24lambda_u240.setHandlerSchema(it2.handlerSchema);
                                    $this$invoke_u24lambda_u240.setInlineHandlerName(it2.inline);
                                    $this$invoke_u24lambda_u240.setInlineHandlerSchema(it2.inlineSchema);
                                    $this$invoke_u24lambda_u240.setValidatorName(it2.validator);
                                    $this$invoke_u24lambda_u240.setValidatorSchema(it2.validatorSchema);
                                }
                            }, 2, null);
                        }
                    }
                    catch (DBException e$iv) {
                        this_$iv.getErrorSink().consume(null, (Object)((Object)e$iv));
                    }
                    $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                    $this$modifyAndCleanup_u24default$iv.sort();
                }
            });
        }

        protected void retrieveCasts(boolean detectDropped, boolean loadNew) {
            ObjectKind objectKind = ObjectKind.CAST;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"CAST");
            this.this$0.reportRetrieving(objectKind);
            this.inDatabase((Function1)new Function1<D, Unit>(this.this$0, detectDropped, this, loadNew){
                final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;
                final /* synthetic */ boolean $detectDropped;
                final /* synthetic */ DatabaseRetriever<D> this$1;
                final /* synthetic */ boolean $loadNew;
                {
                    this.this$0 = $receiver;
                    this.$detectDropped = $detectDropped;
                    this.this$1 = $receiver2;
                    this.$loadNew = $loadNew;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull D db2) {
                    void $this$modifyAndCleanup_u24default$iv;
                    Intrinsics.checkNotNullParameter(db2, (String)"db");
                    ModFamily modFamily = db2.getCasts();
                    PgBaseIntrospector<MR, D, S> pgBaseIntrospector = this.this$0;
                    boolean bl = this.$detectDropped;
                    DatabaseRetriever<D> databaseRetriever = this.this$1;
                    boolean bl2 = this.$loadNew;
                    boolean inc$iv = true;
                    boolean $i$f$modifyAndCleanup = false;
                    $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                    ModNamingIdentifyingFamily casts = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
                    boolean bl3 = false;
                    BaseNativeIntrospector this_$iv = pgBaseIntrospector;
                    boolean $i$f$continueOnDbError = false;
                    try {
                        boolean bl4 = false;
                        if (bl) {
                            long[] $this$forEach$iv = (long[])DatabaseRetriever.access$performQuery(databaseRetriever, pgBaseIntrospector.getQueries().getListExistentCasts());
                            boolean $i$f$forEach = false;
                            int n = $this$forEach$iv.length;
                            for (int j = 0; j < n; ++j) {
                                long element$iv;
                                long it2 = element$iv = $this$forEach$iv[j];
                                boolean bl5 = false;
                                PgBaseCast pgBaseCast = (PgBaseCast)casts.getByObjectId(it2);
                                if (pgBaseCast != null) {
                                    pgBaseCast.resetSyncPending();
                                }
                            }
                        }
                        if (bl2) {
                            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(databaseRetriever, pgBaseIntrospector.getQueries().getListCasts(), 0, (Function1)new Function1<PgBaseIntroQueries.OneCast, Unit>((ModNamingIdentifyingFamily<? extends PgBaseCast>)casts, pgBaseIntrospector){
                                final /* synthetic */ ModNamingIdentifyingFamily<? extends PgBaseCast> $casts;
                                final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;
                                {
                                    this.$casts = $casts;
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                public final void invoke(@NotNull PgBaseIntroQueries.OneCast m) {
                                    Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                                    PgBaseCast cast = (PgBaseCast)this.$casts.createOrGet(m.oid);
                                    cast.setStateNumber(m.state_number);
                                    cast.setSourceTypeRef(this.this$0.createIdOrQNameRef(m.castsource_id, m.castsource_name, PgBaseIntrospector.access$getDbConnectionInfo(this.this$0).schemaName));
                                    cast.setTargetTypeRef(this.this$0.createIdOrQNameRef(m.casttarget_id, m.casttarget_name, PgBaseIntrospector.access$getDbConnectionInfo(this.this$0).schemaName));
                                    cast.setCastFunctionRef(this.this$0.createIdOrQNameRef(m.castfunc_id, m.castfunc_name, PgBaseIntrospector.access$getDbConnectionInfo(this.this$0).schemaName));
                                    char c2 = m.castmethod;
                                    cast.setMethod(c2 == 'f' ? PgCastMethod.FUNCTION : (c2 == 'i' ? PgCastMethod.IO : (c2 == 'b' ? PgCastMethod.BINARY : null)));
                                    c2 = m.castcontext;
                                    cast.setContext(c2 == 'e' ? PgCastContext.EXPLICIT : (c2 == 'a' ? PgCastContext.ASSIGNMENT : (c2 == 'i' ? PgCastContext.IMPLICIT : null)));
                                }
                            }, 2, null);
                        }
                    }
                    catch (DBException e$iv) {
                        this_$iv.getErrorSink().consume(null, (Object)((Object)e$iv));
                    }
                    $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                    $this$modifyAndCleanup_u24default$iv.sort();
                }
            });
        }

        @Override
        public void retrieveSchemas() {
            super.retrieveSchemas();
            if (!Intrinsics.areEqual((Object)((PgBaseDatabase)this.getDatabase()).getName(), (Object)((PgBaseIntrospector)this.this$0).getDbConnectionInfo().databaseName)) {
                return;
            }
            List<PgBaseIntroQueries.IdNameCommentOwner> scs = this.performQuery(this.this$0.getQueries().getListSchemas());
            this.inDatabase((Function1)new Function1<D, Unit>(scs, this.this$0, this){
                final /* synthetic */ List<PgBaseIntroQueries.IdNameCommentOwner> $scs;
                final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;
                final /* synthetic */ DatabaseRetriever<D> this$1;
                {
                    this.$scs = $scs;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull D db2) {
                    void scs$iv;
                    void $this$applySchemasImpl$iv;
                    Intrinsics.checkNotNullParameter(db2, (String)"db");
                    ModNamingFamily modNamingFamily = db2.getSchemas();
                    Intrinsics.checkNotNullExpressionValue((Object)modNamingFamily, (String)"getSchemas(...)");
                    ModNamingFamily modNamingFamily2 = modNamingFamily;
                    List<PgBaseIntroQueries.IdNameCommentOwner> list = this.$scs;
                    PgBaseIntrospector<MR, D, S> pgBaseIntrospector = this.this$0;
                    DatabaseRetriever<D> databaseRetriever = this.this$1;
                    List<PgBaseIntroQueries.IdNameCommentOwner> list2 = this.$scs;
                    boolean $i$f$applySchemasImpl = false;
                    $this$applySchemasImpl$iv.markChildrenAsSyncPending();
                    Iterable $this$forEach$iv$iv = (Iterable)scs$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void sc2;
                        T element$iv$iv;
                        T sc$iv = element$iv$iv = iterator.next();
                        boolean bl = false;
                        PgBaseIntroQueries.IdNameCommentOwner idNameCommentOwner = (PgBaseIntroQueries.IdNameCommentOwner)sc$iv;
                        void $this$invoke_u24lambda_u241 = $this$applySchemasImpl$iv;
                        boolean bl2 = false;
                        if (!pgBaseIntrospector.getShowSystemScs() && DatabaseRetriever.access$isSystem(databaseRetriever, sc2.name)) continue;
                        E e2 = db2.getSchemas().renew(sc2.id, sc2.name);
                        PgBaseSchema $this$invoke_u24lambda_u241_u24lambda_u240 = (PgBaseSchema)e2;
                        boolean bl3 = false;
                        $this$invoke_u24lambda_u241_u24lambda_u240.setStateNumber(sc2.state_number);
                        $this$invoke_u24lambda_u241_u24lambda_u240.setComment(sc2.description);
                        $this$invoke_u24lambda_u241_u24lambda_u240.setOwnerRef(BasicNameReference.create(sc2.getOwnerName()));
                        PgBaseIntroQueries.IdNameCommentOwner idNameCommentOwner2 = (PgBaseIntroQueries.IdNameCommentOwner)CollectionsKt.firstOrNull(list2);
                        $this$invoke_u24lambda_u241_u24lambda_u240.setCurrent(idNameCommentOwner2 != null ? idNameCommentOwner2.id == $this$invoke_u24lambda_u241_u24lambda_u240.getObjectId() : false);
                    }
                    $this$applySchemasImpl$iv.removeSyncPendingChildren();
                    $this$applySchemasImpl$iv.sort();
                }
            });
        }

        private final boolean isSystem(String name2) {
            return name2 != null && (StringsKt.startsWith$default((String)name2, (String)"pg_temp", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name2, (String)"pg_toast", (boolean)false, (int)2, null));
        }

        private static final boolean retrieveAcls$lambda$2$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ void access$retrieveAcls(DatabaseRetriever $this, boolean detectDropped, boolean loadNew) {
            $this.retrieveAcls(detectDropped, loadNew);
        }

        public static final /* synthetic */ Object access$performQuery(DatabaseRetriever $this, SqlQuery query) {
            return $this.performQuery(query);
        }

        public static final /* synthetic */ boolean access$isSystem(DatabaseRetriever $this, String name2) {
            return $this.isSystem(name2);
        }

        public static final /* synthetic */ PgBaseDatabase access$getDatabase(DatabaseRetriever $this) {
            return (PgBaseDatabase)$this.getDatabase();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0094\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$NativeRetriever;", "D", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseNativeRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "(Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeDatabase;)V", "intellij.database.dialects.postgresbase"})
    protected static class NativeRetriever<D extends PgBaseLikeDatabase>
    extends BaseMultiDatabaseIntrospector.BaseNativeRetriever<D> {
        final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;

        public NativeRetriever(@NotNull DBTransaction tran, D database) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter(database, (String)"database");
            this.this$0 = this$0;
            super((BaseMultiDatabaseIntrospector)this$0, tran, (BasicModMateDatabase)database);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e2\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00a4\u0004\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u001e\u0012\u0004\u0012\u0002H\u00010\u0003R\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004B\u0017\b\u0014\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\b\u0010\"\u001a\u0004\u0018\u00010\u000bH\u0014J\b\u0010#\u001a\u00020$H\u0014J\u001f\u0010%\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030'0&2\u0006\u0010(\u001a\u00020)H\u0014\u00a2\u0006\u0002\u0010*J\u001d\u0010+\u001a\u00020,2\u0006\u0010\u0007\u001a\u00028\u00032\u0006\u0010-\u001a\u00020.H\u0014\u00a2\u0006\u0002\u0010/J)\u00100\u001a\u0004\u0018\u0001012\u0006\u0010\u0007\u001a\u00028\u00032\b\u0010!\u001a\u0004\u0018\u00010 2\u0006\u00102\u001a\u00020\u0010H\u0014\u00a2\u0006\u0002\u00103J\b\u00104\u001a\u00020$H\u0014J\u0012\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u000208H\u0014J#\u00109\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020;0:0&2\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010<J\b\u0010=\u001a\u00020\u0010H\u0014J'\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010\u0007\u001a\u00028\u00032\u0006\u0010@\u001a\u00020 2\u0006\u0010A\u001a\u00020\u0010H\u0014\u00a2\u0006\u0002\u0010BJ(\u0010C\u001a\u00020$2\u0006\u0010(\u001a\u00020?2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\u000b2\u0006\u0010G\u001a\u00020\u000bH\u0014J \u0010C\u001a\u00020$2\u0006\u0010(\u001a\u00020?2\u0006\u0010F\u001a\u00020\u000b2\u0006\u0010H\u001a\u00020\u000bH\u0014J\u0010\u0010I\u001a\u00020\r2\u0006\u0010J\u001a\u00020KH\u0014J\b\u0010L\u001a\u00020\rH\u0014J\b\u0010M\u001a\u00020\rH\u0014J\u001d\u0010N\u001a\u00020\r2\u0006\u0010O\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0003H\u0016\u00a2\u0006\u0002\u0010PJ\u0010\u0010Q\u001a\u00020\r2\u0006\u0010!\u001a\u00020 H\u0014J\u0014\u0010R\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020T0&0SH$J\u0015\u0010U\u001a\u00020$2\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010VJ\b\u0010W\u001a\u00020$H\u0014J0\u0010X\u001a\b\u0012\u0004\u0012\u00020\u000b0Y2\b\u0010Z\u001a\u0004\u0018\u00010\u000b2\u0006\u0010[\u001a\u00020\u000b2\u000e\u0010\\\u001a\n\u0012\u0006\b\u0001\u0012\u00020^0]H\u0004J\b\u0010_\u001a\u00020$H\u0014J\u0006\u0010`\u001a\u00020$J\u001e\u0010a\u001a\u0004\u0018\u00010?2\b\u0010b\u001a\u0004\u0018\u00010?2\b\u0010c\u001a\u0004\u0018\u00010?H\u0014J\u0018\u0010d\u001a\u00020$2\u0006\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020hH\u0014J)\u0010i\u001a\u00020$\"\b\b\u0004\u0010j*\u00020k2\u0006\u0010l\u001a\u0002Hj2\b\u0010m\u001a\u0004\u0018\u00010 H\u0016\u00a2\u0006\u0002\u0010nJ0\u0010o\u001a\u00020$\"\b\b\u0004\u0010j*\u00020k2\u0006\u0010-\u001a\u00020p2\f\u0010q\u001a\b\u0012\u0004\u0012\u0002Hj0r2\u0006\u0010s\u001a\u00020tH\u0002J\u0018\u0010u\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u0010J\u001a\u00020KH\u0014J0\u0010v\u001a\u00020$2\u0006\u0010w\u001a\u00020x2\u0006\u0010y\u001a\u00020z2\u000e\u0010\\\u001a\n\u0012\u0006\b\u0001\u0012\u00020z0r2\u0006\u0010(\u001a\u00020?H\u0014J#\u0010{\u001a\u00020$2\f\u0010|\u001a\b\u0012\u0004\u0012\u00020x0}2\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0002\u0010~J*\u0010\u007f\u001a\u00020$2\b\u0010\u0080\u0001\u001a\u00030\u0081\u00012\b\u0010\u0082\u0001\u001a\u00030\u0083\u00012\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0003\u0010\u0084\u0001J1\u0010\u0085\u0001\u001a\u00020$2\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\u0006\u0010(\u001a\u00020)2\u0006\u0010J\u001a\u00020K2\u0006\u0010\u0007\u001a\u00028\u0003H\u0014\u00a2\u0006\u0003\u0010\u0088\u0001J\u001a\u0010\u0089\u0001\u001a\u00020$2\u0007\u0010\u008a\u0001\u001a\u00020,2\u0006\u00107\u001a\u000208H\u0002J\u001a\u0010\u008b\u0001\u001a\u00020$2\u0007\u0010\u008a\u0001\u001a\u00020,2\u0006\u00107\u001a\u000208H\u0014J#\u0010\u008c\u0001\u001a\u00020$2\b\u0010\u008d\u0001\u001a\u00030\u008e\u00012\u0006\u0010(\u001a\u00020)2\u0006\u0010J\u001a\u00020KH\u0014J\u001b\u0010\u008f\u0001\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\b\u0010\u0090\u0001\u001a\u00030\u0091\u0001H$J\u001b\u0010\u0092\u0001\u001a\u00020$2\u0006\u0010(\u001a\u00020?2\b\u0010\u0090\u0001\u001a\u00030\u0091\u0001H$J\u001d\u0010\u0093\u0001\u001a\u00020$2\b\u0010\u0094\u0001\u001a\u00030\u0095\u00012\b\u0010\u0096\u0001\u001a\u00030\u0097\u0001H\u0014J\t\u0010\u0098\u0001\u001a\u00020$H\u0016J!\u0010\u0099\u0001\u001a\u00020$2\u0006\u0010\u0007\u001a\u00028\u00032\b\u0010\u0090\u0001\u001a\u00030\u0091\u0001H\u0004\u00a2\u0006\u0003\u0010\u009a\u0001J)\u0010\u0099\u0001\u001a\u00020$2\u0006\u0010(\u001a\u00020?2\u0006\u0010\u0007\u001a\u00028\u00032\b\u0010\u009b\u0001\u001a\u00030\u0091\u0001H\u0014\u00a2\u0006\u0003\u0010\u009c\u0001J\u001f\u0010\u009d\u0001\u001a\u00020$2\t\u0010\u009e\u0001\u001a\u0004\u0018\u00010?2\t\u0010\u009f\u0001\u001a\u0004\u0018\u00010\u000bH\u0014J'\u0010\u00a0\u0001\u001a\u00020$2\u0013\u0010\u00a1\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020T0&0S2\u0007\u0010\u00a2\u0001\u001a\u00020;H\u0014J\u001e\u0010\u00a3\u0001\u001a\u00020$2\u0013\u0010\u00a1\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020T0&0SH\u0002J3\u0010\u00a4\u0001\u001a\u0004\u0018\u00010?2\u0006\u0010\u0007\u001a\u00028\u00032\u0006\u0010@\u001a\u00020 2\u0007\u0010\u00a5\u0001\u001a\u00020\u00102\u0007\u0010\u00a6\u0001\u001a\u00020\u000bH\u0002\u00a2\u0006\u0003\u0010\u00a7\u0001J3\u0010\u00a8\u0001\u001a\u0004\u0018\u00010?2\u0006\u0010\u0007\u001a\u00028\u00032\u0006\u0010@\u001a\u00020 2\u0007\u0010\u00a5\u0001\u001a\u00020\u00102\u0007\u0010\u00a6\u0001\u001a\u00020\u000bH\u0014\u00a2\u0006\u0003\u0010\u00a7\u0001J\u001b\u0010\u00a9\u0001\u001a\u00020$2\u0007\u0010\u00aa\u0001\u001a\u00020\r2\u0007\u0010\u00ab\u0001\u001a\u00020\rH\u0002J\u001b\u0010\u00ac\u0001\u001a\u00020$2\u0007\u0010\u00aa\u0001\u001a\u00020\r2\u0007\u0010\u00ab\u0001\u001a\u00020\rH\u0014J\u0019\u0010\u00ad\u0001\u001a\u00020$2\u000e\u0010\u00ae\u0001\u001a\t\u0012\u0005\u0012\u00030\u00af\u00010}H\u0002J\u001b\u0010\u00b0\u0001\u001a\u00020$2\u0007\u0010\u00aa\u0001\u001a\u00020\r2\u0007\u0010\u00ab\u0001\u001a\u00020\rH\u0002J\u001b\u0010\u00b1\u0001\u001a\u00020$2\u0007\u0010\u00aa\u0001\u001a\u00020\r2\u0007\u0010\u00ab\u0001\u001a\u00020\rH\u0014J\u001b\u0010\u00b2\u0001\u001a\u00020$2\u0007\u0010\u00aa\u0001\u001a\u00020\r2\u0007\u0010\u00ab\u0001\u001a\u00020\rH\u0014J\t\u0010\u00b3\u0001\u001a\u00020$H\u0014J\t\u0010\u00b4\u0001\u001a\u00020$H\u0014J\u001b\u0010\u00b5\u0001\u001a\u00020$2\u0007\u0010\u00aa\u0001\u001a\u00020\r2\u0007\u0010\u00ab\u0001\u001a\u00020\rH\u0014J\u001b\u0010\u00b6\u0001\u001a\u00020$2\u0007\u0010\u00aa\u0001\u001a\u00020\r2\u0007\u0010\u00ab\u0001\u001a\u00020\rH\u0014J\t\u0010\u00b7\u0001\u001a\u00020$H\u0014J\t\u0010\u00b8\u0001\u001a\u00020$H\u0002J\u001b\u0010\u00b9\u0001\u001a\u00020$2\u0007\u0010\u00aa\u0001\u001a\u00020\r2\u0007\u0010\u00ab\u0001\u001a\u00020\rH\u0002J\t\u0010\u00ba\u0001\u001a\u00020$H\u0002J\t\u0010\u00bb\u0001\u001a\u00020\rH\u0004J\t\u0010\u00bc\u0001\u001a\u00020\rH\u0014J\u0010\u0010\u00bd\u0001\u001a\t\u0012\u0005\u0012\u00030\u00be\u00010}H\u0014J&\u0010\u00bf\u0001\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020?0'0&2\u0007\u0010\u00c0\u0001\u001a\u00028\u0003H\u0014\u00a2\u0006\u0003\u0010\u00c1\u0001J\t\u0010\u00c2\u0001\u001a\u00020\rH\u0014J\u0019\u0010\u00c3\u0001\u001a\u00020$*\u00030\u00c4\u00012\t\u0010\u009f\u0001\u001a\u0004\u0018\u00010\u000bH\u0002J \u0010\u00c5\u0001\u001a\u0004\u0018\u00010\u000b*\n\u0012\u0006\b\u0001\u0012\u00020^0]2\u0007\u0010\u00c6\u0001\u001a\u00020TH\u0004J$\u0010\u00c7\u0001\u001a\u00020$*\t\u0012\u0005\u0012\u00030\u00c8\u00010Y2\u000e\u0010\u00ae\u0001\u001a\t\u0012\u0005\u0012\u00030\u00af\u00010}H\u0002JD\u0010\u00c7\u0001\u001a\u00020$*\u0017\u0012\u0013\u0012\u0011\u0012\u0005\u0012\u00030\u00ca\u0001\u0012\u0005\u0012\u00030\u00cb\u00010\u00c9\u00010Y2\u0007\u0010\u00a5\u0001\u001a\u00020\u00102\u0007\u0010\u00cc\u0001\u001a\u00020\u00102\u000e\u0010\u00ae\u0001\u001a\t\u0012\u0005\u0012\u00030\u00af\u00010}H\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00cd\u0001"}, d2={"Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$SchemaRetriever;", "S", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)V", "myFrozen", "", "", "myHasChanges", "", "myTypes", "", "", "Lcom/intellij/database/types/DasType;", "getMyTypes", "()Ljava/util/Map;", "setMyTypes", "(Ljava/util/Map;)V", "srcFromTx", "wasMatViews", "getWasMatViews", "()Z", "setWasMatViews", "(Z)V", "wasStructures", "wasTables", "wasViews", "adjustRelKind", "", "kind", "name", "analyzeBriefInfo", "", "constraintFamilies", "", "Lcom/intellij/database/model/families/ModNamingIdentifyingFamily;", "table", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseTable;", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseTable;)[Lcom/intellij/database/model/families/ModNamingIdentifyingFamily;", "createRoutine", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseRoutine;", "r", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneRoutine;", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneRoutine;)Lcom/intellij/database/dialects/postgresbase/model/PgBaseRoutine;", "findObjectById", "Lcom/intellij/database/model/basic/BasicElement;", "id", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;Ljava/lang/Character;J)Lcom/intellij/database/model/basic/BasicElement;", "finishSchema", "getFunSourceText", "Lcom/intellij/database/model/properties/CompositeText;", "fs", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneFunctionSource;", "getSchemaChildrenToDrop", "Lcom/intellij/database/model/families/ModIdentifyingFamily;", "Lcom/intellij/database/model/basic/BasicModIdentifiedElement;", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)[Lcom/intellij/database/model/families/ModIdentifyingFamily;", "getSchemaStateNumber", "getTableOrView", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;", "relKind", "tableId", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;CJ)Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;", "handleColumnRenaming", "childrenKind", "Lcom/intellij/database/model/ObjectKind;", "oldName", "newName", "tableName", "hasReference", "con", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneConstraint;", "incrementalColAcl", "incrementalViewSources", "isPossibleToIntrospectSchemaIncrementally", "tran", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)Z", "isTableKind", "listExistentComments", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "", "loadTables", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)V", "obtainUsedTypes", "peekColNames", "", "columnPositions", "what", "columns", "Lcom/intellij/database/model/families/PositioningFamily;", "Lcom/intellij/database/model/basic/BasicTableOrViewColumn;", "performNonIncrementalPart", "prepareParameters", "preventDuplicates", "newRelation", "existing", "processAggregate", "agg", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneAggregate;", "aggregate", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseAggregate;", "processArgExtra", "T", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseArgument;", "argument", "argMode", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseArgument;Ljava/lang/Character;)V", "processArgs", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$ArgumentHolder;", "family", "Lcom/intellij/database/model/families/ModPositioningNamingFamily;", "routine", "Lcom/intellij/database/model/basic/BasicModRoutine;", "processCheck", "processColumn", "col", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneColumn;", "column", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeColumn;", "processColumns", "cols", "", "(Ljava/util/List;Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)V", "processDataType", "dataType", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseDefType;", "oneType", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneDataType;", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseDefType;Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneDataType;Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)V", "processForeignKey", "fkey", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseForeignKey;", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseForeignKey;Lcom/intellij/database/dialects/postgresbase/model/PgBaseTable;Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneConstraint;Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)V", "processFunSource", "function", "processFunSourceAttributes", "processKey", "key", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseKey;", "processModTable", "t", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneTable;", "processModView", "processOperator", "o", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneOperator;", "operator", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseOperator;", "processPreliminaryPhase", "processTable", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneTable;)V", "oneTable", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneTable;)V", "processViewSource", "view", "sourceText", "removeComments", "existentComments", "e", "removeDroppedComments", "renewTableOrView", "objectId", "objectName", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;CJLjava/lang/String;)Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;", "renewTableOrViewImpl", "retrieveAcls", "detectDropped", "loadNew", "retrieveAggregates", "retrieveColumnAcl", "newGrants", "Lcom/intellij/database/dialects/postgresbase/model/properties/PgObjectGrant;", "retrieveConstraints", "retrieveDataTypes", "retrieveDescriptions", "retrieveFunSources", "retrieveMainContent", "retrieveOperators", "retrieveRoutines", "retrieveStructAttributes", "retrieveTableColumns", "retrieveTables", "retrieveViewSources", "shouldIntrospectTableRelatedData", "shouldIntrospectTableRelatedDataIncremental", "steps", "Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "tableFamilies", "sc", "(Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;)[Lcom/intellij/database/model/families/ModNamingIdentifyingFamily;", "wasDataTables", "applyViewSourceText", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseSourceAware;", "getColumnName", "position", "toGrants", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$AttrAcl;", "Lkotlin/Pair;", "", "Lcom/intellij/database/dialects/postgresbase/introspector/PgAclItem;", "granteeId", "intellij.database.dialects.postgresbase"})
    @SourceDebugExtension(value={"SMAP\nPgBaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgBaseIntrospector.kt\ncom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$SchemaRetriever\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 8 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 9 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 10 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 11 ModelFun.kt\ncom/intellij/database/model/ModelFun\n*L\n1#1,1636:1\n26#2:1637\n26#2:1718\n620#3,2:1638\n623#3,4:1641\n620#3,7:1645\n620#3,7:1673\n620#3,7:1680\n620#3,7:1688\n620#3,7:1719\n620#3,2:1728\n391#3:1730\n623#3,4:1731\n620#3,2:1735\n391#3:1737\n623#3,4:1738\n1#4:1640\n988#5:1652\n1017#5,3:1653\n1020#5,3:1663\n372#6,7:1656\n372#6,7:1699\n215#7,2:1666\n215#7:1709\n216#7:1717\n1855#8:1668\n1855#8,2:1669\n1856#8:1671\n1477#8:1695\n1502#8,3:1696\n1505#8,3:1706\n14#9:1672\n14#9:1687\n181#10,7:1710\n138#11:1726\n131#11:1727\n*S KotlinDebug\n*F\n+ 1 PgBaseIntrospector.kt\ncom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$SchemaRetriever\n*L\n580#1:1637\n1272#1:1718\n675#1:1638,2\n675#1:1641,4\n698#1:1645,7\n851#1:1673,7\n874#1:1680,7\n1123#1:1688,7\n1317#1:1719,7\n1353#1:1728,2\n1354#1:1730\n1353#1:1731,4\n1375#1:1735,2\n1376#1:1737\n1375#1:1738,4\n717#1:1652\n717#1:1653,3\n717#1:1663,3\n717#1:1656,7\n1132#1:1699,7\n717#1:1666,2\n1133#1:1709\n1133#1:1717\n726#1:1668\n728#1:1669,2\n726#1:1671\n1132#1:1695\n1132#1:1696,3\n1132#1:1706,3\n824#1:1672\n1017#1:1687\n1135#1:1710,7\n1344#1:1726\n1344#1:1727\n*E\n"})
    protected static abstract class SchemaRetriever<S extends PgBaseSchema>
    extends BaseNativeIntrospector.AbstractSchemaRetriever<S> {
        private boolean myHasChanges;
        protected Map<Long, DasType> myTypes;
        private boolean wasStructures;
        private boolean wasTables;
        private boolean wasViews;
        private boolean wasMatViews;
        private final long srcFromTx;
        @NotNull
        private final Set<String> myFrozen;
        final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;

        @NotNull
        protected final Map<Long, DasType> getMyTypes() {
            Map<Long, DasType> map2 = this.myTypes;
            if (map2 != null) {
                return map2;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTypes");
            return null;
        }

        protected final void setMyTypes(@NotNull Map<Long, DasType> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
            this.myTypes = map2;
        }

        protected final boolean getWasMatViews() {
            return this.wasMatViews;
        }

        protected final void setWasMatViews(boolean bl) {
            this.wasMatViews = bl;
        }

        protected SchemaRetriever(@NotNull DBTransaction transaction, S schema2) {
            long l;
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter(schema2, (String)"schema");
            this.this$0 = this$0;
            super((BaseNativeIntrospector)this$0, transaction, (BasicModSchema)schema2);
            this.myHasChanges = true;
            this.myFrozen = new HashSet();
            Long existentSourcesTx = this.getModel().getSchemaSourcesVersion((BasicSchema)schema2);
            if (this.getMode().increment) {
                Long l2 = existentSourcesTx;
                l = l2 != null ? l2 : 0L;
            } else {
                l = 0L;
            }
            this.srcFromTx = l;
            this.prepareParameters();
        }

        @Override
        public boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull S schema2) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter(schema2, (String)"schema");
            return true;
        }

        @Override
        public final void prepareParameters() {
            super.prepareParameters();
            long stateNumber = this.getMode().increment ? ((PgBaseSchema)this.getSchema()).getIntrospectionStateNumber() : 0L;
            this.this$0.setTx(this, stateNumber, "tx", "TXAGE");
            this.this$0.setTx(this, this.getWithSources() ? this.srcFromTx : stateNumber, "src_tx", "SRCTXAGE");
        }

        @Override
        public void processPreliminaryPhase() {
            if (this.getMode().fragment) {
                return;
            }
            this.analyzeBriefInfo();
            this.analyzeCurrentContent();
        }

        @Override
        protected void analyzeBriefInfo() {
            long stateNumber;
            long l = stateNumber = this.getMode().increment ? ((PgBaseSchema)this.getSchema()).getIntrospectionStateNumber() : 0L;
            this.myHasChanges = this.getMode().full || this.this$0.getQueries().checkSchemaChanges(this.getTransaction(), stateNumber, this.getWithSources() ? this.srcFromTx : stateNumber, (PgBaseSchema)this.getSchema());
        }

        private final void removeDroppedComments(Long2ObjectMap<Short[]> existentComments) {
            this.inSchema((Function1)new Function1<S, Unit>(this, existentComments){
                final /* synthetic */ SchemaRetriever<S> this$0;
                final /* synthetic */ Long2ObjectMap<Short[]> $existentComments;
                {
                    this.this$0 = $receiver;
                    this.$existentComments = $existentComments;
                    super(1);
                }

                public final void invoke(@NotNull S schema2) {
                    Intrinsics.checkNotNullParameter(schema2, (String)"schema");
                    for (ModFamily modFamily : schema2.getFamilies()) {
                        if (!modFamily.getMetaObject().kindOf(BasicModIdentifiedElement.class)) continue;
                        for (BasicModElement c2 : modFamily) {
                            Intrinsics.checkNotNull((Object)c2, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModIdentifiedElement");
                            this.this$0.removeComments(this.$existentComments, (BasicModIdentifiedElement)c2);
                        }
                    }
                }
            });
        }

        @NotNull
        protected abstract Long2ObjectMap<Short[]> listExistentComments();

        protected void removeComments(@NotNull Long2ObjectMap<Short[]> existentComments, @NotNull BasicModIdentifiedElement e2) {
            Object[] commented;
            Intrinsics.checkNotNullParameter(existentComments, (String)"existentComments");
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            BasicModNamedElement cfr_ignored_0 = (BasicModNamedElement)((Object)e2);
            Short[] shortArray = (Short[])existentComments.get(e2.getObjectId());
            if (shortArray == null) {
                boolean bl = false;
                v0 = new Short[]{};
            } else {
                v0 = commented = shortArray;
            }
            if (!ArraysKt.contains((Object[])commented, (Object)0)) {
                ((BasicModNamedElement)((Object)e2)).setComment(null);
            }
            if (e2 instanceof PgBaseDefType) {
                for (PgBaseDefTypeAttribute pgBaseDefTypeAttribute : ((PgBaseDefType)e2).getAttributes()) {
                    if (ArraysKt.contains((Object[])commented, (Object)pgBaseDefTypeAttribute.getPosition())) continue;
                    pgBaseDefTypeAttribute.setComment(null);
                }
            }
            if (e2 instanceof PgBaseLikeTable) {
                for (PgBaseLikeColumn pgBaseLikeColumn : ((PgBaseLikeTable)e2).getColumns()) {
                    if (ArraysKt.contains((Object[])commented, (Object)pgBaseLikeColumn.getPosition())) continue;
                    pgBaseLikeColumn.setComment(null);
                }
                for (BasicModKey basicModKey : ((PgBaseLikeTable)e2).getKeys()) {
                    Intrinsics.checkNotNull((Object)basicModKey, (String)"null cannot be cast to non-null type com.intellij.database.dialects.postgresbase.model.PgBaseKey");
                    this.removeComments(existentComments, (PgBaseKey)basicModKey);
                }
                for (BasicModForeignKey basicModForeignKey : ((PgBaseLikeTable)e2).getForeignKeys()) {
                    Intrinsics.checkNotNull((Object)basicModForeignKey, (String)"null cannot be cast to non-null type com.intellij.database.dialects.postgresbase.model.PgBaseForeignKey");
                    this.removeComments(existentComments, (PgBaseForeignKey)basicModForeignKey);
                }
            }
        }

        @NotNull
        protected ModIdentifyingFamily<? extends BasicModIdentifiedElement>[] getSchemaChildrenToDrop(@NotNull S schema2) {
            Intrinsics.checkNotNullParameter(schema2, (String)"schema");
            ModIdentifyingFamily[] modIdentifyingFamilyArray = new ModIdentifyingFamily[7];
            Intrinsics.checkNotNullExpressionValue(schema2.getDefTypes(), (String)"getDefTypes(...)");
            Intrinsics.checkNotNullExpressionValue(schema2.getTables(), (String)"getTables(...)");
            Intrinsics.checkNotNullExpressionValue(schema2.getViews(), (String)"getViews(...)");
            Intrinsics.checkNotNullExpressionValue(schema2.getMatViews(), (String)"getMatViews(...)");
            Intrinsics.checkNotNullExpressionValue(schema2.getRoutines(), (String)"getRoutines(...)");
            Intrinsics.checkNotNullExpressionValue(schema2.getOperators(), (String)"getOperators(...)");
            Intrinsics.checkNotNullExpressionValue(schema2.getAggregates(), (String)"getAggregates(...)");
            return modIdentifyingFamilyArray;
        }

        @Override
        protected void retrieveMainContent() {
            List<IntroStep> steps2 = this.steps();
            CollectionsKt.sort(steps2);
            boolean loadNew = !this.getMode().increment || this.myHasChanges;
            for (IntroStep step2 : steps2) {
                step2.getPerform().invoke((Object)this.getMode().increment, (Object)loadNew);
            }
            if (!loadNew) {
                this.performNonIncrementalPart();
            }
        }

        protected void performNonIncrementalPart() {
            if (!this.incrementalColAcl()) {
                List<PgObjectGrant> newGrants = ((PgBaseSchema)this.getSchema()).getGrants().toMutableList();
                this.retrieveColumnAcl(newGrants);
                ((PgBaseSchema)this.getSchema()).setGrants(((PgBaseSchema)this.getSchema()).getGrants().with((Iterable<PgObjectGrant>)newGrants));
            }
        }

        protected boolean incrementalViewSources() {
            return false;
        }

        protected boolean incrementalColAcl() {
            return true;
        }

        @Override
        protected long getSchemaStateNumber() {
            Long l = this.this$0.getIntrospectionXid();
            return l != null ? l.longValue() : ((PgBaseSchema)this.getSchema()).getIntrospectionStateNumber();
        }

        @Override
        protected void finishSchema() {
            super.finishSchema();
            this.inSchema((Function1)new Function1<S, Unit>(this.this$0){
                final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull S it2) {
                    Intrinsics.checkNotNullParameter(it2, (String)"it");
                    Long xid = this.this$0.getIntrospectionXid();
                    if (xid != null) {
                        it2.setIntrospectionStateNumber(xid);
                    }
                }
            });
        }

        @NotNull
        protected List<IntroStep> steps() {
            return PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(new ArrayList(), 10, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this){
                final /* synthetic */ SchemaRetriever<S> this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(boolean detectDropped, boolean loadNew) {
                    this.this$0.retrieveDataTypes(detectDropped, loadNew);
                }
            })), 20, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this){
                final /* synthetic */ SchemaRetriever<S> this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(boolean detectDropped, boolean loadNew) {
                    SchemaRetriever.access$retrieveTables(this.this$0, detectDropped, loadNew);
                }
            })), 30, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this){
                final /* synthetic */ SchemaRetriever<S> this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(boolean detectDropped, boolean loadNew) {
                    if (loadNew) {
                        this.this$0.obtainUsedTypes();
                    }
                }
            })), 40, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this){
                final /* synthetic */ SchemaRetriever<S> this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(boolean detectDropped, boolean loadNew) {
                    this.this$0.retrieveRoutines(detectDropped, loadNew);
                }
            })), 45, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this){
                final /* synthetic */ SchemaRetriever<S> this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(boolean detectDropped, boolean loadNew) {
                    this.this$0.retrieveAggregates(detectDropped, loadNew);
                }
            })), 50, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this){
                final /* synthetic */ SchemaRetriever<S> this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(boolean detectDropped, boolean loadNew) {
                    this.this$0.retrieveOperators(detectDropped, loadNew);
                }
            })), 60, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this){
                final /* synthetic */ SchemaRetriever<S> this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(boolean detectDropped, boolean loadNew) {
                    if (loadNew) {
                        this.this$0.retrieveStructAttributes();
                    }
                }
            })), 70, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this){
                final /* synthetic */ SchemaRetriever<S> this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(boolean detectDropped, boolean loadNew) {
                    if (loadNew) {
                        SchemaRetriever.access$retrieveTableColumns(this.this$0);
                    }
                }
            })), 80, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this){
                final /* synthetic */ SchemaRetriever<S> this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(boolean detectDropped, boolean loadNew) {
                    SchemaRetriever.access$retrieveConstraints(this.this$0, detectDropped, loadNew);
                }
            })), 90, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this){
                final /* synthetic */ SchemaRetriever<S> this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(boolean detectDropped, boolean loadNew) {
                    this.this$0.retrieveDescriptions(detectDropped, loadNew);
                }
            })), 99, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this){
                final /* synthetic */ SchemaRetriever<S> this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(boolean detectDropped, boolean loadNew) {
                    SchemaRetriever.access$retrieveAcls(this.this$0, detectDropped, loadNew);
                }
            })), 100, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this){
                final /* synthetic */ SchemaRetriever<S> this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(boolean detectDropped, boolean loadNew) {
                    if (loadNew || !this.this$0.incrementalViewSources()) {
                        SchemaRetriever.access$retrieveViewSources(this.this$0);
                    }
                }
            })), 110, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this){
                final /* synthetic */ SchemaRetriever<S> this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(boolean detectDropped, boolean loadNew) {
                    if (loadNew) {
                        this.this$0.retrieveFunSources();
                    }
                }
            }));
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveAcls(boolean detectDropped, boolean loadNew) {
            this.this$0.reportRetrieving("ACL", "introspection.retrieve.ACL");
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl = false;
                Grants.Controller<PgObjectGrant, ?> ctl = ((PgBaseSchema)this.getSchema()).getGrants().getController();
                List<PgObjectGrant> newGrants = ((PgBaseSchema)this.getSchema()).getGrants().toMutableList();
                if (detectDropped) {
                    newGrants.removeIf(arg_0 -> SchemaRetriever.retrieveAcls$lambda$2$lambda$0((Function1)new Function1<PgObjectGrant, Boolean>(ctl, this){
                        final /* synthetic */ Grants.Controller<PgObjectGrant, ?> $ctl;
                        final /* synthetic */ SchemaRetriever<S> this$0;
                        {
                            this.$ctl = $ctl;
                            this.this$0 = $receiver;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(PgObjectGrant it2) {
                            Grants.Grant grant = it2;
                            BasicElement basicElement = (BasicElement)this.this$0.getSchema();
                            BasicResolveAssistant basicResolveAssistant = BasicResolveAssistant.DEFAULT;
                            Intrinsics.checkNotNullExpressionValue((Object)basicResolveAssistant, (String)"DEFAULT");
                            return this.$ctl.findTarget((PgObjectGrant)grant, basicElement, basicResolveAssistant) == null;
                        }
                    }, arg_0));
                }
                if (loadNew) {
                    Long l = ((PgBaseSchema)this.getSchema()).getIntrospectionStateNumber();
                    long it2 = ((Number)l).longValue();
                    boolean bl2 = false;
                    Long tx = detectDropped ? l : null;
                    Lexer lexer = pgBaseIntrospector.getSqlHelper().createLexer();
                    NamingService ns = NamingServices.getNamingService(pgBaseIntrospector.dbms, this.getModel(), ((PgBaseSchema)this.getSchema()).getDatabase());
                    pgBaseIntrospector.getQueries().processObjectAcls(this.getTransaction(), (PgBaseSchema)this.getSchema(), tx, (Function1<? super PgBaseIntroQueries.OneAcl, Unit>)((Function1)new Function1<PgBaseIntroQueries.OneAcl, Unit>(newGrants, pgBaseIntrospector, lexer, ns){
                        final /* synthetic */ List<PgObjectGrant> $newGrants;
                        final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;
                        final /* synthetic */ Lexer $lexer;
                        final /* synthetic */ NamingService $ns;
                        {
                            this.$newGrants = $newGrants;
                            this.this$0 = $receiver;
                            this.$lexer = $lexer;
                            this.$ns = $ns;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull PgBaseIntroQueries.OneAcl acl) {
                            block1: {
                                void $this$forEach$iv;
                                Intrinsics.checkNotNullParameter((Object)acl, (String)"acl");
                                this.$newGrants.removeIf(arg_0 -> retrieveAcls.1.2.invoke$lambda$0((Function1)new Function1<PgObjectGrant, Boolean>(acl){
                                    final /* synthetic */ PgBaseIntroQueries.OneAcl $acl;
                                    {
                                        this.$acl = $acl;
                                        super(1);
                                    }

                                    @NotNull
                                    public final Boolean invoke(PgObjectGrant it2) {
                                        return it2.getObjectId() == this.$acl.object_id && !it2.isSub();
                                    }
                                }, arg_0));
                                if (acl.acl == null) break block1;
                                String[] stringArray = acl.acl;
                                PgBaseIntrospector<MR, D, S> pgBaseIntrospector = this.this$0;
                                Lexer lexer = this.$lexer;
                                NamingService namingService2 = this.$ns;
                                List<PgObjectGrant> list = this.$newGrants;
                                boolean $i$f$forEach = false;
                                int n = ((void)$this$forEach$iv).length;
                                for (int j = 0; j < n; ++j) {
                                    void element$iv;
                                    void it2 = element$iv = $this$forEach$iv[j];
                                    boolean bl = false;
                                    PgAclItem pgAclItem = pgBaseIntrospector.parseAclItem(lexer, namingService2, (String)it2);
                                    if (pgAclItem == null) continue;
                                    pgAclItem.toGrants(acl.object_id, (Collection<PgObjectGrant>)list);
                                }
                            }
                        }

                        private static final boolean invoke$lambda$0(Function1 $tmp0, Object p0) {
                            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                            return (Boolean)$tmp0.invoke(p0);
                        }
                    }));
                    this.retrieveColumnAcl(newGrants);
                }
                ((PgBaseSchema)this.getSchema()).setGrants(((PgBaseSchema)this.getSchema()).getGrants().with((Iterable<PgObjectGrant>)newGrants));
            }
            catch (DBException e$iv) {
                void this_$iv;
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveColumnAcl(List<PgObjectGrant> newGrants) {
            Long l = ((PgBaseSchema)this.getSchema()).getIntrospectionStateNumber();
            long it22 = ((Number)l).longValue();
            boolean bl = false;
            Long tx = this.getMode().increment ? l : null;
            ArrayList<PgBaseIntroQueries.AttrAcl> columns2 = new ArrayList<PgBaseIntroQueries.AttrAcl>();
            BaseNativeIntrospector it22 = this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl2 = false;
                pgBaseIntrospector.getQueries().processColumnAcls(this.getTransaction(), (PgBaseSchema)this.getSchema(), tx, (Function1<? super PgBaseIntroQueries.AttrAcl, Unit>)((Function1)new Function1<PgBaseIntroQueries.AttrAcl, Unit>(newGrants, columns2, this){
                    final /* synthetic */ List<PgObjectGrant> $newGrants;
                    final /* synthetic */ ArrayList<PgBaseIntroQueries.AttrAcl> $columns;
                    final /* synthetic */ SchemaRetriever<S> this$0;
                    {
                        this.$newGrants = $newGrants;
                        this.$columns = $columns;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull PgBaseIntroQueries.AttrAcl acl) {
                        Intrinsics.checkNotNullParameter((Object)acl, (String)"acl");
                        this.$newGrants.removeIf(arg_0 -> retrieveColumnAcl.1.1.invoke$lambda$0((Function1)new Function1<PgObjectGrant, Boolean>(acl){
                            final /* synthetic */ PgBaseIntroQueries.AttrAcl $acl;
                            {
                                this.$acl = $acl;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull PgObjectGrant it2) {
                                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                                return it2.getObjectId() == this.$acl.object_id && it2.isSub() && it2.getSubsStream().allMatch(arg_0 -> SchemaRetriever.retrieveColumnAcl.1.1.invoke$lambda$0(this.$acl, arg_0));
                            }

                            private static final boolean invoke$lambda$0(PgBaseIntroQueries.AttrAcl $acl, int n) {
                                Intrinsics.checkNotNullParameter((Object)$acl, (String)"$acl");
                                return n == $acl.attr_position;
                            }
                        }, arg_0));
                        PgBaseIntroQueries.AttrAcl attrAcl = (PgBaseIntroQueries.AttrAcl)CollectionsKt.firstOrNull((List)this.$columns);
                        if (!(attrAcl != null ? attrAcl.object_id == acl.object_id : false)) {
                            SchemaRetriever.access$toGrants(this.this$0, this.$columns, this.$newGrants);
                            this.$columns.clear();
                        }
                        ((Collection)this.$columns).add(acl);
                    }

                    private static final boolean invoke$lambda$0(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        return (Boolean)$tmp0.invoke(p0);
                    }
                }));
            }
            catch (DBException e$iv) {
                void this_$iv;
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
            this.toGrants((List<PgBaseIntroQueries.AttrAcl>)columns2, newGrants);
        }

        /*
         * WARNING - void declaration
         */
        private final void toGrants(List<PgBaseIntroQueries.AttrAcl> $this$toGrants, List<PgObjectGrant> newGrants) {
            void $this$forEach$iv;
            void $this$groupByTo$iv$iv;
            Map $this$groupBy$iv;
            if ($this$toGrants.isEmpty()) {
                return;
            }
            long objectId = ((PgBaseIntroQueries.AttrAcl)CollectionsKt.first($this$toGrants)).object_id;
            Lexer lexer = this.this$0.getSqlHelper().createLexer();
            NamingService ns = NamingServices.getNamingService(this.this$0.dbms, this.getModel(), ((PgBaseSchema)this.getSchema()).getDatabase());
            Sequence sequence = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)$this$toGrants), (Function1)((Function1)new Function1<PgBaseIntroQueries.AttrAcl, Sequence<? extends kotlin.Pair<? extends Integer, ? extends PgAclItem>>>(this.this$0, lexer, ns){
                final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;
                final /* synthetic */ Lexer $lexer;
                final /* synthetic */ NamingService $ns;
                {
                    this.this$0 = $receiver;
                    this.$lexer = $lexer;
                    this.$ns = $ns;
                    super(1);
                }

                @NotNull
                public final Sequence<kotlin.Pair<Integer, PgAclItem>> invoke(@NotNull PgBaseIntroQueries.AttrAcl a) {
                    Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                    String[] stringArray = a.acl;
                    if (stringArray == null || (stringArray = ArraysKt.asSequence((Object[])stringArray)) == null || (stringArray = SequencesKt.mapNotNull((Sequence)stringArray, (Function1)((Function1)new Function1<String, PgAclItem>(this.this$0, this.$lexer, this.$ns){
                        final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;
                        final /* synthetic */ Lexer $lexer;
                        final /* synthetic */ NamingService $ns;
                        {
                            this.this$0 = $receiver;
                            this.$lexer = $lexer;
                            this.$ns = $ns;
                            super(1);
                        }

                        @Nullable
                        public final PgAclItem invoke(@NotNull String it2) {
                            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                            return this.this$0.parseAclItem(this.$lexer, this.$ns, it2);
                        }
                    }))) == null || (stringArray = SequencesKt.map((Sequence)stringArray, (Function1)((Function1)new Function1<PgAclItem, kotlin.Pair<? extends Integer, ? extends PgAclItem>>(a){
                        final /* synthetic */ PgBaseIntroQueries.AttrAcl $a;
                        {
                            this.$a = $a;
                            super(1);
                        }

                        @NotNull
                        public final kotlin.Pair<Integer, PgAclItem> invoke(@NotNull PgAclItem it2) {
                            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                            return new kotlin.Pair((Object)this.$a.attr_position, (Object)it2);
                        }
                    }))) == null) {
                        stringArray = SequencesKt.emptySequence();
                    }
                    return stringArray;
                }
            }));
            boolean $i$f$groupBy = false;
            Iterator iterator = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                kotlin.Pair it2 = (kotlin.Pair)element$iv$iv;
                boolean bl = false;
                Long key$iv$iv = ((PgAclItem)it2.getSecond()).getGrantee();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                long granteeId = ((Number)entry.getKey()).longValue();
                List grants = (List)entry.getValue();
                this.toGrants(grants, objectId, granteeId, newGrants);
            }
        }

        private final void toGrants(List<kotlin.Pair<Integer, PgAclItem>> $this$toGrants, long objectId, long granteeId, List<PgObjectGrant> newGrants) {
            if (newGrants.isEmpty()) {
                return;
            }
            BitSet columns2 = new BitSet();
            for (PgPrivilege privilege : PgPrivilege.values()) {
                Iterable $this$forEach$iv = (Iterable)new IntRange(0, 1);
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int g2 = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl = false;
                    for (kotlin.Pair<Integer, PgAclItem> acl : $this$toGrants) {
                        Iterable $this$forEach$iv2 = g2 == 1 ? ((PgAclItem)acl.getSecond()).getGrantablePrivileges() : ((PgAclItem)acl.getSecond()).getPrivileges();
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            PgPrivilege p2 = (PgPrivilege)((Object)element$iv2);
                            boolean bl2 = false;
                            if (p2 != privilege) continue;
                            columns2.set(((Number)acl.getFirst()).intValue());
                        }
                    }
                    if (columns2.isEmpty()) continue;
                    newGrants.add(new PgObjectGrant(objectId, columns2, granteeId, privilege.name(), g2 == 1 ? Grants.State.GRANT_WITH_GRANT_OPTION : Grants.State.GRANT));
                    columns2.clear();
                }
            }
        }

        protected void retrieveDataTypes(boolean detectDropped, boolean loadNew) {
            this.this$0.reportRetrieving("data types", "introspection.retrieve.types");
            this.inSchema((Function1)new Function1<S, Unit>(this.this$0, detectDropped, this, loadNew){
                final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;
                final /* synthetic */ boolean $detectDropped;
                final /* synthetic */ SchemaRetriever<S> this$1;
                final /* synthetic */ boolean $loadNew;
                {
                    this.this$0 = $receiver;
                    this.$detectDropped = $detectDropped;
                    this.this$1 = $receiver2;
                    this.$loadNew = $loadNew;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull S sc2) {
                    void $this$modifyAndCleanup_u24default$iv;
                    Intrinsics.checkNotNullParameter(sc2, (String)"sc");
                    ModFamily modFamily = sc2.getDefTypes();
                    PgBaseIntrospector<MR, D, S> pgBaseIntrospector = this.this$0;
                    boolean bl = this.$detectDropped;
                    SchemaRetriever<S> schemaRetriever = this.this$1;
                    boolean bl2 = this.$loadNew;
                    boolean inc$iv = true;
                    boolean $i$f$modifyAndCleanup = false;
                    $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                    ModNamingIdentifyingFamily defTypes = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
                    boolean bl3 = false;
                    BaseNativeIntrospector this_$iv = pgBaseIntrospector;
                    boolean $i$f$continueOnDbError = false;
                    try {
                        boolean bl4 = false;
                        if (bl) {
                            long[] $this$forEach$iv = (long[])SchemaRetriever.access$performQuery(schemaRetriever, pgBaseIntrospector.getQueries().getRetrieveExistentDataTypes());
                            boolean $i$f$forEach = false;
                            int n = $this$forEach$iv.length;
                            for (int j = 0; j < n; ++j) {
                                long element$iv;
                                long it2 = element$iv = $this$forEach$iv[j];
                                boolean bl5 = false;
                                PgBaseDefType pgBaseDefType = (PgBaseDefType)defTypes.getByObjectId(it2);
                                if (pgBaseDefType != null) {
                                    pgBaseDefType.resetSyncPending();
                                }
                            }
                        }
                        if (bl2) {
                            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(schemaRetriever, pgBaseIntrospector.getQueries().getRetrieveDataTypes(), 0, (Function1)new Function1<PgBaseIntroQueries.OneDataType, Unit>((ModNamingIdentifyingFamily<? extends PgBaseDefType>)defTypes, schemaRetriever, sc2){
                                final /* synthetic */ ModNamingIdentifyingFamily<? extends PgBaseDefType> $defTypes;
                                final /* synthetic */ SchemaRetriever<S> this$0;
                                final /* synthetic */ S $sc;
                                {
                                    this.$defTypes = $defTypes;
                                    this.this$0 = $receiver;
                                    this.$sc = $sc;
                                    super(1);
                                }

                                public final void invoke(@NotNull PgBaseIntroQueries.OneDataType dt) {
                                    Intrinsics.checkNotNullParameter((Object)dt, (String)"dt");
                                    PgBaseDefType dataType = this.$defTypes.renew(dt.type_id, dt.type_name);
                                    Intrinsics.checkNotNull((Object)dataType);
                                    this.this$0.processDataType(dataType, dt, this.$sc);
                                }
                            }, 2, null);
                        }
                    }
                    catch (DBException e$iv) {
                        this_$iv.getErrorSink().consume(null, (Object)((Object)e$iv));
                    }
                    $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                    $this$modifyAndCleanup_u24default$iv.sort();
                }
            });
        }

        protected void processDataType(@NotNull PgBaseDefType dataType, @NotNull PgBaseIntroQueries.OneDataType oneType, @NotNull S schema2) {
            Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
            Intrinsics.checkNotNullParameter((Object)oneType, (String)"oneType");
            Intrinsics.checkNotNullParameter(schema2, (String)"schema");
            PgDataTypeSubKind subKind = PgDataTypeSubKind.of(oneType.type_sub_kind);
            dataType.setStateNumber(oneType.type_state_number);
            dataType.setSubKind(subKind);
            String string = PgBaseIntrospectorKt.access$adjustedTypeSpec(oneType);
            dataType.setDefinition(string != null ? PgBaseIntrospectorKt.normalizeDataTypeSpec(string) : null);
            dataType.setDefaultExpression(oneType.default_expression);
            dataType.setNotNull(oneType.mandatory);
            this.wasStructures = this.wasStructures || subKind == PgDataTypeSubKind.COMPOSITE;
        }

        private final void retrieveTables(boolean detectDropped, boolean loadNew) {
            this.this$0.reportRetrieving("tables and views", "introspection.retrieve.tablesViews");
            this.inSchema((Function1)new Function1<S, Unit>(this, this.this$0, detectDropped, loadNew){
                final /* synthetic */ SchemaRetriever<S> this$0;
                final /* synthetic */ PgBaseIntrospector<MR, D, S> this$1;
                final /* synthetic */ boolean $detectDropped;
                final /* synthetic */ boolean $loadNew;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    this.$detectDropped = $detectDropped;
                    this.$loadNew = $loadNew;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull S sc2) {
                    void families$iv;
                    Intrinsics.checkNotNullParameter(sc2, (String)"sc");
                    ModNamingIdentifyingFamily<PgBaseLikeStoredTable>[] fTables = this.this$0.tableFamilies(sc2);
                    ModFamily[] modFamilyArray = Arrays.copyOf(fTables, fTables.length);
                    PgBaseIntrospector<MR, D, S> pgBaseIntrospector = this.this$1;
                    boolean bl = this.$detectDropped;
                    SchemaRetriever<S> schemaRetriever = this.this$0;
                    boolean bl2 = this.$loadNew;
                    boolean inc$iv = true;
                    boolean $i$f$modifyFamiliesAndCleanup = false;
                    for (void f$iv : families$iv) {
                        f$iv.markChildrenAsSyncPending();
                    }
                    boolean bl3 = false;
                    BaseNativeIntrospector this_$iv = pgBaseIntrospector;
                    boolean $i$f$continueOnDbError = false;
                    try {
                        boolean bl4 = false;
                        if (bl) {
                            long[] $this$forEach$iv = (long[])SchemaRetriever.access$performQuery(schemaRetriever, pgBaseIntrospector.getQueries().getRetrieveExistentTables());
                            boolean $i$f$forEach = false;
                            int n = $this$forEach$iv.length;
                            for (int j = 0; j < n; ++j) {
                                long element$iv;
                                long it2 = element$iv = $this$forEach$iv[j];
                                boolean bl5 = false;
                                for (ModNamingIdentifyingFamily<PgBaseLikeStoredTable> tables2 : fTables) {
                                    PgBaseLikeStoredTable pgBaseLikeStoredTable = (PgBaseLikeStoredTable)tables2.getByObjectId(it2);
                                    if (pgBaseLikeStoredTable == null) continue;
                                    pgBaseLikeStoredTable.resetSyncPending();
                                }
                            }
                        }
                        if (bl2) {
                            schemaRetriever.loadTables(sc2);
                        }
                    }
                    catch (DBException e$iv) {
                        this_$iv.getErrorSink().consume(null, (Object)((Object)e$iv));
                    }
                    for (void f$iv : families$iv) {
                        f$iv.removeSyncPendingChildren();
                        f$iv.sort();
                    }
                }
            });
        }

        @NotNull
        protected ModNamingIdentifyingFamily<? extends PgBaseLikeStoredTable>[] tableFamilies(@NotNull S sc2) {
            Intrinsics.checkNotNullParameter(sc2, (String)"sc");
            ModNamingIdentifyingFamily[] modNamingIdentifyingFamilyArray = new ModNamingIdentifyingFamily[3];
            Intrinsics.checkNotNullExpressionValue(sc2.getTables(), (String)"getTables(...)");
            Intrinsics.checkNotNullExpressionValue(sc2.getViews(), (String)"getViews(...)");
            Intrinsics.checkNotNullExpressionValue(sc2.getMatViews(), (String)"getMatViews(...)");
            return modNamingIdentifyingFamilyArray;
        }

        protected void loadTables(@NotNull S schema2) {
            Intrinsics.checkNotNullParameter(schema2, (String)"schema");
            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this, this.this$0.getQueries().getRetrieveTables(), 0, (Function1)new Function1<PgBaseIntroQueries.OneTable, Unit>(this, schema2){
                final /* synthetic */ SchemaRetriever<S> this$0;
                final /* synthetic */ S $schema;
                {
                    this.this$0 = $receiver;
                    this.$schema = $schema;
                    super(1);
                }

                public final void invoke(@NotNull PgBaseIntroQueries.OneTable it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    this.this$0.processTable(this.$schema, it2);
                }
            }, 2, null);
        }

        protected final void processTable(@NotNull S schema2, @NotNull PgBaseIntroQueries.OneTable t) {
            Intrinsics.checkNotNullParameter(schema2, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            char c2 = t.table_kind;
            long l = t.table_id;
            String string = t.table_name;
            Intrinsics.checkNotNull((Object)string);
            PgBaseLikeStoredTable pgBaseLikeStoredTable = this.renewTableOrView(schema2, c2, l, string);
            if (pgBaseLikeStoredTable == null) {
                return;
            }
            PgBaseLikeStoredTable table = pgBaseLikeStoredTable;
            this.processTable(table, schema2, t);
        }

        protected void processTable(@NotNull PgBaseLikeStoredTable table, @NotNull S schema2, @NotNull PgBaseIntroQueries.OneTable oneTable) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter(schema2, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)oneTable, (String)"oneTable");
            table.setStateNumber(oneTable.table_state_number);
            table.setOwnerRef(BasicNameReference.create(oneTable.getOwnerName()));
            PgBaseLikeStoredTable pgBaseLikeStoredTable = table;
            if (pgBaseLikeStoredTable instanceof PgBaseTable) {
                this.processModTable((PgBaseTable)table, oneTable);
            } else if (pgBaseLikeStoredTable instanceof PgBaseView) {
                this.processModView(table, oneTable);
            }
            this.wasTables = this.wasTables || this.isTableKind(oneTable.table_kind);
            this.wasViews = this.wasViews || oneTable.table_kind == 'v';
            this.wasMatViews = this.wasMatViews || oneTable.table_kind == 'm';
        }

        private final PgBaseLikeStoredTable renewTableOrView(S schema2, char relKind, long objectId, String objectName) {
            BasicIdentifiedElement basicIdentifiedElement;
            PgBaseLikeStoredTable pgBaseLikeStoredTable;
            PgBaseDatabase pgBaseDatabase = schema2.getDatabase();
            Intrinsics.checkNotNull((Object)pgBaseDatabase);
            BasicIdentifiedElement existing = pgBaseDatabase.findIdentifiedElement(objectId);
            PgBaseLikeStoredTable newRelation = this.renewTableOrViewImpl(schema2, relKind, objectId, objectName);
            BasicIdentifiedElement $this$asSafely$iv = existing;
            boolean $i$f$asSafely = false;
            BasicIdentifiedElement basicIdentifiedElement2 = $this$asSafely$iv;
            if (!(basicIdentifiedElement2 instanceof PgBaseLikeStoredTable)) {
                basicIdentifiedElement2 = null;
            }
            if ((pgBaseLikeStoredTable = (PgBaseLikeStoredTable)basicIdentifiedElement2) != null) {
                BasicIdentifiedElement it2 = $this$asSafely$iv = pgBaseLikeStoredTable;
                boolean bl = false;
                basicIdentifiedElement = newRelation != null && !Intrinsics.areEqual((Object)it2, (Object)newRelation) && Intrinsics.areEqual((Object)it2.getSchema(), schema2) ? $this$asSafely$iv : null;
            } else {
                basicIdentifiedElement = null;
            }
            BasicIdentifiedElement it3 = basicIdentifiedElement;
            boolean bl = false;
            return this.preventDuplicates(newRelation, (PgBaseLikeStoredTable)it3);
        }

        @Nullable
        protected PgBaseLikeStoredTable renewTableOrViewImpl(@NotNull S schema2, char relKind, long objectId, @NotNull String objectName) {
            Intrinsics.checkNotNullParameter(schema2, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
            return this.isTableKind(relKind) ? (PgBaseLikeStoredTable)schema2.getTables().renew(objectId, objectName) : (relKind == 'v' ? (PgBaseLikeStoredTable)schema2.getViews().renew(objectId, objectName) : (relKind == 'm' ? (PgBaseLikeStoredTable)schema2.getMatViews().renew(objectId, objectName) : null));
        }

        @Nullable
        protected PgBaseLikeStoredTable preventDuplicates(@Nullable PgBaseLikeStoredTable newRelation, @Nullable PgBaseLikeStoredTable existing) {
            block0: {
                PgBaseLikeStoredTable pgBaseLikeStoredTable = existing;
                if (pgBaseLikeStoredTable == null) break block0;
                pgBaseLikeStoredTable.drop();
            }
            return newRelation;
        }

        protected boolean isTableKind(char kind) {
            return kind == 'r';
        }

        /*
         * WARNING - void declaration
         */
        protected void retrieveStructAttributes() {
            if (!(this.wasStructures || this.getMode().increment && ((PgBaseSchema)this.getSchema()).getDefTypes().hasChildren())) {
                return;
            }
            ObjectKind objectKind = ObjectKind.OBJECT_ATTRIBUTE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"OBJECT_ATTRIBUTE");
            this.this$0.reportRetrieving(objectKind);
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl = false;
                List<PgBaseIntroQueries.OneStructAttribute> ats = this.performQuery(pgBaseIntrospector.getQueries().getRetrieveStructAttributes());
                if (ats.isEmpty()) {
                    return;
                }
                this.inSchema((Function1)new Function1<S, Unit>(ats){
                    final /* synthetic */ List<PgBaseIntroQueries.OneStructAttribute> $ats;
                    {
                        this.$ats = $ats;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull S schema2) {
                        void $this$groupByTo$iv$iv;
                        Intrinsics.checkNotNullParameter(schema2, (String)"schema");
                        Iterable $this$groupBy$iv = this.$ats;
                        boolean $i$f$groupBy = false;
                        Object object = $this$groupBy$iv;
                        Map destination$iv$iv = new LinkedHashMap<K, V>();
                        boolean $i$f$groupByTo = false;
                        for (T element$iv$iv : $this$groupByTo$iv$iv) {
                            Object object2;
                            PgBaseIntroQueries.OneStructAttribute it2 = (PgBaseIntroQueries.OneStructAttribute)element$iv$iv;
                            boolean bl = false;
                            Long key$iv$iv = it2.type_id;
                            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                            boolean $i$f$getOrPut = false;
                            V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                            if (value$iv$iv$iv == null) {
                                boolean bl2 = false;
                                List answer$iv$iv$iv = new ArrayList<E>();
                                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                                object2 = answer$iv$iv$iv;
                            } else {
                                object2 = value$iv$iv$iv;
                            }
                            List list$iv$iv = (List)object2;
                            list$iv$iv.add(element$iv$iv);
                        }
                        Map $this$forEach$iv = destination$iv$iv;
                        boolean $i$f$forEach = false;
                        object = $this$forEach$iv.entrySet().iterator();
                        while (object.hasNext()) {
                            PgBaseDefType dataType;
                            Map.Entry element$iv;
                            Map.Entry entry = element$iv = (Map.Entry)object.next();
                            boolean bl = false;
                            if ((PgBaseDefType)schema2.getDefTypes().getByObjectId(((Number)entry.getKey()).longValue()) == null) continue;
                            ModFamily $this$modifyAndCleanup_u24default$iv = dataType.getAttributes();
                            boolean inc$iv = true;
                            boolean $i$f$modifyAndCleanup = false;
                            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                            ModPositioningNamingFamily attributes2 = (ModPositioningNamingFamily)$this$modifyAndCleanup_u24default$iv;
                            boolean bl3 = false;
                            for (PgBaseIntroQueries.OneStructAttribute at : (List)entry.getValue()) {
                                if (at.att_dropped) continue;
                                PgBaseDefTypeAttribute attribute = (PgBaseDefTypeAttribute)attributes2.createOrGetAt(at.att_position);
                                String string = at.att_name;
                                Intrinsics.checkNotNull((Object)string);
                                attribute.setName(string);
                                attribute.setStoredType(PgBaseIntrospectorKt.dasTypeOf(at));
                            }
                            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                            $this$modifyAndCleanup_u24default$iv.sort();
                        }
                    }
                });
            }
            catch (DBException e$iv) {
                void this_$iv;
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void obtainUsedTypes() {
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl = false;
                Map<Long, String> typeSpecs = this.performQuery(pgBaseIntrospector.getQueries().getRetrieveUsedArgumentTypes());
                this.setMyTypes(new HashMap(typeSpecs.size()));
                for (Map.Entry<Long, String> entry : typeSpecs.entrySet()) {
                    DataType type2;
                    long typeId = ((Number)entry.getKey()).longValue();
                    String typeSpec = entry.getValue();
                    typeSpec = PgBaseIntrospectorKt.normalizeDataTypeSpec(typeSpec);
                    Intrinsics.checkNotNullExpressionValue((Object)DataTypeFactory.of(typeSpec), (String)"of(...)");
                    Long l = typeId;
                    this.getMyTypes().put(l, DasUnresolvedTypeReference.Companion.of(type2));
                }
            }
            catch (DBException e$iv) {
                void this_$iv;
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
        }

        protected void retrieveRoutines(boolean detectDropped, boolean loadNew) {
            ObjectKind objectKind = ObjectKind.ROUTINE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ROUTINE");
            this.this$0.reportRetrieving(objectKind);
            this.inSchema((Function1)new Function1<S, Unit>(this.this$0, detectDropped, this, loadNew){
                final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;
                final /* synthetic */ boolean $detectDropped;
                final /* synthetic */ SchemaRetriever<S> this$1;
                final /* synthetic */ boolean $loadNew;
                {
                    this.this$0 = $receiver;
                    this.$detectDropped = $detectDropped;
                    this.this$1 = $receiver2;
                    this.$loadNew = $loadNew;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull S schema2) {
                    void $this$modifyAndCleanup_u24default$iv;
                    Intrinsics.checkNotNullParameter(schema2, (String)"schema");
                    ModFamily modFamily = schema2.getRoutines();
                    PgBaseIntrospector<MR, D, S> pgBaseIntrospector = this.this$0;
                    boolean bl = this.$detectDropped;
                    SchemaRetriever<S> schemaRetriever = this.this$1;
                    boolean bl2 = this.$loadNew;
                    boolean inc$iv = true;
                    boolean $i$f$modifyAndCleanup = false;
                    $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                    ModNamingIdentifyingFamily routines = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
                    boolean bl3 = false;
                    BaseNativeIntrospector this_$iv = pgBaseIntrospector;
                    boolean $i$f$continueOnDbError = false;
                    try {
                        boolean bl4 = false;
                        if (bl) {
                            long[] $this$forEach$iv = (long[])SchemaRetriever.access$performQuery(schemaRetriever, pgBaseIntrospector.getQueries().getRetrieveExistentRoutines());
                            boolean $i$f$forEach = false;
                            int n = $this$forEach$iv.length;
                            for (int j = 0; j < n; ++j) {
                                long element$iv;
                                long it2 = element$iv = $this$forEach$iv[j];
                                boolean bl5 = false;
                                PgBaseRoutine pgBaseRoutine = (PgBaseRoutine)routines.getByObjectId(it2);
                                if (pgBaseRoutine != null) {
                                    pgBaseRoutine.resetSyncPending();
                                }
                            }
                        }
                        if (bl2) {
                            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(schemaRetriever, pgBaseIntrospector.getQueries().getRetrieveRoutines(), 0, (Function1)new Function1<PgBaseIntroQueries.OneRoutine, Unit>(schemaRetriever, schema2){
                                final /* synthetic */ SchemaRetriever<S> this$0;
                                final /* synthetic */ S $schema;
                                {
                                    this.this$0 = $receiver;
                                    this.$schema = $schema;
                                    super(1);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final void invoke(@NotNull PgBaseIntroQueries.OneRoutine r) {
                                    PgRoutineKind pgRoutineKind;
                                    Iterator<T> iterator;
                                    BasicNameReference basicNameReference;
                                    Regex it2;
                                    int n;
                                    PgBaseRoutine routine2;
                                    Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                                    PgBaseRoutine pgBaseRoutine = routine2 = this.this$0.createRoutine(this.$schema, r);
                                    String string = r.lang;
                                    if (string != null) {
                                        String string2 = string;
                                        PgBaseRoutine pgBaseRoutine2 = pgBaseRoutine;
                                        n = 0;
                                        basicNameReference = BasicNameReference.create((String)it2);
                                        pgBaseRoutine = pgBaseRoutine2;
                                    } else {
                                        basicNameReference = null;
                                    }
                                    pgBaseRoutine.setLanguageRef(basicNameReference);
                                    routine2.setStateNumber(r.r_state_number);
                                    routine2.setReturnsSet(r.ret_set);
                                    PgVolatilityKind pgVolatilityKind = PgVolatilityKind.of(r.volatile_kind);
                                    if (pgVolatilityKind == null) {
                                        pgVolatilityKind = PgVolatilityKind.VOLATILE;
                                    }
                                    routine2.setVolatilityKind(pgVolatilityKind);
                                    PgBaseIntroQueries.ArgumentHolder argumentHolder = r;
                                    PositioningNamingFamily positioningNamingFamily = routine2.getArguments();
                                    Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getArguments(...)");
                                    SchemaRetriever.access$processArgs(this.this$0, argumentHolder, (ModPositioningNamingFamily)positioningNamingFamily, routine2);
                                    if (r.arg_defaults != null) {
                                        void $this$toTypedArray$iv;
                                        List list;
                                        Collection $this$dropLastWhile$iv;
                                        String string3 = r.arg_defaults;
                                        Intrinsics.checkNotNull((Object)string3);
                                        Object object = string3;
                                        it2 = new Regex(",\\s+");
                                        n = 0;
                                        object = it2.split((CharSequence)object, n);
                                        boolean $i$f$dropLastWhile = false;
                                        if (!$this$dropLastWhile$iv.isEmpty()) {
                                            ListIterator<E> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                                            while (iterator$iv.hasPrevious()) {
                                                String p0 = (String)iterator$iv.previous();
                                                boolean bl = false;
                                                if (((CharSequence)p0).length() == 0) continue;
                                                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                                                break;
                                            }
                                        } else {
                                            list = CollectionsKt.emptyList();
                                        }
                                        $this$dropLastWhile$iv = list;
                                        boolean $i$f$toTypedArray = false;
                                        void thisCollection$iv = $this$toTypedArray$iv;
                                        String[] defaults = thisCollection$iv.toArray(new String[0]);
                                        PositioningNamingFamily positioningNamingFamily2 = routine2.getArguments();
                                        Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily2, (String)"getArguments(...)");
                                        List<E> arguments = BaseIntrospectionFunctions.toList(positioningNamingFamily2);
                                        int an = arguments.size();
                                        int k = defaults.length;
                                        for (int i2 = an - 1; -1 < i2; --i2) {
                                            PgBaseArgument a = (PgBaseArgument)arguments.get(i2);
                                            if (a.getArgumentDirection().isIn()) {
                                                if (--k >= 0) {
                                                    String theDefaultExpression = PgBaseIntrospectorKt.normalizeDefaultExpression(defaults[k]);
                                                    a.setDefaultExpression(theDefaultExpression);
                                                    continue;
                                                }
                                                a.setDefaultExpression(null);
                                                continue;
                                            }
                                            a.setDefaultExpression(null);
                                        }
                                    } else {
                                        iterator = routine2.getArguments().iterator();
                                        while (iterator.hasNext()) {
                                            PgBaseArgument a = (PgBaseArgument)iterator.next();
                                            a.setDefaultExpression(null);
                                        }
                                    }
                                    if (r.kind == 'p') {
                                        pgRoutineKind = PgRoutineKind.PG_PROCEDURE;
                                    } else {
                                        Object object = routine2.getReturnArgument();
                                        if (object != null && (object = object.getDasType()) != null && (object = DasTypeUtilsKt.getTypeName((DasType)object)) != null) {
                                            String string4 = ((String)object).toLowerCase();
                                            v12 = string4;
                                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                                        } else {
                                            v12 = iterator = null;
                                        }
                                        pgRoutineKind = Intrinsics.areEqual(iterator, (Object)"trigger") ? PgRoutineKind.PG_TRIGGER : (Intrinsics.areEqual(iterator, (Object)"event_trigger") ? PgRoutineKind.PG_EVENT_TRIGGER : PgRoutineKind.PG_FUNCTION);
                                    }
                                    routine2.setPgRoutineKind(pgRoutineKind);
                                    routine2.getArguments().sort();
                                    routine2.getArguments().removeSyncPendingChildren();
                                }
                            }, 2, null);
                        }
                    }
                    catch (DBException e$iv) {
                        this_$iv.getErrorSink().consume(null, (Object)((Object)e$iv));
                    }
                    $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                    $this$modifyAndCleanup_u24default$iv.sort();
                }
            });
        }

        public <T extends PgBaseArgument> void processArgExtra(@NotNull T argument, @Nullable Character argMode) {
            Intrinsics.checkNotNullParameter(argument, (String)"argument");
        }

        private final <T extends PgBaseArgument> void processArgs(PgBaseIntroQueries.ArgumentHolder r, ModPositioningNamingFamily<T> family, BasicModRoutine routine2) {
            NamingService namingService2 = NamingServices.getNamingService$default(this.this$0.dbms, null, null, 6, null);
            String[] argNames = r.getArgNames();
            char[] argModes = PgBaseIntrospectorKt.stringsToChars(r.getArgModes());
            long[] argTypeIds = r.getArgTypes();
            int argNamesCount = argNames != null ? argNames.length : 0;
            int n = Math.max(argNamesCount, argModes.length);
            int n3 = argTypeIds != null ? argTypeIds.length : 0;
            int n4 = Math.max(n, n3);
            String resultType = null;
            StringBuilder resultArguments = null;
            int i2 = 0;
            int n5 = n4 - 1;
            if (i2 <= n5) {
                while (true) {
                    DasType dt;
                    String string;
                    ArgumentDirection direction;
                    Character argMode;
                    Character c2;
                    Character c3 = c2 = (argMode = ArraysKt.getOrNull((char[])argModes, (int)i2));
                    char c4 = 'b';
                    if (c3 != null && c3.charValue() == c4) {
                        v1 = ArgumentDirection.INOUT;
                    } else {
                        Character c5 = c2;
                        c4 = 'o';
                        if (c5 != null && c5.charValue() == c4) {
                            v1 = ArgumentDirection.OUT;
                        } else {
                            Character c6 = c2;
                            c4 = 't';
                            v1 = direction = c6 != null && c6.charValue() == c4 ? ArgumentDirection.RESULT : ArgumentDirection.IN;
                        }
                    }
                    if (i2 < argNamesCount) {
                        Intrinsics.checkNotNull((Object)argNames);
                        string = argNames[i2];
                    } else {
                        string = null;
                    }
                    String argName = string;
                    DasType dasType = DasTypeSystemBase.UNKNOWN;
                    Intrinsics.checkNotNull((Object)argTypeIds);
                    if (i2 < argTypeIds.length && (dt = this.getMyTypes().get(argTypeIds[i2])) != null) {
                        dasType = dt;
                    }
                    if (r instanceof PgBaseIntroQueries.OneRoutine && ((PgBaseIntroQueries.OneRoutine)r).ret_set && direction == ArgumentDirection.RESULT) {
                        if (resultType == null || resultArguments == null) {
                            resultType = "table";
                            resultArguments = new StringBuilder();
                        } else {
                            resultArguments.append(", ");
                        }
                        if (argName != null) {
                            resultArguments.append(namingService2.enquote(argName, ObjectKind.ARGUMENT)).append(' ');
                        }
                        resultArguments.append(dasType.getSpecification());
                    } else {
                        short position = (short)(i2 + 1);
                        PgBaseArgument argument = (PgBaseArgument)family.getByNaturalPosition(position);
                        if (argument == null) {
                            argument = (PgBaseArgument)family.createNewOne();
                            argument.setPosition(position);
                        } else {
                            argument.resetSyncPending();
                        }
                        argument.setRealName(argName);
                        argument.setArgumentDirection(direction);
                        argument.setStoredType(dasType);
                        this.processArgExtra(argument, argMode);
                    }
                    if (i2 == n5) break;
                    ++i2;
                }
            }
            Object $this$asSafely$iv = r;
            boolean $i$f$asSafely = false;
            Object object = $this$asSafely$iv;
            if (!(object instanceof PgBaseIntroQueries.OneRoutine)) {
                object = null;
            }
            PgBaseIntroQueries.OneRoutine oneRoutine = (PgBaseIntroQueries.OneRoutine)object;
            boolean bl = oneRoutine != null ? oneRoutine.kind == 'p' : false;
            if (bl) {
                $this$asSafely$iv = routine2.getReturnArgument();
                BasicModArgument basicModArgument = $this$asSafely$iv instanceof BasicModArgument ? (BasicModArgument)$this$asSafely$iv : null;
                if (basicModArgument != null) {
                    basicModArgument.drop();
                }
            } else {
                BasicModArgument basicModArgument = routine2.createOrGetReturnArgument();
                Intrinsics.checkNotNullExpressionValue((Object)basicModArgument, (String)"createOrGetReturnArgument(...)");
                BasicModArgument returns = basicModArgument;
                if (resultType != null) {
                    StringBuilder stringBuilder = resultArguments;
                    Intrinsics.checkNotNull(stringBuilder);
                    DataType dataType = DataTypeFactory.ofArgs(null, resultType, stringBuilder.toString(), false);
                    Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"ofArgs(...)");
                    DataType resultDataType = dataType;
                    returns.setArgumentDirection(ArgumentDirection.RESULT);
                    returns.setStoredType(DasUnresolvedTypeReference.Companion.of(resultDataType));
                } else if (r.getReturnType() != 0L) {
                    DasType retType;
                    returns.setArgumentDirection(ArgumentDirection.RETURN);
                    DasType dasType = this.getMyTypes().get(r.getReturnType());
                    if (dasType == null) {
                        dasType = retType = (DasType)DasTypeSystemBase.UNKNOWN;
                    }
                    if (r.getReturnsSet()) {
                        DataType dataType = DataTypeFactory.of("setof " + retType.getSpecification());
                        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                        retType = DasUnresolvedTypeReference.Companion.of(dataType);
                    }
                    returns.setStoredType(retType);
                }
                returns.setRealName(null);
                returns.setPosition((short)0);
                returns.setDefaultExpression(null);
            }
        }

        @NotNull
        protected PgBaseRoutine createRoutine(@NotNull S schema2, @NotNull PgBaseIntroQueries.OneRoutine r) {
            PgBaseRoutine pgBaseRoutine;
            Intrinsics.checkNotNullParameter(schema2, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            PgBaseRoutine $this$createRoutine_u24lambda_u2413 = pgBaseRoutine = schema2.getRoutines().renew(r.r_id, r.r_name);
            boolean bl = false;
            $this$createRoutine_u24lambda_u2413.setSecurityDefiner(r.is_security_definer);
            if (r.configuration_parameters != null) {
                Intrinsics.checkNotNull((Object)r.configuration_parameters);
                $this$createRoutine_u24lambda_u2413.setConfigurationParameters(ArraysKt.toMutableList((Object[])r.configuration_parameters));
            }
            PgBaseRoutine pgBaseRoutine2 = pgBaseRoutine;
            Intrinsics.checkNotNullExpressionValue((Object)pgBaseRoutine2, (String)"apply(...)");
            return pgBaseRoutine2;
        }

        protected void retrieveAggregates(boolean detectDropped, boolean loadNew) {
            ObjectKind objectKind = ObjectKind.AGGREGATE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"AGGREGATE");
            this.this$0.reportRetrieving(objectKind);
            this.inSchema((Function1)new Function1<S, Unit>(this.this$0, detectDropped, this, loadNew){
                final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;
                final /* synthetic */ boolean $detectDropped;
                final /* synthetic */ SchemaRetriever<S> this$1;
                final /* synthetic */ boolean $loadNew;
                {
                    this.this$0 = $receiver;
                    this.$detectDropped = $detectDropped;
                    this.this$1 = $receiver2;
                    this.$loadNew = $loadNew;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull S schema2) {
                    void $this$modifyAndCleanup_u24default$iv;
                    Intrinsics.checkNotNullParameter(schema2, (String)"schema");
                    ModFamily modFamily = schema2.getAggregates();
                    PgBaseIntrospector<MR, D, S> pgBaseIntrospector = this.this$0;
                    boolean bl = this.$detectDropped;
                    SchemaRetriever<S> schemaRetriever = this.this$1;
                    boolean bl2 = this.$loadNew;
                    boolean inc$iv = true;
                    boolean $i$f$modifyAndCleanup = false;
                    $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                    ModNamingIdentifyingFamily aggregates = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
                    boolean bl3 = false;
                    BaseNativeIntrospector this_$iv = pgBaseIntrospector;
                    boolean $i$f$continueOnDbError = false;
                    try {
                        boolean bl4 = false;
                        if (bl) {
                            long[] $this$forEach$iv = (long[])SchemaRetriever.access$performQuery(schemaRetriever, pgBaseIntrospector.getQueries().getRetrieveExistentAggregates());
                            boolean $i$f$forEach = false;
                            int n = $this$forEach$iv.length;
                            for (int j = 0; j < n; ++j) {
                                long element$iv;
                                long it2 = element$iv = $this$forEach$iv[j];
                                boolean bl5 = false;
                                PgBaseAggregate pgBaseAggregate = (PgBaseAggregate)aggregates.getByObjectId(it2);
                                if (pgBaseAggregate != null) {
                                    pgBaseAggregate.resetSyncPending();
                                }
                            }
                        }
                        if (bl2) {
                            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(schemaRetriever, pgBaseIntrospector.getQueries().getRetrieveAggregates(), 0, (Function1)new Function1<PgBaseIntroQueries.OneAggregate, Unit>((ModNamingIdentifyingFamily<? extends PgBaseAggregate>)aggregates, schemaRetriever){
                                final /* synthetic */ ModNamingIdentifyingFamily<? extends PgBaseAggregate> $aggregates;
                                final /* synthetic */ SchemaRetriever<S> this$0;
                                {
                                    this.$aggregates = $aggregates;
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                public final void invoke(@NotNull PgBaseIntroQueries.OneAggregate agg) {
                                    Intrinsics.checkNotNullParameter((Object)agg, (String)"agg");
                                    PgBaseAggregate aggregate = this.$aggregates.renew(agg.aggregate_id, agg.aggregate_name);
                                    aggregate.setStateNumber(agg.state_number);
                                    PgBaseIntroQueries.ArgumentHolder argumentHolder = agg;
                                    PositioningNamingFamily positioningNamingFamily = aggregate.getArguments();
                                    Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getArguments(...)");
                                    Intrinsics.checkNotNull((Object)aggregate);
                                    SchemaRetriever.access$processArgs(this.this$0, argumentHolder, (ModPositioningNamingFamily)positioningNamingFamily, aggregate);
                                    this.this$0.processAggregate(agg, aggregate);
                                    aggregate.getArguments().sort();
                                    aggregate.getArguments().removeSyncPendingChildren();
                                }
                            }, 2, null);
                        }
                    }
                    catch (DBException e$iv) {
                        this_$iv.getErrorSink().consume(null, (Object)((Object)e$iv));
                    }
                    $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                    $this$modifyAndCleanup_u24default$iv.sort();
                }
            });
        }

        protected void processAggregate(@NotNull PgBaseIntroQueries.OneAggregate agg, @NotNull PgBaseAggregate aggregate) {
            Intrinsics.checkNotNullParameter((Object)agg, (String)"agg");
            Intrinsics.checkNotNullParameter((Object)aggregate, (String)"aggregate");
            aggregate.setTransitionRef(this.this$0.createIdOrQNameRef(agg.transition_function_id, agg.transition_function_name, ((PgBaseIntrospector)this.this$0).getDbConnectionInfo().schemaName));
            aggregate.setFinalRef(this.this$0.createIdOrQNameRef(agg.final_function_id, agg.final_function_name, ((PgBaseIntrospector)this.this$0).getDbConnectionInfo().schemaName));
            aggregate.setInitialValue(agg.initial_value);
            DasType dasType = this.getMyTypes().get(agg.transition_type);
            if (dasType == null) {
                dasType = DasTypeSystemBase.UNKNOWN;
            }
            aggregate.setTransitionStoredType(dasType);
        }

        protected void retrieveOperators(boolean detectDropped, boolean loadNew) {
            ObjectKind objectKind = ObjectKind.OPERATOR;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"OPERATOR");
            this.this$0.reportRetrieving(objectKind);
            this.inSchema((Function1)new Function1<S, Unit>(this.this$0, detectDropped, this, loadNew){
                final /* synthetic */ PgBaseIntrospector<MR, D, S> this$0;
                final /* synthetic */ boolean $detectDropped;
                final /* synthetic */ SchemaRetriever<S> this$1;
                final /* synthetic */ boolean $loadNew;
                {
                    this.this$0 = $receiver;
                    this.$detectDropped = $detectDropped;
                    this.this$1 = $receiver2;
                    this.$loadNew = $loadNew;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull S schema2) {
                    void $this$modifyAndCleanup_u24default$iv;
                    Intrinsics.checkNotNullParameter(schema2, (String)"schema");
                    ModFamily modFamily = schema2.getOperators();
                    PgBaseIntrospector<MR, D, S> pgBaseIntrospector = this.this$0;
                    boolean bl = this.$detectDropped;
                    SchemaRetriever<S> schemaRetriever = this.this$1;
                    boolean bl2 = this.$loadNew;
                    boolean inc$iv = true;
                    boolean $i$f$modifyAndCleanup = false;
                    $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                    ModNamingIdentifyingFamily operators = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
                    boolean bl3 = false;
                    BaseNativeIntrospector this_$iv = pgBaseIntrospector;
                    boolean $i$f$continueOnDbError = false;
                    try {
                        boolean bl4 = false;
                        if (bl) {
                            long[] $this$forEach$iv = (long[])SchemaRetriever.access$performQuery(schemaRetriever, pgBaseIntrospector.getQueries().getRetrieveExistentOperators());
                            boolean $i$f$forEach = false;
                            int n = $this$forEach$iv.length;
                            for (int j = 0; j < n; ++j) {
                                long element$iv;
                                long it2 = element$iv = $this$forEach$iv[j];
                                boolean bl5 = false;
                                PgBaseOperator pgBaseOperator = (PgBaseOperator)operators.getByObjectId(it2);
                                if (pgBaseOperator != null) {
                                    pgBaseOperator.resetSyncPending();
                                }
                            }
                        }
                        if (bl2) {
                            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(schemaRetriever, pgBaseIntrospector.getQueries().getRetrieveOperators(), 0, (Function1)new Function1<PgBaseIntroQueries.OneOperator, Unit>((ModNamingIdentifyingFamily<? extends PgBaseOperator>)operators, schemaRetriever){
                                final /* synthetic */ ModNamingIdentifyingFamily<? extends PgBaseOperator> $operators;
                                final /* synthetic */ SchemaRetriever<S> this$0;
                                {
                                    this.$operators = $operators;
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                public final void invoke(@NotNull PgBaseIntroQueries.OneOperator op) {
                                    Intrinsics.checkNotNullParameter((Object)op, (String)"op");
                                    PgBaseOperator operator2 = this.$operators.renew(op.op_id, op.op_name);
                                    Intrinsics.checkNotNull((Object)operator2);
                                    this.this$0.processOperator(op, operator2);
                                }
                            }, 2, null);
                        }
                    }
                    catch (DBException e$iv) {
                        this_$iv.getErrorSink().consume(null, (Object)((Object)e$iv));
                    }
                    $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                    $this$modifyAndCleanup_u24default$iv.sort();
                }
            });
        }

        protected void processOperator(@NotNull PgBaseIntroQueries.OneOperator o2, @NotNull PgBaseOperator operator2) {
            String string;
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            Intrinsics.checkNotNullParameter((Object)operator2, (String)"operator");
            operator2.setStateNumber(o2.state_number);
            operator2.setOperatorKind(PgOperatorKind.of(o2.op_kind));
            DasType dasType = o2.arg_left_type_id > 0L ? this.getMyTypes().get(o2.arg_left_type_id) : null;
            if (dasType == null) {
                dasType = DasTypeSystemBase.UNKNOWN;
            }
            operator2.setLeftStoredType(dasType);
            DasType dasType2 = o2.arg_right_type_id > 0L ? this.getMyTypes().get(o2.arg_right_type_id) : null;
            if (dasType2 == null) {
                dasType2 = DasTypeSystemBase.UNKNOWN;
            }
            operator2.setRightStoredType(dasType2);
            DasType dasType3 = o2.arg_result_type_id > 0L ? this.getMyTypes().get(o2.arg_result_type_id) : null;
            if (dasType3 == null) {
                dasType3 = DasTypeSystemBase.UNKNOWN;
            }
            operator2.setResultStoredType(dasType3);
            operator2.setCallRoutineRef(this.this$0.createIdOrQNameRef(o2.main_id, o2.main_name, ((PgBaseIntrospector)this.this$0).getDbConnectionInfo().schemaName));
            String string2 = string = o2.join_name;
            long l = o2.join_id;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            PgBaseOperator pgBaseOperator = operator2;
            boolean bl = false;
            boolean bl2 = o2.join_id != 0L;
            pgBaseOperator.setJoinRoutineRef(pgBaseIntrospector.createIdOrQNameRef(l, bl2 ? string : null, ((PgBaseIntrospector)this.this$0).getDbConnectionInfo().schemaName));
            String it2 = string = o2.restrict_name;
            l = o2.restrict_id;
            pgBaseIntrospector = this.this$0;
            pgBaseOperator = operator2;
            boolean bl3 = false;
            bl2 = o2.restrict_id != 0L;
            pgBaseOperator.setRestrictRoutineRef(pgBaseIntrospector.createIdOrQNameRef(l, bl2 ? string : null, ((PgBaseIntrospector)this.this$0).getDbConnectionInfo().schemaName));
            it2 = string = o2.neg_name;
            l = o2.neg_id;
            pgBaseIntrospector = this.this$0;
            pgBaseOperator = operator2;
            boolean bl4 = false;
            bl2 = o2.neg_id != 0L;
            pgBaseOperator.setNegateOperatorRef(pgBaseIntrospector.createIdOrQNameRef(l, bl2 ? string : null, ((PgBaseIntrospector)this.this$0).getDbConnectionInfo().schemaName));
            it2 = string = o2.com_name;
            l = o2.com_id;
            pgBaseIntrospector = this.this$0;
            pgBaseOperator = operator2;
            boolean bl5 = false;
            bl2 = o2.com_id != 0L;
            pgBaseOperator.setCommuteOperatorRef(pgBaseIntrospector.createIdOrQNameRef(l, bl2 ? string : null, ((PgBaseIntrospector)this.this$0).getDbConnectionInfo().schemaName));
            operator2.setHashes(o2.hashes);
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTableColumns() {
            if (!this.shouldIntrospectTableRelatedData()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            this.this$0.reportRetrieving(objectKind);
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl = false;
                List<PgBaseIntroQueries.OneColumn> cols2 = this.performQuery(pgBaseIntrospector.getQueries().getRetrieveColumns());
                if (cols2.isEmpty()) {
                    return;
                }
                this.inSchema((Function1)new Function1<S, Unit>(this, cols2){
                    final /* synthetic */ SchemaRetriever<S> this$0;
                    final /* synthetic */ List<PgBaseIntroQueries.OneColumn> $cols;
                    {
                        this.this$0 = $receiver;
                        this.$cols = $cols;
                        super(1);
                    }

                    public final void invoke(@NotNull S it2) {
                        Intrinsics.checkNotNullParameter(it2, (String)"it");
                        this.this$0.processColumns(this.$cols, it2);
                    }
                });
            }
            catch (DBException e$iv) {
                void this_$iv;
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void processColumns(@NotNull List<PgBaseIntroQueries.OneColumn> cols2, @NotNull S schema2) {
            void $this$groupByTo$iv$iv;
            Intrinsics.checkNotNullParameter(cols2, (String)"cols");
            Intrinsics.checkNotNullParameter(schema2, (String)"schema");
            Iterable $this$groupBy$iv = cols2;
            boolean $i$f$groupBy = false;
            Object object = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                PgBaseIntroQueries.OneColumn it2 = (PgBaseIntroQueries.OneColumn)element$iv$iv;
                boolean bl = false;
                Long key$iv$iv = it2.table_id;
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            Map $this$forEach$iv = destination$iv$iv;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.entrySet().iterator();
            while (object.hasNext()) {
                PgBaseLikeStoredTable table;
                Map.Entry element$iv;
                Map.Entry entry = element$iv = (Map.Entry)object.next();
                boolean bl = false;
                if (this.getTableOrView(schema2, '\u0000', ((Number)entry.getKey()).longValue()) == null) continue;
                ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)((Object)table.getColumns());
                boolean inc$iv = true;
                boolean $i$f$modifyAndCleanup = false;
                $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
                ModPositioningNamingFamily columns2 = (ModPositioningNamingFamily)$this$modifyAndCleanup_u24default$iv;
                boolean bl3 = false;
                for (PgBaseIntroQueries.OneColumn col : (List)entry.getValue()) {
                    PgBaseLikeColumn pgBaseLikeColumn;
                    if (col.column_is_dropped) continue;
                    if (col.column_position >= 1) {
                        Object e2 = columns2.createOrGetAt(col.column_position);
                        Intrinsics.checkNotNullExpressionValue(e2, (String)"createOrGetAt(...)");
                        pgBaseLikeColumn = (PgBaseLikeColumn)e2;
                    } else {
                        String string = col.column_name;
                        Intrinsics.checkNotNull((Object)string);
                        Object e3 = columns2.createOrGet(string);
                        Intrinsics.checkNotNullExpressionValue(e3, (String)"createOrGet(...)");
                        pgBaseLikeColumn = (PgBaseLikeColumn)e3;
                    }
                    PgBaseLikeColumn column2 = pgBaseLikeColumn;
                    Intrinsics.checkNotNull((Object)columns2);
                    this.processColumn(col, column2, columns2, table);
                }
                $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
                $this$modifyAndCleanup_u24default$iv.sort();
            }
        }

        protected void processColumn(@NotNull PgBaseIntroQueries.OneColumn col, @NotNull PgBaseLikeColumn column2, @NotNull ModPositioningNamingFamily<? extends PgBaseLikeColumn> columns2, @NotNull PgBaseLikeStoredTable table) {
            String newName;
            Intrinsics.checkNotNullParameter((Object)col, (String)"col");
            Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
            Intrinsics.checkNotNullParameter(columns2, (String)"columns");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            column2.setPosition(col.column_position);
            String string = column2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String oldName = string;
            String string2 = col.column_name;
            if (string2 == null) {
                String string3 = ModelConsts.NO_NAME;
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"NO_NAME");
            }
            if (!Intrinsics.areEqual((Object)oldName, (Object)(newName = string2))) {
                column2.setName(newName);
                if (!Intrinsics.areEqual((Object)oldName, (Object)ModelConsts.NO_NAME)) {
                    this.handleColumnRenaming(table, oldName, newName);
                }
            }
            column2.resetSyncPending();
            column2.setStateNumber(col.column_state_number);
            column2.setStoredType(PgBaseIntrospectorKt.dasTypeOf(col));
            column2.setNotNull(col.mandatory);
            if (column2 instanceof PgBaseTableColumn) {
                ((PgBaseTableColumn)column2).setDefaultExpression(StringKt.nullize$default((String)col.column_default_expression, (boolean)false, (int)1, null));
            }
            column2.setNameSurrogate(this.this$0.isColumnNameSurrogate(col.column_name));
        }

        protected char adjustRelKind(char kind, @Nullable String name2) {
            return kind;
        }

        @Nullable
        protected PgBaseLikeStoredTable getTableOrView(@NotNull S schema2, char relKind, long tableId) {
            PgBaseLikeStoredTable pgBaseLikeStoredTable;
            Intrinsics.checkNotNullParameter(schema2, (String)"schema");
            char lowerCaseKind = Character.toLowerCase(relKind);
            if (this.isTableKind(lowerCaseKind)) {
                pgBaseLikeStoredTable = (PgBaseLikeStoredTable)schema2.getTables().getByObjectId(tableId);
            } else {
                char c2 = lowerCaseKind;
                if (c2 == 'v') {
                    pgBaseLikeStoredTable = (PgBaseLikeStoredTable)schema2.getViews().getByObjectId(tableId);
                } else if (c2 == 'm') {
                    pgBaseLikeStoredTable = (PgBaseLikeStoredTable)schema2.getMatViews().getByObjectId(tableId);
                } else if (c2 == '\u0000') {
                    PgBaseRegularTable pgBaseRegularTable = (PgBaseRegularTable)schema2.getTables().getByObjectId(tableId);
                    if (pgBaseRegularTable != null) {
                        pgBaseLikeStoredTable = pgBaseRegularTable;
                    } else {
                        PgBaseView pgBaseView = (PgBaseView)schema2.getViews().getByObjectId(tableId);
                        pgBaseLikeStoredTable = pgBaseView != null ? (PgBaseLikeStoredTable)pgBaseView : (PgBaseLikeStoredTable)schema2.getMatViews().getByObjectId(tableId);
                    }
                } else {
                    pgBaseLikeStoredTable = null;
                }
            }
            return pgBaseLikeStoredTable;
        }

        protected void handleColumnRenaming(@NotNull PgBaseLikeStoredTable table, @NotNull String oldName, @NotNull String tableName) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
            Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
            ObjectKind objectKind = ObjectKind.KEY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"KEY");
            this.handleColumnRenaming(table, objectKind, oldName, tableName);
            ObjectKind objectKind2 = ObjectKind.FOREIGN_KEY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"FOREIGN_KEY");
            this.handleColumnRenaming(table, objectKind2, oldName, tableName);
        }

        protected void handleColumnRenaming(@NotNull PgBaseLikeStoredTable table, @NotNull ObjectKind childrenKind, @NotNull String oldName, @NotNull String newName) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)childrenKind, (String)"childrenKind");
            Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            ModFamily f = (ModFamily)table.familyOf(childrenKind);
            if (f != null && f.hasChildren()) {
                for (BasicModElement child : f) {
                    if (!(child instanceof BasicModColumniation)) continue;
                    boolean changed = false;
                    ArrayList<String> names2 = new ArrayList<String>((Collection)((BasicModColumniation)child).getColNames());
                    int n = names2.size();
                    for (int i2 = 0; i2 < n; ++i2) {
                        if (!Intrinsics.areEqual(names2.get(i2), (Object)oldName)) continue;
                        names2.set(i2, newName);
                        changed = true;
                    }
                    if (!changed) continue;
                    ((BasicModColumniation)child).setColNames((List<String>)names2);
                    if (child instanceof BasicModNamedElement) {
                        ((BasicModNamedElement)child).setNameSurrogate(this.this$0.isNameSurrogate((BasicModColumniation)child));
                    }
                    if (!Intrinsics.areEqual((Object)childrenKind, (Object)ObjectKind.KEY)) continue;
                    if (table.getSchema() != null) {
                        PgBaseSchema pgBaseSchema;
                        PgBaseIntrospector pgBaseIntrospector = this.this$0;
                        PgBaseSchema it2 = pgBaseSchema;
                        boolean bl = false;
                        pgBaseIntrospector.affectedKeySchemaIds.add((Object)it2.getObjectId());
                    }
                }
            }
        }

        private final void retrieveConstraints(boolean detectDropped, boolean loadNew) {
            this.this$0.reportRetrieving("constraints", "introspection.retrieve.constraints");
            Ref.BooleanRef wasKeys = new Ref.BooleanRef();
            this.inSchema((Function1)new Function1<S, Unit>(this, this.this$0, detectDropped, loadNew, wasKeys){
                final /* synthetic */ SchemaRetriever<S> this$0;
                final /* synthetic */ PgBaseIntrospector<MR, D, S> this$1;
                final /* synthetic */ boolean $detectDropped;
                final /* synthetic */ boolean $loadNew;
                final /* synthetic */ Ref.BooleanRef $wasKeys;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    this.$detectDropped = $detectDropped;
                    this.$loadNew = $loadNew;
                    this.$wasKeys = $wasKeys;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull S schema2) {
                    ModNamingIdentifyingFamily<?>[] $this$forEach$iv;
                    void $this$mapNotNullTo$iv$iv;
                    Intrinsics.checkNotNullParameter(schema2, (String)"schema");
                    ModNamingIdentifyingFamily<PgBaseLikeStoredTable>[] $this$mapNotNull$iv = this.this$0.tableFamilies(schema2);
                    boolean $i$f$mapNotNull = false;
                    ModNamingIdentifyingFamily<PgBaseLikeStoredTable>[] modNamingIdentifyingFamilyArray = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    int n = ((void)$this$forEach$iv$iv$iv).length;
                    for (int j = 0; j < n; ++j) {
                        ModFamily<PgBaseTable> it$iv$iv;
                        void element$iv$iv$iv;
                        void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                        boolean bl = false;
                        void it2 = element$iv$iv;
                        boolean bl2 = false;
                        if (ModelFun.tryCast((ModFamily)it2, PgBaseTable.class) == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List tables2 = (List)destination$iv$iv;
                    SchemaRetriever<S> schemaRetriever = this.this$0;
                    PgBaseIntrospector<MR, D, S> pgBaseIntrospector = this.this$1;
                    boolean bl = this.$detectDropped;
                    SchemaRetriever<S> schemaRetriever2 = this.this$0;
                    boolean bl4 = this.$loadNew;
                    Ref.BooleanRef booleanRef = this.$wasKeys;
                    boolean $i$f$modifyFamiliesAndCleanup = false;
                    Function1 it3 = SchemaRetriever$retrieveConstraints$1$invoke$$inlined$modifyFamiliesAndCleanup$1.INSTANCE;
                    boolean bl5 = false;
                    Iterable $this$forEach$iv2 = tables2;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv : $this$forEach$iv2) {
                        ModFamily tf = (ModFamily)element$iv;
                        boolean bl6 = false;
                        Iterable $this$forEach$iv3 = tf;
                        boolean $i$f$forEach3 = false;
                        for (T element$iv2 : $this$forEach$iv3) {
                            PgBaseTable t = (PgBaseTable)element$iv2;
                            boolean bl7 = false;
                            Intrinsics.checkNotNull((Object)t);
                            $this$forEach$iv = schemaRetriever.constraintFamilies(t);
                            boolean $i$f$forEach4 = false;
                            for (ModNamingIdentifyingFamily<?> element$iv3 : $this$forEach$iv) {
                                it3.invoke(element$iv3);
                            }
                        }
                    }
                    boolean bl8 = false;
                    BaseNativeIntrospector this_$iv = pgBaseIntrospector;
                    boolean $i$f$continueOnDbError = false;
                    try {
                        boolean bl9 = false;
                        if (bl) {
                            LongOpenHashSet ids = new LongOpenHashSet((long[])SchemaRetriever.access$performQuery(schemaRetriever2, pgBaseIntrospector.getQueries().getRetrieveExistentConstraints()));
                            Iterable $this$forEach$iv4 = tables2;
                            boolean $i$f$forEach5 = false;
                            for (T element$iv : $this$forEach$iv4) {
                                ModFamily tf = (ModFamily)element$iv;
                                boolean bl10 = false;
                                Iterable $this$forEach$iv5 = tf;
                                boolean $i$f$forEach6 = false;
                                for (T element$iv4 : $this$forEach$iv5) {
                                    PgBaseTable t = (PgBaseTable)element$iv4;
                                    boolean bl11 = false;
                                    Intrinsics.checkNotNull((Object)t);
                                    ModNamingIdentifyingFamily<?>[] $this$forEach$iv6 = schemaRetriever2.constraintFamilies(t);
                                    boolean $i$f$forEach7 = false;
                                    int n3 = $this$forEach$iv6.length;
                                    for (int j = 0; j < n3; ++j) {
                                        ModNamingIdentifyingFamily<?> element$iv5;
                                        ModNamingIdentifyingFamily<?> f = element$iv5 = $this$forEach$iv6[j];
                                        boolean bl12 = false;
                                        Iterable $this$forEach$iv7 = f;
                                        boolean $i$f$forEach8 = false;
                                        for (T element$iv6 : $this$forEach$iv7) {
                                            BasicModElement it4 = (BasicModElement)element$iv6;
                                            boolean bl13 = false;
                                            if (!ids.contains(((BasicModIdentifiedElement)it4).getObjectId())) continue;
                                            ((BasicModNamedElement)it4).resetSyncPending();
                                        }
                                    }
                                }
                            }
                        }
                        if (bl4) {
                            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(schemaRetriever2, pgBaseIntrospector.getQueries().getRetrieveConstraints(), 0, (Function1)new Function1<PgBaseIntroQueries.OneConstraint, Unit>(schema2, schemaRetriever2, booleanRef){
                                final /* synthetic */ S $schema;
                                final /* synthetic */ SchemaRetriever<S> this$0;
                                final /* synthetic */ Ref.BooleanRef $wasKeys;
                                {
                                    this.$schema = $schema;
                                    this.this$0 = $receiver;
                                    this.$wasKeys = $wasKeys;
                                    super(1);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final void invoke(@NotNull PgBaseIntroQueries.OneConstraint con) {
                                    BasicElement basicElement;
                                    PgBaseObjectWithOwner pgBaseObjectWithOwner;
                                    block12: {
                                        block11: {
                                            void $this$findById$iv;
                                            Intrinsics.checkNotNullParameter((Object)con, (String)"con");
                                            pgBaseObjectWithOwner = this.$schema.getDatabase();
                                            if (pgBaseObjectWithOwner == null) break block11;
                                            basicElement = pgBaseObjectWithOwner;
                                            long objectId$iv = con.table_id;
                                            boolean $i$f$findById = false;
                                            void $this$findAllById$iv$iv = $this$findById$iv;
                                            boolean $i$f$findAllById = false;
                                            JBIterable jBIterable = JBIterable.from((Iterable)$this$findAllById$iv$iv.findIdentifiedElements(objectId$iv)).filter(PgBaseTable.class);
                                            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                                            pgBaseObjectWithOwner = (PgBaseTable)((BasicIdentifiedElement)jBIterable.first());
                                            if (pgBaseObjectWithOwner != null) break block12;
                                        }
                                        return;
                                    }
                                    PgBaseObjectWithOwner table = pgBaseObjectWithOwner;
                                    char c2 = con.con_kind;
                                    if ((c2 == 'p' ? true : c2 == 'u') ? true : c2 == 'x') {
                                        PgBaseRegularTable pgBaseRegularTable = table instanceof PgBaseRegularTable ? (PgBaseRegularTable)table : null;
                                        if (pgBaseRegularTable != null) {
                                            basicElement = pgBaseRegularTable;
                                            SchemaRetriever<S> schemaRetriever = this.this$0;
                                            Ref.BooleanRef booleanRef = this.$wasKeys;
                                            BasicElement it2 = basicElement;
                                            boolean bl = false;
                                            PgBaseKey key2 = (PgBaseKey)it2.getKeys().renew(con.con_id, con.con_name);
                                            Intrinsics.checkNotNull((Object)key2);
                                            schemaRetriever.processKey(key2, (PgBaseTable)it2, con);
                                            booleanRef.element = true;
                                        }
                                    } else if (c2 == 'f') {
                                        PgBaseRegularTable pgBaseRegularTable = table instanceof PgBaseRegularTable ? (PgBaseRegularTable)table : null;
                                        if (pgBaseRegularTable != null) {
                                            basicElement = pgBaseRegularTable;
                                            SchemaRetriever<S> schemaRetriever = this.this$0;
                                            S s2 = this.$schema;
                                            BasicElement it3 = basicElement;
                                            boolean bl = false;
                                            PgBaseForeignKey fkey = (PgBaseForeignKey)it3.getForeignKeys().renew(con.con_id, con.con_name);
                                            Intrinsics.checkNotNull((Object)fkey);
                                            schemaRetriever.processForeignKey(fkey, (PgBaseTable)it3, con, s2);
                                        }
                                    } else if (c2 == 'c') {
                                        this.this$0.processCheck((PgBaseTable)table, con);
                                    }
                                }
                            }, 2, null);
                        }
                    }
                    catch (DBException e$iv) {
                        this_$iv.getErrorSink().consume(null, (Object)((Object)e$iv));
                    }
                    it = SchemaRetriever$retrieveConstraints$1$invoke$$inlined$modifyFamiliesAndCleanup$2.INSTANCE;
                    $i$a$-modifyFamiliesAndCleanup-PgBaseIntrospector$SchemaRetriever$retrieveConstraints$1$1 = false;
                    $this$forEach$iv = tables2;
                    $i$f$forEach2 = false;
                    for (T element$iv : $this$forEach$iv) {
                        ModFamily tf = (ModFamily)element$iv;
                        boolean bl14 = false;
                        Iterable $this$forEach$iv8 = tf;
                        boolean $i$f$forEach9 = false;
                        for (T element$iv2 : $this$forEach$iv8) {
                            PgBaseTable t = (PgBaseTable)element$iv2;
                            boolean bl15 = false;
                            Intrinsics.checkNotNull((Object)t);
                            $this$forEach$iv = schemaRetriever.constraintFamilies(t);
                            boolean $i$f$forEach10 = false;
                            for (ModNamingIdentifyingFamily<?> element$iv7 : $this$forEach$iv) {
                                it.invoke(element$iv7);
                            }
                        }
                    }
                }
            });
            if (wasKeys.element) {
                ((Collection)this.this$0.affectedKeySchemaIds).add(((PgBaseSchema)this.getSchema()).getObjectId());
            }
        }

        @NotNull
        protected ModNamingIdentifyingFamily<?>[] constraintFamilies(@NotNull PgBaseTable table) {
            ModNamingIdentifyingFamily[] modNamingIdentifyingFamilyArray;
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            PgBaseRegularTable pgBaseRegularTable = table instanceof PgBaseRegularTable ? (PgBaseRegularTable)table : null;
            if (pgBaseRegularTable != null) {
                PgBaseRegularTable $this$constraintFamilies_u24lambda_u2423 = pgBaseRegularTable;
                boolean bl = false;
                ModNamingIdentifyingFamily[] modNamingIdentifyingFamilyArray2 = new ModNamingIdentifyingFamily[2];
                Intrinsics.checkNotNullExpressionValue((Object)$this$constraintFamilies_u24lambda_u2423.getKeys(), (String)"getKeys(...)");
                Intrinsics.checkNotNullExpressionValue((Object)$this$constraintFamilies_u24lambda_u2423.getForeignKeys(), (String)"getForeignKeys(...)");
                modNamingIdentifyingFamilyArray = modNamingIdentifyingFamilyArray2;
            } else {
                boolean $i$f$emptyArray = false;
                modNamingIdentifyingFamilyArray = new ModNamingIdentifyingFamily[]{};
            }
            return modNamingIdentifyingFamilyArray;
        }

        protected void processKey(@NotNull PgBaseKey key2, @NotNull PgBaseTable table, @NotNull PgBaseIntroQueries.OneConstraint con) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)con, (String)"con");
            key2.setPrimary(con.con_kind == 'p');
            key2.setStateNumber(con.con_state_id);
            String string = con.con_columns;
            String string2 = "Key " + con.con_name + " column positions";
            PositioningNamingFamily positioningNamingFamily = table.getColumns();
            Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
            key2.setColNames(this.peekColNames(string, string2, positioningNamingFamily));
            key2.setNameSurrogate(this.this$0.isNameSurrogate(key2));
        }

        protected void processCheck(@NotNull PgBaseTable table, @NotNull PgBaseIntroQueries.OneConstraint con) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)con, (String)"con");
        }

        protected void processForeignKey(@NotNull PgBaseForeignKey fkey, @NotNull PgBaseTable table, @NotNull PgBaseIntroQueries.OneConstraint con, @NotNull S schema2) {
            Intrinsics.checkNotNullParameter((Object)fkey, (String)"fkey");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)con, (String)"con");
            Intrinsics.checkNotNullParameter(schema2, (String)"schema");
            fkey.setStateNumber(con.con_state_id);
            fkey.setRefTableRef(BasicIdReference.create(con.ref_table_id));
            String string = con.con_columns;
            String string2 = "Foreign key " + con.con_name + " domestic column positions";
            PositioningNamingFamily positioningNamingFamily = table.getColumns();
            Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getColumns(...)");
            fkey.setColNames(this.peekColNames(string, string2, positioningNamingFamily));
            fkey.setNameSurrogate(this.this$0.isNameSurrogate(fkey));
            List<Short> refColPositions = PgBaseIntrospectorKt.parseArrayOfPositions(con.ref_columns, "Foreign Key " + fkey.getName() + " ref columns");
            fkey.setRefKeyRef(BasicByColumnPositionsReference.create(refColPositions));
        }

        protected boolean hasReference(@NotNull PgBaseIntroQueries.OneConstraint con) {
            Intrinsics.checkNotNullParameter((Object)con, (String)"con");
            return con.ref_table_id > 0L && con.ref_columns != null;
        }

        @NotNull
        protected final List<String> peekColNames(@Nullable String columnPositions, @NotNull String what, @NotNull PositioningFamily<? extends BasicTableOrViewColumn> columns2) {
            Intrinsics.checkNotNullParameter((Object)what, (String)"what");
            Intrinsics.checkNotNullParameter(columns2, (String)"columns");
            List<Short> positions = PgBaseIntrospectorKt.parseArrayOfPositions(columnPositions, what);
            int n = positions.size();
            ArrayList<String> names2 = new ArrayList<String>(n);
            Iterator<Short> iterator = positions.iterator();
            while (iterator.hasNext()) {
                String it2;
                short position = ((Number)iterator.next()).shortValue();
                if (this.getColumnName(columns2, position) == null) continue;
                boolean bl = false;
                names2.add(it2);
            }
            return names2;
        }

        @Nullable
        protected final String getColumnName(@NotNull PositioningFamily<? extends BasicTableOrViewColumn> $this$getColumnName, short position) {
            Intrinsics.checkNotNullParameter($this$getColumnName, (String)"<this>");
            return this.this$0.getHelper().getColumnName($this$getColumnName, position);
        }

        /*
         * WARNING - void declaration
         */
        protected void retrieveDescriptions(boolean detectDropped, boolean loadNew) {
            this.this$0.reportRetrieving("comments", "introspection.retrieve.comments");
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl = false;
                this.inSchema((Function1)new Function1<S, Unit>(detectDropped, this, loadNew, pgBaseIntrospector){
                    final /* synthetic */ boolean $detectDropped;
                    final /* synthetic */ SchemaRetriever<S> this$0;
                    final /* synthetic */ boolean $loadNew;
                    final /* synthetic */ PgBaseIntrospector<MR, D, S> this$1;
                    {
                        this.$detectDropped = $detectDropped;
                        this.this$0 = $receiver;
                        this.$loadNew = $loadNew;
                        this.this$1 = $receiver2;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull S schema2) {
                        Intrinsics.checkNotNullParameter(schema2, (String)"schema");
                        Long2ObjectMap existentComments = this.$detectDropped ? this.this$0.listExistentComments() : (Long2ObjectMap)new Long2ObjectOpenHashMap();
                        SchemaRetriever.access$removeDroppedComments(this.this$0, existentComments);
                        if (this.$loadNew) {
                            void $this$forEach$iv;
                            void $this$groupByTo$iv$iv;
                            Object $this$groupBy$iv = (Iterable)SchemaRetriever.access$performQuery(this.this$0, this.this$1.getQueries().getRetrieveSchemaComments());
                            boolean $i$f$groupBy = false;
                            Iterable iterable = $this$groupBy$iv;
                            Map destination$iv$iv = new LinkedHashMap<K, V>();
                            boolean $i$f$groupByTo = false;
                            for (T element$iv$iv : $this$groupByTo$iv$iv) {
                                Object object;
                                PgBaseIntroQueries.OneComment it2 = (PgBaseIntroQueries.OneComment)element$iv$iv;
                                boolean bl = false;
                                Long key$iv$iv = it2.id;
                                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                                boolean $i$f$getOrPut = false;
                                V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                                if (value$iv$iv$iv == null) {
                                    boolean bl2 = false;
                                    List answer$iv$iv$iv = new ArrayList<E>();
                                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                                    object = answer$iv$iv$iv;
                                } else {
                                    object = value$iv$iv$iv;
                                }
                                List list$iv$iv = (List)object;
                                list$iv$iv.add(element$iv$iv);
                            }
                            $this$groupBy$iv = destination$iv$iv;
                            SchemaRetriever<S> schemaRetriever = this.this$0;
                            boolean $i$f$forEach = false;
                            Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                            while (iterator.hasNext()) {
                                Map.Entry<K, V> element$iv;
                                Map.Entry<K, V> it3 = element$iv = iterator.next();
                                boolean bl = false;
                                if (schemaRetriever.findObjectById(schema2, ((PgBaseIntroQueries.OneComment)CollectionsKt.first((List)((List)it3.getValue()))).kind, ((Number)it3.getKey()).longValue()) == null) continue;
                                Iterable $this$forEach$iv2 = (Iterable)it3.getValue();
                                boolean $i$f$forEach2 = false;
                                for (T element$iv2 : $this$forEach$iv2) {
                                    BasicElement obj2;
                                    BasicModNamedElement target2;
                                    PgBaseIntroQueries.OneComment it4 = (PgBaseIntroQueries.OneComment)element$iv2;
                                    boolean bl3 = false;
                                    BasicModNamedElement basicModNamedElement = target2 = it4.sub_id == 0 ? (obj2 instanceof BasicModNamedElement ? (BasicModNamedElement)obj2 : null) : (obj2 instanceof BasicModLikeTable ? (BasicModNamedElement)((BasicModLikeTable)obj2).getColumns().getByNaturalPosition(it4.sub_id) : (obj2 instanceof PgBaseDefType ? (BasicModNamedElement)((PgBaseDefType)obj2).getAttributes().getByNaturalPosition(it4.sub_id) : null));
                                    if (basicModNamedElement == null) continue;
                                    basicModNamedElement.setComment(it4.description);
                                }
                            }
                        }
                    }
                });
            }
            catch (DBException e$iv) {
                void this_$iv;
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Nullable
        protected BasicElement findObjectById(@NotNull S schema2, @Nullable Character kind, long id) {
            BasicIdentifiedElement basicIdentifiedElement;
            Intrinsics.checkNotNullParameter(schema2, (String)"schema");
            BasicSchema $this$findById$iv = (BasicSchema)schema2;
            boolean $i$f$findById = false;
            BasicDatabase basicDatabase = $this$findById$iv.getDatabase();
            if (basicDatabase != null) {
                Function1 function1;
                BasicDatabase $this$findAllById$iv$iv = basicDatabase;
                boolean $i$f$findAllById = false;
                JBIterable jBIterable = JBIterable.from((Iterable)$this$findAllById$iv$iv.findIdentifiedElements(id)).filter(BasicIdentifiedElement.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                basicDatabase = jBIterable;
                if (jBIterable != null && (basicDatabase = basicDatabase.filter(new Condition(function1 = (Function1)new Function1<BasicIdentifiedElement, Boolean>($this$findById$iv){
                    final /* synthetic */ BasicSchema $this_findById;
                    {
                        this.$this_findById = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(BasicIdentifiedElement it2) {
                        return Intrinsics.areEqual((Object)it2.getSchema(), (Object)this.$this_findById);
                    }
                }){
                    private final /* synthetic */ Function1 function;
                    {
                        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                        this.function = function2;
                    }

                    public final /* synthetic */ boolean value(Object p0) {
                        return (Boolean)this.function.invoke(p0);
                    }
                })) != null) {
                    basicIdentifiedElement = (BasicIdentifiedElement)basicDatabase.first();
                    return basicIdentifiedElement;
                }
            }
            basicIdentifiedElement = null;
            return basicIdentifiedElement;
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveViewSources() {
            if (!this.getWithSources()) {
                return;
            }
            this.setQueryParameter("INCSRC", this.getMode().increment && this.incrementalViewSources());
            this.this$0.reportRetrieving("view sources", "introspection.retrieve.view.sources");
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl = false;
                BaseNativeIntrospector this_$iv = pgBaseIntrospector;
                boolean $i$f$writeSources = false;
                this_$iv.getModel().writeSources(new Runnable(this, pgBaseIntrospector){
                    final /* synthetic */ SchemaRetriever this$0;
                    final /* synthetic */ PgBaseIntrospector this$1$inlined;
                    {
                        this.this$0 = schemaRetriever;
                        this.this$1$inlined = pgBaseIntrospector;
                    }

                    public final void run() {
                        boolean bl = false;
                        SchemaRetriever.access$inSchema(this.this$0, (Function1)new Function1<S, Unit>(this.this$0, this.this$1$inlined){
                            final /* synthetic */ SchemaRetriever<S> this$0;
                            final /* synthetic */ PgBaseIntrospector<MR, D, S> this$1;
                            {
                                this.this$0 = $receiver;
                                this.this$1 = $receiver2;
                                super(1);
                            }

                            public final void invoke(@NotNull S schema2) {
                                Intrinsics.checkNotNullParameter(schema2, (String)"schema");
                                BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this.this$0, this.this$1.getQueries().getRetrieveViewSources(), 0, (Function1)new Function1<PgBaseIntroQueries.OneViewSource, Unit>(this.this$0, schema2){
                                    final /* synthetic */ SchemaRetriever<S> this$0;
                                    final /* synthetic */ S $schema;
                                    {
                                        this.this$0 = $receiver;
                                        this.$schema = $schema;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull PgBaseIntroQueries.OneViewSource vs) {
                                        Intrinsics.checkNotNullParameter((Object)vs, (String)"vs");
                                        PgBaseLikeStoredTable view2 = this.this$0.getTableOrView(this.$schema, this.this$0.adjustRelKind(vs.view_kind, vs.view_name), vs.view_id);
                                        String sourceText = vs.source_text;
                                        this.this$0.processViewSource(view2, sourceText);
                                    }
                                }, 2, null);
                            }
                        });
                    }
                });
            }
            catch (DBException e$iv) {
                void this_$iv;
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
        }

        protected void processViewSource(@Nullable PgBaseLikeStoredTable view2, @Nullable String sourceText) {
            if (view2 instanceof PgBaseView) {
                this.applyViewSourceText((PgBaseSourceAware)((Object)view2), sourceText);
            }
            if (view2 instanceof PgBaseMatView) {
                this.applyViewSourceText((PgBaseSourceAware)((Object)view2), sourceText);
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void retrieveFunSources() {
            if (!this.getWithSources()) {
                return;
            }
            this.this$0.reportRetrieving("functions' sources", "introspection.retrieve.routine.sources");
            BaseNativeIntrospector baseNativeIntrospector = this.this$0;
            PgBaseIntrospector pgBaseIntrospector = this.this$0;
            boolean $i$f$continueOnDbError = false;
            try {
                boolean bl = false;
                BaseNativeIntrospector this_$iv = pgBaseIntrospector;
                boolean $i$f$writeSources = false;
                this_$iv.getModel().writeSources(new Runnable(this, pgBaseIntrospector){
                    final /* synthetic */ SchemaRetriever this$0;
                    final /* synthetic */ PgBaseIntrospector this$1$inlined;
                    {
                        this.this$0 = schemaRetriever;
                        this.this$1$inlined = pgBaseIntrospector;
                    }

                    public final void run() {
                        boolean bl = false;
                        SchemaRetriever.access$inSchema(this.this$0, (Function1)new Function1<S, Unit>(this.this$0, this.this$1$inlined){
                            final /* synthetic */ SchemaRetriever<S> this$0;
                            final /* synthetic */ PgBaseIntrospector<MR, D, S> this$1;
                            {
                                this.this$0 = $receiver;
                                this.this$1 = $receiver2;
                                super(1);
                            }

                            public final void invoke(@NotNull S schema2) {
                                Intrinsics.checkNotNullParameter(schema2, (String)"schema");
                                BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this.this$0, this.this$1.getQueries().getRetrieveFunctionSources(), 0, (Function1)new Function1<PgBaseIntroQueries.OneFunctionSource, Unit>(schema2, this.this$0){
                                    final /* synthetic */ S $schema;
                                    final /* synthetic */ SchemaRetriever<S> this$0;
                                    {
                                        this.$schema = $schema;
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull PgBaseIntroQueries.OneFunctionSource fs) {
                                        Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
                                        PgBaseRoutine pgBaseRoutine = (PgBaseRoutine)this.$schema.getRoutines().getByObjectId(fs.id);
                                        if (pgBaseRoutine == null) {
                                            return;
                                        }
                                        PgBaseRoutine function2 = pgBaseRoutine;
                                        SchemaRetriever.access$processFunSource(this.this$0, function2, fs);
                                    }
                                }, 2, null);
                            }
                        });
                    }
                });
            }
            catch (DBException e$iv) {
                void this_$iv;
                this_$iv.getErrorSink().consume(null, (Object)e$iv);
            }
        }

        private final void processFunSource(PgBaseRoutine function2, PgBaseIntroQueries.OneFunctionSource fs) {
            this.processFunSourceAttributes(function2, fs);
            function2.setSourceText(this.getFunSourceText(fs));
        }

        protected void processFunSourceAttributes(@NotNull PgBaseRoutine function2, @NotNull PgBaseIntroQueries.OneFunctionSource fs) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
            function2.setArgumentsDefinition(StringKt.nullize((String)fs.arguments_def, (boolean)true));
            function2.setResultsDefinition(StringKt.nullize((String)fs.result_def, (boolean)true));
        }

        @Nullable
        protected CompositeText getFunSourceText(@NotNull PgBaseIntroQueries.OneFunctionSource fs) {
            Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
            String string = fs.source_text;
            return string != null ? BaseIntrospectionFunctions.toCompositeText(string, CompositeText.Kind.ORIGINAL_TEXT) : null;
        }

        private final void applyViewSourceText(PgBaseSourceAware $this$applyViewSourceText, String sourceText) {
            CharSequence charSequence = sourceText;
            if (charSequence == null || charSequence.length() == 0) {
                $this$applyViewSourceText.setSourceText(null);
                return;
            }
            String body2 = PgBaseIntrospectorKt.removeSuffix(((Object)StringsKt.trim((CharSequence)sourceText)).toString(), ';');
            $this$applyViewSourceText.setSourceText(BaseIntrospectionFunctions.toCompositeText(body2, CompositeText.Kind.DECOMPILED_TEXT));
        }

        protected final boolean shouldIntrospectTableRelatedData() {
            return this.wasDataTables() || this.getMode().increment && this.shouldIntrospectTableRelatedDataIncremental();
        }

        protected boolean shouldIntrospectTableRelatedDataIncremental() {
            return ((PgBaseSchema)this.getSchema()).getTables().hasChildren();
        }

        protected boolean wasDataTables() {
            return this.wasTables || this.wasViews || this.wasMatViews;
        }

        protected abstract void processModView(@NotNull PgBaseLikeStoredTable var1, @NotNull PgBaseIntroQueries.OneTable var2);

        protected abstract void processModTable(@NotNull PgBaseTable var1, @NotNull PgBaseIntroQueries.OneTable var2);

        private static final boolean retrieveAcls$lambda$2$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ void access$retrieveTables(SchemaRetriever $this, boolean detectDropped, boolean loadNew) {
            $this.retrieveTables(detectDropped, loadNew);
        }

        public static final /* synthetic */ void access$retrieveTableColumns(SchemaRetriever $this) {
            $this.retrieveTableColumns();
        }

        public static final /* synthetic */ void access$retrieveConstraints(SchemaRetriever $this, boolean detectDropped, boolean loadNew) {
            $this.retrieveConstraints(detectDropped, loadNew);
        }

        public static final /* synthetic */ void access$retrieveAcls(SchemaRetriever $this, boolean detectDropped, boolean loadNew) {
            $this.retrieveAcls(detectDropped, loadNew);
        }

        public static final /* synthetic */ void access$retrieveViewSources(SchemaRetriever $this) {
            $this.retrieveViewSources();
        }

        public static final /* synthetic */ Object access$performQuery(SchemaRetriever $this, SqlQuery query) {
            return $this.performQuery(query);
        }

        public static final /* synthetic */ void access$processArgs(SchemaRetriever $this, PgBaseIntroQueries.ArgumentHolder r, ModPositioningNamingFamily family, BasicModRoutine routine2) {
            $this.processArgs(r, family, routine2);
        }

        public static final /* synthetic */ void access$toGrants(SchemaRetriever $this, List $receiver, List newGrants) {
            $this.toGrants($receiver, newGrants);
        }

        public static final /* synthetic */ void access$removeDroppedComments(SchemaRetriever $this, Long2ObjectMap existentComments) {
            $this.removeDroppedComments((Long2ObjectMap<Short[]>)existentComments);
        }

        public static final /* synthetic */ void access$inSchema(SchemaRetriever $this, Function1 modifier) {
            $this.inSchema(modifier);
        }

        public static final /* synthetic */ void access$processFunSource(SchemaRetriever $this, PgBaseRoutine function2, PgBaseIntroQueries.OneFunctionSource fs) {
            $this.processFunSource(function2, fs);
        }
    }
}

