/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.generator;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.ElementProducer;
import com.intellij.database.dialects.base.generator.GrantsHelper;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelper;
import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.AlterProducerBase;
import com.intellij.database.dialects.base.generator.producers.BaseProducersKt;
import com.intellij.database.dialects.base.generator.producers.CreateProducer;
import com.intellij.database.dialects.base.generator.producers.CreateProducerBase;
import com.intellij.database.dialects.base.generator.producers.DropProducer;
import com.intellij.database.dialects.base.generator.producers.Flags;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseAlterDatabase;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseAlterForeignKey;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseAlterKey;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseAlterSchema;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseAlterTable;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseAlterTableColumn;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseAlterView;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseAlterViewColumn;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseCreateDatabase;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseCreateForeignKey;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseCreateKey;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseCreateSchema;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseCreateView;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseDropConstraint;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseDropDatabase;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseDropRoutine;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseDropSchema;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseDropTable;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseDropTableColumn;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseDropView;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseGrantsProducer;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseOwnerAwareAlterProducer;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseOwnerAwareProducer;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseRoleHelper;
import com.intellij.database.dialects.postgresbase.generator.producers.PgBaseRoutineProducersKt;
import com.intellij.database.dialects.postgresbase.model.PgBaseAggregate;
import com.intellij.database.dialects.postgresbase.model.PgBaseConstraint;
import com.intellij.database.dialects.postgresbase.model.PgBaseDefTypeAttribute;
import com.intellij.database.dialects.postgresbase.model.PgBaseForeignKey;
import com.intellij.database.dialects.postgresbase.model.PgBaseKey;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeDatabase;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeSchema;
import com.intellij.database.dialects.postgresbase.model.PgBaseObjectWithOwner;
import com.intellij.database.dialects.postgresbase.model.PgBaseRole;
import com.intellij.database.dialects.postgresbase.model.PgBaseRoutine;
import com.intellij.database.dialects.postgresbase.model.PgBaseSchema;
import com.intellij.database.dialects.postgresbase.model.PgBaseTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseTableColumn;
import com.intellij.database.dialects.postgresbase.model.PgBaseView;
import com.intellij.database.dialects.postgresbase.model.PgBaseViewColumn;
import com.intellij.database.dialects.postgresbase.model.properties.PgObjectGrant;
import com.intellij.database.dialects.postgresbase.model.properties.PgObjectGrantController;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicGrantee;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaReferenceId;
import com.intellij.database.script.generator.ScriptLocus;
import com.intellij.database.script.generator.ScriptingOption;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0016J \u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0016J\u001c\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H\u0016J\u001c\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H\u0016J\u0014\u0010$\u001a\u00020%2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0014J\u0014\u0010'\u001a\u00020(2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*H\u0016J\u0010\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020\u0016H\u0016J*\u0010-\u001a\u00020%2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020/01H\u0016J \u00102\u001a\u00020%\"\b\b\u0000\u00103*\u00020!2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H304H\u0016J\u0012\u00105\u001a\u0004\u0018\u00010!2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u00106\u001a\u00020\u0016*\u0006\u0012\u0002\b\u0003072\u0006\u00108\u001a\u000209H\u0016R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\"\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u0010X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006:"}, d2={"Lcom/intellij/database/dialects/postgresbase/generator/PgBaseScriptGeneratorHelper;", "Lcom/intellij/database/dialects/base/generator/ScriptGeneratorHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "grantsHelper", "Lcom/intellij/database/dialects/base/generator/GrantsHelper;", "Lcom/intellij/database/dialects/postgresbase/model/properties/PgObjectGrant;", "Lcom/intellij/database/model/basic/BasicGrantee;", "getGrantsHelper", "()Lcom/intellij/database/dialects/base/generator/GrantsHelper;", "roleHelper", "Lcom/intellij/database/dialects/postgresbase/generator/producers/PgBaseRoleHelper;", "getRoleHelper", "()Lcom/intellij/database/dialects/postgresbase/generator/producers/PgBaseRoleHelper;", "supportsCreateOrReplace", "", "Lcom/intellij/database/model/ObjectKind;", "kotlin.jvm.PlatformType", "getSupportsCreateOrReplace", "()Ljava/util/Set;", "commentStr", "", "comment", "createAlterProducerImpl", "Lcom/intellij/database/dialects/base/generator/producers/AlterProducerBase;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "elements", "Lcom/intellij/database/model/ElementAlteration;", "createDropProducerImpl", "Lcom/intellij/database/dialects/base/generator/producers/DropProducer;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "createProducerImpl", "Lcom/intellij/database/dialects/base/generator/producers/CreateProducer;", "initAlterProducer", "", "producer", "isOptionSupported", "", "option", "Lcom/intellij/database/script/generator/ScriptingOption;", "isSchemaAlwaysInPath", "sc", "produceAlterFlag", "id", "Lcom/intellij/database/model/meta/BasicMetaId;", "produced", "", "produceCreate", "T", "Lcom/intellij/database/dialects/base/generator/producers/CreateProducerBase;", "qualifier", "aggregateArgumentsDefinition", "Lcom/intellij/database/dialects/base/generator/ElementProducer;", "agg", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseAggregate;", "intellij.database.dialects.postgresbase"})
public abstract class PgBaseScriptGeneratorHelper
extends ScriptGeneratorHelper {
    @NotNull
    private final Set<ObjectKind> supportsCreateOrReplace;
    @NotNull
    private final GrantsHelper<PgObjectGrant, BasicGrantee> grantsHelper;
    @NotNull
    private final PgBaseRoleHelper roleHelper;

    public PgBaseScriptGeneratorHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
        Object object = new ObjectKind[]{ObjectKind.VIEW, ObjectKind.MAT_VIEW, ObjectKind.RULE, ObjectKind.ROUTINE};
        this.supportsCreateOrReplace = SetsKt.setOf((Object[])object);
        object = PgObjectGrantController.INSTANCE;
        this.grantsHelper = new GrantsHelper<PgObjectGrant, BasicGrantee>((PgObjectGrantController)object){

            @NotNull
            public PgBaseGrantsProducer createProducer(@NotNull ScriptingContext context, @Nullable BasicElement element2, @Nullable BasicGrantee grantee, @NotNull Collection<PgObjectGrant> grants) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter(grants, (String)"grants");
                return new PgBaseGrantsProducer(context, element2, grantee, grants);
            }
        };
        this.roleHelper = new PgBaseRoleHelper();
    }

    @Override
    @NotNull
    protected Set<ObjectKind> getSupportsCreateOrReplace() {
        return this.supportsCreateOrReplace;
    }

    @Override
    @Nullable
    public BasicElement qualifier(@NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return element2 instanceof PgBaseDefTypeAttribute ? (BasicElement)((PgBaseDefTypeAttribute)element2).getParent() : super.qualifier(element2);
    }

    @Override
    @NotNull
    public String commentStr(@Nullable String comment) {
        String string = comment;
        if (string == null || (string = ScriptGeneratorHelperKt.getSqlString(string)) == null) {
            string = "null";
        }
        return string;
    }

    @NotNull
    public GrantsHelper<PgObjectGrant, BasicGrantee> getGrantsHelper() {
        return this.grantsHelper;
    }

    @Override
    @NotNull
    public CreateProducer<?> createProducerImpl(@NotNull ScriptingContext context, @NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        BasicElement basicElement = element2;
        return basicElement instanceof PgBaseView ? (CreateProducer)new PgBaseCreateView<PgBaseView>(context, (PgBaseView)element2) : (basicElement instanceof PgBaseSchema ? (CreateProducer)new PgBaseCreateSchema<PgBaseSchema>(context, (PgBaseSchema)element2) : (basicElement instanceof PgBaseLikeDatabase ? (CreateProducer)new PgBaseCreateDatabase<PgBaseLikeDatabase>(context, (PgBaseLikeDatabase)element2) : (basicElement instanceof PgBaseKey ? (CreateProducer)new PgBaseCreateKey<PgBaseKey>(context, (PgBaseKey)element2) : (basicElement instanceof PgBaseForeignKey ? (CreateProducer)new PgBaseCreateForeignKey(context, (PgBaseForeignKey)element2) : super.createProducerImpl(context, element2)))));
    }

    @Override
    @NotNull
    public DropProducer<?> createDropProducerImpl(@NotNull ScriptingContext context, @NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        BasicElement basicElement = element2;
        return basicElement instanceof PgBaseConstraint ? (DropProducer)new PgBaseDropConstraint(context, (PgBaseConstraint)element2) : (basicElement instanceof PgBaseTableColumn ? (DropProducer)new PgBaseDropTableColumn<PgBaseTableColumn>(context, (PgBaseTableColumn)element2) : (basicElement instanceof PgBaseRoutine ? (DropProducer)new PgBaseDropRoutine(context, (PgBaseRoutine)element2) : (basicElement instanceof PgBaseView ? (DropProducer)new PgBaseDropView(context, (PgBaseView)element2) : (basicElement instanceof PgBaseTable ? (DropProducer)new PgBaseDropTable(context, (PgBaseTable)element2) : (basicElement instanceof PgBaseLikeDatabase ? (DropProducer)new PgBaseDropDatabase(context, (PgBaseLikeDatabase)element2) : (basicElement instanceof PgBaseLikeSchema ? (DropProducer)new PgBaseDropSchema<PgBaseLikeSchema>(context, (PgBaseLikeSchema)element2) : super.createDropProducerImpl(context, element2)))))));
    }

    @Override
    @NotNull
    public AlterProducerBase<?> createAlterProducerImpl(@NotNull ScriptingContext context, @NotNull ElementAlteration<?> elements2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        Object it2 = elements2.getSourceElement();
        boolean bl = false;
        Object obj2 = it2;
        return obj2 instanceof PgBaseLikeDatabase ? (AlterProducerBase)new PgBaseAlterDatabase(context, BaseProducersKt.cast(elements2, it2)) : (obj2 instanceof PgBaseLikeSchema ? (AlterProducerBase)new PgBaseAlterSchema(context, BaseProducersKt.cast(elements2, it2)) : (obj2 instanceof PgBaseViewColumn ? (AlterProducerBase)new PgBaseAlterViewColumn(context, BaseProducersKt.cast(elements2, it2)) : (obj2 instanceof PgBaseTable ? (AlterProducerBase)new PgBaseAlterTable(context, BaseProducersKt.cast(elements2, it2)) : (obj2 instanceof PgBaseTableColumn ? (AlterProducerBase)new PgBaseAlterTableColumn(context, BaseProducersKt.cast(elements2, it2)) : (obj2 instanceof PgBaseKey ? (AlterProducerBase)new PgBaseAlterKey(context, BaseProducersKt.cast(elements2, it2)) : (obj2 instanceof PgBaseForeignKey ? (AlterProducerBase)new PgBaseAlterForeignKey(context, BaseProducersKt.cast(elements2, it2)) : (obj2 instanceof PgBaseView ? (AlterProducerBase)new PgBaseAlterView(context, BaseProducersKt.cast(elements2, it2)) : super.createAlterProducerImpl(context, elements2))))))));
    }

    @Override
    protected void initAlterProducer(@NotNull AlterProducerBase<?> producer) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        super.initAlterProducer(producer);
        if (producer instanceof PgBaseOwnerAwareAlterProducer) {
            Flags flags = producer.getFlags();
            BasicMetaReferenceId<PgBaseRole> basicMetaReferenceId = PgBaseObjectWithOwner.OWNER_REF;
            Intrinsics.checkNotNullExpressionValue(basicMetaReferenceId, (String)"OWNER_REF");
            flags.add(basicMetaReferenceId, ((PgBaseOwnerAwareAlterProducer)((Object)producer)).checkOwner());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void produceAlterFlag(@NotNull AlterProducerBase<?> producer, @NotNull BasicMetaId id, @NotNull Set<BasicMetaId> produced) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(produced, (String)"produced");
        if (!Intrinsics.areEqual((Object)id, PgBaseObjectWithOwner.OWNER_REF)) {
            super.produceAlterFlag(producer, id, produced);
            return;
        }
        if (producer instanceof PgBaseOwnerAwareAlterProducer) {
            BasicMetaReferenceId<PgBaseRole> basicMetaReferenceId = PgBaseObjectWithOwner.OWNER_REF;
            Intrinsics.checkNotNullExpressionValue(basicMetaReferenceId, (String)"OWNER_REF");
            if (producer.canAlter(basicMetaReferenceId).get(producer.getTask().getVersion()).booleanValue()) {
                ((PgBaseOwnerAwareAlterProducer)((Object)producer)).produceAlterOwner();
                return;
            }
        }
        super.produceAlterFlag(producer, id, produced);
    }

    @Override
    public <T extends BasicElement> void produceCreate(@NotNull CreateProducerBase<T> producer) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        super.produceCreate(producer);
        if (producer instanceof PgBaseOwnerAwareProducer && !producer.getOptions().get(ScriptingOptionStatic.IGNORE_OWNER).booleanValue()) {
            BasicMetaReferenceId<PgBaseRole> basicMetaReferenceId = PgBaseObjectWithOwner.OWNER_REF;
            Intrinsics.checkNotNullExpressionValue(basicMetaReferenceId, (String)"OWNER_REF");
            if (producer.canCreateWith(basicMetaReferenceId).get(producer.getTask().getVersion()).booleanValue() && producer.getContext().getLocus() == ScriptLocus.OUTSIDE) {
                Object t = producer.getElement();
                PgBaseObjectWithOwner pgBaseObjectWithOwner = t instanceof PgBaseObjectWithOwner ? (PgBaseObjectWithOwner)t : null;
                if ((pgBaseObjectWithOwner != null ? pgBaseObjectWithOwner.getOwnerRef() : null) != null) {
                    ((PgBaseOwnerAwareProducer)((Object)producer)).produceOwner();
                }
            }
        }
    }

    @NotNull
    public PgBaseRoleHelper getRoleHelper() {
        return this.roleHelper;
    }

    @NotNull
    public String aggregateArgumentsDefinition(@NotNull ElementProducer<?> $this$aggregateArgumentsDefinition, @NotNull PgBaseAggregate agg) {
        Intrinsics.checkNotNullParameter($this$aggregateArgumentsDefinition, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)agg, (String)"agg");
        PositioningNamingFamily positioningNamingFamily = agg.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getArguments(...)");
        return SequencesKt.joinToString$default(PgBaseRoutineProducersKt.mapToDefinitions($this$aggregateArgumentsDefinition, positioningNamingFamily, true, false), null, null, null, (int)0, null, null, (int)63, null);
    }

    @Override
    public boolean isSchemaAlwaysInPath(@NotNull String sc2) {
        Intrinsics.checkNotNullParameter((Object)sc2, (String)"sc");
        return StringsKt.equals((String)"pg_catalog", (String)sc2, (boolean)true) || super.isSchemaAlwaysInPath(sc2);
    }

    @Override
    public boolean isOptionSupported(@NotNull ScriptingOption<?> option) {
        Intrinsics.checkNotNullParameter(option, (String)"option");
        ScriptingOption<?> scriptingOption = option;
        return ((((((((((Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.SKIP_GRANTS) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.USER_GRANTS)) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.IGNORE_OWNER)) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.WITH_NO_DATA)) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.CALL)) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.IGNORE_EXTENSION_MEMBERS)) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.CREATE_OR_REPLACE)) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.CREATE_IF_NOT_EXISTS)) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.DISABLE_DISABLED)) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.CONSIDER_RULES)) ? true : Intrinsics.areEqual(scriptingOption, ScriptingOptionStatic.IF_EXISTS)) ? true : super.isOptionSupported(option);
    }
}

